//__lib__ lib_common
//priority 100

"use strict";

SHINKEN.OBJECT.CollapseFolderFromData           = function ( name, label ) {
    this.initSpecific( name, label );
};
SHINKEN.OBJECT.CollapseFolderFromData.prototype = {
    initSpecific: function ( name, label ) {
        this.class = "shinken-collapse-folder shinken-toggle-container";
        this.init( name, label );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    
    //********************************************  ACTIONS  *****************************************************//
    
    //********************************************  GETTER SETTER  *****************************************************//
    
    //********************************************  HTML  *****************************************************//
    computeHtml             : function () {
        this.computeCommonHtml();
        this.computeSpecificHtml();
    },
    computeCommonHtml       : function () {
        this.setDomElement( DOM.Service.createElement( "div", this.computeHtml_getAttribute() ) );
        var _button        = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-toggle-button", onclick: "DOM.Service.Toggle.toggle(this)" } ) );
        this._button_label = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-toggle-button-label shinken-layout-center-h-v shinken-layout-justify-between" } ), _button );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-label" }, this.label ), this._button_label );
        var _div = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-collapse-icon-cell" } ), this._button_label );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-toggle-icon shinken-hidden-if-toggle-close shinken-2023-arrow-down" } ), _div );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-toggle-icon shinken-hidden-if-toggle-open shinken-2023-arrow-up" } ), _div );
        
        this.dom_content_target = DOM.Service.createElement( "div", { class: "shinken-toggle-target" } );
        this.addDomElement( this.dom_content_target );
        
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeHtml();
            DOM.Service.addElementTo( this.getContent( i ).getDomElement(), this.dom_content_target );
        }
        this.computeHtmlExtra();
    },
    computeHtml_getAttribute: function () {
        var _to_return                        = {};
        _to_return[ "class" ]                 = this.class;
        _to_return[ "data-name" ]             = this.name;
        _to_return[ "data-visibility-state" ] = this.getVisibilityState();
        return _to_return;
    },
    computeSpecificHtml     : function () {
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave: function ( type ) {
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CollapseFolderFromData, SHINKEN.OBJECT.CollapseFolder );

SHINKEN.OBJECT.CollapseFolderForProperties           = function ( name, label ) {
    this.initSpecific( name, label );
};
SHINKEN.OBJECT.CollapseFolderForProperties.prototype = {
    initSpecific     : function ( name, label ) {
        this.class = "shinken-collapse-folder shinken-toggle-container";
        this.init( name, label );
        this.initCounterCommon();
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    
    //********************************************  ACTIONS  *****************************************************//
    add: function ( to_add ) {
        to_add.setCountersParent( this );
        return this.addCommon( to_add );
    }
    //********************************************  GETTER SETTER  *****************************************************//
    
    //********************************************  HTML  *****************************************************//
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CollapseFolderForProperties, SHINKEN.OBJECT.CollapseFolderFromData );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CollapseFolderForProperties, SHINKEN.OBJECT.CounterInterfaceV2 );