//__lib__ lib_common
"use strict";

COMPONENT.BUTTON = {
    PARAM: {
        BUTTON_NAME: "button_name"
    }
};

COMPONENT.InterfaceButton           = function () {
};
COMPONENT.InterfaceButton.prototype = {
    init: function () {
    },
    //********************************************  GETTER AND SETTER  ***********************************************//
    setState         : function ( to_set ) {
        this.state = to_set;
        if ( !this.dom_element ) {
            return;
        }
        this.resetStateClass();
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.dom_element.classList.add( "shinken-active" );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                this.dom_element.classList.add( "shinken-disabled" );
                break;
            case COMPONENT.CONST.BTN_STATE.ENABLED_WITH_ERRORS:
                this.dom_element.classList.add( "shinken-enabled-with-errors" );
                break;
        }
        var _tooltip_by_state = this.getTooltipByState();
        if ( _tooltip_by_state ) {
            this.setTooltipHtml( _tooltip_by_state );
        }
    },
    toggleState      : function () {
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
        }
    },
    resetStateClass  : function () {
        if ( !this.dom_element ) {
            return;
        }
        this.dom_element.classList.remove( "shinken-active" );
        this.dom_element.classList.remove( "shinken-disabled" );
        this.dom_element.classList.remove( "shinken-enabled-with-errors" );
    },
    getValue         : function () {
        return this.value;
    },
    getUUID          : function () {
        return this.getValue();
    },
    getState         : function () {
        return this.state;
    },
    isOn             : function () {
        return this.state === COMPONENT.CONST.BTN_STATE.ON;
    },
    isChecked        : function () {
        return this.state === COMPONENT.CONST.BTN_STATE.ON;
    },
    setInheritedLabel: function ( to_set ) {
        this.dom_element.querySelector( '.shinken-inherited-value' ).innerHTML = to_set;
    },
    removeClass      : function ( to_remove ) {
        this.dom_element.classList.remove( to_remove );
    },
    setTooltipByState: function ( state, text_tooltip ) {
        this.tooltip_text          = this.tooltip_text || {};
        this.tooltip_text[ state ] = text_tooltip;
    },
    getTooltipByState: function () {
        if ( !this.tooltip_text ) {
            return;
        }
        return this.tooltip_text[ this.state ] || "";
    },
    getOnClickEvent  : function () {
        return this.onclick_event;
    },
    setOnClickEvent  : function ( to_set ) {
        this.onclick_event = to_set;
    },
    //********************************************  COMPUTE  ***********************************************//
    computeCounters: function () {
        switch ( this.status ) {
            case COMPONENT.CONST.BTN_STATUS.ERROR:
                this.getCounterError().update( this.uuid, 1 );
                break;
            case COMPONENT.CONST.BTN_STATUS.WARNING:
                this.getCounterWarning().update( this.uuid, 1 );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceButton, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceButton, COMPONENT.Interface );

COMPONENT.InterfaceButton_V3           = function () {
};
COMPONENT.InterfaceButton_V3.prototype = {
    init: function () {
    },
    //********************************************  GETTER AND SETTER  ***********************************************//
    setState         : function ( to_set ) {
        this.state = to_set;
        if ( !this.dom_element ) {
            return;
        }
        this.resetStateClass();
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.dom_element.classList.add( "shinken-active" );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                this.dom_element.classList.add( "shinken-disabled" );
                break;
            case COMPONENT.CONST.BTN_STATE.ENABLED_WITH_ERRORS:
                this.dom_element.classList.add( "shinken-enabled-with-errors" );
                break;
        }
        var _tooltip_by_state = this.getTooltipByState();
        if ( _tooltip_by_state ) {
            this.setTooltipHtml( _tooltip_by_state );
        }
    },
    toggleState      : function () {
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
        }
    },
    resetStateClass  : function () {
        if ( !this.dom_element ) {
            return;
        }
        this.dom_element.classList.remove( "shinken-active" );
        this.dom_element.classList.remove( "shinken-disabled" );
        this.dom_element.classList.remove( "shinken-enabled-with-errors" );
    },
    getValue         : function () {
        return this.value;
    },
    getUUID          : function () {
        return this.getValue();
    },
    getState         : function () {
        return this.state;
    },
    isOn             : function () {
        return this.state === COMPONENT.CONST.BTN_STATE.ON;
    },
    setInheritedLabel: function ( to_set ) {
        this.dom_element.querySelector( '.shinken-inherited-value' ).innerHTML = to_set;
    },
    removeClass      : function ( to_remove ) {
        this.dom_element.classList.remove( to_remove );
    },
    setTooltipByState: function ( state, text_tooltip ) {
        this.tooltip_text          = this.tooltip_text || {};
        this.tooltip_text[ state ] = text_tooltip;
    },
    getTooltipByState: function () {
        if ( !this.tooltip_text ) {
            return;
        }
        return this.tooltip_text[ this.state ] || "";
    },
    getOnClickEvent  : function () {
        return this.onclick_event;
    },
    setOnClickEvent  : function ( to_set ) {
        this.onclick_event = to_set;
    },
    //********************************************  COMPUTE  ***********************************************//
    computeCounters: function () {
        switch ( this.status ) {
            case COMPONENT.CONST.BTN_STATUS.ERROR:
                this.getCounterError().update( this.uuid, 1 );
                break;
            case COMPONENT.CONST.BTN_STATUS.WARNING:
                this.getCounterWarning().update( this.uuid, 1 );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceButton_V3, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceButton_V3, COMPONENT.Interface_V3 );


COMPONENT.Button           = function ( dom_element, name ) {
    this.__class_name__ = 'COMPONENT.Button';
    // dom_element
    // value
    // state
    // label
    // name
    this.uuid   = SHINKEN.TOOLS.STRING.buildUUID();
    this.state  = COMPONENT.CONST.BTN_STATE.OFF;
    this.status = COMPONENT.CONST.BTN_STATUS.NONE;
    this.name   = name;
    this.value  = '';
    this.init( dom_element );
};
COMPONENT.Button.prototype = {
    init          : function ( dom_element ) {
        this.dom_element = dom_element;
        if ( this.dom_element ) {
            this.initDomElement();
        }
        else {
            this.state = COMPONENT.CONST.BTN_STATE.DISABLED;
        }
        this._computeState();
    },
    initDomElement: function () {
        this.value = this.dom_element.value;
        if ( this.dom_element.classList.contains( 'shinken-error' ) ) {
            this.status = COMPONENT.CONST.BTN_STATUS.ERROR;
        }
        else if ( this.dom_element.classList.contains( 'shinken-warning' ) ) {
            this.status = COMPONENT.CONST.BTN_STATUS.WARNING;
        }
    },
    _computeState : function () {
        if ( this.state === COMPONENT.CONST.BTN_STATE.DISABLED ) {
            return;
        }
        if ( this.dom_element.classList.contains( "shinken-active" ) ) {
            this.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Button, COMPONENT.InterfaceButton );

COMPONENT.ButtonFromData           = function ( event_name, class_to_add, label ) {
    this.__class_name__ = 'COMPONENT.ButtonFromData';
    this.init( event_name, class_to_add, label );
};
COMPONENT.ButtonFromData.prototype = {
    init       : function ( event_name, class_to_add, label ) {
        this.name         = event_name;
        this.label        = label || "";
        this.class_to_add = class_to_add;
        this.state        = COMPONENT.CONST.BTN_STATE.OFF;
    },
    computeHtml: function () {
        this.setDomElement( DOM.Service.createElement( "button", {
            class                  : "shinken-label " + this.class_to_add,
            onclick                : "MANAGER.EventManager.clickOnButton(event, '" + this.name + "','" + this.extra_param + "' )",
            "data-visibility-state": this.getVisibilityState()
        }, this.label ) );
        var _tooltip_by_state = this.getTooltipByState();
        if ( _tooltip_by_state ) {
            this.setTooltipHtml( _tooltip_by_state );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.ButtonFromData, COMPONENT.InterfaceButton );

COMPONENT.ButtonFromData_V2           = function ( event_name, label ) {
    this.__class_name__ = 'COMPONENT.ButtonFromData';
    this.init( event_name, label );
    
};
COMPONENT.ButtonFromData_V2.prototype = {
    init   : function ( event_name, label ) {
        this.name          = event_name;
        this.label         = label;
        this.class         = "shinken-button shinken-button-V2";
        this.onclick_event = "MANAGER.EventManagerV2.clickButtonV2(event, '" + this.name + "')";
    },
    getUUID: function () {
        return this.name;
    },
    //********************************************  GETTER AND SETTER  ***********************************************//
    computeHtml: function () {
        this.setDomElement( DOM.Service.createElement( "div", {
            class                  : this.getClass(),
            onclick                : this.getOnClickEvent(),
            "data-name"            : this.name,
            "data-visibility-state": this.getVisibilityState()
        } ) );
        this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-label" }, this.label ) );
        var _tooltip_by_state = this.getTooltipByState();
        if ( _tooltip_by_state ) {
            this.setTooltipHtml( _tooltip_by_state );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.ButtonFromData_V2, COMPONENT.InterfaceButton );

COMPONENT.ButtonFromData_V3           = function ( event_name, label ) {
    this.__class_name__ = 'COMPONENT.ButtonFromData';
    this.init( event_name, label );
    
};
COMPONENT.ButtonFromData_V3.prototype = {
    init   : function ( event_name, label ) {
        this.name             = event_name;
        this.addParamForEvents( COMPONENT.BUTTON.PARAM.BUTTON_NAME, this.name );
        this.label = label;
        this.class = "shinken-button shinken-button-V3 shinken-layout-center-h-v";
    },
    getUUID: function () {
        return this.name;
    },
    //********************************************  GETTER SETTER  ***********************************************//
    setLabelDomElement: function ( dom_element_label ) {
        DOM.Service.addElementToAfterEmpty( dom_element_label, this.label_dom_element );
    },
    //********************************************  HTML  ***********************************************//
    computeHtml: function () {
        let onclick_event = "MANAGER.EventManagerV2.clickButton_V3(event, " + this.parseParamForEventsToHtml() + ")";
        this.setDomElement( DOM.Service.createElement( "div", {
            class                  : this.getClass(),
            onclick                : onclick_event,
            "data-name"            : this.name,
            "data-visibility-state": this.getVisibilityState()
        } ) );
        this.label_dom_element = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-label" }, this.label ) );
        let _tooltip_by_state  = this.getTooltipByState();
        if ( _tooltip_by_state ) {
            this.setTooltipHtml( _tooltip_by_state );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.ButtonFromData_V3, COMPONENT.InterfaceButton_V3 );


COMPONENT.ButtonWithCounter           = function ( event_name, label ) {
    this.__class_name__ = 'COMPONENT.ButtonFromData';
    this.init( event_name, label );
    
};
COMPONENT.ButtonWithCounter.prototype = {
    init             : function ( event_name, label ) {
        this.name             = event_name;
        this.addParamForEvents( COMPONENT.BUTTON.PARAM.BUTTON_NAME, this.name );
        this.label = label;
        this.class = "shinken-button shinken-button-V3";
        this.initCounterCommon();
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL );
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL ).setShowIfNull( true );
    },
    //********************************************  GETTER SETTER  ***********************************************//
    setLabelDomElement: function ( dom_element_label ) {
        DOM.Service.addElementToAfterEmpty( dom_element_label, this.label_dom_element );
    },
    //********************************************  HTML  ***********************************************//
    computeHtml: function () {
        let onclick_event = "MANAGER.EventManagerV2.clickButton_V3(event, " + this.parseParamForEventsToHtml() + ")";
        this.setDomElement( DOM.Service.createElement( "div", {
            class                  : this.getClass(),
            onclick                : onclick_event,
            "data-name"            : this.name,
            "data-visibility-state": this.getVisibilityState()
        } ) );
        this.label_dom_element = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-label" }, this.label ) );
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL ).computeHtml();
        this.addCounterTargetDomElement( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL, this.getDomElement(), "total" );
        DOM.Service.addElementTo( this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL ).getDomElement(), this.label_dom_element );
        let _tooltip_by_state = this.getTooltipByState();
        if ( _tooltip_by_state ) {
            this.setTooltipHtml( _tooltip_by_state );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.ButtonWithCounter, COMPONENT.ButtonFromData_V3 );


COMPONENT.RadioButtonFromData           = function ( value, label, property_name ) {
    this.__class_name__ = 'COMPONENT.RadioButtonFromData';
    this.initSpecific( value, label, property_name );
};
COMPONENT.RadioButtonFromData.prototype = {
    setState       : function ( to_set ) {
        this.state = to_set;
        if ( !this.button_dom_element ) {
            return;
        }
        this.resetStateClass();
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.button_dom_element.classList.add( "shinken-active" );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                this.button_dom_element.classList.add( "shinken-disabled" );
                break;
            case COMPONENT.CONST.BTN_STATE.ENABLED_WITH_ERRORS:
                this.button_dom_element.classList.add( "shinken-enabled-with-errors" );
                break;
        }
    },
    resetStateClass: function () {
        if ( !this.dom_element ) {
            return;
        }
        this.button_dom_element.classList.remove( "shinken-active" );
        this.button_dom_element.classList.remove( "shinken-disabled" );
        this.button_dom_element.classList.remove( "shinken-enabled-with-errors" );
    },
    initSpecific   : function ( value, label, property_name ) {
        this.property_name = property_name;
        this.param_name    = value;
        this.value         = value;
        this.label         = label || this.value;
        this.state         = COMPONENT.CONST.BTN_STATE.OFF;
    },
    computeHtml    : function () {
        this.setDomElement( DOM.Service.createElement( "td", { class: "shinken-btn-cell shinken-btn-user-cell", "data-visibility-state": this.getVisibilityState() } ) );
        var _class_button       = this.isOn() ? "shinken-radio-btn shinken-active" : "shinken-radio-btn";
        this.button_dom_element = this.addDomElement( DOM.Service.createElement( "button", {
            class  : _class_button,
            value  : this.getValue(),
            onclick: "MANAGER.EventManagerV2.clickRadioButton(event,'" + this.property_name + "', '" + this.param_name + "')"
        } ) );
        DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-label" }, this.label ), this.button_dom_element );
        if ( this.tooltip_html ) {
            this.setTooltipHtml( this.tooltip_html, this.tooltip_type );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioButtonFromData, COMPONENT.ButtonFromData );

COMPONENT.RadioButtonFromData_V3           = function ( value, label, property_name ) {
    this.__class_name__ = 'COMPONENT.RadioButtonFromData_V3';
    this.initSpecific( value, label, property_name );
};
COMPONENT.RadioButtonFromData_V3.prototype = {
    setState       : function ( to_set ) {
        this.state = to_set;
        if ( !this.button_dom_element ) {
            return;
        }
        this.resetStateClass();
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.button_dom_element.classList.add( "shinken-active" );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                this.button_dom_element.classList.add( "shinken-disabled" );
                break;
            case COMPONENT.CONST.BTN_STATE.ENABLED_WITH_ERRORS:
                this.button_dom_element.classList.add( "shinken-enabled-with-errors" );
                break;
        }
    },
    resetStateClass: function () {
        if ( !this.dom_element ) {
            return;
        }
        this.button_dom_element.classList.remove( "shinken-active" );
        this.button_dom_element.classList.remove( "shinken-disabled" );
        this.button_dom_element.classList.remove( "shinken-enabled-with-errors" );
    },
    initSpecific   : function ( value, label, property_name ) {
        this.property_name    = property_name;
        this.value            = value;
        this.label            = label || this.value;
        this.state            = COMPONENT.CONST.BTN_STATE.OFF;
        this.addParamForEvents( PROPERTY.COMMON.PARAM.PROPERTY_NAME, property_name );
        this.addParamForEvents( COMPONENT.BUTTON.PARAM.BUTTON_NAME, this.value );
    },
    computeHtml    : function () {
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-btn-container", "data-visibility-state": this.getVisibilityState() } ) );
        var _class_button       = this.isOn() ? "shinken-radio-btn-V3 shinken-active" : "shinken-radio-btn-V3";
        this.button_dom_element = this.addDomElement( DOM.Service.createElement( "button", {
            class  : _class_button,
            value  : this.getValue(),
            onclick: "MANAGER.EventManagerV2.clickRadioButton_V3(event," + this.parseParamForEventsToHtml() + ")"
        } ) );
        DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-label" }, this.label ), this.button_dom_element );
        if ( this.tooltip_html ) {
            this.setTooltipHtml( this.tooltip_html, this.tooltip_type );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioButtonFromData_V3, COMPONENT.ButtonFromData );

COMPONENT.RadioButtonClassicFromData_V3 = function ( value, label, property_name ) {
    this.__class_name__ = 'COMPONENT.RadioButtonClassicFromData_V3';
    this.initSpecific( value, label, property_name );
};

COMPONENT.RadioButtonClassicFromData_V3.prototype = {
    initSpecific: COMPONENT.RadioButtonFromData_V3.prototype.initSpecific,
    computeHtml : function () {
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-btn-container", "data-visibility-state": this.getVisibilityState() } ) );
        var _class_button       = this.isChecked() ? "shinken-radio-btn-V3 shinken-active" : "shinken-radio-btn-V3";
        this.button_dom_element = this.addDomElement( DOM.Service.createElement( "input", {
            class  : _class_button,
            type   : "radio",
            id     : this.value,
            name   : this.property_name,
            value  : this.getValue(),
            onclick: "MANAGER.EventManagerV2.clickRadioButton_V3(event," + this.parseParamForEventsToHtml() + ")"
        } ) );
        DOM.Service.addElementAfterTo( DOM.Service.createElement( "label", { class: "shinken-label", for: this.value }, this.label ), this.button_dom_element );
        if ( this.tooltip_html ) {
            this.setTooltipHtml( this.tooltip_html, this.tooltip_type );
        }
    },
    setState    : function ( to_set ) {
        this.state = to_set;
        if ( !this.dom_element ) {
            return;
        }
        this.resetStateClass();
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                DOM.Service.addAttribute(this.dom_element, 'checked');
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                this.dom_element.classList.add( "shinken-disabled" );
                break;
            case COMPONENT.CONST.BTN_STATE.ENABLED_WITH_ERRORS:
                this.dom_element.classList.add( "shinken-enabled-with-errors" );
                break;
        }
        var _tooltip_by_state = this.getTooltipByState();
        if ( _tooltip_by_state ) {
            this.setTooltipHtml( _tooltip_by_state );
        }
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioButtonClassicFromData_V3, COMPONENT.RadioButtonFromData_V3 );