//priority 20
"use strict";


COMPONENT.InterfaceLine = function () {
};

COMPONENT.InterfaceLine.prototype = {
    init                            : function ( parent, element ) {
        this.inputs    = {};
        this.selectors = {};
        this.uuid      = SHINKEN.TOOLS.STRING.buildUUID();
        DOM.Service.setDataSet( element, 'uuid', this.uuid );
        DOM.Service.setDataSet( element, 'name', this.uuid );
        this.parent_name = parent.getParentName();
        this.initCounters( parent );
        this.initSpecific();
        this.initDomElement( element );
        this.initSpecificEnd();
    },
    initDomElement                  : function ( element ) {
        this.dom_element          = element;
        this.dom_element_cfg_file = element.querySelector( '.shinken-cfg-line-value .shinken-cfg-file-value' );
        
        var _keys = Object.keys( this.inputs );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.addInput( _current_key );
        }
        _keys = Object.keys( this.selectors );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key                   = _keys[ i ];
            this.selectors[ _current_key ] = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container[data-name="' + _current_key + '"]' ), this.selectors[ _current_key ], false, this );
            this.selectors[ _current_key ].computeTitle();
        }
    },
    initSpecificEnd                 : function ( parent ) {
        var self = this;
        setTimeout( function () {
            var _keys = Object.keys( self.inputs );
            for( var i = 0, _size = _keys.length ; i < _size; i++ ) {
                self.inputs[_keys[i]].validateValueInput();
            }
        }, 10 );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    clickOnSelector                 : function ( dom_element ) {
        var _target = DOM.Service.findParentElementWithClass( dom_element, "shinken-select-container", 10 ).dataset.name;
        var _keys   = Object.keys( this.selectors );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.selectors[ _keys[ i ] ];
            if ( _keys[ i ] === _target ) {
                _current.clickOnSelector();
            }
            else {
                _current.hidePopup();
            }
        }
    },
    ___clickOnItemSelector          : function ( key_name, dom_element ) {
        if ( !dom_element ) {
            return;
        }
        var _current = this.getSelectorViaChildrenDomElement( dom_element );
        _current.clickOnItemSelector( "", key_name );
        _current.computeTitle();
    },
    askComputeAfterChange           : function ( dom_element, parent_prop_object ) {
        var _keys = Object.keys( this.inputs );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.inputs[ _keys[ i ] ];
            if ( _current.dom_element_input === dom_element ) {
                _current.askComputeAfterChange( dom_element, parent_prop_object );
                return;
            }
        }
    },
    delete                          : function () {
        this.resetCounters();
        DOM.Service.removeElement( this.dom_element );
    },
    getSelectorViaChildrenDomElement: function ( dom_element ) {
        var _selector = DOM.Service.findParentElementWithClass( dom_element, "shinken-select-container", 30 );
        if ( !_selector ) {
            return null;
        }
        var _keys = Object.keys( this.selectors );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.selectors[ _keys[ i ] ];
            if ( _keys[ i ] === _selector.dataset.name ) {
                return _current;
            }
        }
        return null;
    },
    getListElement                  : function ( event ) {
        return this.getSelectorViaChildrenDomElement( event.target ).getListElement();
    },
    //********************************************  SETTER GETTER   **************************************************//
    getParentName                   : function () {
        return this.parent_name;
    },
    getValue                        : function () {
    },
    getCfgValue                     : function () {
    },
    setValueFromUser                : function ( value ) {
        console.warn( "", "[note implemented for ]", this.constructor );
    },
    addInput                        : function ( _current_key ) {
        var _dom_input = this.dom_element.querySelector( "." + _current_key + " .shinken-input" );
        var _parent_input = DOM.Service.findParentElementWithClass( _dom_input, "shinken-input-table", 25 );
        this.inputs[ _current_key ] = new COMPONENT.Input( _parent_input || _dom_input, this );
    },
    //********************************************  VALIDATION   *****************************************************//
    computeErrorsSpecifics          : function ( property_state ) {
        var _keys = Object.keys( this.inputs );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.inputs[ _keys[ i ] ];
            switch ( property_state ) {
                case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                    _current.hideCountersForParent();
                    break;
                default:
                    _current.showCountersForParent();
            }
        }
    },
    //********************************************  UPDATE VIEW  **************************************************//
    updateCfgDomElement             : function () {
        if ( !this.dom_element_cfg_file ) {
            return;
        }
        this.dom_element_cfg_file.innerHTML = this.getCfgValue().trim() || "&nbsp;";
    },
    hidePopup                       : function () {
        var _keys = Object.keys( this.selectors );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.selectors[ _keys[ i ] ].hidePopup();
        }
    },
    updateViewInputs           : function (to_set) {
        var _keys = Object.keys( this.inputs );
        for( var i = 0, _size = _keys.length ; i < _size; i++ ) {
            this.inputs[_keys[i]].setDisabled(to_set);
        }
    },
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceLine, SHINKEN.OBJECT.CounterInterface );

COMPONENT.getInterfaceLinePrototype = function ( object, name_constructor ) {
    var _current;
    var _keys = Object.keys( COMPONENT.InterfaceLine.prototype );
    for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
        _current = _keys[ i ];
        if ( !object.prototype[ _current ] ) {
            object.prototype[ _current ] = COMPONENT.InterfaceLine.prototype[ _current ];
        }
    }
    
    object.prototype.constructor = name_constructor;
};
