//__lib__ lib_common
"use strict";

COMPONENT.InterfaceSelect           = function () {
};
COMPONENT.InterfaceSelect.prototype = {
    init        : function () {
    },
    hidePopup   : function () {
        DOM.Service.setDataSet( this.dom_element, COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, COMPONENT.CONST.BTN_STATE.OFF );
        this.list_element.setState( COMPONENT.CONST.BTN_STATE.OFF );
    },
    openSelector: function () {
        if ( this.list_element.state === COMPONENT.CONST.BTN_STATE.OFF ) {
            this.clickOnSelector();
        }
    },
    //********************************************  EVENT LISTENER  **************************************************//
    clickOnSelector          : function () {
        DOM.Service.setDataSet( this.dom_element, COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, this.list_element.toggleState() );
        this.list_element.focusOnResearchInput();
    },
    clickOnItemSelector      : function ( parent_name, key_name, class_to_add ) {
        this.setLastSelectedElementName( key_name );
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.MULTI_SELECT:
            case COMPONENT.CONST.TYPE.MULTI_SELECT_BASIC:
                var _element = this.list_element.toggleStateSelectedInList( key_name, class_to_add );
                this.list_element.setState( COMPONENT.CONST.BTN_STATE.OFF );
                this.getActiveListForUser().addTag( parent_name, _element );
                break;
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
            case COMPONENT.CONST.TYPE.SINGLE_SELECT_WITH_INPUT:
                break;
            case COMPONENT.CONST.TYPE.STRING_INPUT_WITH_DROPDOWN:
                this.list_element.clickOnItemSelector( key_name );
                break;
        }
        if ( MANAGER.__instance_property_distributor ) {
            MANAGER.__instance_property_distributor.hidePopups();
        }
    },
    clickOnDeleteItemSelector: function ( key_name ) {
        var _element = this.list_element.toggleStateSelectedInList( key_name );
        this.getActiveListForUser().deleteTag( _element );
    },
    askComputeAfterChange    : function ( dom_element ) {
        switch ( dom_element.name ) {
            case 'multi-search':
                this.component_input_search.askComputeAfterChange( dom_element, this );
                break;
        }
    },
    doActionAfterChange      : function ( args ) {
        if ( args[ 'validation_done' ] ) {
            this.doFilter( this.component_input_search.getValue() );
        }
    },
    simulateClickOnItem      : function ( key_name ) {
        DOM.Service.SimulateAction.mouseUp( this.list_element.getListSelectElement( key_name ).dom_element );
    },
    //********************************************  DRAG N DROP  **************************************************//
    dragStartShinken: function ( type_element, key_name ) {
        switch ( type_element ) {
            case PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM:
                return this.getActiveListForUser().dragStartShinken( key_name );
        }
    },
    resetDragging   : function () {
        this.list_element_selected.resetDragging();
    },
    //********************************************  GETTER AND SETTER  **************************************************//
    setTitle                  : function ( _to_set ) {
        if ( !this.is_editable ) {
            return;
        }
        var _dom_text       = this.dom_select.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR_TEXT );
        this.title          = _to_set;
        _dom_text.innerHTML = this.title;
    },
    setResearchDisplay        : function ( _to_set ) {
        this.list_element.setResearchDisplay( _to_set );
    },
    isSet                     : function () {
        return !this.getActiveListForUser().isEmpty();
    },
    cleanAllTags              : function () {
        this.getActiveListForUser().emptyList();
    },
    getActiveListForUser      : function () {
        if ( this.is_override ) {
            return this.list_element_override;
        }
        else {
            return this.list_element_selected;
        }
    },
    cleanAllItemsSelected     : function ( extra_class ) {
        this.list_element.unselectAllElement( extra_class );
    },
    getValue                  : function () {
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.MULTI_SELECT:
            case COMPONENT.CONST.TYPE.MULTI_SELECT_BASIC:
                return this.getActiveListForUser().getValue();
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
            case COMPONENT.CONST.TYPE.SINGLE_SELECT_WITH_INPUT:
                return this.getLastSelectedElementName();
        }
    },
    getValueToSave            : function () {
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.MULTI_SELECT:
            case COMPONENT.CONST.TYPE.MULTI_SELECT_BASIC:
                return this.getTagsValueToSave();
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
            case COMPONENT.CONST.TYPE.SINGLE_SELECT_WITH_INPUT:
                if ( this.last_selected_key_name ) {
                    return this.getLastSelectedElement().getElement().getValueFinal();
                }
                return;
        }
    },
    getTagsValueToSave        : function () {
        var _to_return = [];
        var _tags      = this.getActiveListForUser().getTags();
        for ( var i = 0, size = _tags.length; i < size; i++ ) {
            _to_return.push( _tags[ i ].getValueFinal() );
        }
        return _to_return;
    },
    computeTitle              : function ( add_extra, extra_label ) {
        if ( this.last_selected_key_name === undefined ) {
            var _selected = this.list_element.getSelectedElements();
            if ( _selected[ 0 ] !== undefined ) {
                this.setLastSelectedElementName( _selected[ 0 ].element.name );
            }
        }
        var _selected_element = this.getLastSelectedElement();
        var _title_to_set     = '';
        if ( _selected_element ) {
            _title_to_set = _selected_element.element.getLabel();
        }
        if ( extra_label ) {
            _title_to_set += extra_label;
        }
        this.setTitle( _title_to_set );
    },
    getLastSelectedElement    : function () {
        return this.list_element.getListSelectElement( this.last_selected_key_name );
    },
    getLastSelectedElementName: function () {
        return this.last_selected_key_name || '';
    },
    setLastSelectedElementName: function ( to_set ) {
        if ( this.last_selected_key_name ) {
            this.previous_selected_key_name = this.last_selected_key_name;
        }
        this.last_selected_key_name = to_set;
    },
    hasTag                    : function ( name ) {
        return !this.list_element_selected.hasTag( name ) || !this.list_elements_inherited.hasTag( name );
    },
    getMissingItemSelectorWith: function ( property ) {
        return this.list_element_selected.getMissingItemSelectorWith( property );
    },
    getExtraItemSelectorWith  : function ( property ) {
        return this.list_element_selected.getExtraItemSelectorWith( property );
    },
    setMaximumSelected        : function ( to_set ) {
        this.maximum_selected = to_set;
    },
    getMaximumSelected        : function () {
        return this.maximum_selected;
    },
    isLimitReached            : function () {
        return (this.getActiveListForUser().getSizeTags() + this.list_elements_inherited.getSizeTags() - this.maximum_selected);
    },
    isLimitReachedForSelected : function () {
        return (this.getActiveListForUser().getSizeTags() - this.maximum_selected);
    },
    disabledTagsOutOfLimit    : function ( limit ) {
        this.list_elements_inherited.disabledTagsOutOfLimit( limit );
    },
    getErrors                 : function ( state, prop_name ) {
        var _to_return = 0;
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.MULTI_SELECT:
                switch ( state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                        _to_return = this.list_element_selected.getErrors( prop_name ) + this.list_elements_inherited.getErrors( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                        _to_return = this.list_element_selected.getErrors( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                        _to_return = this.list_elements_inherited.getErrors( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                        _to_return = this.list_element_override.getErrors( prop_name ) + this.list_elements_inherited.getErrors( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                        break;
                }
                break;
        }
        _to_return += this.getCounterError().getValue();
        return _to_return;
    },
    getWarnings               : function ( state, prop_name ) {
        var _to_return = 0;
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.MULTI_SELECT:
                switch ( state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                        _to_return = this.list_element_selected.getWarnings( prop_name ) + this.list_elements_inherited.getWarnings( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                        _to_return = this.list_element_selected.getWarnings( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                        _to_return = this.list_elements_inherited.getWarnings( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                        _to_return = this.list_element_override.getWarnings( prop_name ) + this.list_elements_inherited.getWarnings( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                        break;
                }
                break;
        }
        _to_return += this.getCounterWarning().getValue();
        return _to_return;
    },
    setMessage                : function ( message ) {
        var _status = COMPONENT.CONST.STATUS.NONE;
        if ( typeof message === 'string' ) {
            _status = COMPONENT.CONST.STATUS.INFO;
        }
        else if ( message ) {
            _status = message.getStatus();
        }
        var _counter = [0, 0];
        this.setStatus( _status );
        switch ( _status ) {
            case COMPONENT.CONST.STATUS.INFO:
                this.addShinkenTooltip( "", message );
                break;
            case COMPONENT.CONST.STATUS.ERROR:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.ERROR_BORDER, message.buildMessage() );
                _counter[ 0 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER, message.buildMessage() );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.WARNING_BORDER, message.buildMessage() );
                _counter[ 1 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.NONE:
                this.addShinkenTooltip( "shinken-success-border", "" );
                break;
        }
        this.setError( this.uuid, _counter[ 0 ] );
        this.setWarning( this.uuid, _counter[ 1 ] );
    },
    addShinkenTooltip         : function ( type, message ) {
        this.dom_element.setAttribute( 'shi-tip-type', type );
        this.dom_element.setAttribute( 'shi-tip-text', message );
        message ? SHINKEN_TOOLTIP.showTooltip( this.dom_element ) : SHINKEN_TOOLTIP.hideTooltip();
    },
    setStatus                 : function ( to_set ) {
        this.status = to_set;
        DOM.Service.setDataSet( this.dom_element, 'status', to_set );
    },
    setDataSetLink            : function ( to_set ) {
        this.dataSetLink = to_set;
        if ( this.dataSetLink ) {
            this.computeTitle();
        }
    },
    getDataSetLink            : function () {
        return this.dataSetLink;
    },
    getListElement            : function () {
        return this.list_element;
    },
    //********************************************  FILTER   *********************************************************//
    doFilter            : function ( filter ) {
        this.list_element.doFilter( filter );
    },
    doChangeFilterSelect: function () {
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.MULTI_SELECT:
            case COMPONENT.CONST.TYPE.MULTI_SELECT_BASIC:
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
            case COMPONENT.CONST.TYPE.SINGLE_SELECT_WITH_INPUT:
                break;
            case COMPONENT.CONST.TYPE.STRING_INPUT_WITH_DROPDOWN:
                this.list_element.doChangeFilterSelect();
                break;
        }
    },
    cleanFilter         : function () {
        this.list_element.cleanFilter();
    },
    validOrCreateTag    : function ( name_element, prop_name ) {
        var _existing = this.list_element.getListSelectElement( name_element );
        if ( _existing ) {
            return _existing;
        }
        return this.list_element.addNewElementUnknown( name_element, prop_name );
    },
    //********************************************  COMPUTE      *****************************************************//
    buildLinkOpenNewTab: function ( link, id ) {
        var _span_link                         = '<span class="shinken-link-icon-button"><span class="shinken-link-icon shinicon shinicon-open"></span></span>';
        this.dom_link_icon_container.innerHTML = SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( link, id, _span_link, "shinken-link" ).outerHTML;
    },
    //********************************************  ANIMATION    *****************************************************//
    pulsateTag: function ( name ) {
        var _existing = this.getActiveListForUser().getTagByName( name );
        if ( _existing ) {
            _existing.pulsateTag();
        }
        else if ( this.list_elements_inherited ) {
            _existing = this.list_elements_inherited.getTagByName( name );
            if ( _existing ) {
                _existing.pulsateTag();
            }
        }
    },
    //********************************************  AUTO SELECT  *****************************************************//
    hasAutoSelect                 : function () {
        return this.list_element.hasAutoSelect();
    },
    moveAutoSelectCursor          : function ( move_down ) {
        if ( this.component_input_search ) {
            this.component_input_search.need_validation = false;
        }
        this.list_element.moveAutoSelectCursor( move_down );
    },
    validAutoSelect               : function () {
        return this.list_element.validAutoSelect();
    },
    isAllElementsSelectedDisabled : function () {
        return this.getActiveListForUser().isAllElementsSelectedDisabled();
    },
    hasInvalidElementForProduction: function () {
        return this.getActiveListForUser().hasInvalidElementForProduction();
    },
    validSelectedOrFirstElement   : function () {
        this.list_element.selectSelectedOrFirstFilteredElement();
        this.validAutoSelect();
    },
    //********************************************  OTHERS *****************************************************//
    applySiblingSettings: function ( select_comp ) {
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
            case COMPONENT.CONST.TYPE.SINGLE_SELECT_WITH_INPUT:
                var _value = select_comp.getValue();
                if ( _value ) {
                    this.simulateClickOnItem( _value );
                }
                else {
                    this.cleanAllItemsSelected();
                }
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceSelect, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceSelect, SHINKEN.OBJECT.ShinkenObjectHtml );

COMPONENT.Select           = function ( dom_element, type, is_override, parent, datasetLink, allow_multiple_select ) {
    this.__class_name__ = 'COMPONENT.Select';
    // title
    // dom_element
    // dom_select
    // list_element
    // list_element_override
    // list_element_selected
    // last_selected_key_name
    // previous_selected_key_name
    // list_elements_inherited
    // maximum_selected
    this.type                  = type;
    this.is_override           = is_override;
    this.allow_multiple_select = !!allow_multiple_select;
    this.is_editable           = true;
    this.init( dom_element, parent );
    this.setDataSetLink( datasetLink );
    this.__class = SHINKEN.TOOLS.CLASS.CONST.COMPONENT.SELECT;
};
COMPONENT.Select.prototype = {
    init                      : function ( dom_element, parent ) {
        this.uuid        = SHINKEN.TOOLS.STRING.buildUUID();
        this.dom_element = dom_element;
        this.dom_select  = dom_element.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR );
        if ( this.dom_select ) {
            this.dom_link_icon_container = this.dom_select.querySelector( '.shinken-link-icon-container' );
            this.dom_link_icon_button    = this.dom_select.querySelector( '.shinken-link-icon-button' );
        }
        else {
            this.is_editable = false;
        }
        var _dom_list_select = dom_element.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR_LIST );
        this.list_element    = new COMPONENT.ListSelect( _dom_list_select, parent.getParentName(), this.allow_multiple_select );
        this.initSearchElement();
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.MULTI_SELECT:
                var _dom_list_selected       = dom_element.querySelector( '.shinken-list-selected-in-select' );
                var _dom_list_inherited      = dom_element.querySelector( '.shinken-list-inherited' );
                var _dom_list_override       = dom_element.querySelector( '.shinken-list-override' );
                this.list_element_selected   = new COMPONENT.ListTag( _dom_list_selected, parent.name );
                this.list_elements_inherited = new COMPONENT.ListTag( _dom_list_inherited );
                this.list_element_override   = new COMPONENT.ListTag( _dom_list_override );
                break;
            case COMPONENT.CONST.TYPE.MULTI_SELECT_BASIC:
                var _dom_list_selected     = dom_element.querySelector( '.shinken-list-selected-in-select' );
                this.list_element_selected = new COMPONENT.ListTag( _dom_list_selected, parent.name );
                break;
        }
        this.initCounters( parent );
    },
    initSearchElement         : function () {
        var _dom = this.dom_element.querySelector( ".shinken-input-search" );
        if ( _dom ) {
            this.component_input_search = new COMPONENT.Input( _dom );
        }
    },
    updateWithTemplateSpecific: function ( tags ) {
        this.list_elements_inherited.addTags( tags );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Select, COMPONENT.InterfaceSelect );


COMPONENT.SelectFromData           = function ( type ) {
    this.__class_name__ = 'COMPONENT.SelectFromData';
    this.type           = type;
    this.is_editable    = true;
    this.default_label_for_select  = '-- --';
    this.init();
};
COMPONENT.SelectFromData.prototype = {
    init: function () {
        this.uuid         = SHINKEN.TOOLS.STRING.buildUUID();
        this.list_element = new COMPONENT.ListSelectFromData();
        //switch ( this.type ) {
        //    case COMPONENT.CONST.TYPE.MULTI_SELECT:
        //        break;
        //    case COMPONENT.CONST.TYPE.MULTI_SELECT_BASIC:
        //        this.list_element_selected = new COMPONENT.ListTagFromData();
        //        break;
        //}
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setDefaultLabelForSelector: function ( to_set ) {
        this.default_label_for_select = to_set;
    },
    setOptionsFromArray: function ( to_set ) {
        for ( var i = 0, _size_i = to_set.length; i < _size_i; i++ ) {
            this.addOption( to_set[ i ] );
        }
    },
    addOption          : function ( to_add ) {
        this.list_element.addFromString( to_add.name, to_add.label, to_add.filtering_option );
        if ( to_add.is_selected ) {
            this.setLastSelectedElementName( to_add.name );
        }
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.list_element.computeHtml();
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-select-container", "data-state-selector": 0 } ) );
        
        this.dom_select = DOM.Service.createElement( "div",
            {
                class  : "shinken-select-selector shinken-user-select-none",
                onclick: "MANAGER.EventManager.clickOnSelector(event)"
            }, '<span class="shinken-selector-label shinken-space">' + this.default_label_for_select  + '</span><span class="caret"></span>' );
        if ( this.getLastSelectedElement() ) {
            this.dom_select.innerHTML = '<span class="shinken-selector-label shinken-space">' + this.getLastSelectedElement().getLabel() + '</span><span class="caret"></span>';
        }
        
        for ( var i = 0, _size_i = this.list_element.size_list; i < _size_i; i++ ) {
            DOM.Service.addElementTo( this.list_element.list[ i ].dom_element, this.list_element.dom_element_select_content );
        }
        DOM.Service.addElementTo( this.dom_select, this.dom_element );
        DOM.Service.addElementTo( this.list_element.dom_element, this.dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.SelectFromData, COMPONENT.InterfaceSelect );
