//__lib__ lib_common
"use strict";
SHINKEN.OBJECT.LastModificationElement           = function ( element_modified, previous, next ) {
    this.init( element_modified, previous, next );
};
SHINKEN.OBJECT.LastModificationElement.prototype = {
    init: function ( element_modified, previous, next ) {
        this.uuid                              = SHINKEN.TOOLS.STRING.buildUUID();
        this.element_modified_param_for_events = element_modified.getParamForEvents();
        this.setPrevious( previous );
        this.setNext( next );
    },
    //********************************************  SETTER GETTER   **************************************************//
    isValid               : function () {
        if ( this.previous && this.next ) {
            return !SHINKEN.TOOLS.DICT.isEquals( this.previous, this.next );
        }
        return this.previous !== this.next;
    },
    setPrevious           : function ( previous ) {
        this.previous = previous;
    },
    setNext               : function ( next ) {
        this.next = next;
    },
    setParam              : function ( param_name, to_set ) {
        this[ param_name ] = to_set;
    },
    getParam              : function ( param_name ) {
        return this[ param_name ];
    },
    getPrevious           : function () {
        return this.previous;
    },
    getNext               : function () {
        return this.next;
    },
    getNextOrPrevious     : function ( event_name ) {
        switch ( event_name ) {
            case "undo_last_modification":
                return this.getPrevious();
            case "redo_last_modification":
                return this.getNext();
        }
    },
    addParamForEvents     : function ( key, value ) {
        this.element_modified_param_for_events[ key ] = value;
    },
    getModifiedObjectParam: function ( key ) {
        return this.element_modified_param_for_events[ key ];
    },
    getUUID               : function () {
        return this.uuid;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LastModificationElement, SHINKEN.OBJECT.ShinkenObject );
