//__lib__ lib_common
"use strict";
SHINKEN.OBJECT.LastModification           = function ( type_modification ) {
    this.init( type_modification );
};
SHINKEN.OBJECT.LastModification.prototype = {
    init: function ( type_modification ) {
        this.initContents();
        this.setTypeModification( type_modification );
        this.setTimestamp();
        
    },
    //********************************************  SETTER GETTER   **************************************************//
    setTypeModification        : function ( to_set ) {
        this.type_modification = to_set;
    },
    setTimestamp               : function ( to_set ) {
        this.timestamp = Date.now();
    },
    setExtraParam              : function ( to_set ) {
        this.extra_params = to_set;
    },
    getExtraParam              : function () {
        return this.extra_params;
    },
    getTypeModification        : function () {
        return this.type_modification;
    },
    IsTypeOfModification       : function ( array_to_test ) {
        for ( let i = 0, _size_i = array_to_test.length; i < _size_i; i++ ) {
            if ( this.type_modification === array_to_test[ i ] ) {
                return true;
            }
        }
        return false;
    },
    getUUID                    : function () {
        return this.index;
    },
    setIndex                   : function ( index ) {
        this.index = index;
    },
    isValid                    : function () {
        return this.contents.length > 0;
    },
    getAllUuidOfImpactedElement: function () {
        return this.getContents().map( last_modification_element => last_modification_element.getModifiedObjectParam( SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ) );
    },
    //updateHighestElementOfModification: function () {
    //    let highest_element   = this.getContent( 0 );
    //    this.uuid_top_element = this.getContent( 0 ).getElementUuid();
    //
    //    switch ( this.getTypeModification() ) {
    //        case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.MOVE:
    //        case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.RESIZE:
    //            this.getContents().forEach( last_modification_element => {
    //                if ( last_modification_element.getPrevious().top_left_y < highest_element.getPrevious().top_left_y ) {
    //                    highest_element = last_modification_element;
    //                }
    //            } );
    //            this.uuid_top_element            = highest_element.getElementUuid();
    //            this.higgest_position_x_previous = highest_element.getPrevious().top_left_x;
    //            this.higgest_position_y_previous = highest_element.getPrevious().top_left_y;
    //            this.higgest_position_x_next     = highest_element.getNext().top_left_x;
    //            this.higgest_position_y_next     = highest_element.getNext().top_left_y;
    //
    //            break;
    //        case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.DELETE:
    //            this.higgest_position_y_previous = this.getContent( 0 ).getPrevious()[ "position_y" ][ "value" ];
    //            this.getContents().forEach( last_modification_element => {
    //                if ( last_modification_element.getPrevious()[ "position_y" ][ "value" ] < highest_element.getPrevious()[ "position_y" ][ "value" ] ) {
    //                    highest_element = last_modification_element;
    //                }
    //            } );
    //            this.uuid_top_element            = highest_element.getElementUuid();
    //            this.higgest_position_y_previous = highest_element.getPrevious()[ "position_y" ][ "value" ];
    //            break;
    //        case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.CREATE:
    //            this.higgest_position_y_next = this.getContent( 0 ).getNext()[ "position_y" ][ "value" ];
    //            break;
    //    }
    //
    //},
    //********************************************  ACTIONS  **************************************************//
    addSpecific: function ( last_modification_element ) {
        if ( !last_modification_element.isValid() ) {
            return;
        }
        if ( last_modification_element instanceof SHINKEN.OBJECT.LastModificationElement ) {
            this.add( last_modification_element );
        }
        else {
            throw new TypeError( "Only LastModificationElement are allowed in LastModification object" );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LastModification, SHINKEN.OBJECT.ShinkenObjectContainer );