//__lib__ lib_common
"use strict";

SHINKEN_LIST.FilterFromData           = function ( type, name ) {
    this.type = type;
    this.name = name;
    this.init();
};
SHINKEN_LIST.FilterFromData.prototype = {
    init          : function ( params ) {
        this.addParamForEvents( SHINKEN_LIST.CONST.PARAM.FILTER_UUID, this.name );
        this.addParamsForEvents( params );
        this.initComponents();
    },
    initComponents: function () {
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
                this.component = new COMPONENT.SelectFromData( this.type );
                break;
            case COMPONENT.CONST.TYPE.STRING_INPUT:
                this.component = new COMPONENT.InputFromData();
                this.component.setPlaceholder( this.getPlaceholderLabel() );
                this.component.skipValidation( true );
                break;
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getPlaceholderLabel: function () {
        switch ( this.name ) {
            case "item.visualisation_name":
                return _( "filter.message_placeholder_visualisation_name", [DICTIONARY_COMMON_UI] );
            case "item.item_type":
                return _( "filter.message_placeholder_item_type", [DICTIONARY_COMMON_UI] );
            default:
                return _( "filter.message_placeholder", [DICTIONARY_COMMON_UI] );
        }
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.dom_element = DOM.Service.createElement( "td", { class: "shinken-list-filter", "data-name": this.name, "data-object-type": "shinken-list-filter", "data-type": this.type } );
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.HIDDEN:
                this.dom_element.classList.add( "shinken-text-centred" );
                this.addDomElement( DOM.Service.createElement( "span", {}, "--" ) );
                break;
            default:
                this.getComponent().computeHtml();
                this.addDomElement( this.getComponent().dom_element );
                break;
        }
        //this.initComponents();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.FilterFromData, SHINKEN_LIST.Filter );

SHINKEN_LIST.FilterFromData_V3           = function ( type, name, params ) {
    this.type = type;
    this.name = name;
    this.init( params );
};
SHINKEN_LIST.FilterFromData_V3.prototype = {
    init          : SHINKEN_LIST.FilterFromData.prototype.init,
    initComponents: function () {
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
                this.component = new COMPONENT.SelectFromData( this.type );
                break;
            case COMPONENT.CONST.TYPE.STRING_INPUT:
                this.component = new COMPONENT.InputFromData_V3( "filter_input", "", this.getParamForEvents() );
                this.component.setPlaceholder( this.getPlaceholderLabel() );
                this.component.skipValidation( true );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.FilterFromData_V3, SHINKEN_LIST.FilterFromData );
