//__lib__ lib_common

"use strict";

SHINKEN_LIST.FiltersFromData           = function ( headers_array ) {
    this.init( headers_array );
};
SHINKEN_LIST.FiltersFromData.prototype = {
    init: function ( headers_array ) {
        this.initContents();
        for ( var i = 0, _size_i = headers_array.length; i < _size_i; i++ ) {
            this.add( this.getChildConstructor( COMPONENT.CONST.TYPE.STRING_INPUT, headers_array[ i ].name ) );
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getChildConstructor: function ( type, name ) {
        return new SHINKEN_LIST.FilterFromData( type, name );
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    
    //********************************************  OTHERS *****************************************************//
    
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.dom_element = DOM.Service.createElement( "tr", { class: "shinken-filter-line" } );
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].computeHtml();
            DOM.Service.addElementTo( this.contents[ i ].getDomElement(), this.dom_element );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.FiltersFromData, SHINKEN_LIST.Filters );

SHINKEN_LIST.FiltersFromData_V3           = function ( headers_array, params ) {
    this.initSpecific( headers_array, params );
};
SHINKEN_LIST.FiltersFromData_V3.prototype = {
    initSpecific: function ( headers_array, params ) {
        this.addParamForEvents( SHINKEN_LIST.CONST.PARAM.FILTERS_UUID, "main_filters_list" );
        this.addParamsForEvents( params );
        this.init( headers_array );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getChildConstructor: function ( type, name ) {
        return new SHINKEN_LIST.FilterFromData_V3( type, name, this.getParamForEvents() );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.FiltersFromData_V3, SHINKEN_LIST.FiltersFromData );