//__lib__ lib_common
"use strict";

SHINKEN_LIST.HeadersWithSortFromData           = function () {
    this.current_index_sorting = 0;
};
SHINKEN_LIST.HeadersWithSortFromData.prototype = {
    init                       : function () {
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter      : function ( event_name, param_1, param_2, param_3 ) {
        switch ( param_1 ) {
            case "click-on-option-header-popup":
                this.clickOnOptionHeaderSorting(event_name, param_1, param_2, param_3);
                break;
            case "click-on-header":
                this.doActionAfterHeaderSorting( event_name, param_1, param_2, param_3 );
                break;
            case "click-on-header-popup":
                this.getContentByUUID( param_2 ).doActionAfter( event_name, param_1, param_2, param_3 );
                break;
        }
        this.doActionAfterCommon( event_name, param_1, param_2, param_3 );
    },
    //********************************************  SORTING  **************************************************//
    _computeCurrentIndexSorting: function ( is_cumulative ) {
        this.current_index_sorting = (this.current_index_sorting && is_cumulative) ? this.current_index_sorting + 1 : 1;
    },
    cleanSorting               : function () {
        let _active_headers = this.getActiveSortingHeaders();
        for ( let i = 0, size_i = _active_headers.length; i < size_i; i++ ) {
            _active_headers[ i ].setSortingStatus( SHINKEN.OBJECT.SORTING.STATUS.NONE );
        }
    },
    doActionAfterHeaderSorting       : function ( event_name, param_1, param_2, event ) {
        let _header = this.getContentByUUID( param_2 );
        if ( !event.shiftKey && (_header.getSortingStatus() === SHINKEN.OBJECT.SORTING.STATUS.NONE || this.current_index_sorting > 1) ) {
            this.cleanSorting();
        }
        //let _index = _header.getSortingIndex() || this.current_index_sorting;
        if ( _header.getSortingIndex() ) {
            _header.doActionAfter( event_name, param_1, _header.getSortingIndex(), event );
        }
        else {
            this._computeCurrentIndexSorting( event.shiftKey );
            _header.doActionAfter( event_name, param_1, this.current_index_sorting, event );
        }
        this._computeAllIndexes();
    },
    _computeAllIndexes         : function () {
        let _active_headers = SHINKEN.TOOLS.ARRAY.cleanEmpty( this.getActiveSortingHeaders() );
        for ( var i = 0, size_i = _active_headers.length; i < size_i; i++ ) {
            _active_headers[ i ].setSortingIndex( i + 1 );
        }
        if ( !size_i ){
            this.current_index_sorting = 0;
        }
    },
    clickOnOptionHeaderSorting : function ( event_name, param_1, param_2, event  ) {
        let _option_dom = DOM.Service.findParentElementWithClass( event.target, "shinken-list-header-sort-popup-option" );
        let _header     = this.getContentByUUID( param_2 );
        let _to_set     = {};
        if ( _option_dom.dataset.status === SHINKEN.OBJECT.SORTING.STATUS.NONE ) {
            let _index = _header.getSortingIndex();
            _to_set.index = 0;
        }
        else {
            if ( !_header.getSortingIndex() ) {
                this._computeCurrentIndexSorting( true );
                _to_set.index = this.current_index_sorting;
            }
            else {
                _to_set.index = _header.getSortingIndex();
            }
        }
        _to_set.status = _option_dom.dataset.status;
        _header.doActionAfter( event_name, param_1, _to_set, event );
        this._computeAllIndexes();
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeadersWithSortFromData, SHINKEN_LIST.HeadersFromData );