//__lib__ lib_common
"use strict";
SHINKEN_LIST.LinesFromHtml           = function ( dom_element, type ) {
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.LinesFromHtml.prototype = {
    init               : function ( dom_element ) {
        this.initCommon();
        this.mapping_parents = {};
        this.initContentsWithDom( DOM.Service.querySelectorAllWithOutChild( dom_element, "shinken-list-line", "shinken-list-table" ) );
    },
    initContentsWithDom: function ( dom_elements ) {
        var _current;
        for ( var i = 0, _size_i = dom_elements.length; i < _size_i; i++ ) {
            _current = new SHINKEN_LIST.LineFromHtml( dom_elements[ i ], this.type );
            this.addSpecific( _current );
            this.addMappingParent( _current.parent_uuid, _current.uuid );
        }
    },
    addMappingParent   : function ( parent_uuid, uuid ) {
        if ( !parent_uuid ) {
            if ( !this.mapping_parents[ uuid ] ) {
                this.mapping_parents[ uuid ] = [];
            }
        }
        else {
            if ( !this.mapping_parents[ parent_uuid ] ) {
                this.mapping_parents[ parent_uuid ] = [];
            }
            this.mapping_parents[ parent_uuid ].push( this.getContentByUUID( uuid ) );
        }
    },
    removeMappingParent: function ( parent_uuid, _to_remove ) {
        if ( parent_uuid ) {
            SHINKEN.TOOLS.ARRAY.removeElement( this.mapping_parents[ parent_uuid ], _to_remove );
        }
    },
    remove             : function ( uuid ) {
        var _to_remove = this.mapping[ uuid ];
        delete this.mapping[ uuid ];
        this.removeMappingParent( _to_remove.parent_uuid, _to_remove );
        SHINKEN.TOOLS.ARRAY.removeElement( this.contents, _to_remove );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    addLineWithDom: function ( dom_element ) {
        var _to_add = new SHINKEN_LIST.LineFromHtml( dom_element, this.type );
        this.add( _to_add );
        this.addMappingParent( _to_add.parent_uuid, _to_add.uuid );
    },
    //********************************************  COLLAPSE  *****************************************************//
    toggleCollapse          : function ( uuid ) {
        this.getContentByUUID( uuid ).toggleCollapse( this.mapping_parents[ uuid ] );
    },
    setIsCollapseAllData    : function ( to_set ) {
        var _keys = Object.keys( this.mapping_parents );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.getContentByUUID( _current_key ).setIsCollapsed( to_set, this.mapping_parents[ _current_key ] );
        }
    },
    isAllActiveLineCollapsed: function () {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( !this.contents[ i ].isCollapsedOrFiltered() ) {
                return false;
            }
        }
        return true;
    },
    //********************************************  FILTERS  *****************************************************//
    applyFilter               : function ( filters ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].applyFilter( filters );
        }
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                this.filterParentWithNoChildren();
                break;
        }
    },
    filterParentWithNoChildren: function () {
        var _current;
        var _filter;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ];
            if ( _current.is_filtered !== SHINKEN_LIST.CONST.FILTER.STATUS.HAS_CHILDREN ) {
                continue;
            }
            if ( _current.parent_uuid ) {
                continue;
            }
            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            for ( var j = 0, _size_j = this.contents.length; j < _size_j; j++ ) {
                if ( this.contents[ j ].parent_uuid === _current.getUUID() && this.contents[ j ].is_filtered === SHINKEN_LIST.CONST.FILTER.STATUS.OFF ) {
                    _filter = SHINKEN_LIST.CONST.FILTER.STATUS.OFF;
                    break;
                }
            }
            _current.setFilter( _filter );
        }
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave: function ( type ) {
        var _to_return = type === CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE ? {} : [];
        var _current;
        var _current_data;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ];
            if ( _current.isSelected() ) {
                switch ( this.type ) {
                    case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                        switch ( type ) {
                            case CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE:
                                _current_data = _current.getDataToSave( type );
                                if ( !_to_return[ _current.host.getUUID() ] ) {
                                    _to_return[ _current.host.getUUID() ] = [];
                                }
                                _to_return[ _current.host.getUUID() ].push( _current_data );
                                break;
                            
                            default:
                                _to_return.push( _current.getDataToSave( type ) );
                                break;
                        }
                        break;
                    default:
                        _to_return.push( _current.getDataToSave( type ) );
                        break;
                }
            }
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LinesFromHtml, SHINKEN_LIST.Lines );