//__lib__ lib_common
"use strict";
SHINKEN_LIST.SetFromHtml           = function ( dom_element, type, structure_format ) {
    //lines
    //filters
    //headers
    this.type             = type;
    this.structure_format = structure_format || SHINKEN_LIST.CONST.STRUCTURE_FORMAT.GENERIC;
    this.init( dom_element );
    this.edit_mode = false;
};
SHINKEN_LIST.SetFromHtml.prototype = {
    init               : function ( dom_element ) {
        this.initCommon();
        this.setDomElement( dom_element );
        //this.initStructureFormat();
        this.initHeaders();
        this.initFilters();
        this.initLines();
        this.is_all_data_selected  = this.dom_element.classList.contains( "shinken-selected" ) ? SHINKEN_LIST.CONST.SELECTION.STATUS.ON : SHINKEN_LIST.CONST.SELECTION.STATUS.OFF;
        this.is_all_data_collapsed = false;
        this.updateHtml();
        var _check_box = DOM.Service.askFindChildElementWithClass( this.dom_element, "shinken-all-elements-check-box-filter", "shinken-list-table" );
        if ( _check_box ) {
            this.checkbox = new OBJECT.ElementCheckbox( _check_box.querySelector( ".shinken-checkbox" ) );
        }
        this.setSelectAllStatus();
    },
    //********************************************  GETTER SETTER  *****************************************************//
    addLineWithDom: function ( dom_element ) {
        this.lines.addLineWithDom( dom_element );
        this.updateHtml();
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    
    //********************************************  HEADERS  *****************************************************//
    initHeaders: function () {
        this.headers = new SHINKEN_LIST.HeadersFromHtml( this.dom_element.querySelector( ".shinken-header-line" ) );
    },
    //********************************************  FILTERS  *****************************************************//
    initFilters        : function () {
        this.filters = new SHINKEN_LIST.FiltersFromHtml( this.dom_element.querySelector( ".shinken-filter-line" ), this.type );
    },
    //********************************************  LINES  *****************************************************//
    initLines          : function () {
        var dom_element = this.dom_element;
        switch ( this.structure_format ) {
            case SHINKEN_LIST.CONST.STRUCTURE_FORMAT.GENERIC:
                if ( !dom_element.classList.contains( "shinken-list-table" ) ) {
                    var temp_dom_element = DOM.Service.askFindChildElementWithClass( dom_element, "shinken-list-table", "shinken-list-line" );
                    if ( temp_dom_element ) {
                        dom_element = temp_dom_element;
                    }
                }
                break;
            case SHINKEN_LIST.CONST.STRUCTURE_FORMAT.WITH_HEADER_FIX:
                dom_element = dom_element.querySelector( ".shinken-scrollable-container .shinken-list-table" );
                break;
        }
        this.setLines( new SHINKEN_LIST.LinesFromHtml( dom_element, this.type ) );
    },
    setLines : function ( to_set ) {
        if ( this.lines ) {
            this.lines.resetContents();
    }
        this.lines = to_set;
        this.addSynchronizedPhase( this.lines.phase );
        to_set.setCountersParent( this );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.SetFromHtml, SHINKEN_LIST.Set );