//__lib__ lib_common
//priority 100
"use strict";

SHINKEN_LIST.Filters           = function () {
    //contents
    this.init();
};
SHINKEN_LIST.Filters.prototype = {
    init: function () {
        this.initContents();
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getActiveFilters: function () {
        var _to_return = [];
        var _keys      = Object.keys( this.contents );
        var _current_key;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].isSet() ) {
                _to_return.push( this.contents[ i ] );
            }
        }
        return _to_return;
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter        : function ( event_name, param, param_2, param_3 ) {
        switch ( event_name ) {
            case "onchange_in_input_V3":
                this.getContentByUUID( param[ SHINKEN_LIST.CONST.PARAM.FILTER_UUID ] ).doActionAfter( event_name, param );
                return;
        }
        this.doActionAfterCommon( event_name, param, param_2, param_3 );
    },
    askComputeAfterChange: function ( dom_element, parent ) {
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( dom_element, 'name', 10 );
        var _type               = _parent_dom_element.dataset.objectType;
        switch ( _type ) {
            case 'shinken-list-filter':
                this.getContentByUUID( _parent_dom_element.dataset.name ).askComputeAfterChange( dom_element, parent || this, { 'type': _type } );
                break;
        }
    },
    onClick              : function ( event ) {
        var _filter = this.getContentByEvent( event );
        this.hidePopup( _filter );
    },
    clickOnSelector      : function ( event ) {
        var _filter = this.getContentByEvent( event );
        this.hidePopup( _filter );
        if ( _filter ) {
            _filter.clickOnSelector();
        }
    },
    clickOnItemSelector  : function ( event ) {
        var _option             = DOM.Service.findParentElementWithDataSet( event.target, 'keyName', 10 );
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 20 );
        var _type               = _parent_dom_element.dataset.objectType;
        switch ( _type ) {
            case 'shinken-list-filter':
                this.getContentByUUID( _parent_dom_element.dataset.name ).clickOnItemSelector( _option.dataset.keyName, _parent_dom_element, false, event );
                break;
        }
    },
    clickOnInput         : function ( event ) {
        var _filter = this.getContentByEvent( event );
        if ( _filter ) {
            _filter.clickOnInput();
        }
    },
    //********************************************  OTHERS *****************************************************//
    getObjectsType      : function () {
        return "shinken-list-filter";
    },
    applySiblingSettings: function ( list_filters ) {
        var _keys = Object.keys( this.contents );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.contents[ _keys[ i ] ].applySiblingSettings( list_filters.contents[ _keys[ i ] ] );
        }
    },
    hidePopup           : function ( filter_exception ) {
        var _keys = Object.keys( this.contents );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.contents[ _keys[ i ] ].hidePopup( filter_exception );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Filters, SHINKEN.OBJECT.ShinkenObjectContainerHtml );