//__lib__ lib_common
"use strict";
SHINKEN.OBJECT.DefaultConfiguration           = function ( default_configuration ) {
    this.init( default_configuration );
};
SHINKEN.OBJECT.DefaultConfiguration.prototype = {
    init        : function ( default_configuration ) {
        this.initInternal();
        this.updateData( default_configuration );
    },
    initInternal: function () {
        this.own_children_keys     = [];
        this.own_property_keys     = [];
        this.unknown_property_keys = [];
        this.initMessages();
        this.initCounterCommon();
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS ).setDataTargetName( "nbError" );
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS ).setDataTargetName( "nbWarning" );
    },
    initMessages: function () {
        this.messages = this.getObjectMessagesConstructor();
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getValidOwnProperty : function ( property_name ) {
        if ( typeof this.valid_own_property === "undefined" ) {
            this.valid_own_property = this._getValidOwnProperty();
        }
        if ( property_name ) {
            return this.valid_own_property.getParameter(  property_name );
        }
        return this.valid_own_property;
    },
    _getValidOwnProperty: function () {
        return false;
    },
    getValidOwnChildren : function () {
        if ( typeof this.valid_own_children === "undefined" ) {
            this.valid_own_children = this._getValidOwnChildren();
        }
        return this.valid_own_children;
    },
    _getValidOwnChildren: function () {
        return false;
    },
    _getObjectToJson    : function ( format_data__20241115 ) {
        //this.computeMandatoryMissingData();
        var _valid_own_property = this.getValidOwnProperty() ? this.getValidOwnProperty().getKeys() : false;
        var _to_add             = _valid_own_property || this.own_property_keys || [];
        var to_return           = {};
        for ( var i = 0, _size_i = _to_add.length; i < _size_i; i++ ) {
            if ( typeof this[ _to_add[ i ] ] === 'undefined' ) {
                continue;
            }
            to_return[ _to_add[ i ] ] = this[ _to_add[ i ] ].getObjectToJson( format_data__20241115 );
        }
        return to_return;
    },
    //computeMandatoryMissingData: function () {
    //},
    getDefaultValueLabel        : function () {
        return "default";
    },
    setDataAsUnknownProperty    : function ( key, value ) {
        this[ key ] = this.getObjectParamConstructor( key, value );
        this[ key ].setCountersParent( this );
        this.unknown_property_keys.push( key );
    },
    getObjectParamConstructor   : function ( key, value, parameter, default_value ) {
        return new SHINKEN.OBJECT.Param( key, value, parameter, default_value );
    },
    getObjectMessagesConstructor: function () {
        return new SHINKEN.OBJECT.MessagesConfig();
    },
    isObjectParamConstructor    : function ( value_object ) {
        return value_object instanceof SHINKEN.OBJECT.Param;
    },
    setIsNotTheExpectedObject   : function ( key, value_object ) {
        if ( !this.not_valid_format_property ) {
            this.not_valid_format_property = {};
        }
        this.not_valid_format_property[ key ] = this.isObjectParamConstructor( value_object ) ? value_object : this.getObjectParamConstructor( key, value_object );
        this._setIsNotTheExpectedObject();
    },
    _setIsNotTheExpectedObject  : function ( key, value ) {
    },
    //********************************************  UPDATE DATA   **************************************************//
    updateData                  : function ( data ) {
        if ( !data ) {
            return;
        }
        
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setMessageValidation        : function ( value ) {
        this.setMessages( value );
    },
    setData                     : function ( key, value ) {
        return this._setData( key, value );
    },
    setDataKey                  : function ( key, value ) {
        this[ key ] = this.getObjectParamConstructor( key, value );
        this[ key ].setCountersParent( this );
        SHINKEN.TOOLS.ARRAY.addElement(this.own_property_keys, key);
    },
    _setData                    : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.MESSAGES:
                this.setMessages( value );
                break;
            default:
                if ( typeof value === 'object' && value !== null && value !== undefined ) {
                    if ( !this._setDataDefaultObject( key, value ) ) {
                        this.setDataAsUnknownProperty( key, value );
                    }
                    this.own_children_keys.push( key );
                }
                else {
                    this.setValueDefault( key, value );
                }
                break;
        }
    },
    _setDataDefaultObject       : function ( key, value ) {
        this[ key ] = new SHINKEN.OBJECT.DefaultConfiguration( value );
        this[ key ].setCountersParent( this );
        return true;
    },
    setValueDefault             : function ( key, value ) {
        this[ key ]               = new this.getObjectParamConstructor( key, {} );
        this[ key ].user_value    = value;
        var _valid_own_properties = this.getValidOwnProperty();
        if ( _valid_own_properties ) {
            var _parameter = _valid_own_properties.getParameter( key );
            if ( !_parameter ) {
                var _valid_own_own_children_keys = this.getValidOwnChildren();
                if ( _valid_own_own_children_keys && SHINKEN.TOOLS.ARRAY.contains( _valid_own_own_children_keys.getKeys(), key ) ) {
                    this.setIsNotTheExpectedObject( key, this[ key ] );
                }
                else {
                    this.unknown_property_keys.push( key );
                }
                return;
            }
            else {
                this.changeToDefaultValueIfNeeded( key, value, _parameter );
            }
        }
        SHINKEN.TOOLS.ARRAY.addElement(this.own_property_keys, key);
    },
    changeToDefaultValueIfNeeded: function ( key, value, parameter ) {
        if ( value && value !== "" ) {
            return;
        }
        if ( parameter.is_mandatory ) {
            return;
        }
        if ( parameter.validation_value && !SHINKEN.TOOLS.ARRAY.contains( parameter.validation_value, this.getDefaultValueLabel() ) ) {
            return;
        }
        this[ key ].setValue( this.getDefaultValueLabel() );
        this[ key ].setUserValue( this.getDefaultValueLabel() );
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfiguration, SHINKEN.OBJECT.CounterInterfaceValidation );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfiguration, SHINKEN.OBJECT.ShinkenObjectJson );


SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty.prototype = {
    //********************************************  GETTER SETTER  *****************************************************//
    _setDataDefaultObject: function ( key, value_object ) {
        var _current = this.getValidOwnChildren().getConfigurationChild( key );
        if ( _current ) {
            if ( this[ key ] ) {
                this[ key ].updateData( value_object );
            }
            else if ( typeof value_object === "undefined" ) {
                this[ key ] = eval( "new " + _current.class_constructor + "({})" );
            }
            else {
                this[ key ] = eval( "new " + _current.class_constructor + "(value_object)" );
            }
            if ( _current.extra_action ) {
                eval( "this[ key ]." + _current.extra_action );
            }
            SHINKEN.TOOLS.ARRAY.addElement(this.own_children_keys, key);
            this[ key ].setCountersParent( this );
            return true;
        }
        return false;
    },
    _getValidOwnProperty : function () {
        return new SHINKEN_VALIDATION.Parameters();
    },
    _getValidOwnChildren : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren();
    },
    getChildrenObject    : function () {
        var _to_return             = [];
        var _own_own_children_keys = this._getValidOwnChildren().getKeys();
        var _to_add                = null;
        for ( var i = 0, _size_i = _own_own_children_keys.length; i < _size_i; i++ ) {
            _to_add = this.getChild( _own_own_children_keys[ i ] );
            if ( _to_add ) {
                _to_return.push( _to_add );
            }
        }
        return _to_return;
    },
    getChildrenObjectDict: function () {
        var _to_return             = {};
        var _own_own_children_keys = this._getValidOwnChildren().getKeys();
        var _to_add                = null;
        for ( var i = 0, _size_i = _own_own_children_keys.length; i < _size_i; i++ ) {
            _to_add = this.getChild( _own_own_children_keys[ i ] );
            if ( _to_add ) {
                _to_return[ _own_own_children_keys[ i ] ] = _to_add;
            }
        }
        return _to_return;
    },
    getChild             : function ( key ) {
        if ( !this[ key ] || typeof this[ key ] === 'string' ) {
            this._setDataDefaultObject( key );
        }
        return this[ key ];
    },
    getValue             : function ( key ) {
        if ( !this[ key ] ) {
            this.setValueDefault( key );
        }
        return this[ key ].getValue();
    },
    getBooleanValue      : function ( key ) {
        return SHINKEN.TOOLS.BOOLEAN.parseToBoolean( this.getValue( key ) );
    },
    isValid              : function ( key ) {
        if ( !this[ key ] ) {
            this.setValueDefault( key );
        }
        return !this[ key ].hasCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
    },
    setDataKey           : function ( key, value ) {
        this[ key ] = this.getObjectParamConstructor( key, value, this.getValidOwnProperty().getParameter( key ), this.getDefaultValueLabel(), this.is_belonging_to_grid_cell_object );
        this[ key ].setCountersParent( this );
        SHINKEN.TOOLS.ARRAY.addElement(this.own_property_keys, key);
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave             : function () {
        var _to_return = {};
        if ( this.unknown_property_keys ) {
            for ( let i = 0, _size_i = this.unknown_property_keys.length; i < _size_i; i++ ) {
                _to_return[ this.unknown_property_keys[ i ] ] = this[ this.unknown_property_keys[ i ] ].getDataToSave();
            }
        }
        for ( let i = 0, _size_i = this.own_property_keys.length; i < _size_i; i++ ) {
            _to_return[ this.own_property_keys[ i ] ] = this[ this.own_property_keys[ i ] ].getDataToSave();
        }
        for ( let i = 0, _size_i = this.own_children_keys.length; i < _size_i; i++ ) {
            _to_return[ this.own_children_keys[ i ] ] = this[ this.own_children_keys[ i ] ].getDataToSave();
        }
        return _to_return;
    },
    getDataForLastModification: function () {
        let _to_return = {};
        for ( let i = 0, _size_i = this.own_property_keys.length; i < _size_i; i++ ) {
            _to_return[ this.own_property_keys[ i ] ] = {
                [ SHINKEN.OBJECT.CONST.PARAM.VALUE ]: this[ this.own_property_keys[ i ] ].getDataForLastModification(), [ SHINKEN.OBJECT.CONST.PARAM.SOURCE_VALUE ]: this[ this.own_property_keys[ i ] ].getDataToSave()
            };
        }
        for ( let i = 0, _size_i = this.own_children_keys.length; i < _size_i; i++ ) {
            _to_return[ this.own_children_keys[ i ] ] = { [ SHINKEN.OBJECT.CONST.PARAM.VALUE ]: this[ this.own_children_keys[ i ] ].getDataForLastModification() };
        }
        return _to_return;
    },
    //********************************************  VALIDATION  *****************************************************//
    getAllObjectWithMessages: function () {
        var to_return = [];
        if ( this.messages && this.messages.hasStatus() ) {
            to_return.push( this );
        }
        var _current;
        for ( var i = 0, _size_i = this.own_property_keys.length; i < _size_i; i++ ) {
            _current = this[ this.own_property_keys[ i ] ];
            if ( _current.messages && _current.messages.hasStatus() ) {
                to_return.push( _current );
            }
        }
        for ( var j = 0, _size_j = this.own_children_keys.length; j < _size_j; j++ ) {
            to_return = SHINKEN.TOOLS.ARRAY.concat( to_return, this[ this.own_children_keys[ j ] ].getAllObjectWithMessages() );
        }
        if ( this.unknown_property_keys ) {
            for ( let i = 0, _size_i = this.unknown_property_keys.length; i < _size_i; i++ ) {
                if ( this[ this.unknown_property_keys[ i ] ].messages && this[ this.unknown_property_keys[ i ] ].messages.hasStatus() ) {
                    to_return.push( this[ this.unknown_property_keys[ i ] ] );
                }
            }
        }
        return to_return;
    }
};


SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty, SHINKEN.OBJECT.DefaultConfiguration );

SHINKEN.OBJECT.DefaultConfigurationChildren           = function ( parameters ) {
    this.content = [];
    if ( parameters ) {
        this.init( parameters );
    }
};
SHINKEN.OBJECT.DefaultConfigurationChildren.prototype = {
    init                 : function ( parameters ) {
        for ( var i = 0, _size_i = parameters.length; i < _size_i; i++ ) {
            this.content.push( new SHINKEN.OBJECT.DefaultConfigurationChild( parameters[ i ] ) );
        }
    },
    getConfigurationChild: function ( key ) {
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            if ( this.content[ i ].key === key ) {
                return this.content[ i ];
            }
        }
        return null;
    },
    getKeys              : function () {
        return SHINKEN.TOOLS.ARRAY.extractKey( this.content, 'key' );
    },
    getContent           : function () {
        return this.content;
    }
};

SHINKEN.OBJECT.DefaultConfigurationChild           = function ( args ) {
    this.key               = args[ 0 ];
    this.class_constructor = args[ 1 ];
    this.extra_action      = args[ 2 ];
};
SHINKEN.OBJECT.DefaultConfigurationChild.prototype = {};