//__lib__ lib_common
"use strict";

SHINKEN.OBJECT.SPACEBOX           = {
    CONST: {
        TYPE: {
            CREATION: "shinken-create",
            DELETION: "shinken-delete"
        }
    }
};
SHINKEN.OBJECT.SpaceBox           = function ( type, max_width ) {
    this.__class_name__ = "SHINKEN.OBJECT.SpaceBox";
    this.type           = type;
    this.max_width      = max_width;
};
SHINKEN.OBJECT.SpaceBox.prototype = {
    addOrRemoveDragInProgress: function ( add_or_remove ) {
        DOM.BodyService.addOrRemoveClasses( add_or_remove, "shinken-has-drag-in-progress-overlay-frame" );
    },
    //********************************************  HTML  *****************************************************//
    computeHtml                   : function () {
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-space-box " + this.type } ) );
        DOM.Service.setStyles( this.getDomElement(), this.getInitStyle() );
        this.computeExtraHtml();
    },
    computeExtraHtml              : function () {
    },
    getInitStyle                  : function () {
        return {
            top   : this.getComputedStartY() - this.offset_y,
            left  : 0,
            right : 0,
            height: 0
        };
    },
    getBoundingZone               : function () {
        return {
            left  : 0,
            right : this.max_width,
            top   : this.parsePixelToGrid_y( Math.min( this.getComputedEndY(), this.getComputedStartY() ) ),
            bottom: this.parsePixelToGrid_y( Math.max( this.getComputedEndY(), this.getComputedStartY() ) )
        };
    },
    computeFrameDisplayStyle      : function () {
        const _computed_start_y = this.getComputedStartY();
        const _computed_end_y   = this.getComputedEndY();
        const _computed_height  = this.computeHeight( _computed_end_y, _computed_start_y );
        const _computed_top     = _computed_end_y < _computed_start_y ? _computed_start_y - _computed_height : _computed_start_y; //USEFUL TO PREVENT THE SPACE BOX FROM SLIDING UPWARDS
        
        this.doExtraFrameDisplayStyleAction( _computed_height );
        return {
            top   : _computed_top - this.offset_y,
            height: _computed_height
        };
    },
    computeHeight                 : function () {
    },
    doExtraFrameDisplayStyleAction: function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SpaceBox, SHINKEN.OBJECT.OverlayFrameForGrid );

SHINKEN.OBJECT.SpaceBoxCreation               = function ( grid ) {
    this.__class_name__ = "SHINKEN.OBJECT.SpaceBoxCreation";
    this.type           = SHINKEN.OBJECT.SPACEBOX.CONST.TYPE.CREATION;
    this.initSpecific( grid );
};
SHINKEN.OBJECT.SpaceBoxCreation.getCursorIcon = function () {
    return "/static/" + __SHINKEN_HTTP_START_TIME__ + "/service_weather/img/form/icone_create_space.svg";
};
SHINKEN.OBJECT.SpaceBoxCreation.prototype     = {
    initSpecific                  : function ( grid ) {
        this.max_width               = grid.nb_tiles_in_width.getValue();
        this.max_height              = grid.nb_tiles_in_height.getValue();
        this.tile_pixel_size         = grid.tile_pixel_size;
        this.remaining_space_in_grid = this.getRemainingSpaceInGrid( grid.grid_elements );
        this.grid_controller         = grid.getController();
        this.old_hover_grid_cell     = [];
    },
    getDelta_y                    : function () {
        let bounding_zone = this.getBoundingZone();
        let to_return     = bounding_zone.bottom - bounding_zone.top;
        to_return         = Math.abs( to_return );
        return to_return;
    },
    doExtraFrameDisplayStyleAction: function ( _computed_height ) {
        for ( let _span of this.arrow_spans ) {
            if ( _computed_height <= 60 ) {
                _span.style.fontSize = (_computed_height / 2) + "pt";
            }
        }
    },
    updateContent                 : function ( param ) {
        this.grid_controller.doActionAfter( "remove_hover_grid_cells", { [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELLS_OBJECT ]: this.old_hover_grid_cell } );
        
        this.size_display_element.innerText = this.getDelta_y();
        const bounding_zone                 = this.getBoundingZone();
        const cells_in_zone                 = this.findCellMatchingZone( param[ "grid_elements_2024_07_19" ], bounding_zone );
        this.old_hover_grid_cell            = cells_in_zone;
        
        this.grid_controller.doActionAfter( "hover_grid_cells", { [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELLS_OBJECT ]: cells_in_zone } );
    },
    getSizeDisplayElement         : function () {
        let to_return                       = DOM.Service.createElement( "div", { class: "shinken-size-display" }, SHINKEN.TOOLS.STRING.format( _( 'grid.mode_edition.form_visual.overlay_frame.create_space', [DICTIONARY_COMMON_UI] ), 0 ) );
        this.size_display_element           = to_return.querySelector( ".shinken-data-user" );
        this.size_display_element.innerText = this.getDelta_y();
        return to_return;
    },
    computeExtraHtml              : function () {
        this.arrow_spans = [DOM.Service.createElement( "span", { class: "shinicon-arrow-down" } )];
        this.arrow_spans.push( this.arrow_spans[ 0 ].cloneNode() );
        this.addDomElement( this.arrow_spans[ 0 ] );
        this.addDomElement( DOM.Service.createElement( "HR" ) );
        this.addDomElement( this.getSizeDisplayElement() );
        this.addDomElement( DOM.Service.createElement( "HR" ) );
        this.addDomElement( this.arrow_spans[ 1 ] );
    },
    getImpactedElement            : function ( shinken_grid_cells ) {
        this.grid_controller.doActionAfter( "remove_hover_grid_cells", { [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELLS_OBJECT ]: this.old_hover_grid_cell } );
        if ( !this.getDelta_y() ) {
            return;
        }
        let bounding_zone = this.getBoundingZone();
        
        let modified_cells = [];
        let area_top       = Math.min( bounding_zone.top, bounding_zone.bottom );
        for ( let _cell of shinken_grid_cells.contents ) {
            let _cell_bottom = _cell[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].getValue() + _cell[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ].getValue();
            if ( _cell_bottom > area_top ) {// CONTINUE ONLY IF CELL IS IN THE GOOD SIDE OF SPACE BOXE
                modified_cells.push( _cell );
            }
        }
        return modified_cells;
    },
    makeMouseUpAction             : function ( shinken_grid_cell_impacted ) {
        let _delta_y            = this.getDelta_y();
        let line_to_add_in_grid = _delta_y - this.remaining_space_in_grid;
        let widget_have_move    = false;
        for ( let _cell of shinken_grid_cell_impacted ) {
            _cell.computeLastModificationData__fromStartingClone();
            let _new_value = _cell[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].getValue() + _delta_y;
            _cell[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].setUserValueAndValue( _new_value );
            _cell.updateSize();
            _cell.computeSquare();
            _cell.doActionAfter( "apply_change_in_json" );
            widget_have_move = true;
        }
        if ( line_to_add_in_grid > 0 && widget_have_move ) {
            this.remaining_space_in_grid = Math.max( 0, this.remaining_space_in_grid - _delta_y );
            this.grid_controller.doActionAfter( "change_size_of_grid", { [ SHINKEN_GRID.CONST.PARAM.GRID.RESIZE_HEIGHT ]: line_to_add_in_grid } );
        }
        return shinken_grid_cell_impacted;
    },
    
    getRemainingSpaceInGrid: function ( cells ) {
        let max_cell_y = 0;
        cells.getContents().forEach( cell => {
            max_cell_y = Math.max( max_cell_y, cell[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].getValue() + cell[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ].getValue() );
        } );
        return Math.max( 0, this.max_height - max_cell_y );
    },
    computeHeight          : function ( _computed_end_y, _computed_start_y ) {
        return Math.abs( _computed_end_y - _computed_start_y );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SpaceBoxCreation, SHINKEN.OBJECT.SpaceBox );

SHINKEN.OBJECT.SpaceBoxDeletion = function ( grid ) {
    this.__class_name__ = "SHINKEN.OBJECT.SpaceBoxDeletion";
    this.type           = SHINKEN.OBJECT.SPACEBOX.CONST.TYPE.DELETION;
    this.initSpaceBox( grid );
};

SHINKEN.OBJECT.SpaceBoxDeletion.getCursorIcon = function () {
    return "/static/" + __SHINKEN_HTTP_START_TIME__ + "/service_weather/img/form/icone_delete_space.svg";
};
SHINKEN.OBJECT.SpaceBoxDeletion.prototype     = {
    initSpaceBox        : function ( grid ) {
        this.max_width       = grid.nb_tiles_in_width.getValue();
        this.tile_pixel_size = grid.tile_pixel_size;
        this.grid_controller = grid.getController();
    },
    getImpactedElement  : function ( shinken_grid_cells ) {
        let bounding_zone = this.getBoundingZone();
        let cells_in_zone = this.findCellMatchingZone( shinken_grid_cells, bounding_zone );
        return this.findAreasWithoutCell( cells_in_zone, bounding_zone.top, bounding_zone.bottom );
    },
    findAreasWithoutCell: function ( cells, y_min, y_max ) {
        const y_ranges = cells.map( cell => ({
            start: cell[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].getValue(),
            end  : cell[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].getValue() + cell[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ].getValue()
        }) );
        
        y_ranges.sort( ( a, b ) => a.start - b.start );
        const uncovered_Y_ranges = [];
        let current_y            = y_min;
        
        y_ranges.forEach( range => {
            if ( current_y < range.start ) {
                uncovered_Y_ranges.push( { start: current_y, end: range.start, height: range.start - current_y } );
            }
            current_y = Math.max( current_y, range.end );
        } );
        if ( current_y < y_max ) {
            uncovered_Y_ranges.push( { start: current_y, end: y_max, height: y_max - current_y } );
        }
        return uncovered_Y_ranges;
    },
    makeMouseUpAction   : function ( uncovered_y_ranges, grid_cells ) {
        const cells_impacted   = [];
        let last_uncovered_range;
        let total_line_removed = 0;
        let widget_have_move   = false;
        for ( let _cell of grid_cells.getContents() ) {
            _cell.last_modication_data = null;
        }
        for ( let i = uncovered_y_ranges.length - 1; i >= 0; i-- ) {
            last_uncovered_range                    = i === 0;
            let current_height_already_add_to_total = false;
            for ( let _cell of grid_cells.getContents() ) {
                if ( _cell[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].getValue() >= uncovered_y_ranges[ i ].end ) {
                    if ( !current_height_already_add_to_total ) {
                        total_line_removed += uncovered_y_ranges[ i ].height;
                        current_height_already_add_to_total = true;
                    }
                    if ( !_cell.last_modication_data ) {
                        _cell.computeLastModificationData__fromStartingClone();
                    }
                    let new_y_value = _cell[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].getValue() - uncovered_y_ranges[ i ].height;
                    _cell[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].setUserValueAndValue( new_y_value );
                    if ( last_uncovered_range ) {
                        _cell.updateSize();
                        _cell.computeSquare();
                        _cell.doActionAfter( "apply_change_in_json" );
                        cells_impacted.push( _cell );
                        widget_have_move = true;
                    }
                }
            }
        }
        if ( total_line_removed > 0 && widget_have_move ) {
            this.grid_controller.doActionAfter( "change_size_of_grid", { [ SHINKEN_GRID.CONST.PARAM.GRID.RESIZE_HEIGHT ]: -total_line_removed } );
        }
        this.resetZoneToRemove();
        return cells_impacted;
    },
    makeMouseMoveAction : function ( param ) {
        const bounding_zone      = this.getBoundingZone();
        const cells_in_zone      = this.findCellMatchingZone( param[ "grid_elements_2024_07_19" ], bounding_zone );
        const areas_without_cell = this.findAreasWithoutCell( cells_in_zone, bounding_zone.top, bounding_zone.bottom );
        this.resetZoneToRemove();
        this.zone_to_remove = [];
        
        areas_without_cell.forEach( area => {
            let current = DOM.Service.createElement( "div", { class: "shinken-delete-zone" } );
            this.createDeleteZoneHtml( current, area );
            param[ "grid_2024_07_19" ].addDomElement( current );
            this.zone_to_remove.push( current );
        } );
        this.updateSize();
    },
    createDeleteZoneHtml: function ( element, range ) {
        this.arrow_spans                     = [DOM.Service.createElement( "span", { class: "shinicon-arrow-up shinicon-arrow-up-red" } )];
        this.arrow_spans[ 0 ].style.fontSize = this.parseGridToPixel_y( range.height ) <= 60 ? this.parseGridToPixel_y( range.height ) / 2 : 30;
        this.arrow_spans.push( this.arrow_spans[ 0 ].cloneNode() );
        
        DOM.Service.addElementTo( this.arrow_spans[ 0 ], element );
        DOM.Service.addElementTo( DOM.Service.createElement( "HR" ), element );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-size-display" }, SHINKEN.TOOLS.STRING.format( _( 'grid.mode_edition.form_visual.overlay_frame.delete_space', [DICTIONARY_COMMON_UI] ), range.height ) ), element );
        DOM.Service.addElementTo( DOM.Service.createElement( "HR" ), element );
        DOM.Service.addElementTo( this.arrow_spans[ 1 ], element );
        DOM.Service.setStyles( element, { top: this.parseGridToPixel_y( range.start ), height: this.parseGridToPixel_y( range.height ) } );
    },
    resetZoneToRemove   : function () {
        if ( this.zone_to_remove ) {
            this.zone_to_remove.forEach( zone => {
                DOM.Service.removeElement( zone );
            } );
            this.zone_to_remove = null;
        }
    },
    computeHeight       : function ( _computed_end_y, _computed_start_y ) {
        return Math.abs( _computed_end_y - _computed_start_y );
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SpaceBoxDeletion, SHINKEN.OBJECT.SpaceBox );
