//__lib__ lib_common
"use strict";
SHINKEN.OBJECT.ShinkenElement           = function () {
    this.sla_value_status = OBJECT.CONST.ELEMENT.SLA.STATUS.UNKNOWN;
};
SHINKEN.OBJECT.ShinkenElement.prototype = {
    //********************************  INIT    ******************************************************************//
    init: function ( data ) {
        this.updateData( data );
    },
    //********************************  SETTER GETTER    ******************************************************************//
    isConfigured                      : function () {
        if ( !this.getType() ) {
            return false;
        }
        return !!(this.getUUID() || this.getName());
    },
    getUUID                           : function () {
        return this.uuid;
    },
    getName                           : function () {
        return this.name;
    },
    getVisualisationName              : function () {
        return this.visualisation_name;
    },
    getType                           : function () {
        return this.item_type;
    },
    setUUID                           : function ( to_set ) {
        this.uuid      = to_set;
        this.item_uuid = to_set;
    },
    isExisting                        : function () {
        if ( !this.getUUID() || !this[ OBJECT.CONST.ELEMENT.FIELD_UI.ITEM_TYPE ] ) {
            return false;
        }
        return this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING ];
    },
    setExists                         : function ( to_set ) {
        if ( this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING ] === to_set ) {
            return false;
        }
        this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING ] = to_set;
        return true;
    },
    isNotAuthorized                   : function ( to_set ) {
        if ( this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_NOT_AUTHORIZED_FOR_USER ] === to_set ) {
            return false;
        }
        this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_NOT_AUTHORIZED_FOR_USER ] = to_set;
        return true;
    },
    setVisibilityWithoutAuthentication: function ( to_set ) {
        if ( this[ OBJECT.CONST.ELEMENT.FIELD_UI.ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW ] === to_set ) {
            return false;
        }
        this[ OBJECT.CONST.ELEMENT.FIELD_UI.ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW ] = to_set;
        return true;
    },
    setName                           : function ( to_set ) {
        if ( this.name === to_set ) {
            return false;
        }
        this.name = to_set;
        return true;
    },
    setVisualisationName              : function ( to_set ) {
        if ( this.visualisation_name === to_set ) {
            return false;
        }
        this.visualisation_name = to_set;
        return true;
    },
    setContext                        : function ( to_set ) {
        this.previous_context = this.previous_context || new SHINKEN.Status();
        if ( this.context ) {
            this.previous_context.setCode( this.context.getCode() );
        }
        if ( this.context && this.context.isByCode( to_set ) ) {
            return false;
        }
        this.context = this.context || new SHINKEN.Status();
        this.context.setCode( to_set );
        return true;
    },
    setStatus                         : function ( to_set ) {
        //DEBUG
        //var _random = function () {
        //    var d = Math.random() * 100;
        //    if ((d -= 50) < 0) {
        //        return 0;
        //    }
        //    return 2;
        //};
        //to_set = _random();
        this.previous_status = this.previous_status || new SHINKEN.Status();
        if ( this.status ) {
            this.previous_status.setCode( this.status.getCode() );
        }
        if ( this.status && this.status.isByCode( to_set ) ) {
            return false;
        }
        this.status = this.status || new SHINKEN.Status();
        this.status.setCode( to_set );
        return true;
    },
    setSlaValue                       : function ( to_set ) {
        if ( this.sla_value === to_set ) {
            return false;
        }
        this.sla_value        = to_set;
        this.sla_value_status = OBJECT.CONST.ELEMENT.SLA.STATUS.UNKNOWN;
        this.sla_quality      = null;
        return true;
    },
    setSlaTendency                    : function ( to_set ) {
        if ( this.tendency === to_set ) {
            return false;
        }
        this.tendency = to_set;
        return true;
    },
    setSlaThreshold                   : function ( key, value ) {
        if ( this[ "sla_" + key ] === value ) {
            return false;
        }
        this[ "sla_" + key ]  = value;
        this.sla_value_status = OBJECT.CONST.ELEMENT.SLA.STATUS.UNKNOWN;
        this.sla_quality      = null;
        return true;
    },
    getSlaValueStatus                 : function ( key, value ) {
        
        if ( this.sla_value_status === OBJECT.CONST.ELEMENT.SLA.STATUS.UNKNOWN ) {
            if ( parseFloat( this.sla_value ) < this.sla_critical_threshold ) {
                this.sla_value_status = OBJECT.CONST.ELEMENT.SLA.STATUS.CRITICAL;
            }
            else if ( parseFloat( this.sla_value ) < this.sla_warning_threshold ) {
                this.sla_value_status = OBJECT.CONST.ELEMENT.SLA.STATUS.WARNING;
            }
            else {
                this.sla_value_status = OBJECT.CONST.ELEMENT.SLA.STATUS.OK;
            }
        }
        return this.sla_value_status;
    },
    getSlaQuality                     : function () {
        if ( this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_NOT_AUTHORIZED_FOR_USER ] ) {
            this.sla_quality = new SHINKEN.SlaQuality();
        }
        else if ( typeof this.sla_value === "undefined" || typeof this.status === 'undefined' ) {
            this.sla_quality = new SHINKEN.SlaQuality();
        }
        else if ( !this.sla_quality ) {
            this.sla_quality = new SHINKEN.SlaQuality( this.status.getCode(), this.getSlaValueStatus() );
        }
        return this.sla_quality;
    },
    //********************************  LAST MODIFICATION    ******************************************************************//
    getDataForLastModification: function () {
        var _to_return                                          = {};
        _to_return[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING ] = this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING ];
        if ( this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING ] ) {
            
            _to_return[ OBJECT.CONST.ELEMENT.FIELD_UI.STATUS ]             = this[ OBJECT.CONST.ELEMENT.FIELD_UI.STATUS ].getCode();
            _to_return[ OBJECT.CONST.ELEMENT.FIELD_UI.CONTEXT ]            = this[ OBJECT.CONST.ELEMENT.FIELD_UI.CONTEXT ].getCode();
            var to_add                                                     = {};
            to_add[ OBJECT.CONST.ELEMENT.FIELD_UI.SLA.CRITICAL_THRESHOLD ] = this[ 'sla_critical_threshold' ];
            to_add[ OBJECT.CONST.ELEMENT.FIELD_UI.SLA.WARNING_THRESHOLD ]  = this[ "sla_warning_threshold" ];
            to_add[ OBJECT.CONST.ELEMENT.FIELD_UI.SLA.TENDENCY ]           = this[ OBJECT.CONST.ELEMENT.FIELD_UI.SLA.TENDENCY ];
            to_add[ OBJECT.CONST.ELEMENT.FIELD_UI.SLA.VALUE ]              = this[ "sla_value" ];
            _to_return[ OBJECT.CONST.ELEMENT.FIELD_UI.SLA.__KEY__ ]        = to_add;
            _to_return[ OBJECT.CONST.ELEMENT.FIELD_UI.VISUALISATION_NAME ] = this[ OBJECT.CONST.ELEMENT.FIELD_UI.VISUALISATION_NAME ];
            
            _to_return[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_NOT_AUTHORIZED_FOR_USER ] = this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_NOT_AUTHORIZED_FOR_USER ];
            
            _to_return[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_NOT_AUTHORIZED_FOR_USER ] = this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_NOT_AUTHORIZED_FOR_USER ];
        }
        return _to_return;
    },
    //********************************  UPDATE DATA    ******************************************************************//
    updateData: function ( data ) {
        if ( !data ) {
            return;
        }
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case "item_uuid":
            case OBJECT.CONST.ELEMENT.FIELD_UI.UUID:
                this.setUUID( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.STATUS:
                this.setStatus( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING:
                this.setExists( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.IS_NOT_AUTHORIZED_FOR_USER:
                this.isNotAuthorized( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW:
                this.setVisibilityWithoutAuthentication( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.CONTEXT:
                this.setContext( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.__KEY__:
                this.updateData( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.VALUE:
                this.setSlaValue( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.TENDENCY:
                this.setSlaTendency( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.WARNING_THRESHOLD:
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.CRITICAL_THRESHOLD:
                this.setSlaThreshold( key, value );
                break;
            case "item_name":
                this[ key ] = value;
                this.setName( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.NAME:
                this.setName( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.VISUALISATION_NAME:
            case OBJECT.CONST.ELEMENT.FIELD_UI.ITEM_TYPE:
                this[ key ] = value;
                break;
            default:
                console.warn( "[IGNORED DATA]", key, value );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenElement, SHINKEN.OBJECT.ShinkenObjectJson );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenElement, SHINKEN.OBJECT.PhaseInterface );