//__lib__ lib_common
"use strict";

SHINKEN.OBJECT.Squares = function () {
    this.__class_name__ = 'SHINKEN.OBJECT.Squares';
    this.init();
    
};

SHINKEN.OBJECT.Squares.prototype = {
    init               : function () {
        this.initContents();
    },
    hasOverlapping     : function () {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            for ( var j = 0, _size_j = this.getSize(); j < _size_j; j++ ) {
                if ( this.getContent( i ) !== this.getContent( j ) && this.getContent( i ).isOverlapping( this.getContent( j ) ) ) {
                    return true;
                }
            }
            
        }
        return false;
    },
    isOverlappingByUuid: function ( uuid_square ) {
        return this.isOverlapping( this.getContentByUUID( uuid_square ) );
    },
    isOverlapping      : function ( square ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            if ( this.getContent( i ) !== square && this.getContent( i ).isOverlapping( square ) ) {
                
                return true;
            }
        }
        return false;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Squares, SHINKEN.OBJECT.ShinkenObjectContainer );

SHINKEN.OBJECT.Point           = function ( x, y, type, max_x, max_y ) {
    this.x_original   = x;
    this.y_original   = y;
    this.x            = x;
    this.y            = y;
    this.type         = type;
    this.display_type = type;
    this.max_x        = max_x;
    this.max_y        = max_y;
};
SHINKEN.OBJECT.Point.prototype = {
    computeHtml   : function () {
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-point", "data-type": this.type, "data-display-type": this.display_type }, this.getInnerHtml() ) );
    },
    getInnerHtml  : function () {
        switch ( this.display_type ) {
            case "drag-n-drop-information-debug":
                return "(x:" + this.x + ', y:' + this.y + ")";
            default:
                return this.type + " (" + this.x + ',' + this.y + ")";
        }
    },
    reset_original: function () {
        this.x_original = this.x;
        this.y_original = this.y;
    },
    addDelta      : function ( delta_x, delta_y ) {
        this.x = Math.max( 0, this.x_original + delta_x );
        this.y = Math.max( 0, this.y_original + delta_y );
        if ( this.max_x ) {
            this.x = Math.min( this.max_x, this.x );
        }
        if ( this.max_y ) {
            this.y = Math.min( this.max_y, this.y );
        }
        if ( this.getDomElement() ) {
            this.getDomElement().innerHTML = this.getInnerHtml();
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Point, SHINKEN.OBJECT.ShinkenObjectHtml );


SHINKEN.OBJECT.Square           = function ( bottom_left_point, top_right_point, uuid, max_width ) {
    this.top_right_point   = top_right_point;
    this.bottom_left_point = bottom_left_point;
    this.max_width         = max_width;
    this.uuid              = uuid || SHINKEN.TOOLS.STRING.buildUUID();
    this.point_to_display  = [];
    this.init();
};
SHINKEN.OBJECT.Square.prototype = {
    init: function () {
        this.addClass( "shinken-square" );
    },
    //********************************************  EVENT  *****************************************************//
    isOverlapping     : function ( square ) {
        if ( this.bottom_left_point.x >= square.top_right_point.x ||
             square.bottom_left_point.x >= this.top_right_point.x ) {
            return false;
        }
        
        // Ici, nous vérifions si l'un des rectangles est au-dessus de l'autre
        if ( (this.top_right_point.y >= square.bottom_left_point.y) && (square.bottom_left_point.y !== -1) ||
             ((square.top_right_point.y >= this.bottom_left_point.y) && (this.bottom_left_point.y !== -1)) ) {
            return false;
        }
        return true;
    },
    isOutsideOfDisplay: function ( nb_tiles_in_width ) {
        if ( this.bottom_left_point.x < 0 || this.top_right_point.y < 0 || this.top_right_point.x > nb_tiles_in_width ) {
            return true;
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getUUID          : function () {
        return this.uuid;
    },
    addPointToDisplay: function ( point_to_add ) {
        this.point_to_display.push( point_to_add );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    reset      : function () {
        this.top_right_point.reset_original();
        this.bottom_left_point.reset_original();
        for ( var i = 0, _size_i = this.point_to_display.length; i < _size_i; i++ ) {
            this.point_to_display[ i ].reset_original();
        }
        DOM.Service.removeElement( this.getDomElement() );
    },
    addDelta   : function ( delta_x, delta_y ) {
        this.top_right_point.addDelta( delta_x, delta_y );
        this.bottom_left_point.addDelta( delta_x, delta_y );
        for ( var i = 0, _size_i = this.point_to_display.length; i < _size_i; i++ ) {
            this.point_to_display[ i ].addDelta( delta_x, delta_y );
        }
    },
    computeHtml: function () {
        if ( this.getDomElement() ) {
            return false;
        }
        this.setDomElement( DOM.Service.createElement( "div", { class: this.getClass() } ) );
        var div = this.addDomElement( DOM.Service.createElement( "div", { class: 'shinken-relative-div' } ) );
        
        for ( var i = 0, _size_i = this.point_to_display.length; i < _size_i; i++ ) {
            this.point_to_display[ i ].computeHtml();
            DOM.Service.addElementTo( this.point_to_display[ i ].getDomElement(), div );
        }
        return true;
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Square, SHINKEN.OBJECT.ShinkenObjectHtml );