//__lib__ lib_common
"use strict";

SHINKEN.StatusService = (function( self ) {
    "use strict";
    
    self.buildPaths     = function ( status, context ) {
        var _to_return = {
            path      : null,
            path_extra: null
        };
        if ( context.is( SHINKEN.STATUS.DISABLED ) ) {
            _to_return.path = context.getPath();
        }
        else if ( !context.is( SHINKEN.STATUS.NOTHING ) ) {
            _to_return.path       = context.getPath();
            _to_return.path_extra = status.getPath();
        }
        else {
            _to_return.path = status.getPath();
        }
        return _to_return;
    };
    self.buildTilePaths = function ( status, context ) {
        return  {
            path      : status.getPath(),
            path_extra: context.getPath()
        };
    };
    self.parseToPartial = function ( code ) {
        var _to_return;
        switch ( code ) {
            case  SHINKEN.STATUS.ACKNOWLEDGED.CODE:
            case  SHINKEN.STATUS.INHERITED_ACKNOWLEDGED.CODE:
                _to_return = SHINKEN.STATUS.PARTIAL_ACKNOWLEDGED.CODE;
                break;
            case SHINKEN.STATUS.DOWNTIME.CODE:
            case SHINKEN.STATUS.INHERITED_DOWNTIME.CODE:
                _to_return = SHINKEN.STATUS.PARTIAL_DOWNTIME.CODE;
                break;
            case SHINKEN.STATUS.FLAPPING.CODE:
                _to_return = SHINKEN.STATUS.PARTIAL_FLAPPING.CODE;
                break;
            default:
                _to_return = code;
                break;
        }
        return _to_return;
    };
    self.isPartial      = function ( code ) {
        switch ( code ) {
            case SHINKEN.STATUS.PARTIAL_ACKNOWLEDGED.CODE:
            case SHINKEN.STATUS.PARTIAL_DOWNTIME.CODE:
            case SHINKEN.STATUS.PARTIAL_FLAPPING.CODE:
                return true;
        }
        return false;
    };
    self.isContext      = function ( context, type ) {
        var _code = context.getCode();
        switch ( type ) {
            case SHINKEN.STATUS.ACKNOWLEDGED:
                switch ( _code ) {
                    case SHINKEN.STATUS.ACKNOWLEDGED.CODE:
                    case SHINKEN.STATUS.INHERITED_ACKNOWLEDGED.CODE:
                    case SHINKEN.STATUS.PARTIAL_ACKNOWLEDGED.CODE:
                        return true;
                }
                break;
            case SHINKEN.STATUS.DOWNTIME:
                switch ( _code ) {
                    case SHINKEN.STATUS.DOWNTIME.CODE:
                    case SHINKEN.STATUS.INHERITED_DOWNTIME.CODE:
                    case SHINKEN.STATUS.PARTIAL_DOWNTIME.CODE:
                        return true;
                }
                break;
            case SHINKEN.STATUS.FLAPPING:
                switch ( _code ) {
                    case SHINKEN.STATUS.FLAPPING.CODE:
                    case SHINKEN.STATUS.PARTIAL_FLAPPING.CODE:
                        return true;
                }
                break;
            case SHINKEN.STATUS.DISABLED:
                switch ( _code ) {
                    case SHINKEN.STATUS.DISABLED.CODE:
                        return true;
                }
                break;
            case SHINKEN.STATUS.NOTHING:
                switch ( _code ) {
                    case SHINKEN.STATUS.NOTHING.CODE:
                        return true;
                }
                break;
        }
        return false;
    };
    
    return self;
})( SHINKEN.StatusService  || {} );
