//__lib__ lib_common
"use strict";
SHINKEN.ELEMENT.UiUsers = function () {
    this.init();
};

SHINKEN.ELEMENT.UiUsers.prototype = {
    init: function () {
        this.initContents();
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getDataForSelector: function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _to_return.push( this.getContent( i ).getDataForSelector() );
        }
        return _to_return;
    },
    getUserByName     : function ( name ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            if ( this.getContent( i ).getName() === name ) {
                return this.getContent( i );
            }
        }
        return null;
    },
    //********************************************  OTHERS  *****************************************************//
    exists         : function ( name_to_find ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            if ( this.getContent( i ).getName() === name_to_find ) {
                return true;
            }
        }
        return false;
    },
    existsPartially: function ( name_to_find ) {
        if ( !name_to_find ) {
            return true;
        }
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            if ( SHINKEN.TOOLS.STRING.containsIgnoreCase( this.getContent( i ).getName(), name_to_find ) ) {
                return true;
            }
        }
        return false;
    },
    //********************************************  COMMUNICATION  *****************************************************//
    getDataFromBackend: function ( parent_object ) {
        var self     = this;
        var _success = function ( _status, data ) {
            switch ( _status ) {
                case COMMUNICATION.CODE.SUCCESS:
                    for ( var i = 0, _size_i = data[ "output" ][ "users" ].length; i < _size_i; i++ ) {
                        self.add( new SHINKEN.ELEMENT.UiUser( data[ "output" ][ "users" ][ i ] ) );
                    }
                    parent_object.doActionAfterCall( "SHINKEN.ELEMENT.UiUsers.getDataFromBackend" );
                    break;
            }
        };
        var _error   = function ( _status, data ) {
        };
        SHINKEN.COMUNICATION.requestGet( SHINKEN.COMUNICATION.CONST.QUERY.GET.USERS.KEY, _success, _error, null );
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.ELEMENT.UiUsers, SHINKEN.OBJECT.ShinkenObjectContainer );

