//__lib__ lib_common_V02_01
"use strict";

PROPERTY.LabelAbstract           = function () {
};
PROPERTY.LabelAbstract.prototype = {
    init: function () {
    },
    //********************************************  EVENT LISTENER  **************************************************//
    
    //********************************************  SETTER GETTER   **************************************************//
    getValue: function () {
        return this.value;
    },
    //********************************************  SAVE     *********************************************************//
    getDataToSave: function () {
        return SHINKEN.TOOLS.STRING.trimExtented( this.getValue() );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.LabelAbstract, PROPERTY.InterfaceCommon );

PROPERTY.LabelFromData           = function ( property_name, label, value ) {
    this.__class_name__ = 'PROPERTY.LabelFromData';
    this.initSpecific( property_name, label, value );
};
PROPERTY.LabelFromData.prototype = {
    initSpecific: function ( property_name, property_label, value ) {
        this.init();
        this.name            = property_name;
        this.label           = property_label;
        this.value           = value;
        this.component_label = new COMPONENT.LabelFromData( this.value );
    },
    //********************************************  HTML    **********************************************************//
    computeHtml                         : function () {
        this.computeHtml_container();
        this.computeHtml_common();
    },
    computeHtml_getType                 : function () {
        return PROPERTY_V2.COMMON.TYPES.STRING_LABEL;
    },
    computeHtml_getCellPropActionContent: function () {
        this.component_label.computeHtml();
        DOM.Service.addElementTo( this.component_label.getDomElement(), this.dom_cell_action );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.LabelFromData, PROPERTY.LabelAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.LabelFromData, PROPERTY.InterfaceCommonFromData );



PROPERTY.LabelFromData_V3           = function ( property_name, label, value ) {
    this.__class_name__ = 'PROPERTY.LabelFromData';
    this.initSpecific( property_name, label, value );
};
PROPERTY.LabelFromData_V3.prototype = {
    initSpecific: function ( property_name, property_label, value ) {
        this.init();
        this.name            = property_name;
        this.label           = property_label;
        this.value           = value;
        this.component_label = new COMPONENT.LabelFromData( this.value );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "add_message_validation":
                this.component_label.doActionAfter(event_name, param);
                break;
            case "property_value__set__by_data":
            case "property_value__set__by_js":
                this.component_label.setValueFromJs( param[ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ] );
                break;
        }
        return this.doActionAfterCommon( event_name, param );
    },
    //********************************************  HTML    **********************************************************//
    computeHtml                         : function () {
        this.computeHtml_container();
        this.computeHtml_common();
    },
    computeHtml_getType                 : function () {
        return PROPERTY_V2.COMMON.TYPES.STRING_LABEL;
    },
    computeHtml_getCellPropActionContent: function () {
        this.component_label.computeHtml();
        DOM.Service.addElementTo( this.component_label.getDomElement(), this.dom_cell_action );
    },
    //********************************************  SAVE    **********************************************************//
    getValue: function ( type_save ) {
        return this.component_label.getValue();
    },
    getDataToSave__20241127: function ( type_save ) {
        let to_return = this.component_label.getValue();
        switch ( type_save ) {
            case SHINKEN.OBJECT.FORM.TYPE_SAVE.VALUE_AND_DEFAULT_FOR_GRID:
                to_return = SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.parseValueToDict_withValueKey( to_return, to_return );
                break;
        }
        return to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.LabelFromData_V3, PROPERTY.LabelAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.LabelFromData_V3, PROPERTY.InterfaceCommonFromData_V3 );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.LabelFromData_V3, PROPERTY.LabelCommonFromData_V3 );



