//priority 20
//__lib__ lib_common
"use strict";

SHINKEN.COMUNICATION = (function ( self ) {
    self.requestGet_withTimeout = function ( timeout, url, success, error, not_found_callback, unauthorized_callback ) {
        setTimeout( () => {
            self.requestGet( url, success, error, not_found_callback, unauthorized_callback );
        }, timeout );
    };
    self.requestGet             = function ( url, success, error, not_found_callback, unauthorized_callback ) {
        var request = new XMLHttpRequest();
        
        request.open( 'GET', url, true );
        request.onload  = self.onRequestSuccess( success, not_found_callback, unauthorized_callback );
        request.onerror = error || self.onRequestError;
        request.send();
    };
    self.requestPost            = function ( url, data, success, error, not_found_callback, unauthorized_callback ) {
        var request            = new XMLHttpRequest();
        self._success_callback = success;
        
        request.open( 'POST', url, true );
        request.setRequestHeader( 'Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8' );
        request.onload  = self.onRequestSuccess( success, not_found_callback, unauthorized_callback );
        request.onerror = error || self.onRequestError;
        request.send( data );
    };
    self.requestPostJSON        = function ( url, data, success, error, not_found_callback, unauthorized_callback ) {
        var request = new XMLHttpRequest();
        request.open( 'POST', url, true );
        request.setRequestHeader( 'Content-Type', "application/json;charset=UTF-8" );
        request.onload  = self.onRequestSuccess( success, not_found_callback, unauthorized_callback );
        request.onerror = error || self.onRequestError;
        
        request.send( data );
    };
    self.onRequestError         = function () {
        SHINKEN.TOOLS.NOTIFICATION.addNotification( _( "communication.no_backend_response", [DICTIONARY_COMMON_UI] ), SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.ERROR );
    };
    
    self.onRequestSuccess = function ( success, not_found_callback, unauthorized_callback ) {
        return function () {
            try {
                var _data = JSON.parse( this.response );
            }
            catch ( e ) {
                _data = this.response;
            }
            switch ( this.status ) {
                case COMMUNICATION.CODE.UNAUTHORIZED:
                    _do_action_401( unauthorized_callback, _data );
                    return;
                case COMMUNICATION.CODE.INTERNAL_SERVER_ERROR:
                    _do_action_500( _data );
                    return;
                default:
                    switch ( _data.rc ) {
                        case COMMUNICATION.CODE.UNAUTHORIZED:
                            _do_action_401( unauthorized_callback, _data );
                            return;
                        case COMMUNICATION.CODE.NOT_FOUND:
                            if ( not_found_callback ) {
                                not_found_callback( this.status, _data );
                                return;
                            }
                            break;
                    }
                    break;
            }
            success( this.status, _data );
        };
    };
    var _do_action_401    = function ( unauthorized_callback, data ) {
        if ( unauthorized_callback ) {
            unauthorized_callback( COMMUNICATION.CODE.UNAUTHORIZED, data );
            
        }
    };
    var _do_action_500    = function ( data ) {
        SHINKEN.TOOLS.NOTIFICATION.addNotification( data, SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.ERROR );
    };
    return self;
})( SHINKEN.COMUNICATION || {} );

SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT = (function ( self ) {
    self.console                     = function ( ...arg ) {
        //console.shinken.debug( "[SERVICE]", "[COMMUNICATION]",  ...arg  );
    };
    self.informParentIframeUrlChange = function ( controller_name ) {
        try {
            window.parent.CONTROLLER.UiVisualisation.iframeChangeUrl( window.location.href, controller_name );
        }
        catch ( e ) {
            self.console( "[informParentIframeUrlChange]", e );
        }
    };
    self.redirectIfNeeded            = function () {
        var need_redirect = false;
        try {
            if ( window.parent.CONTROLLER.UiVisualisation === undefined ) {
                need_redirect = true;
            }
        }
        catch ( e ) {
            need_redirect = true;
        }
        if ( need_redirect ) {
            SHINKEN.HIGHWAY.goTo( window.location.href.replace( window.location.origin, window.location.origin + "/static/ui/index.html#" ) );
        }
    };
    self.clickDone                   = function ( event ) {
        try {
            window.parent.CONTROLLER.UiVisualisation.clickDoneOnIframe( event );
        }
        catch ( e ) {
            self.console( "[clickDone]", e );
        }
    };
    self.doActionAfter               = function ( event_name, param ) {
        try {
            return window.parent.CONTROLLER.UiVisualisation.doActionAfter( event_name, param );
        }
        catch ( e ) {
            try {
                return window.parent.window.parent.CONTROLLER.UiVisualisation.doActionAfter( event_name, param ); //FOR THE WEATHER...
            }
            catch ( e ) {
                self.console( "[doActionAfter]", e );
            }
        }
    };
    self.getFromParent               = function ( name ) {
        try {
            return window.parent.CONTROLLER.UiVisualisation.getFromParent( name );
        }
        catch ( e ) {
            try {
                return window.parent.window.parent.CONTROLLER.UiVisualisation.getFromParent( name ); //FOR THE WEATHER...
            }
            catch ( e ) {
                self.console( "getFromParent", e );
            }
        }
        return null;
    };
    
    return self;
})( SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT || {} );

SHINKEN.COMMUNICATION_WITH_IFRAME_CHILD = (function ( self ) {
    self.doActionAfter = function ( id_iframe, event_name, callback_to_eval ) {
        try {
            var _iframe          = DOM.BodyService.getDomElement().querySelector( "#" + id_iframe );
            var _controller_name = _iframe.contentWindow.document.querySelector( ".shinken-parent-event-listener" ).dataset.controller;
            var _controller      = _iframe.contentWindow.CONTROLLER.DistributorControllerManager.getController( _controller_name );
            _controller.doActionAfter( event_name, callback_to_eval );
        }
        catch ( e ) {
            console.shinken.debug( e );
        }
    };
    
    return self;
})( SHINKEN.COMMUNICATION_WITH_IFRAME_CHILD || {} );

SHINKEN.COMUNICATION.CONST = {
    QUERY: {
        SEPARATOR: {
            GET_BEGINNER: '?',
            GET_ADD     : '&',
            PARAM_SETTER: '=',
            SLASH       : '/'
        },
        PARAMETER: {
            SHINKEN_TIMESTAMP: "shinken-timestamp",
            WIDTH            : "width",
            HEIGHT           : "height"
        },
        GET      : {
            LICENCE           : "/api/key",
            DASHBOARD         : "/screen/dashboard",
            LIST_CONFIG       : "/screen/list",
            LIST_ALL_DATAS    : "/api/list-elements-all",
            LIST_EVENTS       : "/event-container",
            HIVE              : "/screen/hive",
            HIVE_ALL_ELEMENT  : "/api/state/elements",
            HOST              : "/api/host/",
            SERVICE           : "/api/service/",
            ELEMENTS_RECHECKED: "/api/elements_rechecked",
            SHARE             : "/share",
            LIST_HOSTS        : {
                KEY             : "/lookup/",
                FILTER_CHECK    : "with_checks_only",
                FILTER_CHECK_OFF: 0,
                FILTER_CHECK_ON : 1
            },
            LIST_CHECK        : {
                KEY            : "/lookup-service/",
                KEY_WITH_METRIC: "api/widget/graphs/checks-with-metrics/"
            },
            USER              : {
                KEY: "/user"
            },
            USERS             : {
                KEY: "/users"
            },
            IS_SERVER_READY   : "/api/is_backend_available",
            DETAIL_HISTORIC   : {
                KEY                  : "/inner/history/",
                RANGES               : "ranges/",
                BEGIN                : "start",
                END                  : "end",
                DATE                 : "date",
                DISPLAY_FULL_RANGES  : "display_full_ranges",
                CURRENT_RANGE_DISPLAY: "current_range_display",
                RANGES_PAGE_SIZE     : "ranges_page_size",
                MAX_RANGE_DISPLAY    : "max_range_display"
            },
            DETAIL_GRAPHS     : {
                KEY       : "/api/graphs/panel/detail/loading/",
                METRIC    : 'metric',
                WIDTH_HOST: 'width_host'
            },
            WIDGET            : {
                CATALOG: "/api/widgets/"
            },
            WEATHER           : {
                BASIC_STATISTICS: "/service-weather/api/V1/get-basic-statistics"
            },
            DEP_GRAPH         : {
                DEEP: "/deep"
            }
        },
        PUT      : {
            SHARE: "/share"
        },
        POST     : {
            SHARE         : "/share",
            ACTION_COMMAND: {
                URL             : "action",
                TYPE_COMMAND    : "type_action",
                ELEMENT_ID      : "element_id",
                ARGS            : "args",
                CONFIGURATION_ID: "configuration_id"
            },
            WEATHER       : {
                CREATION: "/service-weather/api/V1/create",
                CLONE   : "/service-weather/api/V1/clone"
            },
            HIVE          : {
                KEY  : "/screen/hive/",
                CLONE: "/clone"
            },
            LIST          : {
                KEY  : "/screen/list/",
                CLONE: "/screen/list/clone"
            }
        },
        TIMER    : {
            RECHECK_TIME_MANAGE: 5000,
            RECHECK_INTERVAL   : 2000
        }
    }
};
SHINKEN.NETWORK            = {
    HTTP_CODE : {
        NONE                       : -1,
        _200_SUCCESS               : 200,
        _400_BAD_REQUEST           : 400,
        _401_UNAUTHORIZED          : 401,
        _403_FORBIDDEN             : 403,
        _404_NOT_FOUND             : 404,
        _409_CONFLICT              : 409,
        _410_CONFIGURATION_OUTDATED: 410,
        _500_INTERNAL_ERROR        : 500,
        _514_MODULE_NOT_WORKING    : 514
    },
    ERROR_TYPE: {
        USER_SWITCHED: "userSwitched"
    },
    ADRESSES  : {
        LOCALHOST : "localhost",
        _127_0_0_1: "127.0.0.1",
        HTTP      : "http://",
        HTTPS     : "https://"
    },
    URL_STATUS: {
        VALID            : "valid",
        WRONG_FORMAT_HTTP: "format_unvalid_http"
    }
    
};