//__lib__ lib_common_V02_01
"use strict";

SHINKEN_GRID.Cells           = function ( data ) {
    this.init( data );
};
SHINKEN_GRID.Cells.prototype = {
    init             : function ( data ) {
        this.index_label_index = 1;
        this.initContents();
        this.initPhase();
        this.initCounterCommon();
        this.content_mapping = {};
        this.updateData( data );
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.OVERLAPPING );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.SELECTED );
    },
    //********************************************  EVENT LISTENER  *********************************************//
    doActionAfter: function ( event_name, param, param_2, param_3 ) {
        switch ( event_name ) {
            case "undo_last_modification":
            case "redo_last_modification":
                for ( const modification_element of param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION ].getContents() ) {
                    this.getContentByUUID( modification_element.getModifiedObjectParam( SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ) ).doActionAfter( event_name, {
                        [ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION_ELEMENT ]: modification_element,
                        [ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION_TYPE ]   : param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION ].getTypeModification(),
                        [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ]                       : param[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ]
                    } );
                }
                break;
            case "on_scroll":
            case "mouseover_on_deleting_pop_up":
            case "update_nb_tiles_in_height":
                for ( let i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
                    this.getContent( i ).doActionAfter( event_name, param, param_2, param_3 );
                }
                return;
        }
        var _cell = this.getContentByUUID( param[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ] || param );
        if ( !_cell ) {
            return;
        }
        _cell.doActionAfter( event_name, param, param_2, param_3 );
        
        switch ( event_name ) {
            case "mouse_down_on_grid_cell":
            case "mouse_up_on_grid_cell":
                return _cell;
        }
    },
    //********************************************  UPDATE DATA  *****************************************************//
    getChildrenObject    : function () {
        return this.getContents();
    },
    getChildrenObjectDict: function () {
        return this.getContents();
    },
    updateContentData    : function ( data ) {
        var _keys = Object.keys( data );
        var _current_key;
        var _currents_content;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key      = _keys[ i ];
            _currents_content = this.content_mapping[ _current_key ];
            if ( _currents_content ) {
                for ( var j = 0, _size_j = _currents_content.length; j < _size_j; j++ ) {
                    _currents_content[ j ].updateShinkenElementData( data[ _current_key ] );
                }
            }
            else {
                console.error( "[Cells - updateContentData]", data );
            }
        }
    },
    //********************************************  OTHERS  *****************************************************//
    getMaxTileInHeight: function () {
        var _box_content;
        var _to_return = 0;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _to_return = Math.max( this.getContent( i ).getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ) + this.getContent( i ).getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ), _to_return );
        }
        return _to_return;
    },
    //********************************************  COMPUTE  *****************************************************//
    computeSizes            : function ( shinken_grid ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeSizes( shinken_grid );
        }
    },
    computeContentWithChange: function () {
        var _to_return = 0;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _to_return += this.getContent( i ).computeContentWithChange();
        }
        return _to_return;
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave: function () {
        var _to_return = [];
        for ( let i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _to_return.push( this.contents[ i ].getDataToSave() );
        }
        return _to_return;
    },
    //********************************************  HTML   **************************************************//
    computeHtml: function ( shinken_grid, dom_parent_with_scroll ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeHtml( shinken_grid, dom_parent_with_scroll );
            DOM.Service.addElementTo( this.getContent( i ).getDomElement(), shinken_grid.getDomElement() );
        }
    },
    //********************************************  UPDATE DATA   **************************************************//
    updateData         : SHINKEN.OBJECT.DefaultConfiguration.prototype.updateData,
    setData            : function ( key, value ) {
        switch ( key ) {
            case "list_content":
                for ( var i = 0, _size_i = value.length; i < _size_i; i++ ) {
                    this.addCell( value[ i ], i );
                }
                break;
            default:
                this.setDataAsUnknownProperty( key, value );
                break;
        }
    },
    addCell            : function ( data, index, avoid_index_label ) {
        return this.addCellObject( this.getChildConstructor( data ), index, avoid_index_label );
    },
    addCellObject      : function ( to_add, index, avoid_index_label ) {
        this.addSynchronizedPhase( to_add );
        to_add.setCountersParent( this );
        this.add( to_add );
        if ( !avoid_index_label ) {
            to_add.setIndexLabel( this.index_label_index );
            this.index_label_index++;
        }
        var _uuid_content = to_add.getContentUUID();
        if ( _uuid_content ) {
            if ( !this.content_mapping[ _uuid_content ] ) {
                this.content_mapping[ _uuid_content ] = [];
            }
            this.content_mapping[ _uuid_content ].push( to_add.content );
        }
        return to_add;
    },
    getChildConstructor: function ( data ) {
        return new SHINKEN_GRID.Cell( data );
    },
    //********************************************  COMPUTE  *****************************************************//
    computeOverlapping: function ( grid_cell ) {
        for ( let i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeOverlapping( grid_cell );
        }
    },
    //********************************************  PHASE  *****************************************************//
    callbackForPhase: function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cells, SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cells, SHINKEN.OBJECT.ShinkenObjectContainer );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cells, SHINKEN.OBJECT.PhaseInterface );