//__lib__ lib_common_V02_01
"use strict";

SHINKEN_GRID.Grids           = function () {
};
SHINKEN_GRID.Grids.prototype = {
    initCommon: function () {
        this.initInternal();
        this.initContents();
        this.initPhase();
    },
    init      : function ( data ) {
        this.initCommon();
        this.updateData( data );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    hasGrid              : function () {
        return this.getSize() > 0;
    },
    setType              : function ( to_set ) {
        this.type = to_set;
    },
    getGridByUUID        : function ( grid_uuid ) {
        return this.getContentByUUID( grid_uuid );
    },
    getChildrenObject    : function () {
        return this.getContents();
    },
    getChildrenObjectDict: function () {
        return this.getContents();
    },
    //********************************************  COMPUTE  *****************************************************//
    _computeMapping         : function () {
        this.mapping_uuid_content = {};
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeMapping( this.mapping_uuid_content );
        }
    },
    computeSizes            : function () {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeSizes();
        }
    },
    computeContentWithChange: function () {
        var _to_return = 0;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _to_return += this.getContent( i ).computeContentWithChange();
        }
        return _to_return;
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave: function () {
        var _to_return = [];
        for ( let i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _to_return.push( this.contents[ i ].getDataToSave() );
        }
        return _to_return;
    },
    //********************************************  HTML   **************************************************//
    computeHtml: function ( dom_parent_with_scroll ) {
        var _to_return = !this.getDomElement();
        if ( _to_return ) {
            this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-grids shinken-css-relative-position" } ) );
        }
        var _current;
        for ( let i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _current = this.getContent( i );
            if ( _current.computeHtml( dom_parent_with_scroll ) ) {
                this.addDomElement( _current.getDomElement() );
            }
        }
        return _to_return;
    },
    //********************************************  UPDATE DATA   **************************************************//
    updateData         : SHINKEN.OBJECT.DefaultConfiguration.prototype.updateData,
    reset              : function () {
        this.initContents();
        DOM.Service.removeElement( this.getDomElement() );
    },
    setData            : function ( key, value ) {
        switch ( key ) {
            case "list_content":
                for ( var i = 0, _size_i = value.length; i < _size_i; i++ ) {
                    let _current_grid = this.add( this.getChildConstructor( value[ i ], i ) );
                    this.addSynchronizedPhase( _current_grid );
                }
                break;
            default:
                this.setDataAsUnknownProperty( key, value );
                break;
        }
    },
    getChildConstructor: function ( data ) {
        return new SHINKEN_GRID.Grid( data );
    },
    updateContentData  : function ( data ) {
        for ( var i = 0, _size = this.getSize(); i < _size; i++ ) {
            this.getContent( i ).updateContentData( data );
        }
    },
    doActionAfter      : function ( event_name, param_1, param_2, param_3 ) {
        let to_return;
        for ( let i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            to_return = this.contents[ i ].doActionAfter( event_name, param_1, param_2, param_3 );
        }
        return to_return;
    },
    //********************************************  PHASE   **************************************************//
    callbackForPhase: function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Grids, SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Grids, SHINKEN.OBJECT.ShinkenObjectContainerHtml );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Grids, SHINKEN.OBJECT.PhaseInterface );