//__lib__ lib_common_V02_01
"use strict";
SHINKEN.OBJECT.GridPageEditionSlidePanel           = function () {
    this.initSpecific();
};
SHINKEN.OBJECT.GridPageEditionSlidePanel.prototype = {
    //********************************************  INIT  *****************************************************//
    initSpecific: function () {
        this.setType( SHINKEN.OBJECT.SLIDE_PANEL.TYPE.HORIZONTAL_RIGHT );
        this.init( SHINKEN_PAGE.CONST.SLIDE_PANEL.EDITION.NAME, document.querySelector( ".shinken-slide-panel-main-part" ) );
        this.dom_element__form_button_actions         = document.querySelector( ".shinken-weather-edition-button-action" );
        this.dom_element__form_without_button_actions = document.querySelector( ".shinken-weather-form-container-without-buttons" );
        this.setInitialSize( SHINKEN.TOOLS.IFRAME_PARENT_COMMUNICATION.getUserPref( SHINKEN_PAGE.CONST.USER_PREFS.NAME )[ this.getName() ] );
        this.setMinSize( 100, 340 );
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "slide-panel-restore-structure-done":
                CONTROLLER.PageController.doActionAfter( event_name );
                break;
            case "slide_panel__set_content__done":
                this.doActionAfter( "update_style_dom_element__without_buttons", param );
                break;
            case "slide_panel__size__has_changed":
                if ( param[ SHINKEN.OBJECT.SLIDE_PANEL.PARAM.OBJECT ] !== this ) {
                    return;
                }
                this.doActionAfter( "update_style_dom_element__without_buttons", param );
                this.doActionAfter( "update_style_dom_element__restricted_label_visibility", param );
                break;
            case "update_style_dom_element__without_buttons":
                let height_button = DOM.Service.getBoundingClientRect( this.dom_element__form_button_actions, DOM.CONST.STYLE.HEIGHT );
                let new_height    = "calc(100% - " + height_button + "px)";
                if ( new_height === this.dom_element__form_without_button_actions.style[ DOM.CONST.STYLE.HEIGHT ] ) {
                    return;
                }
                DOM.Service.setStyle( this.dom_element__form_without_button_actions, DOM.CONST.STYLE.HEIGHT, new_height );
                CONTROLLER.PageController.doActionAfter( "update_style_dom_element__without_buttons__done" );
                break;
            case "update_style_dom_element__restricted_label_visibility":
                DOM.Service.addOrRemoveClasses( this.getDomElement(), param[ SHINKEN.OBJECT.SLIDE_PANEL.PARAM.SIZE_EXISTING ] < 220, "shinken-restricted-label-display" );
                break;
        }
        this.doActionAfterCommon( event_name, param );
    },
    //********************************************  CONTROLLER   **************************************************//
    getController_20241003: function () {
        return CONTROLLER.PageController;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridPageEditionSlidePanel, SHINKEN.OBJECT.SlidePanel );

SHINKEN.OBJECT.SlidePanelProblem           = function () {
    this.initSpecific();
};
SHINKEN.OBJECT.SlidePanelProblem.prototype = {
    //********************************************  INIT  *****************************************************//
    initSpecific: function () {
        this.setType( SHINKEN.OBJECT.SLIDE_PANEL.TYPE.VERTICAL_TOP );
        this.init( SHINKEN_PAGE.CONST.SLIDE_PANEL.PROBLEMS.NAME, document.querySelector( ".shinken-weather-form-container-without-buttons .shinken-edition-main-part" ) );
        this.setInitialSize( 0.3 );
        this.setMinSize( 100, 75 );
        this.initCounterCommon();
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "before__update_object__grid_page":
                this.window_group_problem = new SHINKEN.OBJECT.WindowGroupProblem();
                this.window_group_problem.setCountersParent( this );
                break;
            case "clean_widget_with_problem":
                this.window_group_problem.doActionAfter( event_name, param );
                if ( !this.window_group_problem.hasProblems() ) {
                    this.close__20240925();
                }
                break;
            case "add_object_with_problems":
            case "add_object_json_fail":
                this.window_group_problem.doActionAfter( event_name, param );
                return;
            case "add_object__with_problems__from_user_action":
                this.window_group_problem.doActionAfter( event_name, param );
                this.setPhaseIfPhase( SHINKEN.OBJECT.CONST.PHASE.READY, SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                return;
            case "update_style_dom_element__without_buttons__done":
                this.computeSize__parent();
                this.setSize__20240926( this.getSize__partAdded() );
                break;
            case "slide_panel__size__has_changed":
                if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.SLEEPING ) ) {
                    return this.addDoActionAfterCallBackPhaseBecome( SHINKEN.OBJECT.CONST.PHASE.RUNNING, event_name, param );
                }
                if ( param[ SHINKEN.OBJECT.SLIDE_PANEL.PARAM.OBJECT ] && param[ SHINKEN.OBJECT.SLIDE_PANEL.PARAM.OBJECT ].getName() === SHINKEN_PAGE.CONST.SLIDE_PANEL.EDITION.NAME ) {
                    this.computeSize__parent();
                    this.setSize__20240926( this.getSize__partAdded(), param[ SHINKEN.OBJECT.SLIDE_PANEL.PARAM.OBJECT ].is_drag_on );
                }
                if ( this.window_group_problem ) {
                    this.window_group_problem.doActionAfter( event_name, param );
                }
                break;
        }
        this.doActionAfterCommon( event_name, param );
    },
    //********************************************  HTML   **************************************************//
    buildContent__20240828: function () {
        const to_return                 = DOM.Service.createElement( "div", { class: "shinken-weather-main-container-error-message" } );
        const _container_header         = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-container-header" } ), to_return );
        const _container_header_buttons = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-container-header-buttons" } ), _container_header );
        const _button_see_all           = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-button-see-all" } ), _container_header_buttons );
        
        this.display_of_widgets_button = new COMPONENT.ButtonFromData( "toggle-display-of-widgets-with-issues", "shinkon shinkon-eye-open shinken-button" );
        this.display_of_widgets_button.setTooltipByState( COMPONENT.CONST.BTN_STATE.OFF, _( "edit_mode.windows.tooltips.hide_cells_with_problems" ) );
        this.display_of_widgets_button.setTooltipByState( COMPONENT.CONST.BTN_STATE.ON, _( "edit_mode.windows.tooltips.show_cells_with_problems" ) );
        DOM.Service.setDataSet( this.display_of_widgets_button.getDomElement(), "name", "toggle-display-of-widgets-with-issues" );
        this.display_of_widgets_button.computeHtml();
        DOM.Service.addElementTo( this.display_of_widgets_button.getDomElement(), _button_see_all );
        
        this.window_container = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-weather-problem-window-container" } ), to_return );
        this.window_group_problem.computeHtml();
        DOM.Service.addElementTo( this.window_group_problem.getDomElement(), this.window_container );
        this.window_group_problem.computeHtmlTargets( this.window_container );
        this.window_group_problem.setContentSpecific();
        this.window_group_problem.doActionAfter( "link__dom_element__to_widget_problem__counter", { "dom_element_to_link": this.display_of_widgets_button.getDomElement() } );
        
        const _container_title_div = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-edit-title-div" } ), _container_header );
        DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-label shinkon shinkon-warning-circle-lite" } ), _container_title_div );
        DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-container-title" }, "<span>" + _( "edit_mode.windows.title.problem" ) + "</span>" ), _container_title_div );
        return to_return;
    },
    //********************************************  CONTROLLER   **************************************************//
    getController_20241003: function () {
        return CONTROLLER.PageController;
    },
    //********************************************  CALLBACK   **************************************************//
    callbackForPhase: function () {
        const _current = this.getCurrentPhase();
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.REFRESHING:
                DOM.Service.addElementToAfterEmpty( SHINKEN.TOOLS.LOADING_FRAME.getDomElement_V3(), this.window_container );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.READY:
                if ( this.window_group_problem.hasProblems() ) {
                    this.setContent__20240925( this.buildContent__20240828() );
                    this.open__20240925();
                }
                else {
                    this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                }
                break;
            case SHINKEN.OBJECT.CONST.PHASE.HIDDEN:
                this.resetCounters();
                break;
        }
        this.callbackForPhaseCommon();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlidePanelProblem, SHINKEN.OBJECT.SlidePanel );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlidePanelProblem, SHINKEN.OBJECT.CounterInterfaceValidation );
