//priority 5
//__lib__ lib_common_V02_01
'use strict';
SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage           = function ( default_configuration ) {
    this.init( default_configuration );
};
SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype = {
    init: SHINKEN.OBJECT.DefaultConfiguration.prototype.init,
    //********************************************  UPDATE  *****************************************************//
    updateData                       : function ( data ) {
        if ( !data ) {
            return;
        }
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        var _value;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            _value      = data[ _currentKey ];
            switch ( _currentKey ) {
                case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.MESSAGES:
                    this.setMessageValidation( _value );
                    break;
                case SHINKEN_PAGE.CONST.PARAM.SPECIFIC_TREATMENT.OBJECT_VALUE:
                    this.updateData( _value );
                    break;
                default:
                    this.setData( _currentKey, _value );
                    break;
            }
        }
    },
    _setData                         : function ( key, value_object ) {
        var _valid_own_properties = this.getValidOwnProperty();
        var _parameter            = _valid_own_properties.getParameter( key );
        if ( _parameter ) {
            this.setDataKey( key, value_object );
            return;
        }
        if ( !this._setDataDefaultObject( key, value_object ) ) {
            this.setDataAsUnknownProperty( key, value_object );
        }
    },
    setMessageValidation             : function ( value ) {
        this.setMessages( value );
        this.doActionAfterSetMessageValidation();
    },
    doActionAfterSetMessageValidation: function ( value ) {
        CONTROLLER.PageController.doActionAfter( "add_object_with_problems", { [ SHINKEN.OBJECT.CONST.VALIDATION.PARAM.CURRENT_OBJECT ]: this } );
    },
    //********************************************  SAVE  *****************************************************//
    getDataForLastModification: function () {
        let _to_return = {};
        for ( let i = 0, _size_i = this.own_property_keys.length; i < _size_i; i++ ) {
            _to_return[ this.own_property_keys[ i ] ] = {
                [ SHINKEN.OBJECT.CONST.PARAM.VALUE ]: this[ this.own_property_keys[ i ] ].getDataForLastModification(), [ SHINKEN.OBJECT.CONST.PARAM.SOURCE_VALUE ]: this[ this.own_property_keys[ i ] ].getDataToSave()
            };
        }
        for ( let i = 0, _size_i = this.own_children_keys.length; i < _size_i; i++ ) {
            _to_return[ this.own_children_keys[ i ] ] = { [ SHINKEN.OBJECT.CONST.PARAM.VALUE ]: this[ this.own_children_keys[ i ] ].getDataForLastModification() };
        }
        if ( this.messages.hasMessage() ) {
            _to_return[ SHINKEN.OBJECT.CONST.VALIDATION.FIELD.MESSAGES ] = this.messages;
        }
        return _to_return;
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getObjectParamConstructor   : function ( key, value, parameter, default_value, is_belonging_to_grid_cell_object ) {
        return new SHINKEN.OBJECT.ParamGridPage( key, value, parameter, default_value, is_belonging_to_grid_cell_object );
    },
    isObjectParamConstructor    : function ( value_object ) {
        return value_object instanceof SHINKEN.OBJECT.ParamGridPage;
    },
    getDefaultValueLabel        : function () {
        return SHINKEN_PAGE.CONST.DEFAULT_VALUE;
    },
    getObjectMessagesConstructor: function () {
        return new SHINKEN_PAGE.Messages();
    },
    //********************************************  GETTER SETTER  *****************************************************//
    parseValueToDict_withValueKey : function ( value_source, value_value ) {
        return { [ SHINKEN.OBJECT.CONST.PARAM.SOURCE_VALUE ]: value_source, [ SHINKEN.OBJECT.CONST.PARAM.VALUE ]: value_value };
    },
    parseDictToDict_withValueKey  : function ( dict ) {
        let to_return = {};
        var _keys     = Object.keys( dict );
        var _current_key;
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            if ( typeof dict[ _current_key ] === "object" ) {
                to_return[ _current_key ] = this.parseObjectToDict_withValueKey( dict[ _current_key ] );
            }
            else {
                to_return[ _current_key ] = this.parseValueToDict_withValueKey( dict[ _current_key ], dict[ _current_key ] );
            }
        }
        return to_return;
    },
    parseObjectToDict_withValueKey: function ( object ) {
        let to_return = {};
        var _keys     = Object.keys( object );
        if ( _keys.length === 2 && object[ SHINKEN.OBJECT.CONST.PARAM.SOURCE_VALUE ] !== undefined && object[ SHINKEN.OBJECT.CONST.PARAM.VALUE ] !== undefined ) {
            return object;
        }
        return { [ SHINKEN_PAGE.CONST.PARAM.SPECIFIC_TREATMENT.OBJECT_VALUE ]: SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.parseDictToDict_withValueKey( object ) };
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage, SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty );

SHINKEN.OBJECT.ParamGridPage           = function ( key, value_object, parameter, default_value, is_belonging_to_grid_cell_object ) {
    this.is_belonging_to_grid_cell_object = is_belonging_to_grid_cell_object;
    this.init( key, value_object, parameter, default_value );
};
SHINKEN.OBJECT.ParamGridPage.prototype = {
    initMessages       : function () {
        if ( !this.messages ) {
            this.messages = new SHINKEN_PAGE.Messages();
        }
    },
    setMessagesSpecific: function ( message ) {
        this.setMessages( message );
        this.doActionAfterSetMessageValidation();
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave                    : function () {
        return this.getUserValue();
    },
    doActionAfterSetMessageValidation: SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.doActionAfterSetMessageValidation
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ParamGridPage, SHINKEN.OBJECT.Param );
