//__lib__ lib_common_V02_01
'use strict';

SHINKEN.OBJECT.ButtonModeSelectByName           = function ( name ) {
    this.initSpecific( name );
};
SHINKEN.OBJECT.ButtonModeSelectByName.prototype = {
    //********************************************  INIT  **************************************************//
    initSpecific: function ( name, label ) {
        this.init( name );
        this.initInput();
        this.initSelector( name );
        
    },
    initInput   : function () {
        this.input = new COMPONENT.InputFromDataV2( "", this.name );
        this.input.setPlaceholder( _( "form.radio_widget_mode.mode_select.input_placeholder" ) );
        this.input.computeHtml();
    },
    initSelector: function ( name ) {
        this.select = new COMPONENT.SingleSelectFromData( name );
        this.select.setOptionsFromArray( this.computeSelectorOptions( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.SELECT_WIDGET_SELECTOR_OPTIONS ) );
        this.select.computeHtml();
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "click_on_selector":
                this.select.doActionAfter( event_name, param_1, param_2, param_3 );
                return true;
            case "click_on_item_selector":
                this.select.doActionAfter( event_name, param_3, this );
                return true;
        }
        this.doActionAfterCommon(event_name, param_1, param_2, param_3);
    },
    
    //********************************************  GETTER SETTER  *****************************************************//
    
    //********************************************  HTML  *****************************************************//
    getLabelDomElement: function () {
        let to_return = DOM.Service.createElement( "div", { class: "shinken-label-container shinken-layout-inline-center-h-v" } );
        DOM.Service.addElementTo( this.select.getDomElement(), to_return );
        DOM.Service.addElementTo( this.input.getDomElement(), to_return );
        return to_return;
    },
    //********************************************  VALIDATION  *****************************************************//
    computeSelectorOptions: function ( selectors_options ) {
        var _to_return = [];
        var _keys      = Object.keys( selectors_options );
        var _current_key;
        var _to_add;
        for ( let i = 0, _size = (_keys.length); i < _size; i++ ) {
            _current_key       = _keys[ i ];
            _to_add            = { "name": selectors_options[ _current_key ] };
            _to_add[ 'label' ] = _( "form.radio_widget_mode.mode_select.input_selector_options." + selectors_options[ _current_key ] );
            if ( i === 0 ) {
                _to_add[ 'is_selected' ] = true;
            }
            _to_return.push( _to_add );
        }
        return _to_return;
    }
}
;

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ButtonModeSelectByName, SHINKEN.OBJECT.RadioMode );