//__lib__ lib_common_V02_01
'use strict';

SHINKEN.OBJECT.RadioWidgetModeSelect           = function ( name ) {
    this.initSpecific( name );
};
SHINKEN.OBJECT.RadioWidgetModeSelect.prototype = {
    initSpecific  : function ( name, label ) {
        this.init( name );
        this.setLabel( _( "form.radio_widget_mode.label." + name ) );
        //this.radios = new SHINKEN.OBJECT.ModeSelectWidgetButtons( "weather_radio_widget_mode_select" );
        //this.radios.initAllContent();
    },
    initAllContent: function () {
        this.add( new SHINKEN.OBJECT.RadioWidgetModeSelect( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_SELECT ) );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    //doActionAfter: function ( event_name, param ) {
    //    switch ( event_name ) {
    //        case "hide_popup":
    //        case "click_on_selector":
    //        case "click_on_item_selector":
    //            this.radios.doActionAfter( event_name, param );
    //            return true;
    //        case "click_done":
    //            this.radios.doActionAfter( event_name, param );
    //            return true;
    //    }
    //    this.doActionAfterCommon( event_name, param );
    //},
    //********************************************  HTML  *****************************************************//
    getIconSrc        : function () {
        return "/static/" + __SHINKEN_HTTP_START_TIME__ + "/service_weather/img/form/select.png";
    },
    getShortCutLetter : function () {
        return "V";
    },
    getTooltipPosition: function () {
        return SHINKEN_TOOLTIP.PLACEMENT.BOTTOM_LEFT;
    },
    //********************************************  HELP  *****************************************************//
    getHelpContents     : function () {
        return [
            {
                type_content: "label_&_content",
                label       : _( "edit_mode.windows.tooltips.labels_help.select_with" ),
                elements    : [
                    { className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.click" ) },
                    { className: "shinken-tooltip-help-label", content: _( "edit_mode.windows.tooltips.labels_help.or" ) },
                    { className: "shinken-tooltip-help-label", content: _( "edit_mode.windows.tooltips.labels_help.maintain" ) },
                    { className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.click" ) },
                    { className: "shinken-tooltip-help-label", content: "+" },
                    { className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.move" ) }
                ]
            },
            {
                type_content: "label_&_content",
                label       : _( "edit_mode.windows.tooltips.labels_help.mass_selection" ),
                elements    : [
                    { className: "shinken-tooltip-help-label", content: _( "edit_mode.windows.tooltips.labels_help.maintain" ) },
                    { className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.click" ) },
                    { className: "shinken-tooltip-help-label", content: "+" },
                    { className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.move" ) },
                    { className: "shinken-tooltip-help-label", content: _( "edit_mode.windows.tooltips.labels_help.or" ) },
                    { className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.ctrl" ) },
                    { className: "shinken-tooltip-help-label", content: "+" },
                    { className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.click" ) }
                ]
            },
            {
                type_content: "label_&_content",
                label       : _( "edit_mode.windows.tooltips.labels_help.move_widget" ),
                elements    : [
                    { className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.select" ) },
                    { className: "shinken-tooltip-help-label", content: _( "edit_mode.windows.tooltips.labels_help.then" ) },
                    { className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.click" ) },
                    { className: "shinken-tooltip-help-label", content: "+" },
                    { className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.move" ) }
                ]
            },
            {
                type_content: "label_&_content",
                label       : _( "edit_mode.windows.tooltips.labels_help.cancel_selection" ),
                elements    : [{ className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.esc" ) }]
            },
            {
                type_content: "full_line_content",
                label       : _( "edit_mode.windows.tooltips.labels_help.deselect" ),
                elements    : [
                    { className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.ctrl" ) },
                    { className: "shinken-tooltip-help-label", content: "+" },
                    { className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.click" ) },
                    { className: "shinken-tooltip-help-label", content: _( "edit_mode.windows.tooltips.labels_help.or" ) },
                    { className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.click" ) },
                    { className: "shinken-tooltip-help-label", content: _( "edit_mode.windows.tooltips.labels_help.on" ) },
                    { className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.weather" ) }
                ]
            }
        ];
    },
    getHelpSpecificClass: function ( content ) {
        return "shinken-tooltip-selection";
    },
    //computeHtmlExtra    : function () {
    //    this.radios.computeHtml();
    //    DOM.Service.addElementTo( this.radios.getDomElement(), this.dom_content_zone );
    //},
    //********************************************  PHASE  *****************************************************//
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.RadioWidgetModeSelect, SHINKEN.OBJECT.RadioMode );