//priority 1050
//__lib__ lib_common_V02_01
'use strict';

SHINKEN.OBJECT.WidgetRadioModes           = function ( name ) {
    this.init( name );
};
SHINKEN.OBJECT.WidgetRadioModes.prototype = {
    init: SHINKEN.OBJECT.RadioModes.prototype.init,
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "change_radio_mode":
                if ( param[ SHINKEN.OBJECT.RADIOMODE.PARAM.PARENT_OBJECT ] === SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.ADD_WIDGET.RADIOS._KEY ) {
                    this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_ADD ).doActionAfter( event_name, param );
                    this.doActionAfter( event_name, {
                        [ SHINKEN.OBJECT.RADIOMODE.PARAM.PARENT_OBJECT ]: this.getName(),
                        [ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ]         : SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_ADD
                    } );
                    return;
                }
                break;
            case "action_for_page_edit_when_object_is_compute":
                this.setPhaseDomElement( param[ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ].dom_element, "widgetEditionMode" );
                this.addSynchronizedPhase( param[ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ].synchronized_phase_with_widget_mode );
                break;
            case "on_key_up":
                let current_key_code = param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].keyCode;
                switch ( current_key_code ) {
                    case SHINKEN.CONST.KEY_CODE.V:
                    case SHINKEN.CONST.KEY_CODE.ESCAPE:
                        param[ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ] = SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_SELECT;
                        break;
                    case SHINKEN.CONST.KEY_CODE.A:
                        if ( this.getCurrentPhase() === SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_ADD ) {
                            this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_ADD ).doActionAfter( "change_radio_mode_to_next" );
                            return;
                        }
                        param[ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ] = SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_ADD;
                        break;
                    case SHINKEN.CONST.KEY_CODE.C:
                        param[ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ] = SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_CREATE;
                        break;
                    case SHINKEN.CONST.KEY_CODE.S:
                        param[ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ] = SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_DELETE;
                        break;
                    default:
                        return;
                }
                param[ SHINKEN.OBJECT.RADIOMODE.PARAM.PARENT_OBJECT ] = SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES._KEY;
                this.doActionAfter( "change_radio_mode", param );
                break;
        }
        this.doActionAfterCommon( event_name, param );
    },
    //********************************************  PHASE  **************************************************//
    callbackForPhase: function () {
        let current_phase = this.getCurrentPhase();
        switch ( current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.READY:
                this.doActionAfter( "change_radio_mode", {
                        [ SHINKEN.OBJECT.RADIOMODE.PARAM.PARENT_OBJECT ]: this.getName(),
                        [ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ]         : SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_SELECT
                    }
                );
                break;
        }
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.WidgetRadioModes, SHINKEN.OBJECT.RadioModes );