//__lib__ lib_common_V02_01
"use strict";

SHINKEN_PAGE.Messages = function () {
    this.initCounterCommon();
    this.init();
};

SHINKEN_PAGE.Messages.prototype = {
    init             : SHINKEN.OBJECT.MessagesConfig.prototype.init,
    initCounterCommon: SHINKEN.OBJECT.CounterInterfaceValidation.prototype.initCounterCommon,
    getStatus        : function () {
        if ( this.hasError() ) {
            return COMPONENT.CONST.STATUS.ERROR;
        }
        if ( this.hasWarning() ) {
            return COMPONENT.CONST.STATUS.WARNING;
        }
        if ( this.hasInfo() ) {
            return COMPONENT.CONST.STATUS.INFO;
        }
        return COMPONENT.CONST.STATUS.NONE;
    },
    buildMessage     : function () {
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, "SHINKEN_PAGE.Messages", this.messages_error.length || "" );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS, "SHINKEN_PAGE.Messages", this.messages_warning.length || "" );
        let _status = this.getStatus();
        if ( _status === COMPONENT.CONST.STATUS.NONE ) {
            return '';
        }
        let _to_return = '<div class="shinken-tooltip-message text-left shinken-drag-exclude">';
        if ( this.hasError() ) {
            _to_return += '<span class="shinken-error-message-title">' + _( 'messages.tag_error', [DICTIONARY_COMMON_UI] ) + '</span><br><ol class="shinken-error-message-container">';
            _to_return += this.buildMessageForList( this.messages_error, false );
            _to_return += '</ol>';
        }
        if ( this.hasWarning() ) {
            _to_return += '<span class="shinken-warning-message-title">' + _( 'messages.tag_warning', [DICTIONARY_COMMON_UI] ) + '</span><br><ol class="shinken-warning-message-container">';
            _to_return += this.buildMessageForList( this.messages_warning, false );
            _to_return += '</ol>';
        }
        if ( this.hasInfo() ) {
            _to_return += '<span class="shinken-icon-unknown-key shinkon-warning"></span>' + '<span class="shinken-unknown-key-message-title">' + _( 'messages.tag_unknown_key' ) + '</span><br><ol class="shinken-unknown-key-message-container">';
            _to_return += this.buildMessageForList( this.messages_info, false );
            _to_return += '</ol>';
        }
        
        
        if ( this.footer ) {
            _to_return += this.footer;
        }
        
        _to_return += '</div>';
        return _to_return;
    },
    buildHTML        : function () {
        let _to_return;
        if ( this.hasStatus() ) {
            _to_return = DOM.Service.createElement( "div", {}, this.buildMessage() );
        }
        else {
            _to_return = DOM.Service.createElement( "div", { class: "shinken-note" }, _( 'messages.no_message_to_display', [DICTIONARY_COMMON_UI] ) );
        }
        return _to_return;
    },
    addMessage       : function ( type_message, object_message ) {
        switch ( type_message ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.messages_error.push( new SHINKEN_PAGE.Message( type_message, object_message, this.getUUID() ) );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.messages_warning.push( new SHINKEN_PAGE.Message( type_message, object_message, this.getUUID() ) );
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.messages_beware.push( new SHINKEN_PAGE.Message( type_message, object_message, this.getUUID() ) );
                break;
            default:
                this.messages_info.push( new SHINKEN_PAGE.Message( type_message, object_message, this.uuid ) );
                break;
        }
    },
    addMessages      : function ( messages ) {
        if ( !messages ) {
            return;
        }
        let _size = messages.length;
        let _current_message;
        for ( let i = 0; i < _size; i++ ) {
            _current_message = messages[ i ];
            switch ( _current_message._type ) {
                case COMPONENT.CONST.STATUS.ERROR:
                    this.messages_error.push( _current_message );
                    break;
                case COMPONENT.CONST.STATUS.WARNING:
                    this.messages_warning.push( _current_message );
                    break;
                case COMPONENT.CONST.STATUS.BEWARE:
                    this.messages_beware.push( _current_message );
                    break;
                default:
                    this.messages_info.push( _current_message );
                    break;
            }
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_PAGE.Messages, SHINKEN.OBJECT.MessagesConfig );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_PAGE.Messages, SHINKEN.OBJECT.CounterInterfaceValidation );

SHINKEN_PAGE.Message           = function ( type, object_message, uuid ) {
    this._type = type;
    if ( typeof object_message === "string" ) {
        this._text = object_message;
    }
    else {
        this._text          = object_message.text;
        this._list_keys     = object_message.list_keys;
        this.parent_uuid    = SHINKEN.TOOLS.STRING.buildUUID();
        this.impacted_index = this.parseMessageToGetIndexOfCellImpacted( object_message );
    }
};
SHINKEN_PAGE.Message.prototype = {
    _getObjectToJson                    : function ( format_data__20241115 ) {
        
        let _to_return     = {};
        _to_return.uuid    = this.parent_uuid;
        _to_return.tooltip = "";
        if ( this._list_keys !== "__SHINKEN_NONE__" ) {
            if ( this._list_keys ) {
                _to_return.list_keys = this._list_keys;
            }
            _to_return.tooltip = this._text;
            switch ( this._type ) {
                case COMPONENT.CONST.STATUS.ERROR:
                case COMPONENT.CONST.STATUS.WARNING:
                    _to_return.class = SHINKEN.OBJECT.JSON_EDITOR.CLASS_ERROR;
                    break;
            }
        }
        return _to_return;
    },
    parseMessageToGetIndexOfCellImpacted: function ( object_message ) {
        if ( !object_message ) {
            return;
        }
        const regex_find_number_between_bracket     = /\[ (\d+) ]/g;
        const arr_element_matching_regex_in_message = [];
        const matches                               = object_message.text.match( regex_find_number_between_bracket ) || [];
        for ( let i = 0; i < matches.length; i++ ) {
            arr_element_matching_regex_in_message.push( matches[ i ] );
        }
        const impacted_index = [];
        for ( let i = 0, _size_i = arr_element_matching_regex_in_message.length; i < _size_i; i++ ) {
            impacted_index.push(SHINKEN.TOOLS.NUMBER.parseStringToPositiveInteger(arr_element_matching_regex_in_message[i]));
        }
        return impacted_index;
    },
    getImpactedIndex                    : function () {
        return this.impacted_index;
    },
    //********************************************  HTML   **************************************************//
    buildHtml: function () {
        let _to_return = DOM.Service.createElement( "li" );
        let div        = DOM.Service.createElement( "div", { class: "shinken-layout-justify-between " + this._type } ); // flex hide the list style
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-text-cell" }, "<div>" + this._text + "</div>" ), div );
        if ( this._list_keys !== "__SHINKEN_NONE__" ) {
            let _td_2  = DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-json-link-cell" } ), div );
            let button = new COMPONENT.ButtonFromData_V3( 'focus-on-json-forced', "<div class='shinken-layout-column-center-h shinken-json-button'><div class='shinicon-cog'></div><div>JSON</div></div>" );
            button.addParamForEvents( SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID, this.parent_uuid );
            button.addParamForEvents( SHINKEN.OBJECT.JSON_EDITOR.PARAM.JSON_OBJECT, true );
            button.computeHtml();
            DOM.Service.addElementTo( button.getDomElement(), _td_2 );
        }
        DOM.Service.addElementTo( div, _to_return );
        return _to_return.outerHTML;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_PAGE.Message, SHINKEN.OBJECT.MessageConfig );

