//__lib__ lib_common_V02_01
'use strict';


const WINDOW_PROBLEM_NAME_GENERAL           = SHINKEN_PAGE.CONST.WINDOWS_TABS_EDITION_MESSAGE.TABS[ SHINKEN_PAGE.CONST.WINDOWS_TABS_EDITION_MESSAGE.INDEX_TAB.GENERAL ][ "name" ];
const WINDOW_PROBLEM_NAME_WIDGET            = SHINKEN_PAGE.CONST.WINDOWS_TABS_EDITION_MESSAGE.TABS[ SHINKEN_PAGE.CONST.WINDOWS_TABS_EDITION_MESSAGE.INDEX_TAB.WIDGET ][ "name" ];
SHINKEN.OBJECT.WindowGroupProblem           = function () {
    this.initSpecific( "grid_page_window_group_problem" );
};
SHINKEN.OBJECT.WindowGroupProblem.prototype = {
    initSpecific       : function ( group_name ) {
        this.init( group_name );
        this.initWithData( WEATHER.CONST.WINDOWS_TABS_EDITION_MESSAGE.TABS );
    },
    getChildConstructor: function ( window_name, parent_name ) {
        switch ( window_name ) {
            case WINDOW_PROBLEM_NAME_GENERAL:
                return new SHINKEN.OBJECT.WindowProblemGeneral( window_name, this.name );
            case WINDOW_PROBLEM_NAME_WIDGET:
                return new SHINKEN.OBJECT.WindowProblemCell( window_name, this.name );
        }
    },
    //******************************************** EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "clean_widget_with_problem":
            case "link__dom_element__to_widget_problem__counter":
            case "add_object__with_problems__from_user_action":
                this.getWindowByName( WINDOW_PROBLEM_NAME_WIDGET ).doActionAfter( event_name, param );
                return;
            case "add_object_json_fail":
                this.getWindowByName( WINDOW_PROBLEM_NAME_GENERAL ).doActionAfter( event_name, param );
                return;
            case "add_object_with_problems":
                if ( param[ SHINKEN.OBJECT.CONST.VALIDATION.PARAM.CURRENT_OBJECT ].is_belonging_to_grid_cell_object ) {
                    this.getWindowByName( WINDOW_PROBLEM_NAME_WIDGET ).doActionAfter( event_name, param );
                }
                else {
                    this.getWindowByName( WINDOW_PROBLEM_NAME_GENERAL ).doActionAfter( event_name, param );
                }
                return;
            case "weather_window_group_problem_change_index_label": // TODO Utile ??
                this.getWindowByName( WINDOW_PROBLEM_NAME_WIDGET ).doActionAfter( event_name, param );
                this.clickOnWindow( WINDOW_PROBLEM_NAME_WIDGET );
                return;
            //case "compute_resize_done_on_edition_panel":
            case "slide_panel__size__has_changed":
                DOM.Service.addOrRemoveClasses( this.dom_element, false, "shinken-inline-display" );
                const buttons_size = DOM.Service.getBoundingClientRect( this.getWindowByName( WINDOW_PROBLEM_NAME_GENERAL ).getDomElement(), DOM.CONST.STYLE.WIDTH ) +
                                     DOM.Service.getBoundingClientRect( this.getWindowByName( WINDOW_PROBLEM_NAME_WIDGET ).getDomElement(), DOM.CONST.STYLE.WIDTH );
                const target_size  = DOM.Service.getBoundingClientRect( this.dom_element_targets, DOM.CONST.STYLE.WIDTH );
                DOM.Service.addOrRemoveClasses( this.dom_element, target_size <= buttons_size, "shinken-inline-display" );
                return;
        }
        this.doActionAfterSpecificComma( event_name, param );
        this.doActionAfterCommon( event_name, param );
    },
    //********************************************  GETTER SETTER  **************************************************//
    hasProblems       : function () {
        return this.getContents().some( current_window_element => current_window_element.hasProblems() );
    },
    setContentSpecific: function () {
        if ( this.getWindowByName( WINDOW_PROBLEM_NAME_GENERAL ).hasCounterProblems() ) {
            this.setActiveWindow( WINDOW_PROBLEM_NAME_GENERAL );
        }
        else {
            this.setActiveWindow( WINDOW_PROBLEM_NAME_WIDGET );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.WindowGroupProblem, WINDOW_V2.ElementGroupFromDataWithComma );