//__lib__ lib_common
"use strict";

WINDOW.ElementGroupFromDataAbstract           = function () {
};
WINDOW.ElementGroupFromDataAbstract.prototype = {
    init           : WINDOW.ElementGroup.prototype.init,
    initSpecific   : function () {
        this.init();
        this.initName();
        this.initWindows();
        MANAGER.__instance_window_distributor.setParentWindow( this.name, this );
    },
    initWindows    : function () {
    },
    initName       : function () {
        this.name = SHINKEN.TOOLS.STRING.buildUUID();
    },
    initControllers: function () {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].initController();
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    //setControllerName   : function ( to_set ) {
    //    this.controller_name = to_set;
    //    if ( this.getDomElement() ) {
    //        this.getDomElement().classList.add( "shinken-parent-event-listener" );
    //        DOM.Service.setDataSet( this.getDomElement(), "controller", "ui_visualisation" );
    //    }
    //},
    getDomElementTargets: function () {
        return this.dom_element_targets;
    },
    //********************************************  OTHER  *****************************************************//
    resizeDone: function () {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].resizeDone();
        }
    },
    //********************************************  HTML  *****************************************************//
    computeHtml       : function () {
        this.setDomElement( DOM.Service.createElement( "table", this.getMainAttribute() ) );
        var _onclick_attribute = this.getEventMangerHtml();
        var _dom_tr            = this.addDomElement( DOM.Service.createElement( "tr", {
            "class"    : "shinken-window-group",
            "data-name": this.name,
            "onclick"  : _onclick_attribute
        } ) );
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].computeHtml();
            DOM.Service.addElementTo( this.contents[ i ].getDomElement(), _dom_tr );
        }
        this.computeHtmlTargets();
        this.computeHtml_lvl_1();
    },
    getEventMangerHtml: function () {
        return "MANAGER.EventManager.clickOnWindowNavigation(event, '" + this.name + "')";
    },
    computeHtml_lvl_1 : function () {
    },
    computeHtmlTargets: function ( dom_parent ) {
        this.dom_element_targets = DOM.Service.createElement( "div", {
            "class": "shinken-window-targets"
        } );
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            DOM.Service.addElementTo( this.contents[ i ].dom_element_target, this.getDomElementTargets() );
        }
        if ( dom_parent ) {
            this.addDomElement( dom_parent );
        }
    },
    getMainAttribute  : function () {
        var _to_return = { "class": this.getMainClass() };
        if ( this.controller_name ) {
            _to_return[ "data-controller" ] = this.controller_name;
        }
        return _to_return;
    },
    getMainClass      : function () {
        var _to_return = "shinken-window-element-table shinken-table " + this.getClass();
        if ( this.controller_name ) {
            _to_return += " shinken-parent-event-listener";
        }
        return _to_return;
    },
    //********************************************  EVENT LISTENER  **************************************************//
    onClick: function ( event ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].onClick( event );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementGroupFromDataAbstract, WINDOW.ElementGroup );

WINDOW.ElementGroupFromDataWithCommaAbstract           = function () {
    this.initSpecific();
};
WINDOW.ElementGroupFromDataWithCommaAbstract.prototype = {
    initSpecific: WINDOW.ElementGroupFromDataAbstract.prototype.initSpecific,
    //********************************************  HTML  *****************************************************//
    computeHtml_lvl_1: function () {
        this._doExtraActionAfterSetActiveWindow();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementGroupFromDataWithCommaAbstract, WINDOW.ElementGroupWithCommaAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementGroupFromDataWithCommaAbstract, WINDOW.ElementGroupFromDataAbstract );
