//priority 20
//__lib__ lib_common_V02_01
"use strict";

WINDOW_V2.ElementGroup           = function ( group_name ) {
    this.init( group_name );
};
WINDOW_V2.ElementGroup.prototype = {
    init      : function ( group_name ) {
        this.initCommon( group_name );
    },
    initCommon: function ( group_name ) {
        this.initCounterCommon();
        this.initContents();
        this.initName( group_name );
        this.initPhase();
        this.active_window = null;
        MANAGER.__instance_window_distributor.setParentWindow( this.name, this );
    },
    initCounterCommon           : function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
    },
    initName  : function ( group_name ) {
        this.name = group_name || SHINKEN.TOOLS.STRING.buildUUID();
        this.addParamForEvents( WINDOW_V2.CONST.PARAM.WINDOW_GROUP_NAME, this.name );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter      : function ( event_name, param ) {
        this.doActionAfterCommon( event_name, param );
    },
    doActionAfterCommon: function ( event_name, param ) {
        switch ( event_name ) {
            case "compute_html_done" : //NOT GIVE TO CHILDREN
                break;
            default:
                this.doActionAfterContentChildren( event_name, param );
                break;
        }
    },
    //********************************************  GETTER SETTER  **************************************************//
    getController__20240819   : function () {
        return '';
    },
    getChildConstructor       : function ( window_name, parent_name ) {
        return new WINDOW_V2.Element( window_name, parent_name );
    },
    setActiveWindow           : function ( window_name ) {
        var _current;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].setActiveWindow( window_name ) ) {
                this.active_window = this.contents[ i ];
            }
        }
        this.doActionAfter( "set_active_window", {[WINDOW_V2.CONST.PARAM.WINDOW_NAME] : window_name} );
    },
    getActiveWindow           : function () {
        if ( !this.active_window ) {
            for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
                if ( this.contents[ i ].isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING ) ) {
                    this.active_window = this.contents[ i ];
                    break;
                }
            }
        }
        return this.active_window;
    },
    getName                   : function () {
        return this.name;
    },
    clickOnWindow             : function ( window_name ) {
        var _current_window = this.getWindowByName( window_name );
        if ( !_current_window.isClickable() ) {
            return false;
        }
        this.setActiveWindow( window_name );
        return true;
    },
    getWindowByName           : function ( window_name ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].getName() === window_name ) {
                return this.contents[ i ];
            }
        }
        return null;
    },
    setParentCounter          : function ( parent ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].setParentCounter( parent );
        }
    },
    setContentDomElementTarget: function ( window_name, to_set ) {
        var _to_return = this.getWindowByName( window_name );
        _to_return.setContentDomElementTarget( to_set );
        return _to_return;
    },
    hasProblems               : function ( window_name ) {
        return this.getWindowByName( window_name ).hasProblems();
    },
    setVisibilityWindowState  : function ( to_set, window_name, tooltip ) {
        var _window = this.getWindowByName( window_name );
        _window.setVisibilityState( to_set );
        _window.doActionAfter( "set_visibility_state" );
        return _window;
    },
    //********************************************  HTML  **************************************************//
    getDomElementTargets     : function () {
        return this.dom_element_targets;
    },
    pulsateElementIfNotActive: function ( window_name ) {
        if ( this.getActiveWindow().getName() !== window_name ) {
            this.getActiveWindow().pulsate();
        }
    },
    //********************************************  SAVE  **************************************************//
    getDataToSave: function () {
        return this.getActiveWindow().getDataToSave();
    },
    getUrlToSave : function () {
        return this.getActiveWindow().getUrlToSave();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW_V2.ElementGroup, SHINKEN.OBJECT.CounterInterfaceWithShinkenObjectContainer );
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW_V2.ElementGroup, SHINKEN.OBJECT.PhaseInterface );

WINDOW_V2.ElementGroupWithComma           = function ( group_name ) {
    this.init( group_name );
};
WINDOW_V2.ElementGroupWithComma.prototype = {
    init: WINDOW_V2.ElementGroup.prototype.init,
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter             : function ( event_name, param ) {
        this.doActionAfterSpecificComma( event_name, param );
        this.doActionAfterCommon( event_name, param );
    },
    doActionAfterSpecificComma: function ( event_name, param ) {
        switch ( event_name ) {
            case "compute_html_done":
                this.doActionAfter( "set_active_window_for_comma" );
                break;
            case "set_active_window_for_comma":
            case "set_active_window":
                if ( !this.getDomElement() ) {
                    break;
                }
                var _current;
                var _is_first = false;
                var _is_last  = false;
                for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
                    _current = this.contents[ i ];
                    if ( !_is_first && _current.isVisible() ) {
                        _is_first = true;
                        DOM.Service.addOrRemoveClasses( _current.getDomElement(), true, "shinken-is-first-comma" );
                    }
                    else {
                        DOM.Service.addOrRemoveClasses( _current.getDomElement(), false, "shinken-is-first-comma" );
                    }
                }
                for ( i = this.contents.length; i > 0; i-- ) {
                    _current = this.contents[ i - 1 ];
                    if ( !_is_last && _current.isVisible() ) {
                        _is_last = true;
                        DOM.Service.addOrRemoveClasses( _current.getDomElement(), true, "shinken-is-last-comma" );
                    }
                    else {
                        DOM.Service.addOrRemoveClasses( _current.getDomElement(), false, "shinken-is-last-comma" );
                    }
                }
                break;
        }
    },
    //********************************************  GETTER SETTER  **************************************************//
    getChildConstructor: function ( window_name, parent_name ) {
        return new WINDOW_V2.ElementWithComma( window_name, parent_name );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW_V2.ElementGroupWithComma, WINDOW_V2.ElementGroup );