#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2023:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from ...object.shinken_object import ShinkenObject

if TYPE_CHECKING:
    from shinken.misc.type_hint import Any, Callable, Optional
    from shinkensolutions.component.abstract_translate_component import TranslateKey


class LabelHtml(ShinkenObject):
    def __init__(self, translate, label='', hover_label=''):
        # type: (Optional[Callable[[TranslateKey, Any],str]], str, str)-> None
        super(LabelHtml, self).__init__(translate)
        self._label = label
        self._hover_label = hover_label
        self._before_html = ''
        self._after_html = ''
    
    
    def get_label(self):
        # type: () -> str
        return self._label
    
    
    def set_value(self, to_set):
        # type: (str) -> None
        self._label = to_set
    
    
    def get_html(self, extra_label=''):
        # type: (str) -> str
        _to_return = [self._before_html]
        if self._label and self._hover_label:
            _to_return.append('''<span class="shinken-label-with-hover %s">''' % self._class)
            _to_return.append('''<span class="shinken-label-with-hover-false">%s</span>''' % self._label)
            _to_return.append('''<span class="shinken-label-with-hover-true">%s</span>''' % self._hover_label)
            _to_return.append('''</span>''')
        else:
            _to_return.append('''<span class="%s">''' % self._class)
            _to_return.append(self._label)
            _to_return.append('''</span>''')
        _to_return.append(self._after_html)
        return ''.join(_to_return)
