#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2023:
# This file is part of Shinken Enterprise, all rights reserved.

from abc import ABCMeta, abstractmethod

from shinken.misc.type_hint import TYPE_CHECKING
from shinkensolutions.data_hub.data_hub_driver.abstract_data_hub_driver import AbstractDataHubDriver, AbstractDataHubDriverConfig

if TYPE_CHECKING:
    from shinken.misc.type_hint import List, Any, ContextManager


class AbstractDataHubDriverConfigDatabase(AbstractDataHubDriverConfig):
    pass


class AbstractDataHubDriverDatabase(AbstractDataHubDriver, metaclass=ABCMeta):
    @abstractmethod
    def init(self):
        # type: () -> None
        raise NotImplementedError()
    
    
    @abstractmethod
    def get_all_data_id(self):
        # type: () -> List[str]
        raise NotImplementedError()
    
    
    @abstractmethod
    def is_data_correct(self, data_id):
        # type: (str) -> bool
        raise NotImplementedError()
    
    
    @abstractmethod
    def lock_context(self, data_id):
        # type: (str) -> ContextManager[Any]
        raise NotImplementedError()
    
    
    @abstractmethod
    def write(self, data_id, data):
        # type: (str, Any) -> None
        raise NotImplementedError()
    
    
    @abstractmethod
    def read(self, data_id, log_error=True):
        # type: (str, bool) -> Any
        raise NotImplementedError()
    
    
    @abstractmethod
    def remove(self, data_id):
        # type: (str) -> None
        raise NotImplementedError()
    
    
    @abstractmethod
    def get_last_modification_date(self, data_id):
        # type: (str) -> int
        raise NotImplementedError()
    
    
    @abstractmethod
    def destroy(self):
        # type: () -> None
        raise NotImplementedError()
    
    
    @abstractmethod
    def stop(self):
        # type: () -> None
        raise NotImplementedError()
    
    
    @abstractmethod
    def get_total_size(self):
        # type: () -> int
        raise NotImplementedError()
    
    
    @abstractmethod
    def get_number_of_stored_data(self):
        # type: () -> int
        raise NotImplementedError()
