#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
import copy

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import List, Dict, Callable


class ToolsBoxArray:
    @staticmethod
    def add_if_not_inside(to_add, array):
        if to_add not in array:
            array.append(to_add)
    
    
    @staticmethod
    def concat_array_unique(array_1, array_2):
        _to_return = copy.deepcopy(array_1)
        for _current in array_2:
            if _current not in _to_return:
                _to_return.append(_current)
        return _to_return
    
    
    @staticmethod
    def is_in(value_to_find, array):
        if not array:
            return False
        return value_to_find in array
    
    
    @staticmethod
    def append_and_return_insert_index(array, element_to_append):
        array.append(element_to_append)
        return len(array) - 1
    
    
    @staticmethod
    def replace(array, element_to_find, element_to_replace_with):
        return [element_to_replace_with if x == element_to_find else x for x in array]
    
    
    @staticmethod
    def find_duplicates_in_array(array):
        # type: (List) -> List
        unique_values = []
        duplicated_values = []
        for value in array:
            if value not in unique_values:
                unique_values.append(value)
            else:
                duplicated_values.append(value)
        return duplicated_values
    
    
    @staticmethod
    def find_duplicates_index_in_objects_array(object_list, get_value_func):
        # type: (List, Callable) -> Dict
        found_duplicates = {}
        list_size = len(object_list)
        for object_idx in range(list_size):
            object_value_for_key = get_value_func(object_list[object_idx])
            
            # No value? Or already found? Let's skip
            if not object_value_for_key or object_value_for_key in found_duplicates:
                continue
            
            duplicates = []
            for second_object_idx in range(object_idx + 1, list_size):
                second_object_value_for_key = get_value_func(object_list[second_object_idx])
                
                # No value? Or already found? Let's skip
                if not second_object_value_for_key or second_object_value_for_key in found_duplicates:
                    continue
                
                if object_value_for_key == second_object_value_for_key:
                    duplicates.append(second_object_idx)
            
            if duplicates:
                duplicates.insert(0, object_idx)  # We did not add it as we started the check at object_idx + 1
                found_duplicates[object_value_for_key] = duplicates
        
        return found_duplicates
    
    
    @staticmethod
    def split_in_parts(list_to_split, number_of_parts):
        # This method will return your list split in "number_of_parts" list
        k, m = divmod(len(list_to_split), number_of_parts)
        return (list_to_split[i * k + min(i, m):(i + 1) * k + min(i + 1, m)] for i in range(number_of_parts))
    
    
    @staticmethod
    def split_in_chunks(list_to_split, number_of_elements_per_list):
        # This method will return your list split in list to make them contains at most "number_of_elements_per_list"
        return [list_to_split[i * number_of_elements_per_list:(i + 1) * number_of_elements_per_list] for i in range((len(list_to_split) + number_of_elements_per_list - 1) // number_of_elements_per_list)]
