#!/usr/bin/python-shinken
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2024
# This file is part of Shinken Enterprise, all rights reserved.
from itertools import chain

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict, Optional


def find_weather_view_name(weather_dict):
    # type: (Dict) -> Optional[str]
    for grid_element in chain.from_iterable(grid.get('grid_elements', []) for grid in weather_dict.get('grids', [])):
        content = grid_element.get('content', {})
        if content.get('type', None) == 'title_widget':
            return content.get('layout', {}).get('information_to_display', {}).get('title_area', {}).get('label', None)
    return None
