#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2024
# This file is part of Shinken Enterprise, all rights reserved.

# It was named aaaa for be the first in automatic import

import ssl
import sys

from shinken.thread_helper import patch_thread_name

try:
    from cheroot.ssl.builtin import BuiltinSSLAdapter
    from cheroot.server import HTTPServer
    
    
    def get_environ(self, sock):
        """Create WSGI environ entries to be merged into each request."""
        cipher = sock.cipher()
        # noinspection SpellCheckingInspection
        ssl_environ = {
            'wsgi.url_scheme'      : 'https',
            'HTTPS'                : 'on',
            'SSL_PROTOCOL'         : cipher[1],
            'SSL_CIPHER'           : cipher[0],
            'SSL_CIPHER_EXPORT'    : '',
            'SSL_CIPHER_USEKEYSIZE': cipher[2],
            'SSL_VERSION_INTERFACE': '%s Python/%s' % (
                HTTPServer.version, sys.version,
            ),
            'SSL_VERSION_LIBRARY'  : ssl.OPENSSL_VERSION,
            'SSL_CLIENT_VERIFY'    : 'NONE',
            # 'NONE' - client did not provide a cert (overridden below)
        }
        return ssl_environ
    
    
    BuiltinSSLAdapter.get_environ = get_environ
except ImportError:
    BuiltinSSLAdapter = None
    HTTPServer = None

try:
    # noinspection PyProtectedMember
    from cheroot import _compat

    # noinspection SpellCheckingInspection
    orig_ntob = _compat.ntob

    # noinspection SpellCheckingInspection
    def ntob(n, encoding='UTF-8'):
        return orig_ntob(n, encoding)

    # noinspection SpellCheckingInspection
    _compat.ntob = ntob
except:
    _compat = None

try:
    # SEF-11578 - cheroot ate all CPU and stopped responding in Synchronizer main daemon
    import selectors
    import threading
    import shinkensolutions.subprocess_helper.fork_setup

    # noinspection PyProtectedMember
    from cheroot.connections import _ThreadsafeSelector
    
    original_init = _ThreadsafeSelector.__init__
    
    
    def patched_init(self):
        original_init(self)
        shinkensolutions.subprocess_helper.fork_setup.cheroot_selector_list.append(self)
    
    
    _ThreadsafeSelector.__init__ = patched_init
except:
    pass

patch_thread_name()
