#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.

class UNIQUE_ADDRESS_BEHAVIOUR:
    PARAMETER_NAME = 'host__detect_unique_address__behaviour'
    
    DUPLICATED_ACCEPTED = 'duplicated_accepted'
    WARNING_DISPLAYED = 'warning_displayed'
    ERROR_DISPLAYED = 'error_displayed'
    SAVE_FORBIDDEN = 'save_forbidden'
    
    DEFAULT = DUPLICATED_ACCEPTED

    ALL = (DUPLICATED_ACCEPTED, WARNING_DISPLAYED, ERROR_DISPLAYED, SAVE_FORBIDDEN)
    
    ERRORS = (ERROR_DISPLAYED, SAVE_FORBIDDEN)
    
    
    @staticmethod
    def is_error(to_test):
        return bool(to_test in UNIQUE_ADDRESS_BEHAVIOUR.ERRORS)
