#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2024
# This file is part of Shinken Enterprise, all rights reserved.


from shinken.misc.type_hint import TYPE_CHECKING, IN_TESTING

try:
    from shinken.synchronizer.front_end.object.messages import Messages, MESSAGE
    from shinken.synchronizer.front_end.object.shinken_object import ShinkenObject
    from shinken.synchronizer.front_end.object.empty_object import EmptyObject
    from shinken.synchronizer.front_end.object.html.tooltip import Tooltip
    from shinken.synchronizer.front_end.help.help_property import HelpZone
    from shinken.synchronizer.front_end.distributor.html_distributor import HtmlDistributor, HTML_TYPE
    from shinken.synchronizer.front_end.object.html.label import LabelHtml
    from shinken.synchronizer.front_end.property.check_box_property import CHECKBOX_LIST_CONST
    from shinken.synchronizer.front_end.property.factory_property import FactoryProperty
    from shinken.synchronizer.front_end.distributor.option_distributor import CounterSelect, DefineBy, SELECTOR_CONST
    from shinken.synchronizer.front_end.distributor.selector_distributor import instance_selector_distributor
    from shinken.synchronizer.front_end.distributor.manager_distributor import instance_manager_distributor, ORIGIN_DISTRIBUTOR_RESET
    from shinken.synchronizer.front_end.object.counter import Counter
    from shinken.synchronizer.front_end.object.html.tag_template import TagTemplate
    from shinken.synchronizer.front_end.component.option_select import OptionSelectComp
    from shinken.synchronizer.front_end.component.select import SelectComp

except ImportError as e:
    if TYPE_CHECKING or IN_TESTING:
        from synchronizer.front_end.object.messages import Messages, MESSAGE
        from synchronizer.front_end.object.shinken_object import ShinkenObject
        from synchronizer.front_end.object.empty_object import EmptyObject
        from synchronizer.front_end.object.html.tooltip import Tooltip
        from synchronizer.front_end.help.help_property import HelpZone
        from synchronizer.front_end.distributor.html_distributor import HtmlDistributor, HTML_TYPE
        from synchronizer.front_end.object.html.label import LabelHtml
        from synchronizer.front_end.property.check_box_property import CHECKBOX_LIST_CONST
        from synchronizer.front_end.property.factory_property import FactoryProperty
        from synchronizer.front_end.distributor.option_distributor import CounterSelect, DefineBy, SELECTOR_CONST
        from synchronizer.front_end.distributor.selector_distributor import instance_selector_distributor
        from synchronizer.front_end.distributor.manager_distributor import instance_manager_distributor, ORIGIN_DISTRIBUTOR_RESET
        from synchronizer.front_end.object.counter import Counter
        from synchronizer.front_end.object.html.tag_template import TagTemplate
        from synchronizer.front_end.component.option_select import OptionSelectComp
        from synchronizer.front_end.component.select import SelectComp
    
    if not IN_TESTING:
        raise e
