#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2024
# This file is part of Shinken Enterprise, all rights reserved.

from shinkensolutions.api.synchronizer import ITEM_TYPE
from shinkensolutions.api.synchronizer.source.item.source_item import SourceItem


class SourceHostTemplate(SourceItem):
    __slots__ = SourceItem.__slots__ + [
        'active_checks_enabled',
        'business_impact_modulations',
        'check_running_timeout',
        'hostgroups',
        'reactionner_tag',
        'notes_url',
        'escalations',
        'low_flap_threshold',
        'process_perf_data',
        'max_check_attempts',
        'view_contacts',
        'service_overrides',
        'check_period',
        'maintenance_period',
        'use',
        'notes_multi_url',
        'uuid',
        'notification_interval',
        'contacts',
        'notification_period',
        'flap_detection_options',
        'resultmodulations',
        'view_contact_groups',
        'warning_threshold_cpu_usage',
        'event_handler_enabled',
        'parents',
        'host_name',
        'first_notification_delay',
        'flap_detection_enabled',
        'notification_options',
        'high_flap_threshold',
        'edition_contacts',
        'bp_rule',
        'definition_order',
        'notification_contact_groups',
        'macromodulations',
        'notifications_enabled',
        'event_handler',
        'contact_groups',
        'obsess_over_host',
        'freshness_threshold',
        'address',
        'display_name',
        'realm',
        'sla_critical_threshold',
        'service_excludes',
        'imported_from',
        'name',
        'time_to_orphanage',
        'is_cluster',
        'edition_contact_groups',
        'notification_contacts',
        'check_command',
        'checkmodulations',
        'retry_interval',
        'poller_tag',
        'passive_checks_enabled',
        'check_interval',
        'service_excludes_by_id',
        'business_impact',
        'sla_warning_threshold',
        'check_freshness',
        'thresholds_display'
    ]
    
    
    def __init__(self):
        super(SourceHostTemplate, self).__init__()
        self.item_type = ITEM_TYPE.HOSTTPLS
