#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2024
# This file is part of Shinken Enterprise, all rights reserved.

from abc import ABCMeta, abstractmethod
from urllib.parse import quote

from shinken.misc.type_hint import TYPE_CHECKING
from shinkensolutions.api.synchronizer import ComponentManagerSynchronizer

if TYPE_CHECKING:
    from shinken.log import PartLogger


class AbstractRoute(object, metaclass=ABCMeta):
    def __init__(self, logger, source_name, name, have_http_template=False):
        # type: (PartLogger, str, str, bool) -> None
        self.logger = logger
        self.source_name = source_name
        self.name = name
        self.have_http_template = have_http_template
        self.http_template = '%s.tpl' % name
        
        configuration_component = ComponentManagerSynchronizer.get_configuration_component()
        self.http_start_time = configuration_component.http_start_time
    
    
    def __str__(self):
        return 'AbstractRoute:[ name:[%s], source_name:[%s], get_route:[%s],]' % (
            self.name,
            self.source_name,
            self.get_route(),
        )
    
    
    def __repr__(self):
        return self.__str__()
    
    
    @abstractmethod
    def controller(self):
        raise NotImplementedError()
    
    
    def get_route(self):
        url = '/sources/%s/%s' % (self.source_name, self.name)
        return quote(url.encode('utf-8')).replace('%', '__')
    
    
    def have_http_template(self):
        return self.have_http_template
    
    
    def get_template(self):
        return self.http_template
