#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.

from ..object.shinken_object import ShinkenObject
from ..constant import FRONT_HTML_FORMAT


class RadioListElement(ShinkenObject):
    def __init__(self, value, label='', extra_class=''):
        # type: (str, str, str)-> None
        super(RadioListElement, self).__init__()
        self.add_class('shinken-radio-btn')
        self._value = value
        self._label = label or self._value
        self.add_class(extra_class)
    
    
    # *****************************   GETTER SETTER  ************************************************************#
    def is_name(self, to_test):
        # type: (str)-> bool
        return self._value == to_test
    
    
    def get_value(self):
        # type: ()-> str
        return self._value
    
    
    def set_label(self, to_set):
        # type: (str)-> None
        self._label = to_set
    
    
    def get_label(self):
        # type: ()-> str
        return self._label
    
    
    # *****************************   HTML  ************************************************************#
    def get_html(self, class_to_add='', html_format=FRONT_HTML_FORMAT.NORMAL):
        # type: (str, str)-> str
        _extra_attribute = None if html_format == FRONT_HTML_FORMAT.NOT_EDITABLE else {'onclick': 'MANAGER.EventManager.clickOnRadioBtn(event)'}
        if html_format == FRONT_HTML_FORMAT.NOT_EDITABLE:
            class_to_add = "%s %s" % (class_to_add, 'shinken-not-editable')
        
        _to_return = ['''<td class="shinken-btn-cell shinken-btn-user-cell" %s >''' % self.tooltip.get_html(),
                      '''<button type="button" %s value="%s">''' % (self.get_object_tag_html(class_to_add=class_to_add, extra_attribute=_extra_attribute), self._value),
                      '''<span class="shinken-default-radio-button shinken-btn-label-user">%s</span>''' % self._label,
                      '''</button></td>''']
        return ''.join(_to_return)
