"use strict";
var PROPERTY = PROPERTY || {};
PROPERTY.CONST = PROPERTY.CONST || {
    NAME                           : {
        ACTIVE_CHECKS_ENABLED                                      : "active_checks_enabled",
        ACL_MAKE_DOWNTIME                                          : "acl_make_downtime",
        ACL_MAKE_ACKNOWLEDGE                                       : "acl_make_acknowledge",
        ACL_FORCE_RESULT_CHECK                                     : "acl_force_result_check",
        ACL_FORCE_RETRY_CHECK                                      : "acl_force_retry_check",
        ACL_IN_TAB_HISTORY                                         : "acl_in_tab_history",
        ACL_SHARE_EVERYBODY                                        : "acl_share_everybody",
        ACL_SHOW_HISTORY_RANGE                                     : "acl_show_history_range",
        ACL_SHOW_SLA_RANGE                                         : "acl_show_sla_range",
        ACL_TRY_CHECK_ON_SYNCHRONIZER                              : "acl_try_check_on_synchronizer",
        ACL_TRY_CHECK_ON_POLLER                                    : "acl_try_check_on_poller",
        ACL_CHANGE_ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW    : {
            NAME : "acl_change_element_visibility_on_not_authenticated_view",
            VALUE: {
                IS_ADMIN_SHINKEN: "is_admin_shinken"
            }
        },
        ADDRESS                                                    : "address",
        ADVANCED_TIME_PERIODS                                      : "advanced_time_periods",
        AUTHENTICATION_COOKIE_VALIDITY_DURATION                    : 'authentication_cookie_validity_duration', BP_RULE: "bp_rule",
        BUSINESS_IMPACT                                            : "business_impact",
        BUSINESS_IMPACT_MODULATIONS                                : "business_impact_modulations",
        BUSINESS_IMPACT_MODULATION_NAME                            : "business_impact_modulation_name",
        CAN_SUBMIT_COMMANDS                                        : "can_submit_commands",
        CHECK_COMMAND                                              : "check_command",
        CHECK_COMMAND_ARGS                                         : "check_command_args",
        CHECK_INTERVAL                                             : "check_interval",
        CHECK_FRESHNESS                                            : 'check_freshness',
        CHECK_PERIOD                                               : "check_period",
        CHECK_RUNNING_TIMEOUT                                      : "check_running_timeout",
        COMMAND_NAME                                               : "command_name",
        COMMAND_LINE                                               : "command_line",
        CONTACTS                                                   : "contacts",
        CONTACT_NAME                                               : "contact_name",
        CONTACT_GROUPS                                             : "contact_groups",
        CONTACTGROUP_NAME                                          : "contactgroup_name",
        CONTACTGROUPS                                              : "contactgroups",
        DEFAULT_VALUE                                              : "default_value",
        DEFINITION_ORDER                                           : "definition_order",
        DISPLAY_NAME                                               : "display_name",
        DEFAULT_SUBMIT_TO_STAGING                                  : "default_submit_to_staging",
        DOWNTIME_ON_DELETE_ELEMENT_API_PORT                        : "downtime_on_delete_element_api_port",
        DOWNTIME_ON_DELETE_ELEMENT_AUTHOR                          : "downtime_on_delete_element_author",
        DOWNTIME_ON_DELETE_ELEMENT_COMMENT                         : "downtime_on_delete_element_comment",
        DOWNTIME_ON_DELETE_ELEMENT_DURATION                        : "downtime_on_delete_element_duration",
        DUPLICATE_FOREACH_NAME                                     : "duplicate_foreach",
        ENABLED                                                    : "enabled",
        ESCALATIONS                                                : "escalations",
        ESCALATION_NAME                                            : "escalation_name",
        ESCALATION_OPTIONS                                         : "escalation_options",
        EDITION_CONTACTS                                           : "edition_contacts",
        EDITION_CONTACT_GROUPS                                     : "edition_contact_groups",
        EVENT_HANDLER_ENABLED                                      : "event_handler_enabled",
        EVENT_HANDLER                                              : "event_handler",
        ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW               : "element_visibility_on_not_authenticated_view",
        EXCLUDE                                                    : "exclude",
        FIRST_NOTIFICATION_DELAY                                   : "first_notification_delay",
        FIRST_NOTIFICATION_TIME                                    : "first_notification_time",
        FLAP_DETECTION_ENABLED                                     : "flap_detection_enabled",
        FLAP_DETECTION_OPTIONS                                     : "flap_detection_options",
        FRESHNESS_THRESHOLD                                        : "freshness_threshold",
        HOST_NAME                                                  : "host_name",
        HOST_NOTIFICATION_OPTIONS                                  : "host_notification_options",
        HOST_NOTIFICATION_PERIOD                                   : "host_notification_period",
        HOSTGROUPS                                                 : "hostgroups",
        HOSTGROUP_NAME                                             : "hostgroup_name",
        IP_RANGE                                                   : "iprange",
        IMPORT_INTERVAL                                            : "import_interval",
        IS_ADMIN                                                   : "is_admin",
        IS_CLUSTER                                                 : "is_cluster",
        IS_VOLATILE                                                : "is_volatile",
        LOW_FLAP_THRESHOLD                                         : "low_flap_threshold",
        LAST_NOTIFICATION_TIME                                     : "last_notification_time",
        HIGH_FLAP_THRESHOLD                                        : "high_flap_threshold",
        SLA_WARNING_THRESHOLD                                      : "sla_warning_threshold",
        SLA_CRITICAL_THRESHOLD                                     : "sla_critical_threshold",
        MACRO_MODULATIONS                                          : "macromodulations",
        MACROMODULATION_NAME                                       : "macromodulation_name",
        MAINTENANCE_PERIOD                                         : "maintenance_period",
        MAX_CHECK_ATTEMPTS                                         : "max_check_attempts",
        NAME                                                       : "name",
        VISUALISATION_NAME                                         : "visualisation_name",
        NOTE_URL                                                   : "notes_url",
        NOTE_MULTI_URL                                             : "notes_multi_url",
        NOTIFICATIONS_ENABLED                                      : "notifications_enabled",
        NOTIFICATION_PERIOD                                        : "notification_period",
        NOTIFICATIONWAY_NAME                                       : "notificationway_name",
        NOTIFICATIONWAYS                                           : "notificationways",
        PACK                                                       : "pack",
        PASSWORD                                                   : 'password',
        PASSIVE_CHECKS_ENABLED                                     : 'passive_checks_enabled',
        PERIOD_ADVANCED_NAME                                       : "period_advanced_type",
        PERIOD_DAY_NAME                                            : "period_day_type",
        POLLER_TAG                                                 : "poller_tag",
        PROCESS_PERF_DATA                                          : 'process_perf_data',
        PREFIX                                                     : "prefix",
        REACTIONNER_TAG                                            : "reactionner_tag",
        RESULTMODULATION_NAME                                      : "resultmodulation_name",
        RETRY_INTERVAL                                             : "retry_interval",
        NOTIFICATION_OPTIONS                                       : "notification_options",
        NOTIFICATION_CONTACTS                                      : "notification_contacts",
        NOTIFICATION_CONTACT_GROUPS                                : "notification_contact_groups",
        NOTIFICATION_INTERVAL                                      : "notification_interval",
        OUTPUT_RULES                                               : "output_rules",
        ORDER                                                      : "order",
        PARENTS                                                    : "parents",
        PORT_RANGE                                                 : "port_range",
        PUT_IN                                                     : "put_in",
        PUT_IN_USER                                                : "put_in_user",
        REALM                                                      : "realm",
        RESULT_MODULATIONS                                         : "resultmodulations",
        SERVICE_NOTIFICATION_OPTIONS                               : "service_notification_options",
        SERVICE_DESCRIPTION                                        : "service_description",
        SERVICE_EXCLUDES                                           : "service_excludes",
        SHELL_EXECUTION                                            : "shell_execution",
        SYNC_NAME                                                  : "sync_name",
        TIMEPERIOD_NAME                                            : "timeperiod_name",
        TEMPLATE_MEMBERS                                           : "template_members",
        THRESHOLDS_DISPLAY                                         : "thresholds_display",
        USER_RIGHTS_PROPERTY_PERMISSION_THRESHOLDS_DISPLAY_CAN_EDIT: "user__rights__property_permission__thresholds_display__can_edit",
        TIMEPERIODS                                                : "timeperiods",
        TIMEOUT                                                    : "timeout",
        USE                                                        : "use",
        VIEW_CONTACTS                                              : "view_contacts",
        VIEW_CONTACT_GROUPS                                        : "view_contact_groups",
        WARNING_THRESHOLD_CPU_USAGE                                : "warning_threshold_cpu_usage",
        TIMEPERIOD_DAYS                                            : {
            MONDAY   : "monday",
            TUESDAY  : "tuesday",
            WEDNESDAY: "wednesday",
            THURSDAY : "thursday",
            FRIDAY   : "friday",
            SATURDAY : "saturday",
            SUNDAY   : "sunday"
        },
        SYNCKEY_PREFIX                                             : "properties_used_as_synckey_for_"
    },
    TYPES                          : {
        BOOLEAN                   : "boolean",
        DATA                      : "data",
        MULTI_SELECT              : "select-multi",
        MULTI_SELECT_BASIC        : "select-multi-basic",
        RANGE                     : "range",
        RANGE_BUSINESS_IMPACT     : "range_business_impact",
        RANGE_WITH_INPUT          : "range_with_input",
        SINGLE_SELECT             : "select-single",
        SINGLE_SELECT_WITH_INPUT  : "select-single-with-input",
        STRING_INPUT              : "input_string",
        STRING_INPUT_WITH_RENDER  : "string_input_with_render",
        STRING_INPUT_WITH_DROPDOWN: "input-string-with-dropdown",
        CHECKBOX_SINGLE           : "checkbox-single",
        CHECKBOX_MULTI            : "checkbox-multi",
        RADIO_LIST                : "radio-list",
        RADIO_LIST_CUMULATIVE     : "radio-list-cumulative",
        MULTI_LINE_OBJECT         : "multi-line-object",
        PROPERTY_INFORMATION      : "property-information"
    },
    CLASS                          : {
        SKINKEN_LINE: "shinken-element-property-line"
    },
    DEFAULT_BUTTON_LABEL           : "default_button",
    SAME_AS_PARENT                 : "__SHINKEN__SAME_AS_PARENT__",
    BUTTON_LABEL                   : {
        DEFAULT          : "default_button",
        NULL             : "null_button",
        NO_OVERRIDE      : "no_override_button",
        USER_SET         : "user_set_button",
        COPY_TO_CLIPBOARD: "copy_to_clipboard_button",
        SET_DOM_EDITABLE : "set_dom_editable",
        INHERITANCE      : "inheritance_button",
        ADD              : "add_button",
        TARGET_URL       : "target_url_button",
        REMOVE           : "remove_button"
    },
    STATE_PROPERTY                 : {
        INHERITANCE_AND_USER          : "inheritance-and-user-and-plus",
        INHERITANCE                   : "inheritance-only",
        USER_SET                      : "user-set",
        USER_SET_NONE                 : "user-set-none",
        USER_FORCED_DEFAULT           : "user-default-forced",
        USER_SET_MASS_CHANGE_PLUS_ONLY: "user-set-mass-change-plus-only",
        OVERRIDE                      : "override-only",
        OVERRIDE_AND_PLUS             : "override-and-plus",
        OVERRIDE_FORCED_DEFAULT       : "override-default-forced"
    },
    STATE_PROBLEM_PROPERTY         : {
        NONE       : "none",
        HAS_ERROR  : "has_error",
        HAS_WARNING: "has_warning"
    },
    STATE_VALUE_PLUS               : {
        ON : "+",
        OFF: ""
    },
    STATE_IS_NULL_VALUE            : {
        TRUE : "1",
        FALSE: "0"
    },
    ACTIVE                         : {
        TRUE : "1",
        FALSE: "0"
    },
    MAX_SELECTABLE_ITEMS           : {
        RESULT_MODULATIONS: "4"
    },
    CUSTOM_SELECT                  : {
        PLUS_AND_INHERITANCE       : "__PLUS_AND_INHERITANCE__",
        PLUS_AND_OVERRIDE          : "__PLUS_AND_OVERRIDE__",
        NONE                       : "null",
        INHERITANCE                : "__INHERITANCE__",
        DEFAULT                    : "__DEFAULT_NO_TEMPLATE__",
        DEFAULT_FORCED             : "__DEFAULT_NO_TEMPLATE_FORCED__",
        DEFAULT_OR_INHERITANCE     : "__DEFAULT_OR_INHERITANCE__",
        NO_OVERRIDE                : "__NO_OVERRIDE__",
        ENTER_VALUE_FOR_MASS_CHANGE: "__ENTER_VALUE_FOR_MASS_CHANGE__",
        CONSISTENCY_VALUE          : "__CONSISTENCY_VALUE__"
    },
    DEFAULT_TO_LINK                : {
        "has_plus": false,
        "links"   : [{ "name": "__DEFAULT_NO_TEMPLATE__", "exists": false }]
    },
    NONE_TO_LINK                   : {
        "has_plus": false,
        "links"   : [{ "name": "null", "exists": false }]
    },
    DRAG_N_DROP                    : {
        TYPE: {
            SELECTED_ITEM: "selected-item"
        }
    },
    BOOLEAN                        : {
        STATE_INHERITANCE: {
            INHERITANCE: true,
            DEFAULT    : false
        }
    },
    DATA                           : {
        IDENTIFIER_DATA_LOCAL: "_",
        PROTECTED_PLACEHOLDER: "********",
        GROUP                : {
            LOCALE   : "local",
            INHERITED: "templates",
            DFE      : "foreach-dfe"
        },
        STATUS               : {
            NONE  : "",
            NEW   : "shinken-data-status-new",
            HIDDEN: "shinken-data-hidden"
        }
    },
    TIMEPERIOD                     : {
        SEPARATOR   : {
            RANGES  : ",",
            HOURS   : "-",
            HOUR_MIN: ":"
        },
        FORMAT_LABEL: {
            FULL : "full",
            RANGE: "range",
            HOUR : "hour"
        },
        NO_MONTH    : "None"
    },
    ACL_MULTI                      : {
        NAME: {
            READ    : "read",
            CREATE  : "create",
            ORGANIZE: "organize",
            MODIFY  : "modify",
            DELETE  : "delete",
            ALL     : "all"
        }
    },
    ACL_TYPE                       : {
        HISTORY_SLA: "history_sla",
        HISTORY    : "history",
        SLA        : "sla"
    },
    OVERRIDE                       : {
        SEPARATOR: {
            AFTER_NAME    : ", ",
            AFTER_PROPERTY: " ",
            BETWEEN       : "-=#=-"
        }
    },
    NOTES_URL                      : {
        SEPARATOR: {
            ENTRY    : "~#~",
            KEY_VALUE: "~="
        }
    },
    CHECK_COMMAND                  : {
        SEPARATOR: "!"
    },
    PROTECTED_STATUS               : {
        NONE              : 0,
        PROTECTED         : 1,
        PROTECTED_MODIFIED: 2
    },
    SELECTOR                       : {
        MAIN: "main-selector"
    },
    MASS_CHANGE                    : {
        ACTION      : {
            NONE                               : "NONE",
            ADD                                : "ADD",
            ADD_SYNCHRO                        : "ADD_SYNCHRO",
            ADD_CONSISTENCY                    : "ADD_CONSISTENCY",
            MOVE                               : "MOVE",
            EMPTY                              : "EMPTY",
            EMPTY_DATA                         : "EMPTY_DATA",
            EMPTY_DATA_OVERRIDE                : "EMPTY_DATA_OVERRIDE",
            FORCE_TO_DEFAULT                   : "FORCE_TO_DEFAULT",
            REPLACE                            : "REPLACE",
            REMOVE                             : "REMOVE",
            REMOVE_SYNCHRO                     : "REMOVE_SYNCHRO",
            REMOVE_ALL_EXCEPT                  : "REMOVE_ALL_EXCEPT",
            SET                                : "SET",
            SET_SYNCHRO                        : "SET_SYNCHRO",
            SET_OR_CREATE                      : "SET_OR_CREATE",
            SET_IF_DATA_EXISTS_ON_ITEM         : "SET_IF_DATA_EXISTS_ON_ITEM",
            SET_IF_DATA_EXISTS_ON_ITEM_OVERRIDE: "SET_IF_DATA_EXISTS_ON_ITEM_OVERRIDE",
            SET_IF_DATA_IS_SET_ON_ITEM         : "SET_IF_DATA_IS_SET_ON_ITEM",
            SET_IF_DATA_IS_SET_ON_ITEM_OVERRIDE: "SET_IF_DATA_IS_SET_ON_ITEM_OVERRIDE",
            SET_IF_EXIST                       : "SET_IF_EXIST"
        },
        ACTION_EXTRA: {
            NONE  : "NONE",
            LAST  : "LAST",
            FIRST : "FIRST",
            BEFORE: "BEFORE",
            AFTER : "AFTER"
        },
        PLUS_ACTION : {
            NONE: "NONE",
            OFF : "OFF",
            ON  : "ON"
        },
        SELECTOR    : {
            ACTION        : "mass_change_action",
            ACTION_EXTRA  : "mass_change_action_extra",
            ELEMENT_EXTRA : "mass_change_element_extra",
            ELEMENT_SINGLE: "mass_change_element_single",
            ACTION_PLUS   : "mass_change_plus_action"
        }
    },
    HIDDEN                         : "hidden",
    PROPERTY_INFORMATION_TAG       : "-information",
    NAME_IN_SOURCE                 : {
        COMPUTE_NEW_ELEMENT                   : "compute_new_element",
        COMPUTE_ELEMENT_DIFFERENCE            : "compute_element_difference",
        COMPUTE_DELETED_ELEMENT_NOT_IN_SOURCE : "compute_deleted_element_not_in_source",
        DOWNTIME_ON_DELETE_ELEMENT_ACTIVATED  : "downtime_on_delete_element_activated",
        DOWNTIME_ON_DELETE_ELEMENT_API_USE_SSL: "downtime_on_delete_element_api_use_ssl",
        MERGE_MODE                            : "merge_mode",
        PUT_IN                                : "put_in",
        VMWARE_SERVER_USE_SSL                 : "vmware_server_use_ssl"
    },
    MAPPING_PROPERTY_TO_MACRO_HOST : {
        "host_name"               : "$HOSTNAME$",
        "address"                 : "$HOSTADDRESS$",
        "visualisation_name"      : "$HOSTVISUALISATIONNAME$",
        "display_name"            : "$HOSTDISPLAYNAME$",
        "max_check_attempts"      : "$MAXHOSTATTEMPTS$",
        "hostgroups"              : "$HOSTGROUPNAME$",
        "check_command"           : "$HOSTCHECKCOMMAND$",
        "first_notification_delay": "$HOSTFIRSTNOTIFICATIONDELAY$",
        "notes_url"               : "$HOSTNOTESURL$",
        "notes_multi_url"         : "$HOSTNOTESMULTIURL$",
        "realm"                   : "$HOSTREALM$",
        "business_impact"         : "$HOSTBUSINESSIMPACT$"
    },
    MAPPING_PROPERTY_TO_MACRO_CHECK: {
        "service_description"     : "$SERVICEDESC$",
        "max_check_attempts"      : "$MAXSERVICEATTEMPTS$",
        "is_volatile"             : "$SERVICEISVOLATILE$",
        "hostgroup_name"          : "$SERVICEGROUPNAME$",
        "check_command"           : "$SERVICECHECKCOMMAND$",
        "notes_url"               : "$SERVICENOTESURL$",
        "notes_multi_url"         : "$SERVICENOTESMULTIURL$",
        "business_impact"         : "$SERVICEBUSINESSIMPACT$",
        "first_notification_delay": "$SERVICEFIRSTNOTIFICATIONDELAY$"
    }
};
PROPERTY.getTypeByName              = function ( property_name, shinken_element_type ) {
    switch ( property_name ) {
        case PROPERTY.CONST.NAME.CHECK_INTERVAL:
        case PROPERTY.CONST.NAME.CHECK_RUNNING_TIMEOUT:
        case PROPERTY.CONST.NAME.FIRST_NOTIFICATION_DELAY:
        case PROPERTY.CONST.NAME.FLAP_DETECTION_OPTIONS:
        case PROPERTY.CONST.NAME.FRESHNESS_THRESHOLD:
        case PROPERTY.CONST.NAME.MAX_CHECK_ATTEMPTS:
        case PROPERTY.CONST.NAME.NOTE_URL:
        case PROPERTY.CONST.NAME.NOTIFICATION_INTERVAL:
        case PROPERTY.CONST.NAME.NOTIFICATION_OPTIONS:
        case PROPERTY.CONST.NAME.RETRY_INTERVAL:
            return PROPERTY.CONST.TYPES.STRING_INPUT;
        case PROPERTY.CONST.NAME.THRESHOLDS_DISPLAY:
            return PROPERTY.CONST.TYPES.STRING_INPUT_WITH_RENDER;
        case PROPERTY.CONST.NAME.CHECK_PERIOD:
        case PROPERTY.CONST.NAME.MAINTENANCE_PERIOD:
        case PROPERTY.CONST.NAME.NOTIFICATION_PERIOD:
            return PROPERTY.CONST.TYPES.SINGLE_SELECT;
        case PROPERTY.CONST.NAME.USE:
        case PROPERTY.CONST.NAME.VIEW_CONTACTS:
        case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
        case PROPERTY.CONST.NAME.EDITION_CONTACTS:
        case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
        case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
        case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
        case PROPERTY.CONST.NAME.BUSINESS_IMPACT_MODULATIONS:
        case PROPERTY.CONST.NAME.CONTACTS:
        case PROPERTY.CONST.NAME.CONTACT_GROUPS:
        case PROPERTY.CONST.NAME.ESCALATIONS:
        case PROPERTY.CONST.NAME.MACRO_MODULATIONS:
        case PROPERTY.CONST.NAME.RESULT_MODULATIONS:
        case PROPERTY.CONST.NAME.PARENTS:
        case PROPERTY.CONST.NAME.NOTIFICATIONWAYS:
        case PROPERTY.CONST.NAME.CONTACTGROUPS:
        case PROPERTY.CONST.NAME.HOSTGROUPS:
            return PROPERTY.CONST.TYPES.MULTI_SELECT;
        case PROPERTY.CONST.NAME.HOST_NAME:
            switch ( shinken_element_type ) {
                case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
                case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
                    return PROPERTY.CONST.TYPES.MULTI_SELECT;
                case OBJECT.CONST.ELEMENT.TYPES.CHECK_ON_TPL_HOST:
                case OBJECT.CONST.ELEMENT.TYPES.CHECK_ON_TPL_CLUSTER:
                    return PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN;
                default:
                    return PROPERTY.CONST.TYPES.STRING_INPUT;
            }
        case PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD:
        case PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD:
            return PROPERTY.CONST.TYPES.RANGE;
        case PROPERTY.CONST.NAME.SLA_CRITICAL_THRESHOLD:
        case PROPERTY.CONST.NAME.SLA_WARNING_THRESHOLD:
            return PROPERTY.CONST.TYPES.RANGE_WITH_INPUT;
        case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
            return PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT;
        default:
            if ( SHINKEN.TOOLS.STRING.startsWith( property_name, PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL ) ) {
                return PROPERTY.CONST.TYPES.DATA;
            }
            return "";
        
    }
    
};
PROPERTY.getPropertyInformationName = function ( property_name ) {
    return property_name + PROPERTY.CONST.PROPERTY_INFORMATION_TAG;
};
var SOURCE = {};
SOURCE.CONST = {
    ASK_IMPORT   : {
        NONE     : 0,
        ASKED    : 1,
        CONFIRMED: 2
    },
    VIEW_TYPES   : {
        DETAIL: 0,
        ALL   : 1
    },
    TYPES        : {
        ALL      : 'all',
        COLLECTOR: 'collector',
        LISTENER : 'listener',
        ANALYZER : 'analyzer'
    },
    FIELD        : {
        NAME               : 'source_name',
        TYPE               : 'type',
        ORDER              : 'order',
        STATE              : 'state',
        ENABLED            : 'enabled',
        NEXT_IMPORT        : 'next_import',
        NB_ELEMENTS_OK     : 'nb_elements_ok',
        NB_ELEMENTS_WARNING: 'nb_elements_warning',
        NB_ELEMENTS_ERROR  : 'nb_elements_error',
        OUTPUT             : 'output',
        LAST_IMPORT        : 'last_import',
        LAST_IMPORT_HTML   : 'last_import_html',
        NEXT_IMPORT_HTML   : 'next_import_html',
        IMPORT_INTERVAL    : 'import_interval',
        IMPORT_ENABLED     : 'import_enabled',
        ALREADY_IMPORT     : 'already_import',
        IP_RANGES          : 'ip_range',
        MODULE_TYPE        : 'module_type',
        FULLY_MERGED       : 'fully_merged'
    },
    STATE        : {
        OK                          : 'OK',
        PENDING                     : 'PENDING',
        WARNING                     : 'WARNING ',
        CRITICAL                    : 'CRITICAL',
        RUNNING                     : 'RUNNING',
        NOT_CONFIGURED              : 'not-configured',
        NOT_CONFIGURED_BEFORE_IMPORT: 'not-configured-before-import',
        IN_PROGRESS                 : 'difference-computing',
        NEVER_IMPORT                : 'never-import',
        READY_FOR_IMPORT            : 'ready-for-import',
        CONFIGURATION_ERROR         : 'CONFIGURATION_ERROR',
        NEED_CONFIRMATION           : 'need-confirmation'
    },
    RANGE        : {
        ID         : '_id',
        NAME       : 'discovery_name',
        STATE      : 'state',
        ENABLED    : 'discovery_enabled',
        DESCRIPTION: 'notes',
        IP_RANGE   : 'iprange',
        SOURCE_NAME: 'source_name'
    },
    CONFIGURATION: {
        INVALID_ORDER: 'INVALID_ORDER'
    }
};
