"use strict";
var WEATHER          = {};
WEATHER.CONST        = {
    DEFAULT_VALUE : "default",
    PARAM         : {
        PAGE: {
            EXTERNAL_LINKS : "external_links",
            NOTIFICATIONS  : {
                _KEY  : "notifications",
                SOUND : {
                    _KEY: "sound"
                },
                VISUAL: {
                    _KEY : "visual",
                    BLINK: {
                        _KEY: "blink"
                    }
                },
                COMMON: {
                    ENABLED: "enabled"
                }
            },
            TYPE           : "type",
            WEATHER_UUID   : "weather_uuid",
            USERS          : {
                _KEY               : "users",
                COMMON             : {
                    USER_NAME: "user_name",
                    USER_UUID: "user_uuid"
                },
                OWNER_USER         : "owner_user",
                PREVIOUS_OWNER_USER: "previous_owner_user",
                CREATOR_USER       : "creator_user"
            },
            WEATHER_VERSION: "weather_version"
        }
    },
    DOM_ELEMENT   : {
        EXTERNAL_LINKS_CONTAINER              : "external_links_container",
        BTN_EXTERNAL_LINKS_CONTAINER          : "btn_external_links_container",
        EDIT_MODE_BTN_EXTERNAL_LINKS_CONTAINER: "edit_mode_btn_external_links_container"
    },
    EXTERNAL_LINKS: {
        PARAMS: {
            DEFAULT_LINK                       : "default_link",
            DEFAULT_LINKS_BASE_URL             : "links__default_base_url",
            DEFAULT_LINKS_EXTERNAL_PART_URL    : "links__default_external_part_url",
            DEFAULT_LINKS_INFO_BAR             : "links__default_info_bar",
            DEFAULT_LINKS_AUTHENTICATION_NEEDED: "links__default_authentication_needed",
            DEFAULT_LINKS_LINK_PROTOCOL        : "links__default_link_protocol",
            LINKS                              : "links",
            LINK_NAME                          : "link_name",
            LINK_UUID                          : "link_uuid",
            LINK_BASE_URL                      : "link_base_url",
            LINK_EXTERNAL_PART_URL             : "link_external_part_url",
            AUTHENTICATION_NEEDED              : "authentication_needed",
            LINK_PROTOCOL                      : "link_protocol",
            INFO_BAR                           : "info_bar",
            NOTIFICATIONS                      : "notifications"
        }
    },
    
    WINDOWS_TABS_EDITION_MESSAGE: {
        TABS     : [
            {
                name: "general"
            },
            {
                name: "widget"
            }
        ],
        INDEX_TAB: {
            GENERAL: 0,
            WIDGET : 1
        }
    },
    WINDOWS_TABS_EDIT_PART      : {
        TABS     : [
            {
                name     : "edit_tab_visual",
                is_active: true
            },
            {
                name: "edit_tab_json"
            },
            {
                name: "edit_tab_history"
            }
        ],
        INDEX_TAB: {
            VISUAL : 0,
            JSON   : 1,
            HISTORY: 2
        }
    },
    CONFIGURATION_ID_IS_OUTDATED: "configuration_id_is_outdated",
    COMPONENT                   : {
        SVG: {
            RADIO_ICON: "", //INIT DYNAMIC
            SUN       : "", //INIT DYNAMIC
            SEPARATOR : "", //INIT DYNAMIC
            UNKNOWN   : "" //INIT DYNAMIC
        }
    },
    STEP                        : {
        JS_JSON_VERIFICATION     : 1,
        CALL_BACKEND_VERIFICATION: 2,
        BACKEND_RETURN_TREATMENT : 3,
        END                      : 4
    }
};
var EXTERNAL_LINKS   = {};
EXTERNAL_LINKS.CONST = {
    EXTERNAL_LINK: {
        ENUM: {
            LINK_PROTOCOL: {
                HTTP      : "http",
                HTTPS     : "https",
                FROM_WEBUI: "protocol_from_webui"
            }
        }
    }
};
WEATHER.ViewHistory           = function ( name, pagination ) {
    this.init( name, pagination );
};
WEATHER.ViewHistory.prototype = {
    init        : SHINKEN.OBJECT.ViewHistory.prototype.init,
    initSpecific: function ( parent, dom_element_target, avoid_load_last_modification ) {
        this.parent = parent;
        this.initList();
        this.dom_element_parent__20240822 = dom_element_target;
        this.getDataFromBackend__20241001();
        if ( parent.last_modifications && !avoid_load_last_modification ) {
            this.addDoActionAfterCallBackPhaseIs( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING, "load_last_modifications", { modifications_objects_until_init: parent.last_modifications.contents } );
        }
    },
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "redo_last_modification":
            case "add_last_modification":
                this._updateLastModifications( "add", param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ] );
                break;
            case "load_last_modifications":
                for ( let i = 0, _size_i = param[ "modifications_objects_until_init" ].length; i < _size_i; i++ ) {
                    this._updateLastModifications( "add", param[ "modifications_objects_until_init" ][ i ] );
                }
                break;
            case "undo_last_modification":
                this._updateLastModifications( "remove" );
                break;
            case "clear_all_last_modifications":
                this._updateLastModifications( "clear", param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.NUMBER ] );
                break;
        }
        this.doActionAfterCommon( event_name, param );
    },
    _updateLastModifications: function ( type_action, data ) {
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.INIT ) ) {
            return;
        }
        DOM.Service.removeElement( this.getList__20240822().getDomElement() );
        switch ( type_action ) {
            case "add":
                this.getList__20240822().addLineWithData( this.parseLastModificationDataLine( data ), 0 );
                break;
            case "remove":
                this.getList__20240822().getLines().removeContentByIndex( 0 );
                break;
            case "clear":
                this.getList__20240822().getLines().removeFirstXContent( data );
                break;
        }
        this.computeHtml();
        DOM.Service.addElementTo( this.getList__20240822().getDomElement(), this.dom_element_parent__20240822 );
    },
    getBackendUrl: function () {
        return SHINKEN.HIGHWAY.getOrigin() + "/service-weather/api/V1/get-history/" + this.getName();
    },
    parseLastModificationDataLine: function ( data ) {
        return this.parseLastModificationDataLineGrid( data );
    },
    parseBackendDataLine: function ( data ) {
        return this.parseBackendDataLineGrid( data );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.ViewHistory, SHINKEN_GRID.ViewHistory );
WEATHER.ExternalLinkLayout = function ( data ) {
    this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
    this.init( data );
    _load_extra_lang_obj( "weather_lang" );
};
WEATHER.ExternalLinkLayout.prototype = {
    init                       : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.init,
    _getValidOwnProperty       : function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_PROTOCOL, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, SHINKEN.TOOLS.ARRAY.parseToArray( EXTERNAL_LINKS.CONST.EXTERNAL_LINK.ENUM.LINK_PROTOCOL, WEATHER.CONST.DEFAULT_VALUE )],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_BASE_URL, SHINKEN_VALIDATION.CONST.STRING.DONT_HAVE_FORBIDDEN, ["\"", "'", " "]],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_EXTERNAL_PART_URL, SHINKEN_VALIDATION.CONST.STRING.DONT_HAVE_FORBIDDEN, ["\"", "'", "/", " "]],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.AUTHENTICATION_NEEDED, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY]
        ] );
    },
    _getValidOwnChildren       : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.INFO_BAR, "SHINKEN_PAGE.InfoBar"],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.NOTIFICATIONS, "WEATHER.Notifications"]
        ] );
    },
    getValueForTooltip         : function ( key ) {
        switch ( key ) {
            case WEATHER.CONST.EXTERNAL_LINKS.PARAMS.AUTHENTICATION_NEEDED:
                return this.getBooleanValue( key ) ? _( "external_link_tooltip.activated", ["weather_lang"] ) : _( "external_link_tooltip.disabled", ["weather_lang"] );
            case SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.LOGO_DISPLAYED:
                return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.INFO_BAR ).getBooleanValue( key ) ? _( "external_link_tooltip.activated", ["weather_lang"] ) : _( "external_link_tooltip.disabled", ["weather_lang"] );
            case SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.CHRONO_DISPLAYED:
            case SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.GENERATION_TIME_DISPLAYED:
                return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.INFO_BAR ).getChild( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.REFRESH )
                           .getBooleanValue( key ) ? _( "external_link_tooltip.activated", ["weather_lang"] ) : _( "external_link_tooltip.disabled", ["weather_lang"] );
            case WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.SOUND._KEY :
                return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.NOTIFICATIONS ).getChild( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.SOUND._KEY )
                           .getBooleanValue( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.COMMON.ENABLED ) ? _( "external_link_tooltip.activated", ["weather_lang"] ) : _( "external_link_tooltip.disabled", ["weather_lang"] );
            case WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY:
                return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.NOTIFICATIONS ).getChild( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL._KEY ).getChild( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY )
                           .getBooleanValue( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.COMMON.ENABLED ) ? _( "external_link_tooltip.activated", ["weather_lang"] ) : _( "external_link_tooltip.disabled", ["weather_lang"] );
            case SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.POSITION:
                return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.INFO_BAR )
                           .getValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.POSITION ) === SHINKEN_PAGE.CONST.INFO_BAR.VALUES.POSITION_BOTTOM ? _( "external_link_tooltip.bottom", ["weather_lang"] ) : _( "external_link_tooltip.top", ["weather_lang"] );
            default:
                return this.getValue( key );
        }
    },
    getComputeHostUrl          : function () {
        let _host = SHINKEN.HIGHWAY.getHost();
        if ( SHINKEN.HIGHWAY.isDocumentationOn() ) {
            return "<span class='shinken-sensible'>" + _host + "</span>";
        }
        return _host;
    },
    computeUrl                 : function () {
        let _base_url     = this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_BASE_URL );
        this.computed_url = [
            this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_PROTOCOL ) + ":/",
            _base_url || this.getComputeHostUrl(),
            COMMUNICATION.QUERY.GET.SERVICE_WEATHER.WEATHER_SPACE,
            this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_EXTERNAL_PART_URL ),
            this.weather_uuid,
            this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_UUID )
        ].join( "/" );
    },
    getComputedUrl             : function () {
        if ( !this.computed_url ) {
            this.computeUrl();
        }
        return this.computed_url;
    },
    openLinkInNewTab           : function () {
        SHINKEN.HIGHWAY.goToBlank( this.getComputedUrl() );
    },
    copyLinkToClipboard        : function ( dom_button ) {
        CLIPBOARD_SERVICE.setContent( dom_button, this.getComputedUrl(), this.copyLinkToClipboardCallback );
    },
    copyLinkToClipboardCallback: function ( status, dom_button ) {
        let _text     = status ? _( "copy_service.copyExternalLinkSuccess", [ DICTIONARY_COMMON_UI ] ) : _( "copy_service.copyFail", [ DICTIONARY_COMMON_UI ] );
        let _state    = status ? SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_SUCCESS : SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_FAILED;
        let _position = status ? SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_SUCCESS : SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_FAILED;
        SHINKEN.TOOLS.NOTIFICATION.addNotification( _text, _state, dom_button, _position, 2000 );
    },
    buildTooltip               : function () {
        let to_return = document.querySelector( "#id-shinken-template-view .shinken-external-link-tooltip-template" ).innerHTML;
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_auth_needed_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.AUTHENTICATION_NEEDED ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_name_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_NAME ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_uuid_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_UUID ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_external_part_url_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_EXTERNAL_PART_URL ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_auth_needed_attribute_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.AUTHENTICATION_NEEDED ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_protocol_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_PROTOCOL ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_position_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.POSITION ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_background_color_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.INFO_BAR )
                                                                                                                                                           .getValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.BACKGROUND_COLOR ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_logo_displayed_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.LOGO_DISPLAYED ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_chrono_displayed_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.CHRONO_DISPLAYED ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_generated_time_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.GENERATION_TIME_DISPLAYED ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_sound_notification_enable_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.SOUND._KEY ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_blink_notification_enable_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_external_url$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getComputedUrl() ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, '"', "&quot;" );
        return to_return;
    },
    buildHtml                  : function ( weather_uuid ) {
        this.weather_uuid = weather_uuid;
        this.computeUrl();
        let to_return = document.querySelector( "#id-shinken-template-view .shinken-external-link-table-template .shinken-external-link-row" ).outerHTML;
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_uuid_$$$", this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_UUID ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_name_$$$", SHINKEN.TOOLS.STRING.cleanXss( this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_NAME ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_tooltip_$$$", this.buildTooltip() );
        return to_return;
    },
    getUUID: function () {
        return this.uuid;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.ExternalLinkLayout, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
WEATHER.ExternalLink = function ( data ) {
    this.initSpecific( data );
};
WEATHER.ExternalLink.prototype = {
    initSpecific: function ( data ) {
        this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
        this.init( data );
        _load_extra_lang_obj( "weather_lang" );
    },
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_NAME, SHINKEN_VALIDATION.CONST.STRING.NOT_EMPTY, undefined, true],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_UUID],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_PROTOCOL, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, SHINKEN.TOOLS.ARRAY.parseToArray( EXTERNAL_LINKS.CONST.EXTERNAL_LINK.ENUM.LINK_PROTOCOL, WEATHER.CONST.DEFAULT_VALUE )],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_BASE_URL, SHINKEN_VALIDATION.CONST.STRING.DONT_HAVE_FORBIDDEN, ["\"", "'", " "]],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_EXTERNAL_PART_URL, SHINKEN_VALIDATION.CONST.STRING.DONT_HAVE_FORBIDDEN, ["\"", "'", "/", " "]],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.AUTHENTICATION_NEEDED, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.ExternalLink, WEATHER.ExternalLinkLayout );
WEATHER.ExternalLinks = function ( data ) {
    this.init( data );
};
WEATHER.ExternalLinks.prototype = {
    init: function ( data ) {
        this.initInternal();
        this.initCounterCommon();
        this.initContents();
        this.updateData( data );
    },
    getChildrenObject    : function () {
        return this.getContents();
    },
    getChildrenObjectDict: function () {
        return this.getContents();
    },
    hasLinks           : function () {
        return !!this.getSize();
    },
    getLinkByUuid      : function ( uuid ) {
        var _current;
        for ( var i = 0, _size = this.getSize(); i < _size; i++ ) {
            _current = this.getContent( i );
            if ( uuid === _current.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_UUID ) ) {
                return _current;
            }
        }
        return null;
    },
    getChildConstructor: function ( data ) {
        return new WEATHER.ExternalLink( data );
    },
    updateData: SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.updateData,
    reset     : function () {
        this.initContents();
        DOM.Service.removeElement( this.getDomElement() );
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case "list_content":
                for ( var i = 0, _size_i = value.length; i < _size_i; i++ ) {
                    this.add( this.getChildConstructor( value[ i ] ) );
                }
                break;
            default:
                this.setDataAsUnknownProperty( key, value );
                break;
        }
    },
    getDataToSave: function () {
        var _to_return = [];
        for ( let i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _to_return.push( this.contents[ i ].getDataToSave() );
        }
        return _to_return;
    },
    buildHtml   : function ( weather_uuid ) {
        var _to_return = '';
        for ( var i = 0, _size = this.getSize(); i < _size; i++ ) {
            _to_return += this.getContent( i ).buildHtml( weather_uuid );
        }
        return _to_return;
    },
    initMessages: SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.initMessages
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.ExternalLinks, SHINKEN.OBJECT.ShinkenObjectContainer );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.ExternalLinks, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
WEATHER.Notifications           = function ( data ) {
    this.init( data );
};
WEATHER.Notifications.prototype = {
    _getValidOwnChildren   : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.SOUND._KEY, "WEATHER.SoundNotification" ],
            [ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL._KEY, "WEATHER.VisualNotifications" ]
        ] );
    },
    getSoundNotification   : function () {
        return this[ WEATHER.CONST.NOTIFICATION.PARAMS.SOUND ];
    },
    getVisualNotifications : function () {
        return this[ WEATHER.CONST.NOTIFICATION.PARAMS.VISUAL ];
    },
    hasNotificationsEnabled: function () {
        if ( this.getSoundNotification() && this.getSoundNotification().hasNotificationEnabled() ) {
            return true;
        }
        if ( this.getVisualNotifications() && this.getVisualNotifications().hasNotificationsEnabled() ) {
            return true;
        }
        return false;
    },
    playNotifications      : function ( notifications_of_change ) {
        var _sizeData = notifications_of_change.length;
        if ( _sizeData === 0 ) {
            return;
        }
        if ( this.getSoundNotification() && this.getSoundNotification().hasNotificationEnabled() ) {
            this.getSoundNotification().playNotification();
        }
        this.playVisualNotifications( notifications_of_change );
    },
    playVisualNotifications: function ( notifications_of_change ) {
        var _sizeData = notifications_of_change.length;
        if ( this.getVisualNotifications() && this.getVisualNotifications().hasNotificationsEnabled() ) {
            for ( var i = 0; i < _sizeData; i++ ) {
                this.getVisualNotifications().playNotification( notifications_of_change[ i ] );
            }
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Notifications, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
WEATHER.NotificationInterface           = function ( data ) {
    this.init( data );
};
WEATHER.NotificationInterface.prototype = {
    _getValidOwnProperty  : function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.COMMON.ENABLED, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY]
        ] );
    },
    hasNotificationEnabled: function () {
        return this[ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.COMMON.ENABLED ].getValue();
    },
    playNotification: function ( notification_of_change ) {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.NotificationInterface, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
WEATHER.SoundNotification           = function ( data ) {
    this.init( data );
};
WEATHER.SoundNotification.prototype = {
    setVolume       : function ( volume ) {
        this.getAudio().volume = volume;
    },
    playNotification: function () {
        var play_promise = this.getAudio().play();
    },
    getAudio        : function () {
        if ( !this.audio ) {
            this.audio = new Audio( "/static/" + __SHINKEN_HTTP_START_TIME__ + "/service_weather/sound/notification_of_change.mp3" );
        }
        return this.audio;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.SoundNotification, WEATHER.NotificationInterface );
WEATHER.BlinkVisualNotification           = function ( data ) {
    this.init( data );
};
WEATHER.BlinkVisualNotification.prototype = {
    playNotification: function ( notification_of_change ) {
        notification_of_change.getObjectThatChanged().blink( 3 );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.BlinkVisualNotification, WEATHER.NotificationInterface );
WEATHER.VisualNotifications           = function ( data ) {
    this.init( data );
};
WEATHER.VisualNotifications.prototype = {
    _getValidOwnChildren   : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY, "WEATHER.BlinkVisualNotification"]
        ] );
    },
    hasNotificationsEnabled: function () {
        if ( this[ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ] && this[ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ].hasNotificationEnabled() ) {
            return true;
        }
        return false;
    },
    playNotification: function ( notification_of_change ) {
        if ( this[ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ] && this[ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ].hasNotificationEnabled() ) {
            this[ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ].playNotification( notification_of_change );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.VisualNotifications, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
