"use strict";
var SHINKEN     = SHINKEN || {};
SHINKEN.UI      = SHINKEN.UI || {};
SHINKEN.UI.VIEW = SHINKEN.UI.VIEW || {
    VISIBILITY_RESTRICTION   : {
        HAS_EDITABLE_RIGHT: "has_editable_right",
        NONE              : null
    },
    TYPE                     : {
        WEATHER: "service_weather"
    },
    WINDOWS_PANEL_TABS       : [
        {
            name           : "views",
            controller_name: CONTROLLER.CONST.UI_PANELS_VIEW.NAME,
            is_active      : true
        }
    ],
    WINDOWS_VIEW_MANAGER_TABS: [
        {
            name           : "weather_service",
            controller_name: CONTROLLER.CONST.UI_VIEW_WEATHER_MANAGER.NAME,
            is_active      : true
        }
    ],
    ACTIONS                  : {
        CLONE_VIEW   : "clone_view",
        CHANGE_OWNER : "change_owner",
        REMOVE       : "remove",
        REMOVE_FORCED: "remove_forever",
        RESTORED     : "restore_view",
        ERRORS       : {
            USER_NOT_FOUND       : "user_not_found",
            WEATHER_NOT_FOUND    : "weather_not_found",
            CANNOT_PERFORM_ACTION: "cannot_perform_action",
            USER_RENAMED         : "user_has_been_renamed"
        }
    }
};
SHINKEN.UI.VIEW.WEATHER = SHINKEN.UI.VIEW.WEATHER || {
    TRAD_CONTAINER: "views.manager.service_weather",
    TABS          : {
        ADMINISTRATION: {
            _KEY                : "window-ui-panel-weather-administration",
            LABEL_TRAD_CONTAINER: "views.manager.service_weather.window.administration",
            HEADERS             : {
                CANCEL_ORDERS_IN_FORM: {
                    _KEY          : "cancel_orders_in_form",
                    INDEX_COLUMN  : 0,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY
                    }
                },
                SHARES               : {
                    _KEY          : "nb_shared_links",
                    INDEX_COLUMN  : 1,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY
                    }
                },
                NAME                 : {
                    _KEY        : "name",
                    INDEX_COLUMN: 2,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
                },
                PROBLEMS             : {
                    _KEY          : "weather_problems",
                    INDEX_COLUMN  : 3,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY
                    }
                },
                CURRENT_OWNER        : {
                    _KEY        : "current_owner",
                    INDEX_COLUMN: 4,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
                },
                PREVIOUS_OWNER       : {
                    _KEY        : "previous_owner",
                    INDEX_COLUMN: 5,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
                },
                CREATOR              : {
                    _KEY        : "creator",
                    INDEX_COLUMN: 6,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
                },
                EXTERNAL_LINKS       : {
                    _KEY          : "external_links",
                    INDEX_COLUMN  : 7,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY
                    }
                },
                NOTIFICATIONS        : {
                    _KEY          : "notifications",
                    INDEX_COLUMN  : 8,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY,
                        VISUAL : SHINKEN_LIST.CONST.FILTER.VISUAL,
                        AUDIO  : SHINKEN_LIST.CONST.FILTER.AUDIO
                    }
                },
                VIEW_BEHAVIOUR       : {
                    _KEY          : "view_behaviour",
                    INDEX_COLUMN  : 9,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL     : SHINKEN_LIST.CONST.FILTER.ALL,
                        RUNNING : SHINKEN_LIST.CONST.FILTER.VIEW_BEHAVIOUR.RUNNING,
                        DRAFT   : SHINKEN_LIST.CONST.FILTER.VIEW_BEHAVIOUR.DRAFT,
                        CREATING: SHINKEN_LIST.CONST.FILTER.VIEW_BEHAVIOUR.CREATING
                    }
                },
                ACTION               : {
                    _KEY        : "action",
                    INDEX_COLUMN: 10,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.HIDDEN
                }
            }
        },
        RUNNING       : {
            _KEY                : "window-ui-panel-weather-running",
            LABEL_TRAD_CONTAINER: "views.manager.service_weather.window.running",
            HEADERS             : {
                SHARES        : {
                    _KEY          : "nb_shared_links",
                    INDEX_COLUMN  : 1,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY
                    }
                },
                NAME          : {
                    _KEY        : "name",
                    INDEX_COLUMN: 2,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
                },
                CURRENT_OWNER : {
                    _KEY        : "current_owner",
                    INDEX_COLUMN: 4,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
                },
                EXTERNAL_LINKS: {
                    _KEY          : "external_links",
                    INDEX_COLUMN  : 7,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY
                    }
                },
                NOTIFICATIONS : {
                    _KEY          : "notifications",
                    INDEX_COLUMN  : 8,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY,
                        VISUAL : SHINKEN_LIST.CONST.FILTER.VISUAL,
                        AUDIO  : SHINKEN_LIST.CONST.FILTER.AUDIO
                    }
                }
            }
        },
        DELETING      : {
            _KEY                : "window-ui-panel-weather-deleting",
            LABEL_TRAD_CONTAINER: "views.manager.service_weather.window.deleting",
            HEADERS             : {
                CANCEL_ORDERS_IN_FORM: {
                    _KEY          : "cancel_orders_in_form",
                    INDEX_COLUMN  : 0,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY
                    }
                },
                NAME                 : {
                    _KEY        : "name",
                    INDEX_COLUMN: 2,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
                },
                DELETING_TIME        : {
                    _KEY        : "deleting_time",
                    INDEX_COLUMN: 3,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
                },
                CURRENT_OWNER        : {
                    _KEY        : "current_owner",
                    INDEX_COLUMN: 4,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
                },
                CREATOR              : {
                    _KEY        : "creator",
                    INDEX_COLUMN: 6,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
                },
                EXTERNAL_LINKS       : {
                    _KEY          : "external_links",
                    INDEX_COLUMN  : 7,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY
                    }
                },
                NOTIFICATIONS        : {
                    _KEY          : "notifications",
                    INDEX_COLUMN  : 8,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY,
                        VISUAL : SHINKEN_LIST.CONST.FILTER.VISUAL,
                        AUDIO  : SHINKEN_LIST.CONST.FILTER.AUDIO
                    }
                },
                SHARES               : {
                    _KEY          : "nb_shared_links",
                    INDEX_COLUMN  : 9,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY
                    }
                },
                ACTION               : {
                    _KEY        : "action",
                    INDEX_COLUMN: 10,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.HIDDEN
                }
            }
        }
    }
};
var EXTERNAL_LINKS   = {};
EXTERNAL_LINKS.CONST = {
    EXTERNAL_LINK: {
        ENUM: {
            LINK_PROTOCOL: {
                HTTP      : "http",
                HTTPS     : "https",
                FROM_WEBUI: "protocol_from_webui"
            }
        }
    }
};
SHINKEN.UI.ADD_TO_FAVORITE = {
    FORM_NAME : "add-favorite-form",
    PROPERTIES: {
        DICTIONARY_SPOT                         : "favorites.add_to_favorite.form.property.",
        DICTIONARY_SPACE_SHARES_NAMES           : "favorites.space_share.names.",
        DICTIONARY_SPACE_SHARES_NAMES_WITH_ICONS: "favorites.space_share.names_with_icons.",
        NAME                                    : {
            _KEY: "name"
        },
        SPACE_SHARE                             : {
            _KEY: "space_share"
        },
        GROUP_SHARE                             : {
            _KEY: "group_share"
        },
        FOLDER_SHARE                            : {
            _KEY  : "folder_share",
            OPTION: {
                NONE: "___NONE___"
            }
        },
        SEPARATOR_SHARE                         : {
            _KEY: "folder_share"
        },
        TYPE_OF_FAVORITE                        : {
            _KEY: "type_of_favorite"
        }
    }
};
SHINKEN.UI.AddToFavoriteFormSet           = function ( name ) {
    this.initSpecific( name );
};
SHINKEN.UI.AddToFavoriteFormSet.prototype = {
    initSpecific: function ( name ) {
        this.init( name );
        this.toAddSpecific( new PROPERTY.StringInputFromData_V3( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.NAME._KEY ) );
        this.toAddSpecific( new PROPERTY.RadioListFromData_V3( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY, this.getDataForPropertySpaceShare() ) );
        this.toAddSpecific( new PROPERTY.SingleSelectFromData_V3( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.GROUP_SHARE._KEY, this.getDataForPropertyGroupShare() ) );
        this.toAddSpecific( new PROPERTY.SingleSelectFromData_V3( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.FOLDER_SHARE._KEY ) );
        this.toAddSpecific( new PROPERTY.StringInputFromData_V3( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.TYPE_OF_FAVORITE._KEY ) );
        this.setController__20241003( CONTROLLER.NavigationBar );
    },
    initFinal   : function ( window_name ) {
        this.doActionAfter( "click_on__window_navigation__done", { [ WINDOW_V2.CONST.PARAM.WINDOW_NAME ]: window_name } );
        this.doActionAfter( "compute_property_folder_share_content" );
        this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.TYPE_OF_FAVORITE._KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
    },
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "do_action_after_init_dom_element":
                return;
            case "load_shares_data_from_angular":
                this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.FOLDER_SHARE._KEY ).changeOptionsFromArray( this.getFolderOptions() );
                return;
            case "close_all_element":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                break;
            case "click_on__window_navigation__done":
                this.window_name = param[ WINDOW_V2.CONST.PARAM.WINDOW_NAME ];
                this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.TYPE_OF_FAVORITE._KEY ).setValueFromUser( this.window_name );
                this.doActionAfter( "compute_property_name", param );
                this.doActionAfter( "compute_property_space_share", param );
                this.doActionAfter( "compute_property_group_share" );
                this.doActionAfter( "compute_property_folder_share_content" );
                this.doActionAfter( "compute_label_help", param );
                break;
            case "compute_property_name":
                switch ( param[ WINDOW_V2.CONST.PARAM.WINDOW_NAME ] ) {
                    case WINDOW.ADD_TO_FAVORITE.TABS[ WINDOW.ADD_TO_FAVORITE.INDEX_TAB.CREATE_LINK ].name:
                        this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.NAME._KEY ).setValueFromUser( CONTROLLER.UiVisualisation.current_view.getName() );
                        this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.NAME._KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.LOCKED );
                        break;
                    case WINDOW.ADD_TO_FAVORITE.TABS[ WINDOW.ADD_TO_FAVORITE.INDEX_TAB.CREATE_COPY ].name:
                        this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.NAME._KEY ).setValueFromUser( CONTROLLER.UiVisualisation.current_view.getCloneName() );
                        this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.NAME._KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.NORMAL );
                        break;
                }
                return;
            case "compute_property_space_share":
                switch ( param[ WINDOW_V2.CONST.PARAM.WINDOW_NAME ] ) {
                    case WINDOW.ADD_TO_FAVORITE.TABS[ WINDOW.ADD_TO_FAVORITE.INDEX_TAB.CREATE_LINK ].name:
                        this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).setValueFromUser( SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.PRIVATE );
                        if ( !CONTROLLER.UiVisualisation.current_view.isType( SHINKEN.SCREEN.TYPE.SERVICE_WEATHER ) ) {
                            this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).setValueFromUser( SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.EVERYONE );
                            this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).setButtonVisibilityState( SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.PRIVATE, SHINKEN.CONST.VISIBILITY_STATE.LOCKED );
                            this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).setButtonTooltip( SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.PRIVATE, _( "favorites.add_to_favorite.tooltips.disabled" ) );
                        }
                        this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).setButtonVisibilityState( SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.GROUPS, SHINKEN.CONST.VISIBILITY_STATE.NORMAL );
                        this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).setButtonVisibilityState( SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.EVERYONE, SHINKEN.CONST.VISIBILITY_STATE.NORMAL );
                        if ( !CONTROLLER.UiVisualisation.current_user[ SHINKEN.ELEMENT.USER.PARAM.GROUPS ].length ) {
                            this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).setButtonVisibilityState( SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.GROUPS, SHINKEN.CONST.VISIBILITY_STATE.LOCKED );
                            this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).setButtonTooltip( SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.GROUPS, _( "favorites.add_to_favorite.tooltips.no_group" ) );
                        }
                        else {
                            this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).setButtonTooltip( SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.GROUPS, "" );
                        }
                        break;
                    case WINDOW.ADD_TO_FAVORITE.TABS[ WINDOW.ADD_TO_FAVORITE.INDEX_TAB.CREATE_COPY ].name:
                        this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).setValueFromUser( SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.PRIVATE );
                        this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).setButtonVisibilityState( SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.PRIVATE, SHINKEN.CONST.VISIBILITY_STATE.NORMAL );
                        this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).setButtonTooltip( SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.PRIVATE, "" );
                        this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).setButtonVisibilityState( SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.EVERYONE, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                        this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).setButtonVisibilityState( SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.GROUPS, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                        break;
                }
                
                var _spaces_from_acl = CONTROLLER.UiVisualisation.current_user.getAclSpaceShare();
                if ( !_spaces_from_acl[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_PRIVATE ].read ) {
                    this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).setButtonVisibilityState( SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.PRIVATE, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                }
                if ( !_spaces_from_acl[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_GROUP ].read ) {
                    this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).setButtonVisibilityState( SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.GROUPS, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                }
                if ( !_spaces_from_acl[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_EVERYBODY ].read ) {
                    this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).setButtonVisibilityState( SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.EVERYONE, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                }
                return;
            case "compute_label_help":
                this.computeFooterContent();
                this.getFooterContent().setLabel( _( 'favorites.add_to_favorite.form.footer.' + param[ WINDOW_V2.CONST.PARAM.WINDOW_NAME ] ) );
                return;
            case "compute_property_group_share":
                if ( this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).getValue() === SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.GROUPS ) {
                    this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.GROUP_SHARE._KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.NORMAL );
                }
                else {
                    this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.GROUP_SHARE._KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.TOTALLY_FORM_EXCLUDE );
                }
                return;
            case "compute_property_folder_share_content":
                this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.FOLDER_SHARE._KEY ).changeOptionsFromArray( this.getFolderOptions() );
                this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.FOLDER_SHARE._KEY ).setValueFromUser( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.FOLDER_SHARE.OPTION.NONE );
                return;
        }
        this.doActionAfterCommon( event_name, param );
        switch ( event_name ) {
            case "click_on_radio_button_V3":
                switch ( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] ) {
                    case SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY:
                        this.doActionAfter( "compute_property_group_share", this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).getValue() );
                        this.doActionAfter( "compute_property_folder_share_content" );
                        break;
                }
                break;
            case "onchange_in_input_V3":
                switch ( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] ) {
                    case SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.NAME._KEY:
                        this.getContentByUUID( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] ).getContentByUUID( param[ COMPONENT.INPUT.PARAM.NAME ] ).setStatus( COMPONENT.CONST.STATUS.VALID );
                        break;
                }
                break;
            case "click_on_item_selector_V3":
                switch ( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] ) {
                    case SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.GROUP_SHARE._KEY:
                        this.doActionAfter( "compute_property_folder_share_content" );
                        break;
                }
                break;
        }
    },
    getDataForPropertySpaceShare: function () {
        var spaces     = [
            SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.EVERYONE,
            SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.GROUPS,
            SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.PRIVATE
        ];
        var _to_return = [];
        for ( var i = 0, _size_i = spaces.length; i < _size_i; i++ ) {
            var _space   = {};
            _space.value = spaces[ i ];
            _space.label = _( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.DICTIONARY_SPACE_SHARES_NAMES_WITH_ICONS + _space.value );
            switch ( _space.value ) {
                case SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.PRIVATE:
                    _space.is_active = true;
            }
            _to_return.push( _space );
        }
        return _to_return;
    },
    getDataForPropertyGroupShare: function () {
        var _groups    = CONTROLLER.UiVisualisation.current_user[ SHINKEN.ELEMENT.USER.PARAM.GROUPS ];
        var _to_return = [];
        for ( var i = 0, _size_i = _groups.length; i < _size_i; i++ ) {
            _to_return.push( { name: _groups[ i ].uuid, label: _groups[ i ].name } );
        }
        
        return _to_return;
    },
    toAddSpecific               : function ( to_add ) {
        var _key = to_add.getName();
        to_add.setLabel( _( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.DICTIONARY_SPOT + "label." + _key ) );
        to_add.addParamForEvents( SHINKEN.OBJECT.FORMSET.PARAM.FORM_NAME, this.getName() );
        this.addSpecific( to_add );
        this.addToProperties( to_add );
        switch ( _key ) {
            case SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.NAME._KEY:
                to_add.setPlaceholder( _( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.DICTIONARY_SPOT + "placeholder." + _key ) );
                break;
            case SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.GROUP_SHARE._KEY:
                to_add.setDefaultLabelForSelector( "", _( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.DICTIONARY_SPOT + "title." + _key ) );
                break;
        }
    },
    computeFooterContent: function () {
        if ( this.footer_content ) {
            return;
        }
        this.footer_content = new COMPONENT.LabelFromData();
    },
    computeValidation__20241125   : function () {
        this.status_validation    = COMPONENT.CONST.STATUS.VALID;
        let _name_prop = this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.NAME._KEY );
        if ( !_name_prop.getValue() ) {
            _name_prop.setStatus( COMPONENT.CONST.STATUS.ERROR );
            this.status_validation = COMPONENT.CONST.STATUS.ERROR;
        }
        if ( this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).getValue() === SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.GROUPS ) {
            var _group_prop = this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.GROUP_SHARE._KEY );
            if ( !_group_prop.getValue() ) {
                _group_prop.setStatus( COMPONENT.CONST.STATUS.ERROR );
                this.status_validation = COMPONENT.CONST.STATUS.ERROR;
            }
        }
    },
    getNameForGroup      : function ( group_id ) {
        var _groups = CONTROLLER.UiVisualisation.current_user[ SHINKEN.ELEMENT.USER.PARAM.GROUPS ];
        var _current;
        for ( var i = 0, _size_i = _groups.length; i < _size_i; i++ ) {
            _current = _groups [ i ];
            if ( _current.uuid === group_id ) {
                return _current.name;
            }
        }
        return "";
    },
    getDefaultFolderTitle: function () {
        var _to_return = SHINKEN.TOOLS.STRING.format(
            _( "favorites.add_to_favorite.form.property.options." + SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.FOLDER_SHARE.OPTION.NONE ),
            _( "favorites.space_share.names." + this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).getValue() )
        );
        if ( this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).getValue() === SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.GROUPS ) {
            var _selected_group = this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.GROUP_SHARE._KEY ).getValue();
            var _name_group     = this.getNameForGroup( _selected_group );
            if ( _name_group ) {
                _to_return = SHINKEN.TOOLS.STRING.format(
                    _( "favorites.add_to_favorite.form.property.options.___NONE_GROUP___" ),
                    _name_group
                );
            }
            else {
                _to_return = _( "favorites.add_to_favorite.form.property.options.___NONE_GROUP_EMPTY___" );
                
            }
        }
        return _to_return;
    },
    getFoldersList       : function () {
        var _group_name = this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).getValue() === SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.GROUPS ?
                          this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.GROUP_SHARE._KEY ).getValue() :
                          null;
        return CONTROLLER.Share.getFolderForSpace( this.getContentByUUID( SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ).getValue(), _group_name );
    },
    getFolderOptions     : function () {
        var _folders   = this.getFoldersList();
        var _to_return = [
            {
                name : SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.FOLDER_SHARE.OPTION.NONE,
                label: this.getDefaultFolderTitle()
            }
        ];
        for ( var i = 0, _size_i = _folders.length; i < _size_i; i++ ) {
            _to_return.push( { name: _folders[ i ].uuid, label: _folders[ i ].name } );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.UI.AddToFavoriteFormSet, SHINKEN.OBJECT.FormSetFromData );
WINDOW.ADD_TO_FAVORITE = {
    TABS      : [
        {
            name     : "create_link",
            is_active: true
        },
        {
            name: "create_copy"
        }
    ],
    INDEX_TAB : {
        CREATE_LINK: 0,
        CREATE_COPY: 1
    },
    NAME_GROUP: "add-to-favorite-window-group"
};
WINDOW.AddToFavoriteWindowGroup           = function ( group_name ) {
    this.initSpecific( group_name );
};
WINDOW.AddToFavoriteWindowGroup.prototype = {
    initSpecific           : function ( group_name ) {
        this.init( group_name );
        this.initWithData( WINDOW.ADD_TO_FAVORITE.TABS );
        this.addParamForEvents( CONTROLLER.CONST.CONTROLLER_NAME_LABEL, this.getController__20240819().controller_name );
        this.computeHtmlTargets( document.getElementById( "id-shinken-container-panels" ) );
    },
    getChildConstructor    : function ( window_name, parent_name ) {
        return new WINDOW.AddToFavoriteWindow( window_name, parent_name );
    },
    getController__20240819: function () {
        return CONTROLLER.UiVisualisation;
    },
    changeWindowStateByView: function () {
        const is_view_owner = CONTROLLER.UiVisualisation.current_view.isOwnByCurrentUser();
        if ( !is_view_owner ) {
            let window = this.setVisibilityWindowState( SHINKEN.CONST.VISIBILITY_STATE.DISABLED, WINDOW.ADD_TO_FAVORITE.TABS[ WINDOW.ADD_TO_FAVORITE.INDEX_TAB.CREATE_LINK ].name, "toto" );
            window.setTooltipHtml( _( "favorites.add_to_favorite.tooltips.weather.reference_not_allowed" ), SHINKEN_TOOLTIP.TYPE.ERROR_BORDER );
        }
        this.setActiveWindow( WINDOW.ADD_TO_FAVORITE.TABS[ WINDOW.ADD_TO_FAVORITE.INDEX_TAB.CREATE_COPY ].name );
        if ( CONTROLLER.UiVisualisation.current_view.isType( SHINKEN.SCREEN.TYPE.SERVICE_WEATHER ) ) {
            this.setActiveWindow( !is_view_owner ? WINDOW.ADD_TO_FAVORITE.TABS[ WINDOW.ADD_TO_FAVORITE.INDEX_TAB.CREATE_COPY ].name : WINDOW.ADD_TO_FAVORITE.TABS[ WINDOW.ADD_TO_FAVORITE.INDEX_TAB.CREATE_LINK ].name );
            if ( !__current_user_has_editable_right_service_weather__ ) {
                this.setVisibilityWindowState( SHINKEN.CONST.VISIBILITY_STATE.HIDDEN, WINDOW.ADD_TO_FAVORITE.TABS[ WINDOW.ADD_TO_FAVORITE.INDEX_TAB.CREATE_COPY ].name );
            }
        }
    }
    
    
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.AddToFavoriteWindowGroup, WINDOW_V2.ElementGroupFromDataWithComma );
WINDOW.AddToFavoriteWindow           = function ( window_name, parent_name ) {
    this.__class_name__ = 'WINDOW.AddToFavoriteWindow';
    this.init(window_name, parent_name);
};
WINDOW.AddToFavoriteWindow.prototype = {
    init                     : function (window_name, parent_name) {
        this.initCommon( window_name, parent_name );
        this.label = new COMPONENT.LabelFromData( _( "favorites.add_to_favorite.window." + this.name + ".name" ) );
    },
    setDomElementTooltip: function () {
        switch ( this.visibility_state ) {
            case SHINKEN.CONST.VISIBILITY_STATE.DISABLED :
                this.setTooltipHtml( _( "favorites.add_to_favorite.tooltips.disabled" ) );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.AddToFavoriteWindow, WINDOW_V2.ElementFromDataWithComma );
CONTROLLER.KeyEvent = (function ( self ) {
    self.init                            = function () {
        document.onkeydown = function ( e ) {
            var _code = e.keyCode;
            switch ( _code ) {
                case SHINKEN.CONST.KEY_CODE.F1:
                    CONTROLLER.UiVisualisation.onClick();
                    e.preventDefault();
                case SHINKEN.CONST.KEY_CODE.CTRL:
                case SHINKEN.CONST.KEY_CODE.SHIFT:
                case SHINKEN.CONST.KEY_CODE.W:
                case SHINKEN.CONST.KEY_CODE.ESCAPE:
                case SHINKEN.CONST.KEY_CODE.DOWN:
                case SHINKEN.CONST.KEY_CODE.UP:
                case SHINKEN.CONST.KEY_CODE.TAB:
                case SHINKEN.CONST.KEY_CODE.F:
                    SHINKEN.TOOLS.IFRAME.doActionAfter( "#id-shinken-iframe-for-ui-visualisation","on_key_down", e );
                    break;
            }
        };
    };
    
    
    return self;
})( CONTROLLER.KeyEvent || {} );
CONTROLLER.License = (function ( self ) {
    self.clickOnButton = function ( event, event_name, param ) {
        switch ( event_name ) {
            case "licence-toggle":
                self.dom_container.classList.toggle( "shinken-open-popup" );
                self.dom_container.querySelector( ".shinken-license-table" ).classList.toggle( "shinken-licence-open-in-popup" );
                break;
        }
    };
    self.data          = {
        error_on_last_query        : {
            timestamp: undefined
        },
        diff_in_second_with_backend: 0,
        show_message_out_of_synchro: false,
        shinken_configuration_id   : false,
        message_out_of_synchro     : undefined,
        time_zone                  : 0
    };
    
    self.init = function () {
        self.dom_container = document.getElementById( "id-shinken-license-container" );
        self.checkLicense();
    };
    
    self.computeAfterResize = function () {
        if ( !CONTROLLER.NavigationBar.button_menu_is_collapsed && !CONTROLLER.NavigationBar.needACollapse() ) {
            CONTROLLER.NavigationBar.license_is_collapsed = false;
        }
        if ( self.dom_container && self.dom_container.classList.contains( "shinken-open-popup" ) && CONTROLLER.NavigationBar.needACollapse() ) {
            CONTROLLER.NavigationBar.license_is_collapsed = true;
        }
        DOM.Service.addOrRemoveClasses( self.dom_container, CONTROLLER.NavigationBar.license_is_collapsed, "shinken-license-collapsed" );
        if ( CONTROLLER.NavigationBar.needACollapse() ) {
            CONTROLLER.NavigationBar.license_is_collapsed = true;
        }
        DOM.Service.addOrRemoveClasses( self.dom_container, CONTROLLER.NavigationBar.license_is_collapsed, "shinken-license-collapsed" );
    };
    
    self.checkLicense = function () {
        var actionsAfterGetBackendDataSuccess = function ( _status, data ) {
            self.updateData( data );
            self.computeHtml();
            setTimeout( function () {
                CONTROLLER.NavigationBar.computeAfterResize();
            } );
        };
        var actionsAfterGetBackendDataError   = function ( _status, data ) {
            console.log( _( 'license.errors.cannotUpdateLicense', [ DICTIONARY_COMMON_UI ] ) );
        };
        var url                               = SHINKEN.HIGHWAY.getOrigin() + SHINKEN.COMUNICATION.CONST.QUERY.GET.LICENCE;
        SHINKEN.COMUNICATION.requestGet( url, actionsAfterGetBackendDataSuccess, actionsAfterGetBackendDataError, null, CONTROLLER.UiVisualisation.callbackAfter401 );
        
    };
    
    
    self.updateData                  = function ( license ) {
        
        self.data.license = {
            type           : '',
            display        : false,
            isContactError : false,
            isLogoError    : false,
            isNodesError   : false,
            isDurationError: false,
            isInvalidError : false,
            text           : {
                before : '',
                colored: '',
                after  : ''
            },
            nodes          : {
                before : '',
                colored: '',
                after  : ''
            }
        };
        
        var expiredAt    = license.creation_time + license.duration;
        var nowInSeconds = (Date.now() / 1000);
        
        if ( license.is_key_valid === true ) {
            self.data.license.type = _( 'license.licenseType' + (license.is_testing ? 'Trial' : 'Pro'), [ DICTIONARY_COMMON_UI ] );
            
            var leftDays        = Math.ceil( (expiredAt - nowInSeconds) / 86400 );
            var warningDuration = CONTROLLER.UiVisualisation.current_user.isAdmin() ? 60 : 7;
            var warningLicense  = (leftDays <= warningDuration);
            
            if ( leftDays <= 0 ) {
                self.data.license.isDurationError = true;
                self.data.license.isContactError  = true;
                self.data.license.isLogoError     = true;
                self.data.license.text.before     = _( 'license.licensePeriod', [ DICTIONARY_COMMON_UI ] );
                self.data.license.text.colored    = ' ' + _( 'license.expired', [ DICTIONARY_COMMON_UI ] );
                
            }
            else {
                self.data.license.isDurationError = license.is_testing || warningLicense;
                self.data.license.isLogoError     = warningLicense;
                self.data.license.text.before     = SHINKEN.TOOLS.STRING.format( _( 'license.licenseEndingDate', [ DICTIONARY_COMMON_UI ] ), DATE_TIME.FORMAT.get_date_from_timestamp( expiredAt ) ) + ' [';
                
                var pluralDay = (leftDays > 1) ? 's' : '';
                var days      = _( 'license.day', [ DICTIONARY_COMMON_UI ] ) + pluralDay;
                var left      = _( 'license.left', [ DICTIONARY_COMMON_UI ] );// No plural because not good in EN
                if ( warningLicense ) {
                    self.data.license.text.colored = leftDays + ' ' + days + ' ' + left;
                }
                else {
                    self.data.license.text.before += leftDays + ' ' + days + ' ' + left;
                }
                self.data.license.text.after = ']';
            }
            
            var checkNodes = (license.nodes_limit !== 0) && (!license.is_testing);
            if ( checkNodes ) {
                self.data.license.nodes.before = SHINKEN.TOOLS.STRING.format( _( 'license.nodesAndLimit', [ DICTIONARY_COMMON_UI ] ), license.nb_hosts, license.nodes_limit ) + ' [';
                
                var nodesDifference = license.nodes_limit - license.nb_hosts;
                
                if ( nodesDifference < 0 ) {
                    self.data.license.isNodesError   = true;
                    self.data.license.nodes.colored  = SHINKEN.TOOLS.STRING.format( _( 'license.exceedBy', [ DICTIONARY_COMMON_UI ] ), -nodesDifference );
                    self.data.license.isContactError = true;
                    self.data.license.isLogoError    = true;
                }
                else {
                    var warningNode = license.nodes_limit / 10;
                    
                    if ( nodesDifference < warningNode ) {
                        self.data.license.isNodesError  = true;
                        self.data.license.nodes.colored = nodesDifference + ' ' + _( 'license.left', [ DICTIONARY_COMMON_UI ] );
                    }
                }
                self.data.license.nodes.after = ']';
            }
        }
        
        else {
            self.data.license.isInvalidError = true;
            self.data.license.isContactError = true;
            self.data.license.isLogoError    = true;
            
            
            
            self.data.license.type = _( "license.licenseInvalid", [ DICTIONARY_COMMON_UI ] );
            
            self.data.license.text.colored = _( 'license.unexpectedError', [ DICTIONARY_COMMON_UI ] );
            
            if ( license.is_present !== true ) {
                self.data.license.text.colored = _( 'license.noLicenseKey', [ DICTIONARY_COMMON_UI ] );
                self.data.license.text.after   = _( 'license.onServer', [ DICTIONARY_COMMON_UI ] );
            }
            else if ( license.is_duplicated_trial === true ) {
                self.data.license.text.colored = _( 'license.youAreUsingSecondTime', [ DICTIONARY_COMMON_UI ] );
                self.data.license.text.after   = _( 'license.aTrialVersion', [ DICTIONARY_COMMON_UI ] );
            }
            else if ( license.is_format_valid !== true ) {
                self.data.license.text.before  = _( 'license.yourLicenseHas', [ DICTIONARY_COMMON_UI ] );
                self.data.license.text.colored = _( 'license.invalidFormat', [ DICTIONARY_COMMON_UI ] );
            }
        }
        
        if ( self.data.license.isNodesError || self.data.license.isDurationError || self.data.license.isInvalidError ) {
            self.data.license.display = true;
        }
    };
    self.getHtmlExtendedLicense      = function () {
        var _table          = DOM.Service.createElement( "table", { class: "shinken-license-table" } );
        var _line           = DOM.Service.createElement( "tr", { class: "shinken-license-line " + (self.data.license.isContactError ? "shinken-license-glowing" : "") } );
        var _col_icon       = DOM.Service.createElement( "td", { class: "shinken-license-col-icon shinken-license-background-grey" } );
        var _col_icon_ninja = DOM.Service.createElement( "img", { src: "/static/" + __SHINKEN_HTTP_START_TIME__ + "/common_ui/img/logos/ninja-" + (self.data.license.isLogoError ? "red" : "blue") + ".png", class: "shinken-license-col-icon-icon" } );
        var _col_content    = DOM.Service.createElement( "td", { class: "shinken-license-col-content shinken-license-background-grey" } );
        
        var _col_content_text_top       = DOM.Service.createElement( "div", { class: "shinken-license-col-content-text-top" } );
        _col_content_text_top.innerHTML = self.data.license.type;
        var _col_content_text_bottom    = DOM.Service.createElement( "div", { class: "shinken-license-col-content-text-bottom" } );
        
        var _text_bottom_content = "";
        if ( self.data.license.isDurationError || self.data.license.isInvalidError ) {
            _text_bottom_content += '<div>' + self.data.license.text.before + ' <span class="shinken-text-red">' + self.data.license.text.colored + '</span> ' + self.data.license.text.after + '</div>';
        }
        if ( self.data.license.isNodesError ) {
            _text_bottom_content += '<div>' + self.data.license.nodes.before + ' <span class="shinken-text-red">' + self.data.license.nodes.colored + '</span> ' + self.data.license.nodes.after + '</div>';
        }
        _col_content_text_bottom.innerHTML = _text_bottom_content;
        
        _table.appendChild( _line );
        _line.appendChild( _col_icon );
        _line.appendChild( _col_content );
        
        _col_icon.appendChild( _col_icon_ninja );
        _col_content.appendChild( _col_content_text_top );
        _col_content.appendChild( _col_content_text_bottom );
        
        if ( CONTROLLER.UiVisualisation.current_user.isAdmin() ) {
            var _col_contact = DOM.Service.createElement( "td", { class: "shinken-license-col-contact " + (self.data.license.isContactError ? "shinken-red-background" : "shinken-green-background") } );
            var _col_contact_text       = DOM.Service.createElement( "a", {
                class: "shinken-license-col-contact-text", href: "mailto:contact@shinken-solutions.com?subject=" + SHINKEN.TOOLS.STRING.urlEncode( _( 'license.contactMailSubject', [ DICTIONARY_COMMON_UI ] ) )
            } );
            _col_contact_text.innerHTML = _( 'license.contactUs', [ DICTIONARY_COMMON_UI ] );
            _line.appendChild( _col_contact );
            _col_contact.appendChild( _col_contact_text );
        } else {
            _col_content.classList.add("shinken-license-col-content-without-col-contact");
        }
        return _table;
    };
    self.getHtmlCollapsedLicense     = function () {
        var _container = DOM.Service.createElement( "div", { class: "license-container-light", onclick: "MANAGER.EventManager.clickOnButton(event)", "data-name": "licence-toggle" } );
        _container.appendChild( DOM.Service.createElement( "div", { class: "shinkon shinkon-warning" } ) );
        _container.appendChild( DOM.Service.createElement( "div", { class: "shinken-label" }, _( 'license.license', [ DICTIONARY_COMMON_UI ] ) ) );
        return _container;
    };
    self.isNecessaryToComputeLicense = function () {
        if ( CONTROLLER.NavigationBar.__is_for_shinken_documentation === 'license') {
            return true;
        }
        if ( CONTROLLER.NavigationBar.__is_for_shinken_documentation) {
            return false;
        }
        if((CONTROLLER.UiVisualisation.current_user.isAdmin() || self.data.license.isLogoError) && self.data.license.display) {
            return  true;
        }
        
        return false;
    };
    self.computeHtml                 = function () {
        DOM.Service.empty( self.dom_container );
        if ( !self.isNecessaryToComputeLicense() ) {
            return;
        }
        var _extended_license  = self.getHtmlExtendedLicense();
        var _collapsed_license = self.getHtmlCollapsedLicense();
        DOM.Service.addElementTo( _extended_license, self.dom_container );
        DOM.Service.addElementTo( _collapsed_license, self.dom_container );
    };
    
    
    return self;
})( CONTROLLER.License || {} );
CONTROLLER.NavigationBar = (function ( self ) {
    self.controller_name                 = CONTROLLER.CONST.UI_NAV_BAR.NAME;
    self.callbacks_after_close_modal     = new SHINKEN.OBJECT.callbacksAfterCloseModal();
    self.doActionAfter                   = function ( event_name, param, extra_param ) {
        switch ( event_name ) {
            case "current_view_has_been_deleted":
                SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).EXTERNAL.COMMUNICATION.doAction( "current_view_is_being_deleted" );
                SHINKEN.HIGHWAY.changeUrl( SHINKEN.HIGHWAY.getPathFull() + CONTROLLER.UiVisualisation.current_user.getDefaultView() );
                CONTROLLER.UiVisualisation.actionAfterUrlChange();
                let parent_element = DOM.Service.findParentElementWithClass( this.dom_element, "shinken-view-manager-navigation", 50 );
                SHINKEN.TOOLS.NOTIFICATION.addNotification( _( "views.manager.service_weather.lines.current_view_is_deleted" ), SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.INFO, parent_element, SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.TOP, 60000 );
                break;
            case "click_on_button":
            case "click_on_button_V3":
                switch ( param[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "validated_form":
                        self.validateForm( param );
                        break;
                    case "cancel_form":
                        switch ( param[ SHINKEN.OBJECT.FORMSET.PARAM.FORM_NAME ] ) {
                            case SHINKEN.UI.ADD_TO_FAVORITE.FORM_NAME:
                                self.dropdown_add_favorite.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                                break;
                        }
                        break;
                }
                break;
            case "save-panel-done":
            case "save-view-done":
                if ( param === true ) { //need_redirect_to_default_view
                    self.navigate( CONTROLLER.UiVisualisation.current_user.getDefaultView(), event );
                }
                break;
            case "controller-start-init":
                switch ( param ) {
                    case CONTROLLER.CONST.UI_PANELS.NAME:
                        MANAGER.__instance_window_modal_manager.iframeLoaded();
                        break;
                }
                break;
            case "ask-for-pop-up-close-accepted":
                if ( MANAGER.__instance_window_modal_manager ) {
                    MANAGER.__instance_window_modal_manager.close();
                }
                if ( self.dropdown_add_favorite ) {
                    self.dropdown_add_favorite.doActionAfter( "close_opened_pop_up" );
                }
                if ( self.dropdown_configuration_user ) {
                    self.dropdown_configuration_user.doActionAfter( "close_opened_pop_up" );
                }
                self.callbacks_after_close_modal.doActions();
                break;
            case "ask-for-pop-up-close-refused":
                if ( param !== "from_angular__202411023" ) {
                    self.callbacks_after_close_modal.resetActions();
                }
                break;
            case "use_radio_btn_configuration_notification_blink":
                self.dropdown_configuration_user.doActionAfter( event_name, param );
                break;
            case "toggle_configuration_user_setting_interface":
                if ( !self.dropdown_configuration_user ) {
                    self.dropdown_configuration_user = new SHINKEN.OBJECT.Dropdown.ConfigurationUser( param );
                    self.dropdown_configuration_user.initDomElement();
                }
                else {
                    self.dropdown_configuration_user.doActionAfter( "do_action_after_init_dom_element" );
                }
                DOM.Service.setDataSet( self.dropdown_configuration_user.getDomElement(), "activeView", CONTROLLER.UiVisualisation.active_view );
                switch ( CONTROLLER.UiVisualisation.active_view ) {
                    case SHINKEN.SCREEN.TYPE.VIEW360:
                    case SHINKEN.SCREEN.TYPE.IMPACTS:
                    case SHINKEN.SCREEN.TYPE.REPORTING:
                    case SHINKEN.SCREEN.TYPE.REPORTING_WEB:
                        self.dropdown_configuration_user.getDomElement().querySelector( ".shinken-notification-main-table" ).setAttribute( 'shi-tip-html', _( "notification.tooltip_notification_not_enabled" ) );
                        break;
                    default:
                        self.dropdown_configuration_user.getDomElement().querySelector( ".shinken-notification-main-table" ).setAttribute( 'shi-tip-html', "" );
                        break;
                    
                }
                self.dropdown_configuration_user.togglePhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING, SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                break;
            case "click_on__window_navigation__done":
                switch ( param[ WINDOW_V2.CONST.PARAM.WINDOW_GROUP_NAME ] ) {
                    case WINDOW.ADD_TO_FAVORITE.NAME_GROUP:
                        self.dropdown_add_favorite.doActionAfter( event_name, param );
                        break;
                    default:
                        break;
                }
                break;
            case "toggle_add_to_favorite_form":
                if ( !self.dropdown_add_favorite || self.dropdown_add_favorite.isPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN ) ) {
                    self.dropdown_add_favorite = new SHINKEN.OBJECT.Dropdown.AddFavorite( param );
                }
                self.dropdown_add_favorite.togglePhaseSpecific( SHINKEN.OBJECT.CONST.PHASE.RUNNING, SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                break;
            case "load_shares_data_from_angular":
                if ( self.dropdown_add_favorite && self.dropdown_add_favorite.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING ) ) {
                    self.dropdown_add_favorite.doActionAfter( event_name, param, extra_param );
                }
                break;
            case "navigate_to_default_view":
                self.navigate( CONTROLLER.UiVisualisation.current_user.getDefaultView(), event );
                break;
            case "mode_edit_on_has_changed":
                self.updateAddToFavoriteButton();
                if ( self.callbacks_after_close_modal.hasActions() ) {
                    self.callbacks_after_close_modal.doActions();
                }
                break;
            case "update_screen_with_view_behaviour":
            case "update_screen_phase":
                self.updateAddToFavoriteButton();
                break;
        }
    };
    self.onClick                         = function ( event, event_name ) {
        if ( self.dropdown_configuration_user ) {
            self.dropdown_configuration_user.onClick( event, event_name );
        }
        if ( self.dropdown_add_favorite ) {
            self.dropdown_add_favorite.onClick( event, event_name );
        }
        self.closeAllBoostrapPopups( event_name );
    };
    self.clickOnButton                   = function ( event, event_name, param ) {
        var _form_container;
        var _input;
        switch ( event_name ) {
            case "gap-time-toggle":
                self.__dom_container_gap_time.classList.toggle( "shinken-open-popup" );
                self.__dom_container_gap_time.querySelector( ".shinken-backend-gap-full" ).classList.toggle( "shinken-gap-time-open-in-popup" );
                break;
            case "licence-toggle":
                CONTROLLER.License.clickOnButton( event, event_name, param );
                break;
            case "navigate_default_hive":
                self.navigate( "/hive/" + CONTROLLER.UiVisualisation.current_user.prefs.defaultScreen.uuid, event );
                break;
            case "navigate_new_hive":
            case "navigate_new_list":
            case "navigate_new_weather":
                self.navigateIframeAngularForNewView( event, event_name );
                break;
            case "navigate_default_list":
                self.navigate( "/list/all", event );
                break;
            case "navigate_default_root_problem_list":
                self.navigate( "/list/root-problems", event );
                break;
            case "navigate_default_event_list":
                self.navigate( "/event/all_events", event );
                break;
            case "navigate_manager_ui_weather":
                self.openUiPanelManager( event, SHINKEN.UI.VIEW.TYPE.WEATHER );
                break;
            case "navigate_view_360":
                self.navigate( "/360", event );
                break;
            case "navigate_view_impacts":
                self.navigate( "/impacts", event );
                break;
            case "navigate_view_reporting":
                self.navigate( "/reporting", event );
                break;
            case "navigate_to_default_view":
                if ( self._is_default_view_on ) {
                    SHINKEN.HIGHWAY.refreshCurrentPage();
                    return;
                }
                self.navigate( CONTROLLER.UiVisualisation.current_user.getDefaultView(), event );
                break;
            case "navigate_to_parent_view":
                var _uuid_hive = document.getElementById( "id-shinken-iframe-for-ui-visualisation" ).contentWindow.EXTERNAL.COMMUNICATION.getHighwayManagerInstance().hive.uuid;
                self.navigate( "/hive/" + _uuid_hive, event );
                break;
            case "clean-name-for-add_to_favorite":
                DOM.Service.addOrRemoveClasses( document.querySelector( "#id-shinken-add-favorite-form-container .shinken-broom-in-name-area" ), true, "shinken-no-opacity" );
                break;
            case "logout_via_button":
                var _errors = function ( _status, data ) {
                    console.log( _( "logout.errors.cannot_logout", [DICTIONARY_COMMON_UI] ) );
                };
                SHINKEN.COMUNICATION.requestPost( "/apilogout", "", CONTROLLER.UiVisualisation.callbackAfter401, _errors, null, CONTROLLER.UiVisualisation.callbackAfter401 );
                self.dropdown_configuration_user.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                break;
            case "use_default_value_for_sound_notification":
                self.dropdown_configuration_user.doActionAfter( event_name, param );
                break;
        }
    };
    self.navigateTo                      = function ( event, screen_uuid, screen_type ) {
        self.navigate( "/" + screen_type + "/" + screen_uuid, event );
    };
    self.clickOnInput                    = function ( event ) {
    };
    self.onChangeOnInput                 = function ( event, event_name, param ) {
        switch ( event_name ) {
            case "use_slider_configuration_user_notification_volume":
            case "use_slider_configuration_user_notification_volume_oninput":
                self.dropdown_configuration_user.doActionAfter( event_name, param );
                break;
        }
    };
    self.actionAfterUrlChange            = function () {
        self.last_basics_stats_call_timestamp = null;
        setTimeout( function () {
            self.computeDefaultButton();
            self.computeDisplayByView();
            self.refresh();
        }, 200 );
    };
    self.computeDefaultButton            = function () {
        self._is_default_view_on = CONTROLLER.UiVisualisation.current_user.getDefaultUrlFromSettings() === SHINKEN.HIGHWAY.getHash();
        DOM.Service.addOrRemoveClasses( self.__dom_container_navbar, self._is_default_view_on, "shinken-is-default-view-on" );
        let _text_tooltip;
        self.__dom_icon_default_view_btn.setAttribute( "is_edit_on", false );
        if ( CONTROLLER.UiVisualisation.is_edit_on ) {
            self.__dom_icon_default_view_btn.setAttribute( "is_edit_on", true );
            _text_tooltip = _( "default_view_button.tooltipIsEditOnDefaultView", [DICTIONARY_COMMON_UI] );
        }
        else if ( self._is_default_view_on ) {
            _text_tooltip = _( "default_view_button.tooltipIsAlreadyDefaultView", [DICTIONARY_COMMON_UI] );
        }
        else {
            _text_tooltip = _( "default_view_button.tooltipDefaultViewBtn", [DICTIONARY_COMMON_UI] );
        }
        self.__dom_icon_default_view_btn.setAttribute( "shi-tip-text", _text_tooltip );
    };
    self.computeDisplayByView            = function () {
        var _has_parent = false;
        switch ( CONTROLLER.UiVisualisation.active_view ) {
            case "dashboard":
                _has_parent = true;
                break;
        }
        DOM.Service.addOrRemoveClasses( self.__dom_container_navbar, _has_parent, "shinken-view-has-parent" );
    };
    self.navigate                        = function ( url, event ) {
        url = SHINKEN.TOOLS.STRING.startsWith( url, "#" ) ? url : "#" + url;
        CONTROLLER.UiVisualisation.computeIsIframeEditOn();
        var _navigation_type = SHINKEN.HIGHWAY.getNavigationType( event );
        switch ( _navigation_type ) {
            case SHINKEN.HIGHWAY.CONST.NAVIGATION_TYPE.NORMAL:
                if ( MANAGER.__instance_window_modal_manager && MANAGER.__instance_window_modal_manager.is_open ) {
                    self.callbacks_after_close_modal.addCallback( CONTROLLER.NavigationBar.navigate, url, event );
                    self.closeModal();
                    return;
                }
                if ( CONTROLLER.UiVisualisation.is_edit_on ) {
                    self.callbacks_after_close_modal.addCallback( CONTROLLER.NavigationBar.navigate, url, event );
                }
                break;
        }
        SHINKEN.HIGHWAY.goTo( SHINKEN.HIGHWAY.getPathFull() + url, event );
    };
    self.navigateIframeAngular           = function ( url, event ) {
        var _url_constructed = window.location.origin + window.location.pathname + "#" + url;
        _url_constructed     = _url_constructed.replace( "/static/ui/index.html", "/static/ui/angular/index.html" );
        var _navigation_type = SHINKEN.HIGHWAY.getNavigationType( event );
        switch ( _navigation_type ) {
            case SHINKEN.HIGHWAY.CONST.NAVIGATION_TYPE.NORMAL:
                if ( MANAGER.__instance_window_modal_manager && MANAGER.__instance_window_modal_manager.is_open ) {
                    self.callbacks_after_close_modal.addCallback( CONTROLLER.NavigationBar.navigateIframeAngular, url, event );
                    self.closeModal();
                    return;
                }
                document.getElementById( "id-shinken-iframe-for-ui-visualisation" ).setAttribute( "src", _url_constructed );
                break;
            case SHINKEN.HIGHWAY.CONST.NAVIGATION_TYPE.TARGET_BLANK:
                SHINKEN.HIGHWAY.goToBlank( _url_constructed );
                return;
        }
    };
    self.navigateIframeAngularForNewView = function ( event, event_name ) {
        if ( MANAGER.__instance_window_modal_manager && MANAGER.__instance_window_modal_manager.is_open ) {
            self.callbacks_after_close_modal.addCallback( CONTROLLER.NavigationBar.navigateIframeAngularForNewView, event, event_name );
            self.closeModal();
            return;
        }
        CONTROLLER.UiVisualisation.computeIsIframeEditOn();
        if ( CONTROLLER.UiVisualisation.is_edit_on ) {
            document.getElementById( "id-shinken-iframe-for-ui-visualisation" ).contentWindow.EXTERNAL.COMMUNICATION.getHighwayManagerInstance().checkEditModeV2(
                function () {
                    self.navigateIframeAngularForNewView( event, event_name );
                } );
            return;
        }
        switch ( event_name ) {
            case "navigate_new_hive":
                self.navigateIframeAngular( "/hive/" + SHINKEN.TOOLS.STRING.buildUUID() + "/new", event );
                break;
            case "navigate_new_list":
                self.navigateIframeAngular( "/list/" + SHINKEN.TOOLS.STRING.buildUUID() + "/new", event );
                break;
            case "navigate_new_weather":
                var _success  = function ( _status, data ) {
                    if ( data.rc === COMMUNICATION.CODE.SUCCESS ) {
                        self.navigate( "/service_weather/" + data[ "output" ][ "info_after_creation" ][ "uuid" ], event );
                        CONTROLLER.Share.createShare( data, { uuid: data[ "output" ][ "info_after_creation" ][ "uuid" ], type: "service_weather" }, false );
                    }
                };
                var _errors_1 = function ( _status, data ) {
                    SHINKEN.TOOLS.NOTIFICATION.addNotification( _( "service_weather.add_new_weather_button.errors.cannot_create_new_service_weather", [DICTIONARY_COMMON_UI] ), SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.ERROR );
                };
                SHINKEN.COMUNICATION.requestPost( SHINKEN.COMUNICATION.CONST.QUERY.POST.WEATHER.CREATION, "{}", _success, _errors_1, null, CONTROLLER.UiVisualisation.callbackAfter401 );
                break;
        }
    };
    self.openUiPanelManager              = function ( event, type ) {
        if ( SHINKEN.HIGHWAY.getNavigationType( event ) === SHINKEN.HIGHWAY.CONST.NAVIGATION_TYPE.NONE ) {
            return;
        }
        MANAGER.__instance_window_modal_manager = new MANAGER.WindowModalManager();
        MANAGER.__instance_window_modal_manager.showCloseContainer();
        MANAGER.__instance_window_modal_manager.addClass( "shinken-modal-view-panel" );
        MANAGER.__instance_window_modal_manager.setIframeID( "id-shinken-ui-view-manager" );
        MANAGER.__instance_window_modal_manager.addCloseEvent( "ask-for-pop-up-close-event", self );
        let iframe_url = "/" + CONTROLLER.CONST.UI_PANELS.NAME + "?type=" + type;
        if ( SHINKEN.HIGHWAY.isDocumentationOn() ) {
            iframe_url += "&shinken_documentation=" + __shinken_documentation_value__;
        }
        MANAGER.__instance_window_modal_manager.setIframe( iframe_url );
        self.refresh();
    };
    self.isDefaultView                   = function () {
        return !!self._is_default_view_on;
    };
    self.init                            = function () {
        self._min_width_responsive_navbar                       = 0;
        self.message_out_of_synchro                             = undefined;
        self.__dom_container_navbar                             = document.querySelector( ".shinken-main-nav-bar-table" );
        self.__dom_container_gap_time                           = document.getElementById( "id-shinken-gap-time-container" );
        self.__dom_remaning_cell                                = self.__dom_container_navbar.querySelector( '.shinken-remaining-cell' );
        self.__dom_container_add_to_favorite_button             = self.__dom_remaning_cell.querySelector( '.shinken-add-favorite-container' );
        self.__dom_shinken_cell_add_favorite                    = self.__dom_remaning_cell.querySelector( '.shinken-cell-add-favorite' );
        self.__dom_shinken_favorite_container                   = self.__dom_remaning_cell.querySelector( '.shinken-favorite-container' );
        self.__dom_icon_default_view_btn                        = self.__dom_container_navbar.querySelector( '.icon-default-view-btn' );
        self.__dom_container_architecture_export_menu           = document.getElementById( 'id-shinken-architecture-export-menu-container' );
        self.__dom_container_architecture_export_menu_collapsed = document.getElementById( 'id-shinken-architecture-export-menu-collapsed-container' );
        self.__dom_architecture_export_menu_button              = document.getElementById( 'id-shinken-architecture-export-button' );
        self.__dom_architecture_export_menu_button_collapsed    = document.getElementById( 'id-shinken-architecture-export-button-collapsed' );
        self.__dom_service_weather_menu_button                  = document.getElementById( 'id-shinken-service-weather-button-expanded-in-nav-bar' );
        self.__dom_service_weather_menu_button_collasped        = document.getElementById( 'id-shinken-service-weather-button-collapsed-in-nav-bar' );
        self.__dom_event_menu_button                            = document.getElementById( 'id-shinken-event-container-button-expanded-in-nav-bar' );
        self.__dom_event_menu_button_collasped                  = document.getElementById( 'id-shinken-event-container-button-collapsed-in-nav-bar' );
        self.button_menu_is_collapsed                           = false;
        self.license_is_collapsed                               = false;
        self.gap_time_is_collapsed                              = true;
        self.__dom_container_gap_time_is_computed               = false;
        self.initServiceWeatherMenu();
        self.computeAfterResize();
        self.__is_for_shinken_documentation = SHINKEN.HIGHWAY.getParams( "shinken_documentation" );
    };
    self.initWhenUserSet                 = function () {
        document.querySelector( ".shinken-main-nav-bar-table" ).classList.remove( "shinken-hidden" );
        CONTROLLER.UiVisualisation.current_user.computeEllipsisLogoutButton();
    };
    self.initServiceWeatherMenu          = function () {
        self.object_menu_weather_expanded_1        = new SHINKEN.OBJECT.CounterInterface();
        self.object_menu_weather_expanded_1.errors = new SHINKEN.OBJECT.Counter( self.__dom_container_navbar.querySelector( '#id-shinken-service-weather-button-expanded-in-nav-bar .shinken-total-view-problems_1 .shinken-error-counter' ) );
        
        self.object_menu_weather_expanded_2        = new SHINKEN.OBJECT.CounterInterface();
        self.object_menu_weather_expanded_2.total  = new SHINKEN.OBJECT.Counter( self.__dom_container_navbar.querySelector( '#id-shinken-service-weather-button-expanded-in-nav-bar .shinken-total-view .shinken-window-total-counter' ) );
        self.object_menu_weather_expanded_2.errors = new SHINKEN.OBJECT.Counter( self.__dom_container_navbar.querySelector( '#id-shinken-service-weather-button-expanded-in-nav-bar .shinken-total-view-problems_2 .shinken-error-counter' ) );
        
        self.object_menu_weather_collapsed_1        = new SHINKEN.OBJECT.CounterInterface();
        self.object_menu_weather_collapsed_1.errors = new SHINKEN.OBJECT.Counter( self.__dom_container_navbar.querySelector( '#id-shinken-service-weather-button-collapsed-in-nav-bar .shinken-total-view-problems-collapsed_1 .shinken-error-counter' ) );
        
        self.object_menu_weather_collapsed_2        = new SHINKEN.OBJECT.CounterInterface();
        self.object_menu_weather_collapsed_2.total  = new SHINKEN.OBJECT.Counter( self.__dom_container_navbar.querySelector( '#id-shinken-service-weather-button-collapsed-in-nav-bar .shinken-total-view-collapsed .shinken-window-total-counter' ) );
        self.object_menu_weather_collapsed_2.errors = new SHINKEN.OBJECT.Counter( self.__dom_container_navbar.querySelector( '#id-shinken-service-weather-button-collapsed-in-nav-bar .shinken-total-view-problems-collapsed_2 .shinken-error-counter' ) );
    };
    self.refresh                         = function () {
        self.updateServiceWeatherMenu();
        self.updateEventTubMenu();
    };
    self.computeAfterResize              = function () {
        if ( !self.needACollapse() ) {
            self.button_menu_is_collapsed = false;
        }
        else {
            self.gap_time_is_collapsed = true;
            self.license_is_collapsed  = true;
        }
        if ( !self.button_menu_is_collapsed ) {
            DOM.Service.addOrRemoveClasses( self.__dom_container_navbar, false, "shinken-navbar-collapsed-menu-activated" );
        }
        CONTROLLER.License.computeAfterResize();
        self.computeAfterResizeGapTime();
        if ( self.needACollapse() ) {
            DOM.Service.addOrRemoveClasses( self.__dom_container_navbar, true, "shinken-navbar-collapsed-menu-activated" );
            self.button_menu_is_collapsed = true;
        }
        if ( self.dropdown_configuration_user ) {
            self.dropdown_configuration_user.computeAfterResize();
        }
        if ( self.dropdown_add_favorite ) {
            self.dropdown_add_favorite.computeAfterResize();
        }
    };
    self.needACollapse                   = function () {
        var _width_nav_bar = DOM.Service.getBoundingClientRect( self.__dom_container_navbar, DOM.CONST.STYLE.WIDTH );
        return _width_nav_bar > window.innerWidth;
    };
    self.setLocalTime                    = function ( time_stamp_backend ) {
        var _diff                   = Math.round( (Date.now() / 1000) - time_stamp_backend );
        self.message_out_of_synchro = Math.abs( _diff ) > 30 ? DATE_TIME.durationToString( _diff * 1000, true, 4, true ) : "";
        self.buildGapTimeHtml();
    };
    self.computeAfterResizeGapTime       = function () {
        if ( self.__dom_container_gap_time_is_computed ) {
            if ( self.license_is_collapsed ) {
                self.gap_time_is_collapsed = true;
                DOM.Service.addOrRemoveClasses( self.__dom_container_gap_time, self.gap_time_is_collapsed, "shinken-gap-time-collapsed" );
                return;
            }
            var _need_collapse = self.needACollapse();
            if ( !self.button_menu_is_collapsed && !_need_collapse ) {
                self.gap_time_is_collapsed = false;
            }
            if ( self.__dom_container_gap_time.querySelector( ".shinken-backend-gap-full" ).classList.contains( "shinken-open-popup" ) && _need_collapse ) {
                self.gap_time_is_collapsed = true;
            }
            DOM.Service.addOrRemoveClasses( self.__dom_container_gap_time, self.gap_time_is_collapsed, "shinken-gap-time-collapsed" );
            if ( self.needACollapse() ) {
                self.gap_time_is_collapsed = true;
            }
            DOM.Service.addOrRemoveClasses( self.__dom_container_gap_time, self.gap_time_is_collapsed, "shinken-gap-time-collapsed" );
        }
        
    };
    self.buildGapTimeHtml                = function () {
        if ( !self.message_out_of_synchro ) {
            self.__dom_container_gap_time.classList.add( "shinken-hidden" );
            return;
        }
        self.__dom_container_gap_time.classList.remove( "shinken-hidden" );
        
        if ( !self.__dom_container_gap_time_is_computed ) {
            var _to_return      = DOM.Service.createElement( "div", { class: "shinken-backend-gap-container" } );
            var _to_return_full = DOM.Service.createElement( "div", { class: "shinken-backend-gap-full" } );
            _to_return_full.appendChild( DOM.Service.createElement( "span", { class: "shinkon shinkon-clock" } ) );
            _to_return_full.appendChild( DOM.Service.createElement( "span", { class: "shinken-label" }, _( 'gap_time.backendOutSynch', [DICTIONARY_COMMON_UI] ) ) );
            _to_return_full.appendChild( DOM.Service.createElement( "div", { class: "shinken-message" }, "-- " + self.message_out_of_synchro + " --" ) );
            var _to_return_light = DOM.Service.createElement( "div", { class: "shinken-backend-gap-light", onclick: "MANAGER.EventManager.clickOnButton(event)", "data-name": "gap-time-toggle" } );
            _to_return_light.appendChild( DOM.Service.createElement( "div", { class: "shinkon shinkon-clock" } ) );
            _to_return_light.appendChild( DOM.Service.createElement( "div", { class: "shinken-label" }, _( 'gap_time.backendOutSynchShort', [DICTIONARY_COMMON_UI] ) ) );
            
            _to_return.appendChild( _to_return_light );
            _to_return.appendChild( _to_return_full );
            self.__dom_container_gap_time.innerHTML = _to_return.outerHTML;
            DOM.Service.addOrRemoveClasses( self.__dom_container_gap_time, self.gap_time_is_collapsed, "shinken-gap-time-collapsed" );
            self.__dom_container_gap_time_is_computed = true;
        }
        else {
            self.__dom_container_gap_time.querySelector( ".shinken-backend-gap-full .shinken-message" ).innerHTML = "-- " + self.message_out_of_synchro + " --";
        }
    };
    self.validateForm                    = function ( param ) {
        switch ( param[ SHINKEN.OBJECT.FORMSET.PARAM.FORM_NAME ] ) {
            case SHINKEN.UI.ADD_TO_FAVORITE.FORM_NAME:
                if ( CONTROLLER.Form.isValid() ) {
                    let _data = param[ SHINKEN.OBJECT.FORMSET.PARAM.FORM_OBJECT ].getDataToSave__20241114();
                    if ( _data[ SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.TYPE_OF_FAVORITE._KEY ] === WINDOW.ADD_TO_FAVORITE.TABS[ WINDOW.ADD_TO_FAVORITE.INDEX_TAB.CREATE_LINK ].name ) {
                        CONTROLLER.Share.createShare( _data, CONTROLLER.UiVisualisation.current_view, true );
                    }
                    else if ( _data[ SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.TYPE_OF_FAVORITE._KEY ] === WINDOW.ADD_TO_FAVORITE.TABS[ WINDOW.ADD_TO_FAVORITE.INDEX_TAB.CREATE_COPY ].name ) {
                        self.createCloneFromAddFavorite( _data, CONTROLLER.UiVisualisation.current_view );
                    }
                    else {
                        console.shinken.debug( "FORM VALIDATION FAILS", "WRONG DATA FORMAT", _data );
                    }
                    self.dropdown_add_favorite.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                }
                break;
        }
    };
    self.createCloneFromAddFavorite      = function ( form_data, view ) {
        let _success = function ( _status, data ) {
            let uuid = view.type === SHINKEN.SCREEN.TYPE.SERVICE_WEATHER ? data.output[ "information_on_clone" ][ "uuid" ] : data.uuid;
            CONTROLLER.Share.createShare( form_data, {
                uuid           : uuid,
                type           : view.type,
                is_root_problem: view.is_root_problem
            }, false );
        };
        let _data;
        let _url;
        switch ( view.type ) {
            case SHINKEN.SCREEN.TYPE.HIVE:
                _url  = SHINKEN.COMUNICATION.CONST.QUERY.POST.HIVE.KEY + view.getUUID() + SHINKEN.COMUNICATION.CONST.QUERY.POST.HIVE.CLONE;
                _url += "?user_uuid=" + CONTROLLER.UiVisualisation.current_user.getUUID();
                _data = { "name": form_data.name };
                break;
            case SHINKEN.SCREEN.TYPE.LIST:
                let data_view = SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).EXTERNAL.COMMUNICATION.getViewDataToSave();
                _url          = SHINKEN.COMUNICATION.CONST.QUERY.POST.LIST.CLONE;
                _url += "?user_uuid=" + CONTROLLER.UiVisualisation.current_user.getUUID();
                _data         = { "form_data": form_data, "data_view": data_view };
                break;
            case SHINKEN.SCREEN.TYPE.SERVICE_WEATHER:
                _url  = SHINKEN.COMUNICATION.CONST.QUERY.POST.WEATHER.CLONE;
                _data = {
                    "info_on_weather_to_clone" : {
                        "uuid": view.uuid
                    },
                    "info_on_weather_to_create": {
                        "name": form_data.name
                    }
                };
                break;
            default :
                break;
        }
        SHINKEN.COMUNICATION.requestPostJSON( _url, JSON.stringify( _data ), _success );
        
    };
    self.closeModal                      = function ( is_forced ) {
        if ( MANAGER.__instance_window_modal_manager && MANAGER.__instance_window_modal_manager.is_open ) {
            if ( is_forced ) {
                MANAGER.__instance_window_modal_manager.close();
            }
            else {
                MANAGER.__instance_window_modal_manager.askDoClose();
            }
        }
    };
    self.hide                            = function () {
        DOM.Service.empty( self.__dom_container_navbar );
        DOM.BodyService.askAddClass( "shinken-not-authenticate" );
        self.closeModal( true );
    };
    self.updateWithInfoFromUrl           = function () {
        self.updateAddToFavoriteButton();
        self.updateDefaultButton();
    };
    self.updateAddToFavoriteButton       = function () {
        if ( !CONTROLLER.UiVisualisation.current_view ) {
            return;
        }
        CONTROLLER.UiVisualisation.current_view.updateAddToFavoriteButton();
        DOM.Service.addOrRemoveClasses( self.__dom_shinken_cell_add_favorite, !CONTROLLER.UiVisualisation.current_view.isDisplay__AddButton(), "shinken-hidden" );
        DOM.Service.addOrRemoveClasses( self.__dom_container_add_to_favorite_button, CONTROLLER.UiVisualisation.current_view.isDisabled__AddButton(), "shinken-disabled-favorite" );
        this.__dom_shinken_favorite_container.setAttribute( "shi-tip-text", CONTROLLER.UiVisualisation.current_view.getTooltip__AddButton() );
        self.computeAfterResize();
    };
    self.updateDefaultButton             = function () {
        var _show_default_button = true;
        switch ( CONTROLLER.UiVisualisation.active_view ) {
            case SHINKEN.SCREEN.TYPE.VIEW360:
            case SHINKEN.SCREEN.TYPE.IMPACTS:
            case SHINKEN.SCREEN.TYPE.REPORTING:
            case SHINKEN.SCREEN.TYPE.REPORTING_WEB:
                _show_default_button = false;
                break;
            default:
                break;
        }
        DOM.Service.addOrRemoveClasses( self.__dom_icon_default_view_btn, !_show_default_button, "shinken-hidden" );
        self.computeAfterResize();
    };
    self.askUpdateArchitectureExportMenu = function ( shinken_servers ) {
        if ( self._timeout_update_architecture_menu ) {
            clearTimeout( self._timeout_update_architecture_menu );
        }
        self._timeout_update_architecture_menu = setTimeout( function () {
            self.updateArchitectureExportMenu( shinken_servers );
            
            self._timeout_update_architecture_menu = null;
        }, 0 );
    };
    self.updateArchitectureExportMenu    = function ( shinken_servers ) {
        if ( CONTROLLER.UiVisualisation.current_user.isAdmin() && shinken_servers.hasServers() ) {
            shinken_servers.computeHtml();
            DOM.Service.empty( self.__dom_container_architecture_export_menu );
            DOM.Service.empty( self.__dom_container_architecture_export_menu_collapsed );
            self.__dom_architecture_export_menu_button.classList.remove( "shinken-hidden" );
            self.__dom_architecture_export_menu_button_collapsed.classList.remove( "shinken-hidden" );
            for ( var i = 0, _size_i = shinken_servers.size; i < _size_i; i++ ) {
                DOM.Service.addElementTo( shinken_servers.list[ i ].dom_element, self.__dom_container_architecture_export_menu );
                DOM.Service.addElementTo( DOM.Service.cloneElement( shinken_servers.list[ i ].dom_element ), self.__dom_container_architecture_export_menu_collapsed );
            }
        }
        else {
            self.__dom_architecture_export_menu_button.classList.add( "shinken-hidden" );
            self.__dom_architecture_export_menu_button_collapsed.classList.add( "shinken-hidden" );
        }
    };
    self.updateServiceWeatherMenu        = function () {
        const weather_module_is_activated = CONTROLLER.UiVisualisation.current_user.hasServiceWeatherModule();
        DOM.Service.addOrRemoveClasses( self.__dom_service_weather_menu_button, !weather_module_is_activated, "shinken-hidden" );
        DOM.Service.addOrRemoveClasses( self.__dom_service_weather_menu_button_collasped, !weather_module_is_activated, "shinken-hidden" );
        if ( !CONTROLLER.UiVisualisation.current_user.isAdmin() || !weather_module_is_activated ) {
            return;
        }
        if ( self.last_basics_stats_call_timestamp && self.last_basics_stats_call_timestamp + 10 * DATE_TIME.FORMAT.TIME_PERIOD.SECONDE.NB_MS > DATE_TIME.getTimestampNow() ) {
            return;
        }
        var _success                          = function ( _status, data ) {
            if ( !__current_user_has_editable_right_service_weather__ ) {
                return;
            }
            let _weather_with_issues = data[ "output" ][ "weather_with_issues" ];
            let _nb_weathers         = data[ "output" ][ "nb_weathers" ];
            
            DOM.Service.addOrRemoveClasses( self.__dom_service_weather_menu_button, _weather_with_issues, "shinken-service-weather-with-issues" );
            DOM.Service.addOrRemoveClasses( self.__dom_service_weather_menu_button_collasped, _weather_with_issues, "shinken-service-weather-with-issues" );
            
            self.object_menu_weather_expanded_1.setError( "object_menu_weather_expanded_1", _weather_with_issues );
            self.object_menu_weather_expanded_2.setTotal( "object_menu_weather_expanded_2", _nb_weathers );
            self.object_menu_weather_expanded_2.setError( "object_menu_weather_expanded_2", _weather_with_issues );
            
            self.object_menu_weather_collapsed_1.setError( "object_menu_weather_collapsed_1", _weather_with_issues );
            self.object_menu_weather_collapsed_2.setTotal( "object_menu_weather_collapsed_2", _nb_weathers );
            self.object_menu_weather_collapsed_2.setError( "object_menu_weather_collapsed_2", _weather_with_issues );
        };
        var _errors_funct                     = function ( _status, data ) {
            console.error( _status, data );
        };
        self.last_basics_stats_call_timestamp = DATE_TIME.getTimestampNow();
        SHINKEN.COMUNICATION.requestGet( SHINKEN.COMUNICATION.CONST.QUERY.GET.WEATHER.BASIC_STATISTICS, _success, _errors_funct, null, CONTROLLER.UiVisualisation.callbackAfter401 );
    };
    self.updateEventTubMenu              = function () {
        DOM.Service.addOrRemoveClasses( self.__dom_event_menu_button, !CONTROLLER.UiVisualisation.current_user.hasEventTubModule(), "shinken-hidden" );
        DOM.Service.addOrRemoveClasses( self.__dom_event_menu_button_collasped, !CONTROLLER.UiVisualisation.current_user.hasEventTubModule(), "shinken-hidden" );
    };
    self.closeAllBoostrapPopups          = function ( event_name ) {
        if ( event_name === "click-menu-bootstrap" ) {
            return;
        }
        var doms = self.__dom_container_navbar.querySelectorAll( '.open' );
        for ( var i = 0, _size = doms.length; i < _size; i++ ) {
            doms[ i ].classList.remove( 'open' );
        }
    };
    
    return self;
})( CONTROLLER.NavigationBar || {} );
CONTROLLER.Share = (function ( self ) {
    self.controller_name        = CONTROLLER.CONST.SHARE.NAME;
    self.shares                 = null;
    self.share_data             = null;
    self.share_data_used        = false;
    self.doActionAfter          = function ( event_name, param ) {
        switch ( event_name ) {
            case "load_shares_data_from_angular":
                param = self.loadSharesFromAngular( param );
                CONTROLLER.NavigationBar.doActionAfter( event_name );
                return param;
        }
    };
    self.loadSharesFromAngular  = function ( param ) { //WARNING OVERRIDE IN DOCUMENTATION
        self.share_data      = param;
        self.share_data_used = false;
        return param;
    };
    self.createShare            = function ( form_data, view, is_reference ) {
        self.loadShares( function success () {
            var _data                                                           = {};
            _data[ SHINKEN.UI.SHARE.PARAM.UUID._KEY ]                           = SHINKEN.TOOLS.STRING.buildUUID();
            _data[ SHINKEN.UI.SHARE.PARAM.KIND._KEY ]                           = SHINKEN.UI.SHARE.PARAM.KIND.VALUE.ELEMENT;
            _data[ SHINKEN.UI.SHARE.PARAM.CREATED_ON._KEY ]                     = DATE_TIME.getTimestampNow_format_sec();
            _data[ SHINKEN.UI.SHARE.PARAM.LAST_MODIFIED_ON._KEY ]               = _data[ SHINKEN.UI.SHARE.PARAM.CREATED_ON._KEY ];
            _data[ SHINKEN.UI.SHARE.PARAM.SCREEN_IS_REFERENCE._KEY ]            = is_reference;
            _data[ SHINKEN.UI.SHARE.PARAM.NAME._KEY ]                           = form_data[ SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.NAME._KEY ] || _( "service_weather.weathers.default_name", [DICTIONARY_COMMON_UI] );
            _data[ SHINKEN.UI.SHARE.PARAM.TYPE._KEY ]                           = form_data[ SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.SPACE_SHARE._KEY ] || _( "service_weather.weathers.personal", [DICTIONARY_COMMON_UI] );
            _data[ SHINKEN.UI.SHARE.PARAM.INDEX._KEY ]                          = -1;
            var _screen                                                         = {};
            _screen[ SHINKEN.UI.SHARE.PARAM.SCREEN.PARAM.UUID._KEY ]            = view.uuid || view.getUUID();
            _screen[ SHINKEN.UI.SHARE.PARAM.SCREEN.PARAM.TYPE._KEY ]            = view.type || view.getType();
            _screen[ SHINKEN.UI.SHARE.PARAM.SCREEN.PARAM.IS_ROOT_PROBLEM._KEY ] = view.is_root_problem;
            _data[ SHINKEN.UI.SHARE.PARAM.SCREEN._KEY ]                         = _screen;
            var _state                                                          = {};
            _state[ SHINKEN.UI.SHARE.PARAM.STATE.PARAM.REMOVED._KEY ]           = false;
            _data[ SHINKEN.UI.SHARE.PARAM.STATE._KEY ]                          = _state;
            var _owner                                                          = {};
            _owner[ SHINKEN.UI.SHARE.PARAM.OWNER.PARAM.UUID._KEY ]              = CONTROLLER.UiVisualisation.current_user.getUUID();
            _owner[ SHINKEN.UI.SHARE.PARAM.OWNER.PARAM.NAME._KEY ]              = CONTROLLER.UiVisualisation.current_user.getName();
            _data[ SHINKEN.UI.SHARE.PARAM.OWNER._KEY ]                          = _owner;
            
            if ( form_data[ SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.GROUP_SHARE._KEY ] ) {
                var _group                                             = {};
                _group[ SHINKEN.UI.SHARE.PARAM.GROUP.PARAM.UUID._KEY ] = form_data[ SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.GROUP_SHARE._KEY ];
                _data[ SHINKEN.UI.SHARE.PARAM.GROUP._KEY ]             = _group;
            }
            if ( form_data[ SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.FOLDER_SHARE._KEY ] && form_data[ SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.FOLDER_SHARE._KEY ] !== SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.FOLDER_SHARE.OPTION.NONE ) {
                var _parent                                              = {};
                _parent[ SHINKEN.UI.SHARE.PARAM.PARENT.PARAM.UUID._KEY ] = form_data[ SHINKEN.UI.ADD_TO_FAVORITE.PROPERTIES.FOLDER_SHARE._KEY ];
                _data[ SHINKEN.UI.SHARE.PARAM.PARENT._KEY ]              = _parent;
            }
            var _to_create = new SHINKEN.UI.ShareView( _data );
            _to_create.create( function () {
                SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).EXTERNAL.COMMUNICATION.doAction( "an_favorite_has_been_created", _to_create );
                if ( !is_reference ) {
                    CONTROLLER.NavigationBar.navigateTo( null, view.uuid, view.type );
                }
            } );
        } );
    };
    self.isScreenUnValid_ByData = function ( screen_uuid ) {
        for ( let i = 0, _size_i = this.share_data.length; i < _size_i; i++ ) {
            if ( this.share_data[ i ].screen && this.share_data[ i ].screen.uuid === screen_uuid ) {
                if ( this.share_data[ i ].screen.state && this.share_data[ i ].screen.state.not_found ) {
                    return true;
                }
            }
        }
        return false;
    };
    self.getFolderForSpace      = function ( space_name, group_name ) {
        self.loadShares();
        return self.shares.getFolderForSpace( space_name, group_name );
    };
    self.init                   = function () {
    };
    self.loadShares             = function ( callback_success ) {
        if ( !self.share_data_used ) {
            self.shares = new SHINKEN.UI.ShareSet();
            self.shares.updateData( self.share_data );
            self.share_data_used = true;
        }
        if ( callback_success ) {
            callback_success();
        }
        return self.shares;
    };
    return self;
})( CONTROLLER.Share || {} );
CONTROLLER.ShinkenView = (function ( self ) {
    self.controller_name    = CONTROLLER.CONST.SHINKEN_VIEW.NAME;
    self.onClick            = function ( event ) {
        if ( self.dropdown_configuration_shinken_view ) {
            self.dropdown_configuration_shinken_view.onClick( event );
        }
    };
    self.doActionAfter      = function ( event_name, param ) {
        switch ( event_name ) {
            case "edit_shinken_view_configuration":
                if ( self.dropdown_configuration_shinken_view ) {
                    if ( self.dropdown_configuration_shinken_view.shinken_view.uuid !== param.shinken_view.uuid ) {
                        self.dropdown_configuration_shinken_view.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                        self.dropdown_configuration_shinken_view = null;
                    }
                }
                if ( !self.dropdown_configuration_shinken_view ) {
                    self.dropdown_configuration_shinken_view = new SHINKEN.OBJECT.Dropdown.ConfigurationShinkenView( param );
                    self.dropdown_configuration_shinken_view.initDomElement();
                }
                else {
                    self.dropdown_configuration_shinken_view.setDomTargetElement( param.dom_element );
                }
                self.dropdown_configuration_shinken_view.togglePhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING, SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                break;
            case "use_radio_btn_configuration_notification_blink":
            case "radio_btn_configuration_notification_sound_clicked":
                self.dropdown_configuration_shinken_view.doActionAfter( event_name, param );
                break;
        }
    };
    self.computeAfterResize = function () {
        if ( self.dropdown_configuration_shinken_view ) {
            self.dropdown_configuration_shinken_view.computeAfterResize();
        }
    };
    
    self.init          = function () {
    };
    self.reset         = function () {
        self.dropdown_configuration_shinken_view = null;
    };
    self.resetIfNeeded = function ( screen ) {
        if ( self.dropdown_configuration_shinken_view ) {
            if ( !screen || screen.uuid !== self.dropdown_configuration_shinken_view.shinken_view.uuid ) {
                self.reset();
            }
        }
    };
    
    
    return self;
})( CONTROLLER.ShinkenView || {} );
var doActionWhenDomReady = function ( e ) {
    CONTROLLER.UiVisualisation.init();
    window.addEventListener( 'resize', function () {
        CONTROLLER.UiVisualisation.computeAfterResize();
    }, true );
};
CONTROLLER.UiVisualisation = (function ( self ) {
    self.controller_name                 = CONTROLLER.CONST.UI_VISUALISATION.NAME;
    self.timeout_resize                  = null;
    self.current_user                    = null;
    self.doActionAfter                   = function ( event_name, param, extra_param ) {
        switch ( event_name ) {
            case "js_version_is_outdated":
                SHINKEN.HIGHWAY.refreshCurrentPage();
                break;
            case "click_on_button":
            case "click_on_button_V3":
            case "click_on_radio_button_V3":
                switch ( param[ SHINKEN.OBJECT.FORMSET.PARAM.FORM_NAME ] ) {
                    case SHINKEN.UI.ADD_TO_FAVORITE.FORM_NAME:
                        CONTROLLER.NavigationBar.doActionAfter( event_name, param );
                        break;
                }
                break;
            case "get_documentation_value":
                return __shinken_documentation_values__;
            case "action_on_view_done":
                switch ( param.results[ 0 ].key ) {
                    case SHINKEN.UI.VIEW.ACTIONS.CLONE_VIEW:
                    case SHINKEN.UI.VIEW.ACTIONS.RESTORED:
                        SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).EXTERNAL.COMMUNICATION.doAction(
                            "create_share_angular", { screen: { type: param.type, uuid: param.uuid, name: param.results[ 0 ].view_name }, "action_name": param.results[ 0 ].key } );
                        break;
                }
                break;
            case "ask_to_refresh_current_view":
            case "user_rights_to_see_current_view_has_changed":
                CONTROLLER.NavigationBar.doActionAfter( event_name, param );
                break;
            case "mode_edit_on_has_changed":
                self.computeIsIframeEditOn();
                CONTROLLER.NavigationBar.doActionAfter( event_name, param );
                break;
            case "iframe_grid_page_view_has_been_refreshed":
                SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).EXTERNAL.COMMUNICATION.doAction( "weather_view_is_on_screen" ); // TODO regarder si c'est vraiment utile a quelque chose
                break;
            case "iframe_view_has_been_refreshed":
            case "ask_for_refresh_after_save":
                self.refresh();
                break;
            case "click_on_iframe":
                self.onClick( param, event_name );
                break;
            case "login-success-on-iframe":
                DOM.Service.removeElement( document.getElementById( "id-shinken-iframe-for-ui-visualisation" ) );
                SHINKEN.HIGHWAY.refreshCurrentPage();
                break;
            case "raise-error-401":
                CONTROLLER.NavigationBar.hide();
                var _iframe = document.getElementById( "id-shinken-iframe-for-ui-visualisation" );
                _iframe.setAttribute( "src", "/login" );
                break;
            case "raise-error-403":
                SHINKEN.HIGHWAY.refreshCurrentPage();
                break;
            case "save-panel-done":
            case "save-view-done":
            case "controller-start-init":
            case "ask-for-pop-up-close-accepted":
            case "ask-for-pop-up-close-refused":
            case "navigate_to_default_view":
            case "current_view_has_been_deleted":
                CONTROLLER.NavigationBar.doActionAfter( event_name, param );
                break;
            case "update_screen_with_view_behaviour":
                if ( self.screen ) {
                    self.screen.view_behaviour = param;
                }
                CONTROLLER.NavigationBar.doActionAfter( event_name, param );
                break;
            case "update_screen_phase":
                self.screen.screen_phase = param;
                CONTROLLER.NavigationBar.doActionAfter( event_name, param );
                break;
            case "change_value_notification_of_change_sound":
            case "change_value_notification_of_change_visual_blink":
                self.current_user.doActionAfter( event_name, param );
                if ( self.isViewWithNotification() ) {
                    SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).EXTERNAL.COMMUNICATION.saveUserSinglePref(
                        "notifications_of_change", self.current_user.getPrefs()[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NOTIFICATION_OF_CHANGE.NAME ].getDataToSave()
                    );
                    SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).EXTERNAL.COMMUNICATION.doAction(
                        "do_angular_broadcast", { broad_cast_event: "UI_VISUALISATION_CONTROLLER_ASK_FOR_COMPUTE_NOTIFICATION_OF_CHANGE", [ CONTROLLER.CONST.PARAM_EVENT.CONTROLLER_OBJECT ]: this } );
                    self.updateNotificationCurrentUser();
                }
                break;
            case "edit_shinken_view_configuration":
                CONTROLLER.ShinkenView.doActionAfter( event_name, param );
                break;
            case "init_default_notifications_settings":
                this.default_notifications_of_changed = new SHINKEN.OBJECT.NotificationsOfChangeDefaultValues( param );
                break;
            case "click-menu-bootstrap":
                self.onClick( param, event_name );
                break;
            case "click_done_on_parent":
                switch ( CONTROLLER.UiVisualisation.active_view ) {
                    case SHINKEN.SCREEN.TYPE.VIEW360:
                    case SHINKEN.SCREEN.TYPE.IMPACTS:
                    case SHINKEN.SCREEN.TYPE.REPORTING:
                    case SHINKEN.SCREEN.TYPE.REPORTING_WEB:
                        break;
                    default:
                        SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).EXTERNAL.COMMUNICATION.doAction(
                            "do_angular_broadcast", { broad_cast_event: "ASK_TO_CLOSE_POPUPS" } );
                        break;
                }
                break;
            case "click_on__window_navigation__done":
                switch ( param[ WINDOW_V2.CONST.PARAM.WINDOW_GROUP_NAME ] ) {
                    case WINDOW.ADD_TO_FAVORITE.NAME_GROUP:
                        CONTROLLER.NavigationBar.doActionAfter( event_name, param );
                        break;
                    default:
                        break;
                }
                break;
            case "set_weather_current_screen_name":
                if ( self.screen ) {
                    self.screen.setName( param );
                }
                if ( self.current_view ) {
                    self.current_view.setName( param );
                }
                self.updateTitlePage( param );
                break;
            case "load_shares_data_from_angular":
                return CONTROLLER.Share.doActionAfter( event_name, param, extra_param );
            case "load_grid_data_from_angular" :
                return self.loadGridDataFromAngular( param );
        }
    };
    self.loadGridDataFromAngular         = function ( param ) { //WARNING OVERRIDE IN DOCUMENTATION
        return param;
    };
    self.getFromParent                   = function ( name ) {
        switch ( name ) {
            case "current_view":
            case "current_user":
                return self[ name ];
        }
        return null;
    };
    self.navigateTo                      = function ( event, screen_uuid, screen_type ) {
        CONTROLLER.NavigationBar.navigateTo( event, screen_uuid, screen_type );
    };
    self.onClick                         = function ( event, event_name ) {
        CONTROLLER.NavigationBar.onClick( event, event_name );
        CONTROLLER.ShinkenView.onClick( event, event_name );
        switch ( event_name ) {
            case "click_done_on_parent":
            case "click-menu-bootstrap":
            case "toggle_configuration_user_setting_interface":
            case "toggle_add_to_favorite_form":
                self.doActionAfter( "click_done_on_parent" );
                break;
        }
    };
    self.clickOnInput                    = function ( event ) {
    };
    self.onChangeOnInput                 = function ( event, event_name, param ) {
        switch ( event_name ) {
            case "use_slider_configuration_user_notification_volume":
            case "use_slider_configuration_user_notification_volume_oninput":
                CONTROLLER.NavigationBar.onChangeOnInput( event, event_name, param );
                break;
        }
    };
    self.clickOnSelector                 = function ( event, event_name, param ) {
        CONTROLLER.NavigationBar.clickOnSelector( event, event_name, param ); //FOR THE MOMENT ONLY THE SELECTOR IN ADD FAVORITE
    };
    self.clickOnItemSelector             = function ( event, element ) {
        CONTROLLER.NavigationBar.clickOnItemSelector( event, element ); //FOR THE MOMENT ONLY THE SELECTOR IN ADD FAVORITE
    };
    self.clickOnRadioBtn                 = function ( event, event_name, param ) {
        switch ( event_name ) {
            case "use_radio_btn_configuration_notification_blink":
            case "radio_btn_configuration_notification_sound_clicked":
                if ( self.isDropdownConfigurationUser( event ) ) {
                    CONTROLLER.NavigationBar.doActionAfter( event_name, param );
                }
                else {
                    CONTROLLER.ShinkenView.doActionAfter( event_name, param );
                }
                SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).EXTERNAL.COMMUNICATION.doAction(
                    "do_angular_broadcast", { broad_cast_event: "UI_VISUALISATION_CONTROLLER_ASK_FOR_COMPUTE_NOTIFICATION_OF_CHANGE", [ CONTROLLER.CONST.PARAM_EVENT.CONTROLLER_OBJECT ] : this } );
                break;
        }
    };
    self.isDropdownConfigurationUser     = function ( event ) {
        var _dom_element = DOM.Service.findParentElementWithClass( event.target, "shinken-dropdown-container-configuration", 100 );
        return !_dom_element.classList.contains( "shinken-dropdown-container-shinken-view-configuration" );
    };
    self.clickOnButton                   = function ( event, event_name, param ) {
        switch ( event_name ) {
            case "gap-time-toggle":
            case "licence-toggle":
            case "navigate_default_hive":
            case "navigate_new_hive":
            case "navigate_default_list":
            case "navigate_default_root_problem_list":
            case "navigate_new_list":
            case "navigate_default_event_list":
            case "navigate_new_weather":
            case "navigate_manager_ui_weather":
            case "navigate_view_360":
            case "navigate_view_impacts":
            case "navigate_view_reporting":
            case "navigate_to_default_view":
            case "navigate_to_parent_view":
                self.onClick( event, event_name );
                CONTROLLER.NavigationBar.clickOnButton( event, event_name, param );
                break;
            case "toggle_add_to_favorite_form":
                self.onClick( event, event_name );
                CONTROLLER.NavigationBar.doActionAfter( event_name, param );
                break;
            case "close_form_container_favorite":
            case "submit_new_favorite":
            case "logout_via_button":
            case "use_default_value_for_sound_notification":
                CONTROLLER.NavigationBar.clickOnButton( event, event_name, param );
                break;
            case "toggle_configuration_user_setting_interface":
                CONTROLLER.NavigationBar.doActionAfter( event_name, param );
                self.onClick( event, event_name );
                break;
            case "save_current_view_as_default":
                self.current_user.clickOnDefaultView();
                break;
            case "click-on-open-view-external-urls-popup":
                CONTROLLER.UiViewWeatherManager.clickOnButton( event, event_name, param );
                break;
            case SHINKEN.UI.ADD_TO_FAVORITE.FORM_NAME:
                CONTROLLER.NavigationBar.clickOnButton( event, event_name, param );
                break;
        }
    };
    self.computeAfterResize              = function () {
        CONTROLLER.ShinkenView.computeAfterResize();
        CONTROLLER.NavigationBar.computeAfterResize();
    };
    self.mouseLeave                      = function ( event ) {
    };
    self.mouseEnter                      = function ( event ) {
    };
    self.init                            = function () {
        CONTROLLER.NavigationBar.init();
        CONTROLLER.KeyEvent.init();
        CONTROLLER.Share.init();
        self.current_user = new SHINKEN.ELEMENT.UiCurrentUser();
        self.current_user.getDataFromBackend();
    };
    self.initWhenUserSet                 = function () {
        CONTROLLER.NavigationBar.initWhenUserSet();
        self.initRefresh();
        self.initLicense();
    };
    self.initLicense                     = function () {
        CONTROLLER.License.init();
        window.onhashchange();
        setInterval( function () {
            CONTROLLER.License.checkLicense();
        }, 1800000 ); //30min
    };
    self.initRefresh                     = function () {
        setInterval( function () {
            CONTROLLER.UiVisualisation.refresh();
        }, 60000 );
    };
    self.refresh                         = function () {
        if ( self.last_basics_stats_call_timestamp && self.last_basics_stats_call_timestamp + 10 * DATE_TIME.FORMAT.TIME_PERIOD.SECONDE.NB_MS > DATE_TIME.getTimestampNow() ) {
            return;
        }
        self.last_basics_stats_call_timestamp = DATE_TIME.getTimestampNow();
        CONTROLLER.NavigationBar.refresh();
        switch ( self.active_view ) {
            case SHINKEN.SCREEN.TYPE.VIEW360:
            case SHINKEN.SCREEN.TYPE.IMPACTS:
            case SHINKEN.SCREEN.TYPE.REPORTING:
            case SHINKEN.SCREEN.TYPE.REPORTING_WEB:
                return;
        }
        try {
            SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).EXTERNAL.COMMUNICATION.doAction( "ask_for_refresh_share_only" );
        }
        catch ( e ) {
            console.error( "[UiVisualisation - refresh]", e );
            console.error( "[UiVisualisation - refresh]", "[refresh_share_not_possible" );
        }
    };
    self.updateTitlePage                 = function ( title_page ) {
        var _title_page = title_page || "";
        switch ( self.active_view ) {
            case SHINKEN.SCREEN.TYPE.VIEW360:
                _title_page = _( 'screens.360' );
                break;
            case SHINKEN.SCREEN.TYPE.IMPACTS:
                _title_page = _( 'screens.bizApp' );
                break;
            case SHINKEN.SCREEN.TYPE.REPORTING:
                _title_page = _( 'screens.reporting' );
                break;
            case SHINKEN.SCREEN.TYPE.SERVICE_WEATHER:
                break;
            case "login":
                break;
            default:
                if ( self.screen ) {
                    _title_page = self.screen.name;
                }
                break;
        }
        DOM.Service.setPageTitle( _title_page || "Shinken Enterprise" );
    };
    self.isViewWithNotification          = function () {
        switch ( self.active_view ) {
            case SHINKEN.SCREEN.TYPE.HIVE:
            case SHINKEN.SCREEN.TYPE.LIST:
            case SHINKEN.SCREEN.TYPE.LIST_ROOT_PROBLEM:
            case SHINKEN.SCREEN.TYPE.EVENT:
            case SHINKEN.SCREEN.TYPE.SERVICE_WEATHER:
                return true;
        }
        return false;
    };
    self.updateNotificationCurrentUser   = function () {
        self.updateNotificationOfSoundVolume();
        self.updateNotificationOfBlink();
    };
    self.updateNotificationOfSoundVolume = function () {
        if ( !this.default_notifications_of_changed ) {
            return;
        }
        var volume = self.current_user.getPref( SHINKEN.ELEMENT.USER.PARAM.PREFS.NOTIFICATION_OF_CHANGE.NAME ).getVolumeValue();
        if ( volume === SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT ) {
            volume = this.default_notifications_of_changed.users.getVolumeValue();
        }
        DOM.Service.addOrRemoveClasses( DOM.BodyService.getDomElement(), !volume, "shinken-notification-volume-is-muted" );
        SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).EXTERNAL.COMMUNICATION.doAction(
            "add_or_remove_class_to_body_element", { boolean: !volume, class: "shinken-notification-volume-is-muted" } );
    };
    self.updateNotificationOfBlink       = function () {
        if ( !this.default_notifications_of_changed ) {
            return;
        }
        var blink = self.current_user.getPref( SHINKEN.ELEMENT.USER.PARAM.PREFS.NOTIFICATION_OF_CHANGE.NAME ).getBlinkValue();
        if ( blink === SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT ) {
            blink = this.default_notifications_of_changed.users.getBlinkValue();
        }
        DOM.Service.addOrRemoveClasses( DOM.BodyService.getDomElement(), !blink, "shinken-notification-blink-is-disabled" );
        SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).EXTERNAL.COMMUNICATION.doAction(
            "add_or_remove_class_to_body_element", { boolean: !blink, class: "shinken-notification-blink-is-disabled" } );
    };
    self.setLocalTime                    = function ( time_stamp_backend ) {
        CONTROLLER.NavigationBar.setLocalTime( time_stamp_backend );
    };
    self.setUserData                     = function ( data_user ) {
        self.current_user.updateData( data_user );
        if ( SHINKEN.HIGHWAY.isDocumentationOn() ) {
            var _data = SHINKEN.SAMPLE_DATA_4_DOCUMENTATION.CURRENT_USER[ __shinken_documentation_value__ ];
            if ( _data ) {
                var _keys = Object.keys( _data );
                var _current_key;
                for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
                    data_user[ _keys[ i ] ] = _data[ _keys[ i ] ];
                }
            }
        }
        return data_user;
    };
    self.iframeChangeUrl                 = function ( iframe_url, controller_name ) {
        switch ( controller_name ) {
            case "report_web":
            case "report_form":
                self.change_from_iframe = true; //OBLIGED TO ADD BECAUSE FORM REPORT IN ERROR RELOAD TWICE THE IFRAME... DONT KNOW WHY
                SHINKEN.HIGHWAY.goTo( iframe_url.replace( window.location.origin, SHINKEN.HIGHWAY.getPathFull() + "#" ) );
                break;
            case "impacts":
            case "360-controller":
                SHINKEN.HIGHWAY.goTo( iframe_url.replace( window.location.origin, SHINKEN.HIGHWAY.getPathFull() + "#" ) );
                break;
            case CONTROLLER.CONST.LOGIN.NAME:
                self.setActiveView( "login" );
                return;
            default: //ANGULAR
                var _split = iframe_url.split( "#" );
                var _hash  = _split[ 1 ] ? "#" + _split[ 1 ] : "#";
                SHINKEN.HIGHWAY.goTo( SHINKEN.HIGHWAY.getPathFull() + _hash );
                break;
        }
        
        self.computeInfoFromUrl();
    };
    self.changeDefaultUrl                = function ( iframe_url ) {
        self.current_user.setDefaultUrlToCurrentView();
        CONTROLLER.NavigationBar.computeDefaultButton();
    };
    self.doActionAfterUpdateScreen       = function ( screen ) {
        self.screen       = screen;
        self.current_view = new SHINKEN.ELEMENT.UiCurrentView( screen );
        self.updateTitlePage();
        CONTROLLER.NavigationBar.updateWithInfoFromUrl();
        SHINKEN.COMMUNICATION_WITH_IFRAME_CHILD.doActionAfter( "id-shinken-ui-view-manager", "current_screen_has_changed", self.current_view.uuid );
    };
    self.clickDoneOnIframe               = function ( event ) {
        CONTROLLER.UiVisualisation.onClick( event );
    };
    self.iframeIsNotFound                = function () {
        switch ( self.active_view ) {
            case SHINKEN.SCREEN.TYPE.SERVICE_WEATHER:
                if ( CONTROLLER.NavigationBar.isDefaultView() ) {
                    var _iframe = document.getElementById( "id-shinken-iframe-for-ui-visualisation" );
                    _iframe.setAttribute( "src", "/default_view_missing" );
                }
                break;
        }
    };
    self.actionAfterUrlChange            = function () {
        self.last_basics_stats_call_timestamp = null;
        self.onClick( "" );
        var _iframe = document.getElementById( "id-shinken-iframe-for-ui-visualisation" );
        var _hash   = SHINKEN.HIGHWAY.getHash();
        if ( _hash === "#" ) {
            _hash = "";
        }
        var _switch_case = _hash;
        if ( SHINKEN.TOOLS.STRING.startsWith( _hash, "#/reporting" ) ) {
            _switch_case = "#/reporting";
            if ( self.change_from_iframe ) {
                self.change_from_iframe = false;
                return;
            }
        }
        else if ( SHINKEN.TOOLS.STRING.startsWith( _hash, "#/360" ) ) {
            _switch_case = "#/360";
        }
        else if ( SHINKEN.TOOLS.STRING.startsWith( _hash, "#/impacts" ) ) {
            _switch_case = "#/impacts";
        }
        else if ( SHINKEN.TOOLS.STRING.startsWith( _hash, "#/external_redirect" ) ) {
            _switch_case = "#/external_redirect";
        }
        
        if ( !self.current_user.canSeeViewByHash( _hash ) ) {
            _switch_case = "";
        }
        
        self.change_from_iframe = false;
        switch ( _switch_case ) {
            case "#/external_redirect":
                var _external_link = SHINKEN.TOOLS.STRING.b64Decode( location.hash.replace( "#/external_redirect/", "" ) );
                SHINKEN.HIGHWAY.goTo( location.origin + _external_link );
                break;
            case "#/360":
            case "#/impacts":
            case "#/reporting":
                _iframe.setAttribute( "src", window.location.origin + _hash.substr( 1 ) );
                self.screen = null;
                break;
            case "":
                try {
                    SHINKEN.HIGHWAY.goTo( self.current_user.getDefaultView() );
                }
                catch ( e ) {
                    setTimeout( function () {
                        self.actionAfterUrlChange();
                    }, 200 );
                }
                break;
            default:
                _iframe.setAttribute( "src", SHINKEN.HIGHWAY.getOrigin() + "/static/ui/angular/index.html" + _hash );
                break;
        }
        self.computeInfoFromUrl();
        CONTROLLER.NavigationBar.actionAfterUrlChange();
        CONTROLLER.ShinkenView.resetIfNeeded( self.screen );
    };
    self.computeInfoFromUrl              = function () {
        var _split  = SHINKEN.HIGHWAY.getHash().split( "/" );
        var _split2 = _split[ 1 ] ? _split[ 1 ].split( "?" ) : "";
        self.setActiveView( _split2[ 0 ] );
        self.computeIsIframeEditOn();
        CONTROLLER.NavigationBar.updateWithInfoFromUrl();
    };
    self.computeIsIframeEditOn           = function () {
        self.is_edit_on = false;
        try {
            self.is_edit_on = document.getElementById( "id-shinken-iframe-for-ui-visualisation" ).contentWindow.EXTERNAL.COMMUNICATION.getHighwayManagerInstance().isReallyEditModeOn();
        }
        catch ( e ) {
        }
    };
    self.setActiveView                   = function ( active_view ) {
        if ( SHINKEN.TOOLS.STRING.startsWith( active_view, SHINKEN.SCREEN.TYPE.REPORTING_WEB ) ) {
            active_view = SHINKEN.SCREEN.TYPE.REPORTING_WEB;
        }
        self.active_view = active_view;
        self.updateTitlePage();
    };
    self.callbackAfter401                = function () {
        CONTROLLER.UiVisualisation.doActionAfter( "raise-error-401" );
    };
    return self;
})( CONTROLLER.UiVisualisation || {} );
window.onhashchange = function () {
    CONTROLLER.UiVisualisation.actionAfterUrlChange();
};
document.addEventListener( "DOMContentLoaded", function ( e ) {
    doActionWhenDomReady();
    window.addEventListener( "click", function ( event ) {
        CONTROLLER.UiVisualisation.onClick( event, 'click_done_on_parent' );
    } );
} );
SHINKEN.UI.SHARE = SHINKEN.UI.SHARE || {
    PARAM : {
        CREATED_ON         : {
            _KEY: "created_on"
        },
        INDEX              : {
            _KEY: "index"
        },
        IS_OPEN            : {
            _KEY: "isOpen"
        },
        GROUP              : {
            _KEY : "group",
            PARAM: {
                UUID: {
                    _KEY: "uuid"
                }
            }
        },
        KIND               : {
            _KEY : "kind",
            VALUE: {
                UNKNOWN  : 0,
                ELEMENT  : 1,
                FOLDER   : 2,
                SEPARATOR: 3
            }
        },
        LAST_MODIFIED_ON   : {
            _KEY: "last_modified_on"
        },
        NAME               : {
            _KEY: "name"
        },
        OWNER              : {
            _KEY : "owner",
            PARAM: {
                NAME: {
                    _KEY: "name"
                },
                UUID: {
                    _KEY: "uuid"
                }
            }
        },
        PARENT             : {
            _KEY : "parent",
            PARAM: {
                UUID: {
                    _KEY: "uuid"
                }
            }
        },
        SCREEN             : {
            _KEY : "screen",
            PARAM: {
                TYPE           : {
                    _KEY: "type"
                },
                IS_ROOT_PROBLEM: {
                    _KEY: "root_problem"
                },
                UUID           : {
                    _KEY: "uuid"
                }
            }
        },
        SCREEN_IS_REFERENCE: {
            _KEY: "screenIsReference"
        },
        STATE              : {
            _KEY : "state",
            PARAM: {
                REMOVED: {
                    _KEY: "removed"
                }
            }
        },
        TYPE               : {
            _KEY : "type",
            VALUE: {
                EVERYONE: "global",
                GROUPS  : "group",
                PRIVATE : "personal"
            }
        },
        UUID               : {
            _KEY: "uuid"
        }
    },
    SPACES: {
        EVERYONE: {
            _KEY: "global"
        },
        GROUPS  : {
            _KEY: "group"
        },
        PRIVATE : {
            _KEY: "personal"
        }
    }
};
SHINKEN.UI.ShareAbstract           = function () {
};
SHINKEN.UI.ShareAbstract.prototype = {
    init      : function ( data ) {
        this.updateData( data );
    },
    updateData: function ( data ) {
        if ( !data ) {
            return;
        }
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.UI.SHARE.PARAM.UUID._KEY:
            case SHINKEN.UI.SHARE.PARAM.NAME._KEY:
            case SHINKEN.UI.SHARE.PARAM.TYPE._KEY:
            case SHINKEN.UI.SHARE.PARAM.KIND._KEY:
            case SHINKEN.UI.SHARE.PARAM.INDEX._KEY:
            case SHINKEN.UI.SHARE.PARAM.SCREEN._KEY:
            case SHINKEN.UI.SHARE.PARAM.GROUP._KEY:
            case SHINKEN.UI.SHARE.PARAM.STATE._KEY:
            case SHINKEN.UI.SHARE.PARAM.CREATED_ON._KEY:
            case SHINKEN.UI.SHARE.PARAM.OWNER._KEY:
            case SHINKEN.UI.SHARE.PARAM.PARENT._KEY:
            case SHINKEN.UI.SHARE.PARAM.SCREEN_IS_REFERENCE._KEY:
            case SHINKEN.UI.SHARE.PARAM.LAST_MODIFIED_ON._KEY:
                this [ key ] = value;
                break;
            default:
                this.setData_lvl_1( key, value );
                break;
        }
    },
    doActionAfter      : function ( event_name, param_1, param_2 ) {
        switch ( event_name ) {
            default :
                this.doActionAfter_lvl_1( event_name, param_1, param_2 );
                break;
        }
    },
    doActionAfter_lvl_1: function ( event_name, param_1, param_2 ) {
    },
    setData_lvl_1      : function ( key, value ) {
    },
    getUUID         : function () {
        return this[ SHINKEN.UI.SHARE.PARAM.UUID._KEY ];
    },
    isIn            : function ( space_name ) {
        if ( !this.isType( space_name ) ) {
            return false;
        }
        return true;
    },
    isFolderForSpace: function ( space_name, group_id ) {
        if ( !this.isFolder() ) {
            return false;
        }
        if ( !this.isType( space_name ) ) {
            return false;
        }
        if ( group_id !== null && this[ SHINKEN.UI.SHARE.PARAM.GROUP._KEY ].uuid !== group_id ) {
            return false;
        }
        return true;
    },
    isType          : function ( to_test ) {
        return to_test === this[ SHINKEN.UI.SHARE.PARAM.TYPE._KEY ];
    },
    isFolder        : function () {
        return false;
    },
    create: function ( callback_success ) {
        var self     = this;
        var _success = function ( _status, data ) {
            switch ( _status ) {
                case COMMUNICATION.CODE.SUCCESS:
                    if ( callback_success ) {
                        callback_success();
                    }
                    break;
            }
        };
        var _error   = function ( _status, data ) {
            console.log( _status, data );
        };
        SHINKEN.COMUNICATION.requestPost( SHINKEN.COMUNICATION.CONST.QUERY.POST.SHARE, JSON.stringify( this.getDataToSave() ), _success, _error, null, CONTROLLER.UiVisualisation.callbackAfter401 );
    },
    getDataToSave        : function () {
        var _to_return                                                = this.getDataToSaveSpecific();
        _to_return[ SHINKEN.UI.SHARE.PARAM.UUID._KEY ]                = this[ SHINKEN.UI.SHARE.PARAM.UUID._KEY ];
        _to_return[ SHINKEN.UI.SHARE.PARAM.KIND._KEY ]                = this[ SHINKEN.UI.SHARE.PARAM.KIND._KEY ];
        _to_return[ SHINKEN.UI.SHARE.PARAM.CREATED_ON._KEY ]          = this[ SHINKEN.UI.SHARE.PARAM.CREATED_ON._KEY ];
        _to_return[ SHINKEN.UI.SHARE.PARAM.LAST_MODIFIED_ON._KEY ]    = this[ SHINKEN.UI.SHARE.PARAM.LAST_MODIFIED_ON._KEY ];
        _to_return[ SHINKEN.UI.SHARE.PARAM.SCREEN_IS_REFERENCE._KEY ] = this[ SHINKEN.UI.SHARE.PARAM.SCREEN_IS_REFERENCE._KEY ];
        _to_return[ SHINKEN.UI.SHARE.PARAM.NAME._KEY ]                = this[ SHINKEN.UI.SHARE.PARAM.NAME._KEY ];
        _to_return[ SHINKEN.UI.SHARE.PARAM.TYPE._KEY ]                = this[ SHINKEN.UI.SHARE.PARAM.TYPE._KEY ];
        _to_return[ SHINKEN.UI.SHARE.PARAM.INDEX._KEY ]               = this[ SHINKEN.UI.SHARE.PARAM.INDEX._KEY ];
        if ( this[ SHINKEN.UI.SHARE.PARAM.GROUP._KEY ] ) {
            _to_return[ SHINKEN.UI.SHARE.PARAM.GROUP._KEY ] = this[ SHINKEN.UI.SHARE.PARAM.GROUP._KEY ];
        }
        if ( this[ SHINKEN.UI.SHARE.PARAM.PARENT._KEY ] ) {
            _to_return[ SHINKEN.UI.SHARE.PARAM.PARENT._KEY ] = this[ SHINKEN.UI.SHARE.PARAM.PARENT._KEY ];
        }
        return _to_return;
    },
    getDataToSaveSpecific: function () {
        return {};
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.UI.ShareAbstract, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.UI.ShareView           = function ( data ) {
    this.initSpecific( data );
};
SHINKEN.UI.ShareView.prototype = {
    initSpecific: function ( data ) {
        this.init( data );
    },
    doActionAfter_lvl_1: function ( event_name, param_1, param_2 ) {
        return false;
    },
    setData_lvl_1      : function ( key, value ) {
        switch ( key ) {
            default:
                console.warn( "UNKNOWN DATA", key, value );
                break;
        }
    },
    
    getDataToSaveSpecific: function ( callback_success ) {
        var _to_return                                   = {};
        _to_return[ SHINKEN.UI.SHARE.PARAM.SCREEN._KEY ] = this[ SHINKEN.UI.SHARE.PARAM.SCREEN._KEY ];
        _to_return[ SHINKEN.UI.SHARE.PARAM.STATE._KEY ]  = this[ SHINKEN.UI.SHARE.PARAM.STATE._KEY ];
        _to_return[ SHINKEN.UI.SHARE.PARAM.OWNER._KEY ]  = this[ SHINKEN.UI.SHARE.PARAM.OWNER._KEY ];
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.UI.ShareView, SHINKEN.UI.ShareAbstract );
SHINKEN.UI.ShareFolder           = function ( data ) {
    this.initSpecific( data );
};
SHINKEN.UI.ShareFolder.prototype = {
    initSpecific: function ( data ) {
        this.init( data );
    },
    doActionAfter_lvl_1: function ( event_name, param_1, param_2 ) {
        return false;
    },
    setData_lvl_1      : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.UI.SHARE.PARAM.IS_OPEN._KEY:
                this [ key ] = value;
                break;
            default:
                console.warn( "UNKNOWN DATA", key, value );
                break;
        }
    },
    isFolder: function () {
        return true;
    },
    getDataToSaveSpecific: function ( callback_success ) {
        var _to_return                                   = {};
        _to_return[ SHINKEN.UI.SHARE.PARAM.SCREEN._KEY ] = this[ SHINKEN.UI.SHARE.PARAM.SCREEN._KEY ];
        _to_return[ SHINKEN.UI.SHARE.PARAM.STATE._KEY ]  = this[ SHINKEN.UI.SHARE.PARAM.STATE._KEY ];
        _to_return[ SHINKEN.UI.SHARE.PARAM.OWNER._KEY ]  = this[ SHINKEN.UI.SHARE.PARAM.OWNER._KEY ];
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.UI.ShareFolder, SHINKEN.UI.ShareAbstract );
SHINKEN.UI.ShareSeparator           = function ( data ) {
    this.initSpecific( data );
};
SHINKEN.UI.ShareSeparator.prototype = {
    initSpecific: function ( data ) {
        this.init( data );
    },
    isSeparator: function () {
        return true;
    },
    getDataToSaveSpecific: function ( callback_success ) {
        var _to_return                                  = {};
        _to_return[ SHINKEN.UI.SHARE.PARAM.TYPE._KEY ]  = this[ SHINKEN.UI.SHARE.PARAM.TYPE._KEY ];
        _to_return[ SHINKEN.UI.SHARE.PARAM.STATE._KEY ] = this[ SHINKEN.UI.SHARE.PARAM.STATE._KEY ];
        _to_return[ SHINKEN.UI.SHARE.PARAM.OWNER._KEY ] = this[ SHINKEN.UI.SHARE.PARAM.OWNER._KEY ];
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.UI.ShareSeparator, SHINKEN.UI.ShareAbstract );
SHINKEN.UI.SHARE.factory = function ( data ) {
    var _to_return;
    var _kind = data[ SHINKEN.UI.SHARE.PARAM.KIND._KEY ];
    switch ( _kind ) {
        case SHINKEN.UI.SHARE.PARAM.KIND.VALUE.ELEMENT:
            _to_return = new SHINKEN.UI.ShareView( data );
            break;
        case SHINKEN.UI.SHARE.PARAM.KIND.VALUE.FOLDER:
            _to_return = new SHINKEN.UI.ShareFolder( data );
            break;
        case SHINKEN.UI.SHARE.PARAM.KIND.VALUE.SEPARATOR:
            _to_return = new SHINKEN.UI.ShareSeparator( data );
            break;
        default:
            break;
    }
    return _to_return;
};
SHINKEN.UI.ShareSet           = function ( data ) {
    this.init( data );
};
SHINKEN.UI.ShareSet.prototype = {
    init      : function ( data ) {
        this.initContents();
    },
    updateData: function ( data ) {
        for ( var i = 0, _size_i = data.length; i < _size_i; i++ ) {
            this.add( SHINKEN.UI.SHARE.factory( data[ i ] ) );
        }
    },
    getNextIndexFor  : function ( type ) {
        var _to_return = -1;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            if ( this.getContent( i ).isIn( type ) ) {
                _to_return++;
            }
        }
        return _to_return + 1;
    },
    getFolderForSpace: function ( space_name, group_id ) {
        var _to_return = [];
        var _current;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _current = this.getContent( i );
            if ( _current.isFolderForSpace( space_name, group_id ) ) {
                _to_return.push( _current );
            }
        }
        SHINKEN.TOOLS.ARRAY.sortArray(_to_return, "index");
        return _to_return;
    },
    getDataFromBackend: function ( callback_success ) {
        var self     = this;
        var _success = function ( _status, data ) {
            switch ( _status ) {
                case COMMUNICATION.CODE.SUCCESS:
                    self.updateData( data );
                    if ( callback_success ) {
                        callback_success();
                    }
                    break;
            }
        };
        var _error   = function ( _status, data ) {
            console.log( _status, data );
        };
        SHINKEN.COMUNICATION.requestGet( SHINKEN.COMUNICATION.CONST.QUERY.GET.SHARE, _success, _error, null, CONTROLLER.UiVisualisation.callbackAfter401 );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.UI.ShareSet, SHINKEN.OBJECT.ShinkenObjectContainerHtml );
SHINKEN.OBJECT.Dropdown.AddFavorite           = function ( dom_element_target ) {
    this.initSpecific( dom_element_target );
};
SHINKEN.OBJECT.Dropdown.AddFavorite.prototype = {
    initSpecific : function ( dom_element_target ) {
        var _dom_content = this.initDomParent();
        this.init( dom_element_target, _dom_content );
        this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_LEFT;
    },
    initDomParent: function () {
        var to_return               = DOM.Service.createElement( "div", { class: "shinken-add-favorite-dropdown-container" } );
        this.pop_up_add_to_favorite = new WINDOW.AddToFavoriteWindowGroup( WINDOW.ADD_TO_FAVORITE.NAME_GROUP );
        this.pop_up_add_to_favorite.changeWindowStateByView();
        this.pop_up_add_to_favorite.computeHtml();
        
        DOM.Service.addElementTo( this.pop_up_add_to_favorite.getDomElement(), to_return );
        this.form_add_favorite = new SHINKEN.UI.AddToFavoriteFormSet( SHINKEN.UI.ADD_TO_FAVORITE.FORM_NAME );
        this.form_add_favorite.initFinal( this.pop_up_add_to_favorite.getActiveWindow().getName() );
        this.form_add_favorite.computeHtml();
        
        DOM.Service.addElementTo( this.form_add_favorite.getDomElement(), to_return );
        CONTROLLER.Form.setCurrentForm( this.form_add_favorite );
        return to_return;
    },
    onClick      : function ( event, event_name ) {
        if ( !event ) {
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
            return;
        }
        switch ( event_name ) {
            case "toggle_add_to_favorite_form":
                this.dom_element.remove();
                return;
        }
        if ( DOM.Service.findParentElementWithClass( event.target, "shinken-add-favorite-drop-down", 50 ) ) {
            CONTROLLER.Form.onClick( event );
        }
        else {
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
        }
    },
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "close_opened_pop_up":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                break;
            default:
                this.form_add_favorite.doActionAfter( event_name, param );
                break;
        }
        this.form_add_favorite.doActionAfter( event_name, param );
    },
    togglePhaseSpecific: function ( phase_1, phase_2 ) {
        if ( !this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING ) && phase_1 === SHINKEN.OBJECT.CONST.PHASE.RUNNING ) {
            SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).EXTERNAL.COMMUNICATION.doAction( "ask_for_refresh_share_only", { is_refresh: true } );
        }
        this.togglePhase( phase_1, phase_2 );
    },
    
    getClass: function () {
        return "shinken-dropdown-container shinken-add-favorite-drop-down shinken-no-opacity";
    },
    computePosition: function ( _rect, _width_rect ) {
        this.pos_top     = _rect.top + _rect.height + 2 * SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE;
        this.pos_left    = window.innerWidth - this.width - SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE - 8; //8px for the scrollbar
        this.width_arrow = _width_rect;
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Dropdown.AddFavorite, SHINKEN.OBJECT.Dropdown._interface );
SHINKEN.OBJECT.Dropdown.ConfigurationShinkenView           = function ( data ) {
    this.initSpecific( data );
};
SHINKEN.OBJECT.Dropdown.ConfigurationShinkenView.prototype = {
    initSpecific: function ( data ) {
        var _dom_content   = DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-configuration .shinken-dropdown-container-shinken-view-configuration" ) );
        this.shinken_view = data.shinken_view;
        
        this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_LEFT;
        this.init( data.dom_element, _dom_content );
    },
    onClick      : function ( event ) {
        if ( !event.target ) {
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
            return;
        }
        
        if ( !DOM.Service.findParentElementWithClass( event.target, "shinken-dropdown-container-shinken-view-configuration", 50 ) ) {
            if ( SHINKEN.NAVIGATOR.isNavigator( "isIE" ) && (event.target.tagName === "path" || event.target.tagName === "svg") ) {
                return;
            }
            if ( SHINKEN.NAVIGATOR.isNavigator( "isIE" ) ) {
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
            }
            if ( !DOM.Service.findParentElementWithID( event.target, "id-shinken-screen-configuration", 50 ) ) {
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
            }
        }
    },
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "do_action_after_init_dom_element":
                this.updateWithShinkenViewData();
                this.setDefaultValues();
                break;
            case "radio_btn_configuration_notification_sound_clicked":
                this.getPropertySound().doActionAfter( "value_changed", param );
                this.shinken_view.doActionAfter( "change_value_notification_of_change_sound", this.parseFormToObject( this.getPropertySound().getValue() ) );
                break;
            case "use_radio_btn_configuration_notification_blink":
                this.getPropertyBlink().doActionAfter( "value_changed", param );
                this.shinken_view.doActionAfter( "change_value_notification_of_change_visual_blink", this.parseFormToObject( this.getPropertyBlink().getValue() ) );
                break;
        }
    },
    
    getMaxTry       : function () {
        return 1;
    },
    getClass        : function () {
        return "shinken-dropdown-container shinken-dropdown-container-shinken-view-configuration shinken-no-opacity";
    },
    getPropertyBlink: function () {
        if ( !this.property_blink ) {
            this.property_blink = new COMPONENT.RadioListGeneric( this.getDomElement().querySelector( '.shinken-tbody-for-blink' ) );
        }
        return this.property_blink;
    },
    
    getPropertySound            : function () {
        if ( !this.property_sound ) {
            this.property_sound = new COMPONENT.RadioListGeneric( this.getDomElement().querySelector( '.shinken-tbody-for-sound' ) );
        }
        return this.property_sound;
    },
    setPropertyBlinkDefaultValue: function ( default_value ) {
        var property_blink = this.getPropertyBlink();
        property_blink.setDefaultKeyAndValue( default_value, default_value );
    },
    setPropertySoundDefaultValue: function ( default_value ) {
        var property_sound = this.getPropertySound();
        property_sound.setDefaultKeyAndValue( default_value, default_value );
    },
    setDefaultValues            : function () {
        var defaults_values = CONTROLLER.UiVisualisation.default_notifications_of_changed[ CONTROLLER.UiVisualisation.active_view + "s" ];
        this.setPropertyBlinkDefaultValue( defaults_values.visual.blink.enabled );
        this.setPropertySoundDefaultValue( defaults_values.sound.enabled );
    },
    updateWithShinkenViewData: function () {
        this.getPropertyBlink().setValueFromUser( this.parseObjectToForm( this.shinken_view[ "notifications_of_change" ].getBlinkValue() ) );
        this.getPropertySound().setValueFromUser( this.parseObjectToForm( this.shinken_view[ "notifications_of_change" ].getSoundValue() ) );
    },
    doPlacementArrow         : function () {
        this.getDomElement().querySelector( ".shinken-cell-arrow-side.shinken-arrow-top-right" ).style.width = this.width_arrow;
    },
    computePosition          : function ( _rect, _width_rect ) {
        this.pos_top     = _rect.top + _rect.height + DOM.Service.getBoundingClientRect( document.querySelector( "#id-shinken-iframe-for-container" ), DOM.CONST.STYLE.TOP );
        this.pos_left    = _rect.left + _width_rect - this.width + 2 * SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE;
        this.width_arrow = _width_rect;
    }
    
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Dropdown.ConfigurationShinkenView, SHINKEN.OBJECT.Dropdown._interface );
SHINKEN.OBJECT.Dropdown.ConfigurationUser           = function ( dom_element_target ) {
    this.initSpecific( dom_element_target );
};
SHINKEN.OBJECT.Dropdown.ConfigurationUser.prototype = {
    initSpecific: function ( dom_element_target ) {
        var _dom_content = DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-configuration .shinken-dropdown-container-user-configuration" ) );
        this.init( dom_element_target, _dom_content );
        this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_LEFT;
    },
    onClick      : function ( event, event_name ) {
        switch ( event_name ) {
            case "toggle_configuration_user_setting_interface":
                return;
        }
        if ( !event ){
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
            return;
        }
        if ( !DOM.Service.findParentElementWithClass( event.target, "shinken-dropdown-container-user-configuration", 50 ) ) {
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
        }
    },
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "do_action_after_init_dom_element":
                var notification_of_change = CONTROLLER.UiVisualisation.current_user.getPref( SHINKEN.ELEMENT.USER.PARAM.PREFS.NOTIFICATION_OF_CHANGE.NAME );
                this.getPropertyBlink().setDefaultKeyAndValue( CONTROLLER.UiVisualisation.default_notifications_of_changed.getUserBlinkValue(), CONTROLLER.UiVisualisation.default_notifications_of_changed.getUserBlinkValue() );
                this.getPropertyBlink().doActionAfter( event_name, this.parseObjectToForm( notification_of_change.getBlinkValue() ) );
                this.getPropertyVolume().setDefaultKeyAndValue( CONTROLLER.UiVisualisation.default_notifications_of_changed.getUserVolumeValue(), CONTROLLER.UiVisualisation.default_notifications_of_changed.getUserVolumeValue() );
                this.getPropertyVolume().doActionAfter( "do_action_after_init_dom_element", notification_of_change.getVolumeValue() );
                break;
            case "use_slider_configuration_user_notification_volume":
                this.getPropertyVolume().doActionAfter( "value_changed" );
                CONTROLLER.UiVisualisation.doActionAfter( "change_value_notification_of_change_sound", parseInt( this.getPropertyVolume().getValue() ) );
                this.simulatePlayAudio( param.value );
                break;
            case "use_slider_configuration_user_notification_volume_oninput":
                this.getPropertyVolume().doActionAfter( "value_changed" );
                break;
            case "use_radio_btn_configuration_notification_blink":
                this.getPropertyBlink().doActionAfter( "value_changed", param );
                CONTROLLER.UiVisualisation.doActionAfter( "change_value_notification_of_change_visual_blink", this.parseFormToObject( this.getPropertyBlink().getValue() ) );
                break;
            case "use_default_value_for_sound_notification":
                this.getPropertyVolume().doActionAfter( "use_default_value", param );
                CONTROLLER.UiVisualisation.doActionAfter( "change_value_notification_of_change_sound", SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT );
                break;
            case "close_opened_pop_up":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                break;
        }
    },
    
    simulatePlayAudio: function ( param ) {
        if ( !this.audio ) {
            this.audio = new SHINKEN.OBJECT.SoundNotificationOfChange();
            this.audio.initPhase();
        }
        this.audio.doActionAfter( "ask_simulate_play_notification_of_sound", param );
    },
    getMaxTry        : function () {
        return 1;
    },
    getClass         : function () {
        return "shinken-dropdown-container shinken-user-configuration-drop-down shinken-no-opacity";
    },
    getPropertyVolume: function () {
        if ( !this.property_volume ) {
            this.property_volume = new PROPERTY.RangeFomHtml( this.getDomElement().querySelector( '.shinken-tbody-for-volume' ) );
        }
        return this.property_volume;
    },
    getPropertyBlink : function () {
        if ( !this.property_blink ) {
            this.property_blink = new PROPERTY.RadioListFromHtml( this.getDomElement().querySelector( '.shinken-tbody-for-blink' ) );
        }
        return this.property_blink;
    },
    doPlacementArrow: function () {
        this.getDomElement().querySelector( ".shinken-cell-arrow-side.shinken-arrow-top-right" ).style.width = this.width_arrow;
    },
    computePosition : function ( _rect, _width_rect ) {
        this.pos_top     = _rect.top + _rect.height;
        this.pos_left    = _rect.left + _width_rect - this.width + 2 * SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE;
        this.width_arrow = _width_rect;
    }
    
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Dropdown.ConfigurationUser, SHINKEN.OBJECT.Dropdown._interface );
SHINKEN.ELEMENT.UiCurrentUser = function ( data ) {
    this.init( data );
};
SHINKEN.ELEMENT.UiCurrentUser.prototype = {
    clickOnDefaultView: function () {
        SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).EXTERNAL.COMMUNICATION.simulateClickOnDefaultView();
    },
    doActionAfter     : function ( event_name, param ) {
        switch ( event_name ) {
            case "change_value_notification_of_change_sound":
            case "change_value_notification_of_change_visual_blink":
                this.getPrefs().doActionAfter( event_name, param );
                break;
        }
    },
    _setData                   : function ( key, value ) {
        switch ( key ) {
            case "resources":
                MANAGER.DistributorResourcesManager.factory( key, value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.DEFAULT_NOTIFICATIONS_SETTINGS:
                if ( CONTROLLER.UiVisualisation ) {
                    CONTROLLER.UiVisualisation.doActionAfter( "init_default_notifications_settings", value );
                }
                break;
            case SHINKEN.ELEMENT.USER.PARAM.GROUPS:
                this[ key ] = value;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.SYNTHESIS_REPORT_ENABLED:
                this[ key ] = value;
                break;
            default:
        }
    },
    setPrefs                   : function ( value ) {
        this.getPrefs().updateData( value );
        if ( CONTROLLER.UiVisualisation ) {
            CONTROLLER.UiVisualisation.updateNotificationCurrentUser();
        }
    },
    setModules                 : function ( to_set ) {
        if ( SHINKEN.TOOLS.ARRAY.areEqual(to_set, this[ SHINKEN.ELEMENT.USER.PARAM.KNOWN_MODULES ])){
            return;
        }
        this[ SHINKEN.ELEMENT.USER.PARAM.KNOWN_MODULES ]              = to_set;
        this[ SHINKEN.ELEMENT.USER.PARAM.HAS_EVENT_TUB_MODULE ]       = SHINKEN.TOOLS.ARRAY.contains( to_set, 'event_container' );
        this[ SHINKEN.ELEMENT.USER.PARAM.HAS_WEATHER_SERVICE_MODULE ] = SHINKEN.TOOLS.ARRAY.contains( to_set, 'webui_module_service_weather' );
        if ( CONTROLLER.NavigationBar ) {
            CONTROLLER.NavigationBar.refresh();
        }
    },
    hasEventTubModule            : function () {
        return this [ SHINKEN.ELEMENT.USER.PARAM.HAS_EVENT_TUB_MODULE ] || false;
    },
    hasServiceWeatherModule    : function () {
        return this [ SHINKEN.ELEMENT.USER.PARAM.HAS_WEATHER_SERVICE_MODULE ] || false;
    },
    setServers                 : function ( data ) {
        if ( this.servers === undefined ) {
            this.servers = new SHINKEN.SERVER.ShinkenServers();
        }
        this.servers.updateData( data );
        this[ SHINKEN.ELEMENT.USER.PARAM.HAS_ARCHITECTURE_MODULE ] = !!this.servers.size;
        if ( CONTROLLER.NavigationBar ) {
            CONTROLLER.NavigationBar.askUpdateArchitectureExportMenu( this.servers );
        }
    },
    setName                    : function ( to_set ) {
        if ( this[ SHINKEN.ELEMENT.USER.PARAM.USER_NAME ] === to_set ) {
            return;
        }
        this[ SHINKEN.ELEMENT.USER.PARAM.USER_NAME ] = to_set;
        this.askUpdateHtml();
        if ( CONTROLLER.UiVisualisation ) {
            CONTROLLER.UiVisualisation.initWhenUserSet();
        }
    },
    setShinkenVersion          : function ( to_set ) {
        if ( this[ SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION ] === to_set ) {
            return;
        }
        this[ SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION ] = to_set;
        this.askUpdateHtml();
    },
    updateHtml                 : function () {
        if ( this.isAdmin() ) {
            if ( !this.dom_element_version_number ) {
                this.dom_element_version_number = document.getElementById( "id-shinken-version-number" );
            }
            if ( this.dom_element_version_number ) {
                this.dom_element_version_number.setAttribute( "shi-tip-html", this[ SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION ] );
            }
            if ( SHINKEN.HIGHWAY.getParams( "shinken_documentation" ) ) {
                var blurred_shinken_version = "Version : <span class='shinken-sensible'>" + SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION.repeat( 4 ) +
                                              "</span><br>Patch : <span class='shinken-sensible'>" + SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION.repeat( 4 ) + "</span>";
                this.dom_element_version_number.setAttribute( "shi-tip-html", blurred_shinken_version );
            }
        }
    },
    isSynthesisReportEnabled            : function () {
        return this [ SHINKEN.ELEMENT.USER.PARAM.SYNTHESIS_REPORT_ENABLED ];
    },
    canSeeViewByHash           : function ( view_hash ) {
        if ( SHINKEN.TOOLS.STRING.startsWith( view_hash, "#/reporting" ) ) {
            return this.isSynthesisReportEnabled();
        }
        return true;
    },
    canCreateFavorite          : function () {
        if ( this[ SHINKEN.ELEMENT.USER.PARAM.ACL.KEY ] ) {
            return this[ SHINKEN.ELEMENT.USER.PARAM.ACL.KEY ].canCreateFavorite();
        }
        return false;
    },
    getAclSpaceShare           : function () {
        return this[ SHINKEN.ELEMENT.USER.PARAM.ACL.KEY ];
    },
    computeEllipsisLogoutButton: function () {
        this.dom_element_user_name = document.getElementById( "id-shinken-user-name" );
        var _data                  = DOM.ServiceEllipsis.ellipsis(
            this.dom_element_user_name,
            this[ SHINKEN.ELEMENT.USER.PARAM.USER_NAME ],
            "10px Lato",
            2
        );
        if ( _data.line_number === 1 ) {
            DOM.Service.setStyles( this.dom_element_user_name, { "font-size": "10px", "line-height": "20px" } );
        }
    },
    setLocalTime               : function ( to_set ) {
        if ( CONTROLLER.UiVisualisation ) {
            CONTROLLER.UiVisualisation.setLocalTime( to_set );
        }
    },
    hasEditableRight           : function ( view_type ) {
        switch ( view_type ) {
            case SHINKEN.UI.VIEW.TYPE.WEATHER:
                return this.isAdmin();
        }
        return false;
    },
    getDataFromBackend: function ( callback ) {
        var self     = this;
        var _success = function ( _status, data ) {
            switch ( _status ) {
                case COMMUNICATION.CODE.SUCCESS:
                    self.updateData( data );
                    if ( callback ) {
                        callback();
                    }
                    break;
            }
        };
        var _error   = function ( _status, data ) {
            console.log( _( "users.errors.cannot_get_user_from_backend", [DICTIONARY_COMMON_UI] ) );
        };
        SHINKEN.COMUNICATION.requestGet( SHINKEN.COMUNICATION.CONST.QUERY.GET.USER.KEY, _success, _error, null, CONTROLLER.UiVisualisation.callbackAfter401 );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.ELEMENT.UiCurrentUser, SHINKEN.ELEMENT.UiUser );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.ELEMENT.UiCurrentUser, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.ELEMENT.UiCurrentView = function ( data ) {
    this.initSpecific( data );
};
SHINKEN.ELEMENT.UiCurrentView.prototype = {
    initSpecific: function ( data ) {
        this.initAddButton();
        this.init( this.parseDataToViewData( data ) );
    },
    parseDataToViewData: function ( data ) {
        let _data_valid_for_screen                                          = {};
        _data_valid_for_screen[ SHINKEN.OBJECT.VIEW.PARAM.UUID ]            = data[ SHINKEN.OBJECT.VIEW.PARAM.UUID ];
        _data_valid_for_screen[ SHINKEN.OBJECT.VIEW.PARAM.NAME ]            = data[ SHINKEN.OBJECT.VIEW.PARAM.NAME ];
        _data_valid_for_screen[ SHINKEN.OBJECT.VIEW.PARAM.TYPE ]            = data[ SHINKEN.OBJECT.VIEW.PARAM.TYPE ];
        _data_valid_for_screen[ SHINKEN.OBJECT.VIEW.PARAM.IS_ROOT_PROBLEM ] = data[ SHINKEN.OBJECT.VIEW.PARAM.IS_ROOT_PROBLEM ];
        _data_valid_for_screen[ SHINKEN.OBJECT.VIEW.PARAM.FOUND ]           = data[ SHINKEN.OBJECT.VIEW.PARAM.FOUND ];
        let _owner                                                          = {};
        _owner[ SHINKEN.OBJECT.VIEW.PARAM.OWNER.PARAM.NAME._KEY ]           = data[ "owner_name" ];
        _owner[ SHINKEN.OBJECT.VIEW.PARAM.OWNER.PARAM.UUID._KEY ]           = data[ "owner_uuid" ];
        _data_valid_for_screen[ SHINKEN.OBJECT.VIEW.PARAM.OWNER._KEY ]      = _owner;
        return _data_valid_for_screen;
    },
    initAddButton      : function ( data ) {
        this.tooltip__add_to_favorite_button    = "";
        this.is_display__add_to_favorite_button  = false;
        this.is_disabled__add_to_favorite_button = false;
    },
    isOwnByCurrentUser   : function () {
        return this.owner.uuid === CONTROLLER.UiVisualisation.current_user.getUUID();
    },
    isDisplay__AddButton      : function () {
        return this.is_display__add_to_favorite_button;
    },
    isDisabled__AddButton  : function () {
        return this.is_disabled__add_to_favorite_button;
    },
    getTooltip__AddButton: function () {
        return this.tooltip__add_to_favorite_button;
    },
    updateAddToFavoriteButton: function () {
        this.initAddButton();
        switch ( this[ SHINKEN.OBJECT.VIEW.PARAM.FOUND ] ) {
            case SHINKEN.SCREEN.FOUND_ITEM.NOT_FOUND:
                this.is_disabled__add_to_favorite_button = true;
                break;
        }
        
        switch ( this.type ) {
            case SHINKEN.SCREEN.TYPE.LIST:
            case SHINKEN.SCREEN.TYPE.HIVE:
            case SHINKEN.SCREEN.TYPE.SERVICE_WEATHER:
                if ( CONTROLLER.UiVisualisation.current_user.canCreateFavorite() ) {
                    this.is_display__add_to_favorite_button = true;
                    CONTROLLER.UiVisualisation.computeIsIframeEditOn();
                }
                break;
        }
        if ( !this.isType( SHINKEN.SCREEN.TYPE.LIST ) && CONTROLLER.UiVisualisation.is_edit_on ) {
            this.is_disabled__add_to_favorite_button = true;
            this.tooltip__add_to_favorite_button  = _( "favorites.add_to_favorite.tooltips.edit_mode" );
        }
        else if ( CONTROLLER.UiVisualisation.active_view === SHINKEN.SCREEN.TYPE.SERVICE_WEATHER ) {
            if ( !CONTROLLER.UiVisualisation.screen ) {
                this.is_disabled__add_to_favorite_button = true;
                this.tooltip__add_to_favorite_button  = _( "favorites.add_to_favorite.tooltips.weather.no_weather_to_share" );
            }
            else if ( CONTROLLER.Share.isScreenUnValid_ByData( CONTROLLER.UiVisualisation.screen.uuid ) ) {
                this.is_disabled__add_to_favorite_button = true;
                this.tooltip__add_to_favorite_button  = _( "favorites.add_to_favorite.tooltips.weather.no_weather_to_share" );
            }
            else if ( !__current_user_has_editable_right_service_weather__ && CONTROLLER.UiVisualisation.current_view.owner.uuid !== CONTROLLER.UiVisualisation.current_user.getUUID() ) {
                this.is_disabled__add_to_favorite_button = true;
                this.tooltip__add_to_favorite_button  = _( "favorites.add_to_favorite.tooltips.weather.no_right_to_share" );
            }
        }
        switch ( CONTROLLER.UiVisualisation.active_view ) {
            case SHINKEN.SCREEN.TYPE.VIEW360:
            case SHINKEN.SCREEN.TYPE.IMPACTS:
            case SHINKEN.SCREEN.TYPE.REPORTING:
            case SHINKEN.SCREEN.TYPE.REPORTING_WEB:
                this.is_display__add_to_favorite_button = false;
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.ELEMENT.UiCurrentView, SHINKEN.OBJECT.View );
