"use strict";
SHINKEN.TOOLS.TEST_AUTO_PROPERTY_STRING_INPUT_WITH_RENDER = (function ( self ) {
    self.DOM                               = {};
    self.ACTION                            = {};
    self.TEST                              = {};
    //********************************************  GET DOM ELEMENT   ****************************************//
    self.DOM.mainInput                     = function ( property_name ) {
        return SHINKEN.TOOLS.TEST_AUTO_PROPERTY_STRING_INPUT.DOM.mainInput( property_name );
    };
    self.DOM.renderValue                   = function ( property_name ) {
        return SHINKEN.TOOLS.TEST_AUTO_PROPERTY.DOM.line( property_name ).querySelector( ".shinken-cell-render-action-area .shinken-render-value" );
    };
    self.DOM.renderValueForHtmlTest                   = function ( property_name ) {
        return self.DOM.renderValue( property_name ).querySelector( "p" );
    };
    self.DOM.renderValueInheritance                   = function ( property_name ) {
        return SHINKEN.TOOLS.TEST_AUTO_PROPERTY.DOM.line( property_name ).querySelector( ".shinken-cell-render-action-area .shinken-render-value-from-template" );
    };
    self.DOM.renderValueInheritanceForHtmlTest                   = function ( property_name ) {
        return self.DOM.renderValueInheritance( property_name ).querySelector( "p" );
    };
    self.DOM.renderInheritance                   = function ( property_name ) {
        return SHINKEN.TOOLS.TEST_AUTO_PROPERTY.DOM.line( property_name ).querySelector( ".shinken-cell-render-template-area .shinken-render-value" );
    };
    self.DOM.buttonUpdateRender                       = function ( property_name ) {
        return SHINKEN.TOOLS.TEST_AUTO_PROPERTY.DOM.line( property_name ).querySelector( ".shinken-cell-render-action-area .shinken-update-button-of-render-value" );
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.updateRenderDisplay                               = function ( timeout, property_name ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.buttonUpdateRender( property_name ) );
        }, timeout );
        return 2000;
    };
    //********************************************  TEST   **************************************************//
    self.TEST.hasRenderValueHtml                               = function ( timeout, property_name, value_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerHtmlEqualTo( self.DOM.renderValueForHtmlTest(property_name), value_expected );
        }, timeout );
        return 50;
    };
    self.TEST.hasRenderValue                               = function ( timeout, property_name, value_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.renderValue(property_name), value_expected );
        }, timeout );
        return 50;
    };
    self.TEST.hasRenderValueInheritanceHtml                               = function ( timeout, property_name, value_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerHtmlEqualTo( self.DOM.renderValueInheritanceForHtmlTest(property_name), value_expected );
        }, timeout );
        return 50;
    };
    self.TEST.hasRenderValueInheritance                               = function ( timeout, property_name, value_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.renderValueInheritance(property_name), value_expected );
        }, timeout );
        return 50;
    };
    self.TEST.display_               = function ( timeout, property_name, state ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'PROPERTY_STRING_INPUT_WITH_RENDER.TEST.display_', property_name + " --> " + state );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom_value  = self.DOM.renderValue( property_name );
            var _dom_value_inheritance = self.DOM.renderValueInheritance( property_name );
            var _dom_inheritance = self.DOM.renderInheritance( property_name );
            
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_RENDER_COMPONENT.USER_SET:
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_value, property_name + " render value" );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_value_inheritance, property_name + " render inherited value");
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_inheritance, property_name + " render inherited");
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_RENDER_COMPONENT.USER_SET_WITH_INHERITED:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_value, property_name + " render value" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_value_inheritance, property_name + " render inherited value");
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_inheritance, property_name + " render inherited");
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_RENDER_COMPONENT.INHERITED:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_value, property_name + " render value");
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_value_inheritance, property_name + " render inherited value");
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_inheritance, property_name + " render inherited");
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_PROPERTY_STRING_INPUT_WITH_RENDER || {} );