"use strict";
SHINKEN.TOOLS.TEST_AUTO_PROPERTY = (function ( self ) {
    self.DOM                                         = {};
    self.TEST                                        = {};
    self.TEST.JS                                     = {};
    self.ACTION                                      = {};
    self.GETTER                                      = {};
    self.CONST                                       = {
        UNDER_SELECTOR: {
            SELECTOR      : "shinken-select-selector",
            SELECTOR_TITLE: "shinken-multiselect-title",
            SELECTOR_LABEL: "shinken-selector-label",
            LIST_SELECT   : "shinken-list-select",
            FILTER_INPUT  : "shinken-input-search"
        }
    };
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.line                                    = function ( property_name, dom_element ) {
        if ( !dom_element ) {
            dom_element = document;
        }
        return dom_element.querySelector( '.shinken-element-property-line[data-name="' + property_name + '"]' );
    };
    self.DOM.counterError                            = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-property-label .shinken-counter.shinken-error-counter' );
    };
    self.DOM.counterWarning                          = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-property-label .shinken-counter.shinken-warning-counter' );
    };
    self.DOM.lock                                    = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-lock-cell' );
    };
    self.DOM.radioBtnContainer                       = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-radio-list-container' );
    };
    self.DOM.defaultButton                           = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-range-btn-default-container .shinken-radio-btn' );
    };
    self.DOM.noOverrideButton                        = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-no-override-btn' );
    };
    self.DOM.inheritanceButton                       = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-prop-cell-template .switch-button-wrapper' );
    };
    self.DOM.inheritanceButtonValue                  = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-prop-cell-template .shinken-inheritance-value' );
    };
    self.DOM.rangeInput                              = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-range-container input' );
    };
    self.DOM.radioButtons                            = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-btn-radio-container' );
    };
    self.DOM.selector                                = function ( property_name, selector_name, under_type ) {
        var _to_return = self.DOM.line( property_name ).querySelector( '.shinken-select-container[data-name="' + selector_name + '"]' );
        if ( under_type ) {
            _to_return = _to_return.querySelector( "." + under_type );
        }
        return _to_return;
    };
    self.DOM.option                                  = function ( property_name, selector_name, option_name ) {
        var _to_return = self.DOM.line( property_name ).querySelector( '.shinken-select-container[data-name="' + selector_name + '"]' );
        return SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR.DOM.option( _to_return, option_name );
    };
    self.DOM.linkButton                              = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-link-icon-container' );
    };
    self.DOM.tagInformation                          = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-information-tag' );
    };
    self.DOM.flatCheckValue                          = function ( property_override_name ) {
        return self.DOM.line( property_override_name ).querySelector( '.shinken-flat-check-value' );
    };
    self.DOM.extraLabelPropertyName                  = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-property-label .shinken-extra-label' );
    };
    self.DOM.duplicateOverrideArea                  = function ( property_name, duplicate_value ) {
        return self.DOM.line( property_name ).querySelector( ".shinken-override-duplicate-error" );
    };
    self.DOM.duplicateOverrideOption                  = function ( property_name, duplicate_value ) {
        return self.DOM.duplicateOverrideArea( property_name ).querySelector( ".shinken-duplicate-div .shinken-input-radio[value='" + duplicate_value + "']" );
    };
    self.DOM.buttonValidDuplicateOverride                  = function ( property_name, duplicate_value ) {
        return self.DOM.duplicateOverrideArea( property_name ).querySelector( ".shinken-validate-override-duplicate-btn" );
    };
    //********************************************  ACTION VIA JS OBJECT   **************************************************//
    self.ACTION.selectOptionInPropertySelector       = function ( timeout, property_name, selector_name, option_name ) {
        setTimeout( function () {
            var _prop = MANAGER.__instance_property_distributor.getElement( property_name );
            if ( _prop.selectors[ selector_name ] && DOM.Service.isVisible( _prop.selectors[ selector_name ].dom_element, 20 ) ) {
                _prop.clickOnItemSelector( option_name, null, _prop.selectors[ selector_name ] );
            }
        }, timeout );
        return 1000;
    };
    self.ACTION.clickOnInheritanceButton             = function ( timeout, property_name ) {
        setTimeout( function () {
            self.DOM.inheritanceButton( property_name ).click();
        }, timeout );
        return 1000;
    };
    self.ACTION.setValue                             = function ( timeout, property_name, value ) {
        var _to_return = property_name === PROPERTY.CONST.NAME.USE ? 2500 : 1000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'setValue', property_name + " --> " + value );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            try {
                MANAGER.__instance_property_distributor.getElement( property_name ).setValueFromUser( value );
            }
            catch ( ex ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "SET VALUE " + value + " not done", "for property " + property_name );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return property_name === PROPERTY.CONST.NAME.USE ? 2500 : PROPERTY.CONST.NAME.ADDRESS ? 2500 : 1000;
    };
    self.ACTION.clickOnDefaultButton                 = function ( timeout, property_name ) {
        setTimeout( function () {
            self.DOM.defaultButton( property_name ).click();
        }, timeout );
        return 500;
    };
    self.ACTION.clickOnNoOverrideButton              = function ( timeout, property_name ) {
        setTimeout( function () {
            self.DOM.noOverrideButton( property_name ).click();
        }, timeout );
        return 500;
    };
    self.ACTION.clickOnRadioButton                   = function ( timeout, property_name, button_name ) {
        setTimeout( function () {
            self.DOM.radioBtnContainer( property_name ).querySelector( '.shinken-button[value="' + button_name + '"]' ).click();
        }, timeout );
        return 500;
    };
    self.ACTION.setValueWithSynchro                  = function ( timeout, property_name, value ) {
        self.ACTION.setValue( timeout, property_name, value );
        return 4000;
    };
    self.ACTION.mouseEnter                           = function ( timeout, property_name ) {
        let _uuid = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'mouseEnterValue', property_name );
        setTimeout( function () {
            let _dom = self.DOM.line( property_name ).querySelector( ".shinken-input" );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( 0, _dom, SHINKEN.TOOLS.TEST_AUTO_MOUSE_EVENT.getMouseEnterEvent() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", 4000 );
        }, timeout );
        return 500;
    };
    self.ACTION.clickOnDuplicateOverrideValue        = function ( timeout, property_name, duplicate_value ) {
        let _uuid = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'clickOnDuplicateOverrideValue', property_name + " -> " + duplicate_value );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.duplicateOverrideOption( property_name, duplicate_value  ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return 500;
    };
    self.ACTION.clickOnRemoveOverrideDuplicate        = function ( timeout, property_name ) {
        let _uuid = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'clickOnRemoveOverrideDuplicate', property_name  );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.buttonValidDuplicateOverride( property_name  ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return 500;
    };
    //********************************************  GETTER   **************************************************//
    self.GETTER.saveValue                            = function ( property_name ) {
        return MANAGER.__instance_property_distributor.getElement( property_name ).getDataToSave();
    };
    self.GETTER.getDefaultButtonBackgroundColorValue = function () {
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isFireFox' ) ) {
            return "rgb(233, 233, 237)";
        }
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isChrome' ) ) {
            return "rgb(240, 240, 240)";
        }
        return "rgb(240, 240, 240)";
    };
    //********************************************  TEST   **************************************************//
    self.TEST.display_                               = function ( timeout, property_name, state ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'PROPERTY.TEST.display_', property_name + " --> " + state );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom = self.DOM.line( property_name );
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, property_name );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom, property_name );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE.EMPTY:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom, DOM.CONST.STYLE.HEIGHT, 0, property_name );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.JS.defaultValue                        = function ( timeout, property_name, value_to_test ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( MANAGER.__instance_property_distributor.elements[ property_name ].default_value, value_to_test, "defaultValue " + property_name );
        }, timeout );
        return 50;
    };
    self.TEST.hasValue                               = function ( timeout, property_name, value_expected ) {
        setTimeout( function () {
            var _value = MANAGER.__instance_property_distributor.getElement( property_name ).getValue();
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _value, value_expected, "hasValue" );
        }, timeout );
        return 50;
    };
    self.TEST.inheritanceButtonValueLabel            = function ( timeout, property_name, text_expected ) {
        setTimeout( function () {
            var _dom = self.DOM.inheritanceButtonValue( property_name );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _dom.innerText, text_expected, "validMainInputContentDisplay" );
        }, timeout );
        return 50;
    };
    self.TEST.checkValueFlatCheckValue               = function ( timeout, property_name, text_expected ) {
        setTimeout( function () {
            var _dom = self.DOM.flatCheckValue( property_name );
            SHINKEN.TOOLS.TEST_AUTO_DOM.containsText( 0, _dom, text_expected, "checkValueFlatCheckValue" );
        }, timeout );
        return 50;
    };
    self.TEST.counter                                = function ( timeout, property_name, error_expected, warning_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, self.DOM.counterError( property_name ), error_expected, 'error for ' + property_name );
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, self.DOM.counterWarning( property_name ), warning_expected, 'warning for ' + property_name );
        }, timeout );
        return 100;
    };
    self.TEST.countProperty                          = function ( timeout, number_expected ) {
        var _keys      = Object.keys( MANAGER.__instance_property_distributor.elements );
        var _current_key;
        let properties = [];
        for ( let i = 0, size = _keys.length; i < size; i++ ) {
            _current_key    = _keys[ i ];
            //properties += "\"" + MANAGER.__instance_property_distributor.elements[ _current_key ].name + "\",";
            properties[ i ] = {
                "name": MANAGER.__instance_property_distributor.elements[ _current_key ].name
                //"parent-tab": MANAGER.__instance_property_distributor.elements[ _current_key ].tab_parent_name
            };
            
        }
        let expected_properties = SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.EXPECTED_PROPERTIES.HOST;
        for ( let i = 0, _size_i = properties.length; i < _size_i; i++ ) {
            if ( SHINKEN.TOOLS.ARRAY.contains( expected_properties, properties[ i ].name ) ) {
                SHINKEN.TOOLS.ARRAY.removeElementByIndex( expected_properties, expected_properties.indexOf( properties[ i ].name ) );
            }
        }
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( Object.keys( MANAGER.__instance_property_distributor.elements ), number_expected, 'MANAGER.__instance_property_distributor.elements' );
        }, timeout );
        return 100;
    };
    self.TEST.countWindow                            = function ( timeout, number_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( Object.keys( MANAGER.__instance_window_distributor.parent_windows[ MANAGER.__instance_element_distributor.current_element.uuid ].list ), number_expected, 'MANAGER.__instance_window_distributor.parent_windows[' + MANAGER.__instance_element_distributor.current_element.uuid + '].list' );
        }, timeout );
        return 100;
    };
    self.TEST.countPropertySet                       = function ( timeout, number_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( Object.keys( getCurrentObjectFromProperty() ), number_expected, 'getCurrentObjectFromProperty' );
        }, timeout );
        return 100;
    };
    self.TEST.radioButton                            = function ( dom_element, state, inner_text ) {
        var _to_test = SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE;
        switch ( state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                if ( dom_element.getAttribute( "value" ) === PROPERTY.CONST.BUTTON_LABEL.INHERITANCE ) {
                    _to_test = SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.ACTIVE_INHERITED;
                }
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                if ( dom_element.getAttribute( "value" ) === PROPERTY.CONST.BUTTON_LABEL.USER_SET ) {
                    _to_test = SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.ACTIVE;
                }
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET_NONE:
                if ( dom_element.getAttribute( "value" ) === PROPERTY.CONST.BUTTON_LABEL.NULL ) {
                    _to_test = SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.ACTIVE;
                }
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                if ( dom_element.getAttribute( "value" ) === PROPERTY.CONST.BUTTON_LABEL.DEFAULT ) {
                    _to_test = SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.ACTIVE;
                }
                break;
        }
        switch ( _to_test ) {
            case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE:
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, "backgroundColor", "rgb(217, 217, 217)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, "color", "rgb(51, 51, 51)" );
                break;
            case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.ACTIVE_INHERITED:
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, "backgroundColor", "rgba(128, 0, 128, 0.65)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, "color", "rgb(255, 255, 255)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasClass( dom_element, 'shinken-active' );
                break;
            case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.ACTIVE:
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, "backgroundColor", "rgb(100, 99, 99)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, "color", "rgb(255, 255, 255)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasClass( dom_element, 'shinken-active' );
                break;
        }
        SHINKEN.TOOLS.TEST_AUTO.__isVisibleAndHasInnerText( dom_element, inner_text );
    };
    self.TEST.tagInformationDisplay                  = function ( timeout, property_name, state ) {
        setTimeout( function () {
            var _dom_tag_info = self.DOM.tagInformation( property_name );
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_tag_info, "tag information for <span class='shinken-data-user'>" + property_name + "</span>" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_tag_info, "tag information for <span class='shinken-data-user'>" + property_name + "</span>" );
                    break;
            }
        }, timeout );
        return 10;
    };
    self.TEST.linkButton                             = function ( timeout, property_name, state, uuid_link ) {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return 0;
        }
        setTimeout( function () {
            var _dom_link_button = self.DOM.linkButton( property_name );
            var _dom_link        = _dom_link_button.querySelector( ".shinken-link" );
            var _dom_icon        = _dom_link_button.querySelector( ".shinken-link-icon-button" );
            
            var _test_desc = "link button";
            var _is_visble = true;
            var _uuid_link = uuid_link || "";
            var _color     = "rgb(0, 0, 0)";
            
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_LINK_BUTTON.HIDDEN:
                    _is_visble = false;
                    break;
                
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_LINK_BUTTON.USER_SET:
                    break;
                
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_LINK_BUTTON.USER_SET_NEW:
                    _uuid_link = _uuid_link + '?new=1';
                    break;
                
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_LINK_BUTTON.INHERITED:
                    _color = "rgb(128, 0, 128)";
                    break;
                
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_LINK_BUTTON.INHERITED_NEW:
                    _color     = "rgb(128, 0, 128)";
                    _uuid_link = _uuid_link + '?new=1';
                    break;
            }
            if ( !_is_visble && _uuid_link ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Link button are not visible but he have a link" );
            }
            if ( _is_visble ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom_icon, 'color', _color );
                SHINKEN.TOOLS.TEST_AUTO.__containsText( _dom_link.href, _uuid_link, _test_desc );
            }
            SHINKEN.TOOLS.TEST_AUTO_DOM.visibility( 0, _dom_link_button, _test_desc, _is_visble );
            
            
            
        }, timeout );
        return 10;
    };
    self.TEST.isDisabled                             = function ( timeout, property_name, extra_label ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.hasClass( timeout, self.DOM.line( property_name ), 'shinken-disabled', false, extra_label );
        }, timeout );
        return 500;
    };
    self.TEST.isLockDisplayed                        = function ( property_name, show, timeout ) {
        setTimeout( function () {
            if ( show ) {
                SHINKEN.TOOLS.TEST_AUTO.__isVisible( self.DOM.lock( property_name ) );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( self.DOM.lock( property_name ) );
            }
        }, timeout );
        return 500;
    };
    self.TEST.isState                                = function ( timeout, property_name, state ) {
        var _to_return = 10;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'PROPERTY.isState', property_name + " --> " + state );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            switch ( state ) {
                case PROPERTY.CONST.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( self.DOM.line( property_name ) );
                    break;
                default:
                    SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( self.DOM.line( property_name ).dataset, 'state', state, '[--1--]' );
                    SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( MANAGER.__instance_property_distributor.getElement( property_name ), 'state', state, '[--2--]' );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return 10;
    };
    self.TEST.isLabelDefaultButton                   = function ( timeout, property_name, inner_text ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.defaultButton( property_name ), inner_text, property_name );
        }, timeout );
        return 10;
    };
    self.TEST.isLabelNoOverrideButton                   = function ( timeout, property_name, inner_text ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.noOverrideButton( property_name ), inner_text, property_name );
        }, timeout );
        return 10;
    };
    self.TEST.hasStyleDefaultButton                  = function ( timeout, property_name, key, value ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.defaultButton( property_name ), key, value );
        }, timeout );
        return 10;
    };
    self.TEST.extraLabelPropertyName                 = function ( timeout, property_name ) {
        setTimeout( function () {
            if ( __version_shinken !== SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
                SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.extraLabelPropertyName( property_name ), _( "extra_label." + property_name ), "PROPERTY EXTRA_LABEL" );
            }
        }, timeout );
        return 10;
    };
    self.TEST.ErrorInTooltip                         = function ( timeout, error_expected ) {
        setTimeout( function () {
            let _dom_list = document.querySelector( "#shi-tip .shinken-tooltip-message" ).querySelectorAll( ".shinken-error-status" );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _dom_list.length, error_expected );
        }, timeout );
        return 500;
    };
    self.TEST.countErrorInTooltip                    = function ( timeout, property_name, error_expected ) {
        let _timeout = 0;
        setTimeout( function () {
            _timeout += self.ACTION.mouseEnter( 0, property_name );
            self.TEST.ErrorInTooltip( _timeout, error_expected );
        }, timeout );
        return 500;
    };
    
    //********************************************  ACTION   **************************************************//
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_PROPERTY || {} );

SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST = {
    ACTION_SELECTOR_USER_SET: "rgba(30, 30, 30, 0.8)",
    STATE                   : {
        HIDDEN      : 0,
        VISIBLE     : 1,
        EMPTY       : 2,
        COLLAPSED   : 3,
        UN_COLLAPSED: 4
    },
    STATE_BUTTON            : {
        HIDDEN          : 0,
        VISIBLE         : 1,
        ACTIVE          : 2,
        ACTIVE_INHERITED: 3,
        DISABLED        : 4
    },
    STATE_LINK_BUTTON       : {
        HIDDEN       : 0,
        USER_SET     : 1,
        USER_SET_NEW : 2,
        INHERITED    : 3,
        INHERITED_NEW: 4
    },
    STATE_RENDER_COMPONENT  : {
        USER_SET               : 0,
        USER_SET_WITH_INHERITED: 1,
        INHERITED              : 2
    },
    EXPECTED_PROPERTIES     : {
        HOST      : [
            "use", "host_name", "visualisation_name", "display_name", "address", "hostgroups", "realm", "business_impact", "parents", "notes_url", "notes_multi_url", "enabled", "pack", "view_contacts", "view_contact_groups", "element_visibility_on_not_authenticated_view", "notification_contacts", "notification_contact_groups", "edition_contacts", "edition_contact_groups", "maintenance_period", "active_checks_enabled", "check_command", "thresholds_display", "thresholds_display-information", "poller_tag", "check_period", "max_check_attempts", "check_interval", "retry_interval", "check_running_timeout", "warning_threshold_cpu_usage", "passive_checks_enabled", "check_freshness", "freshness_threshold", "process_perf_data", "sla_warning_threshold", "sla_critical_threshold", "service_excludes", "notifications_enabled", "notification_interval", "notification_period", "notification_options", "first_notification_delay", "escalations", "flap_detection_enabled", "flap_detection_options", "low_flap_threshold", "high_flap_threshold", "business_impact_modulations", "macromodulations", "resultmodulations", "event_handler_enabled", "reactionner_tag", "event_handler"
        ],
        CHECK     : [],
        HOST_TPL  : [],
        CLUSTER   : [],
        TIMEPERIOD: []
    }
};