"use strict";
SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL = (function ( self ) {
    self.DOM                                             = {};
    self.DOM.CONFIRMATION_POPUP                          = {};
    self.TEST                                            = {};
    self.ACTION                                          = {};
    self.ACTION.CONFIRMATION_POPUP                       = {};
    self.INTERNAL                                        = {};
    self.CONST                                           = {
        OVERLAYED_FRAME: {
            CORNER: {
                TOP_LEFT    : "top-left",
                TOP_RIGHT   : "top-right",
                BOTTOM_LEFT : "bottom-left",
                BOTTOM_RIGHT: "bottom-right"
            }
        },
        GRID_CELL      : {
            WEATHER: {
                STATUS: {
                    NORMAL           : "normal",
                    SELECTED         : "selected",
                    WARNING          : "warning",
                    ERROR            : "error",
                    ADDING           : "adding",
                    ADDING_OVERLAPPED: "adding_overlapped",
                    MOVING           : "moving",
                    MOVING_OVERLAPPED: "moving_overlapped"
                }
                
            }
        },
        STATE_DISPLAY  : {
            NO_CLICKABLE: 0
        }
    };
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.widgetRadioMode                             = function ( in_iframe, radio_mode_name ) {
        return SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.pageContainer( in_iframe ).querySelector( '.shinken-radio-mode[data-name="' + radio_mode_name + '"] .shinken-title-zone' );
    };
    self.DOM.deletionConfirmationPopup                   = function () {
        return document.querySelector( ".shinken-confirmation-popup" );
    };
    self.DOM.confirmationPopupWidgetList                 = function () {
        return self.DOM.deletionConfirmationPopup().querySelectorAll( ".shinken-deleting" );
    };
    self.DOM.CONFIRMATION_POPUP.buttonDelete             = function () {
        return self.DOM.deletionConfirmationPopup().querySelector( ".shinken-footer-confirmation-popup .shinken-button[data-name='valid_popup__20240904']" );
    };
    self.DOM.CONFIRMATION_POPUP.widgetCancelDeleteButton = function ( widget_index ) {
        return self.DOM.confirmationPopupWidgetList()[ widget_index ].querySelector( ".shinken-button" );
    };
    
    //********************************************  ACTION   **************************************************//
    self.ACTION.changeRadioMode                                = function ( timeout, radio_mode_name ) {
        let _to_return = 600;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "selectRadioMode", radio_mode_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.widgetRadioMode( false, radio_mode_name ) );
        }, timeout );
        return _to_return;
    };
    self.ACTION.toggleWidgetSelectionAtIndex                   = function ( timeout, index, ctrl_key ) {
        let _to_return = 350;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "toggleWidgetSelectionAtIndex", index );
        let _timeout   = 0;
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let _dom = TI.WEATHER.GRID.CELL.DOM.cellByIndex( false, index );
            _timeout += SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( 0, _dom, SHINKEN.TOOLS.TEST_AUTO_MOUSE_EVENT.getMouseDownEvent( undefined, undefined, ctrl_key ) );
            SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( _timeout, _dom, SHINKEN.TOOLS.TEST_AUTO_MOUSE_EVENT.getMouseUpEvent( undefined, undefined, ctrl_key ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.openWidgetForm_byGridCellIndex                 = function ( timeout, index ) {
        let _to_return = 350;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "openWidgetForm_byGridCellIndex", index );
        let _timeout   = 0;
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let _dom = TI.WEATHER.GRID.CELL.DOM.buttonOpenConfigGridCellByIndex( false, index );
            _timeout += SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( _timeout, _dom, SHINKEN.TOOLS.TEST_AUTO_MOUSE_EVENT.getMouseDownEvent() );
            _timeout += SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( _timeout, _dom, SHINKEN.TOOLS.TEST_AUTO_MOUSE_EVENT.getMouseUpEvent() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.selectWidgetByZone                             = function ( timeout, selection_start_coords, selection_end_coords, in_pixel ) {
        let _to_return = 1200;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "selectWidgetByZone" );
        let _timeout   = 0;
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let _dom = SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.gridContainer();
            if ( !in_pixel ) {
                selection_start_coords.x = self.INTERNAL.tilesToPixels( selection_start_coords.x );
                selection_start_coords.y = self.INTERNAL.tilesToPixels( selection_start_coords.y ) + DOM.Service.getBoundingClientRect( SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.gridContainer(), DOM.CONST.STYLE.TOP );
                selection_end_coords.x   = self.INTERNAL.tilesToPixels( selection_end_coords.x );
                selection_end_coords.y   = self.INTERNAL.tilesToPixels( selection_end_coords.y ) + DOM.Service.getBoundingClientRect( SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.gridContainer(), DOM.CONST.STYLE.TOP );
            }
            self.INTERNAL.moveMouseAt( 0, _dom, selection_start_coords.x, selection_start_coords.y, selection_end_coords.x, selection_end_coords.y, true );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.unselectAllWidget                              = function ( timeout ) {
        let _to_return = 1200;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "selectWidgetByZone" );
        let _timeout   = 0;
        setTimeout( function () {
            let _dom = SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.gridContainer();
            SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( _timeout, _dom, SHINKEN.TOOLS.TEST_AUTO_KEY_EVENT.getEscapeEvent() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.addWidget                                      = function ( timeout, position_x, position_y, in_pixel ) {
        let _to_return = 900;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.addWidget" );
        let _timeout   = 0;
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( !in_pixel ) {
                let coords = self.INTERNAL.getCoordinatesFromTiles( position_x, position_y );
                position_x = coords.x;
                position_y = coords.y;
            }
            let _dom = SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.grid();
            _timeout += SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( 0, _dom, SHINKEN.TOOLS.TEST_AUTO_MOUSE_EVENT.getMouseMoveEvent( position_x, position_y, null, _dom ) );
            _timeout += SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( _timeout, _dom, SHINKEN.TOOLS.TEST_AUTO_MOUSE_EVENT.getMouseUpEvent() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.tryAddWidget                                   = function ( timeout, position_x, position_y, in_pixel ) {
        let _to_return = 900;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.tryAddWidget" );
        let _timeout   = 0;
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( !in_pixel ) {
                let coords = self.INTERNAL.getCoordinatesFromTiles( position_x, position_y );
                position_x = coords.x;
                position_y = coords.y;
            }
            let _dom = SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.grid();
            _timeout += SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( 0, _dom, SHINKEN.TOOLS.TEST_AUTO_MOUSE_EVENT.getMouseMoveEvent( position_x, position_y, null ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.moveWidget                                     = function ( timeout, delta_x, delta_y, index, in_pixel ) {
        let _to_return = 1200;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.moveWidget" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( !in_pixel ) {
                delta_x = self.INTERNAL.tilesToPixels( delta_x );
                delta_y = self.INTERNAL.tilesToPixels( delta_y );
            }
            let _dom = TI.WEATHER.GRID.CELL.DOM.cellByIndex( false, index );
            self.INTERNAL.moveMouseAt( 0, _dom, null, null, delta_x, delta_y );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.moveMouseFromGridCell                          = function ( timeout, delta_x, delta_y, index, in_pixel ) {
        let _to_return = 1200;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.moveWidget" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( !in_pixel ) {
                delta_x = self.INTERNAL.tilesToPixels( delta_x );
                delta_y = self.INTERNAL.tilesToPixels( delta_y );
            }
            let _dom = TI.WEATHER.GRID.CELL.DOM.cellByIndex( false, index );
            self.INTERNAL.moveMouseAt( 0, _dom, null, null, delta_x, delta_y, false, true );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.tryMoveWidget                                  = function ( timeout, delta_x, delta_y, index, in_pixel ) {
        let _to_return = 1200;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.tryMoveWidget" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( !in_pixel ) {
                delta_x = self.INTERNAL.tilesToPixels( delta_x );
                delta_y = self.INTERNAL.tilesToPixels( delta_y );
            }
            let _dom = TI.WEATHER.GRID.CELL.DOM.cellByIndex( false, index );
            self.INTERNAL.moveMouseAt( 0, _dom, null, null, delta_x, delta_y, false, true );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.resizeWidget                                   = function ( timeout, delta_x, delta_y, corner, index, in_pixel ) {
        let _to_return = 1000;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.moveWidget" );
        let _timeout   = 0;
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let _dom = TI.WEATHER.GRID.CELL.DOM.cellByIndex( false, index );
            if ( !in_pixel ) {
                let grid_cell = new SHINKEN.TOOLS.TEST_AUTO.Widget( index );
                let coords    = grid_cell.getCoordonnatesForResize( corner, delta_x, delta_y );
                delta_x       = coords.x;
                delta_y       = coords.y;
            }
            let target = _dom.querySelector( ".shinken-resize-cursor[data-position=" + corner + "]" );
            _timeout += SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( _timeout, target, SHINKEN.TOOLS.TEST_AUTO_MOUSE_EVENT.getMouseDownEvent() );
            _timeout += SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( _timeout, target, SHINKEN.TOOLS.TEST_AUTO_MOUSE_EVENT.getMouseMoveEvent( delta_x, delta_y ) );
            _timeout += SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( _timeout, target, SHINKEN.TOOLS.TEST_AUTO_MOUSE_EVENT.getMouseUpEvent() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.createSpace                                    = function ( timeout, start_y, delta_y, in_pixel ) {
        let _to_return = 1200;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.createSpace" );
        let _timeout   = 0;
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let _dom = SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.gridContainer();
            if ( !in_pixel ) {
                start_y = self.INTERNAL.tilesToPixels( start_y ) + DOM.Service.getBoundingClientRect( SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.gridContainer(), DOM.CONST.STYLE.TOP );
                delta_y = self.INTERNAL.tilesToPixels( delta_y ) + start_y;
            }
            _timeout += self.ACTION.changeRadioMode( _timeout, SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_CREATE );
            self.INTERNAL.moveMouseAt( 0, _dom, 1, start_y, 0, delta_y );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.deleteSpace                                    = function ( timeout, start_y, delta_y, in_pixel ) {
        let _to_return = 1400;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.createSpace" );
        let _timeout   = 0;
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let _dom = SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.gridContainer();
            if ( !in_pixel ) {
                start_y = self.INTERNAL.tilesToPixels( start_y ) + DOM.Service.getBoundingClientRect( SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.gridContainer(), DOM.CONST.STYLE.TOP );
                delta_y = self.INTERNAL.tilesToPixels( delta_y ) + start_y;
            }
            _timeout += self.ACTION.changeRadioMode( _timeout, SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_DELETE );
            self.INTERNAL.moveMouseAt( _timeout, _dom, 1, start_y, 0, delta_y );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.useShortcut                                    = function ( timeout, key, shiftKey, ctrlKey ) {
        let _to_return = 600;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.useShortcut", key );
        let _timeout   = 0;
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let _dom = SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.gridContainer();
            SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( _timeout, _dom, SHINKEN.TOOLS.TEST_AUTO_KEY_EVENT.getKeyEvent( key, shiftKey, ctrlKey ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.CONFIRMATION_POPUP.clickOnConfirmDeletion      = function ( timeout ) {
        let _to_return = 500;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.clickOnConfirmDeletion" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let _dom = self.DOM.CONFIRMATION_POPUP.buttonDelete();
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _dom );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.CONFIRMATION_POPUP.cancelWidgetDeletionAtIndex = function ( timeout, index ) {
        let _to_return = 500;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.clickOnConfirmDeletion" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let _dom = self.DOM.CONFIRMATION_POPUP.widgetCancelDeleteButton( index );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _dom );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  TEST **************************************************//
    self.TEST.gridCellSize                                     = function ( timeout, width_expected, height_expected, grid_cell_index, in_pixel ) {
        let _to_return = 100;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "TEST.gridCellSize" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let grid_cell = new SHINKEN.TOOLS.TEST_AUTO.Widget( grid_cell_index );
            let width     = in_pixel ? grid_cell.getWidth() : grid_cell.getWidthInTiles();
            let height    = in_pixel ? grid_cell.getHeight() : grid_cell.getHeightInTiles();
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( width, width_expected, "cell width not expected: " + width + " /= " + width_expected );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( height, height_expected, "cell height not expected: " + height + " /= " + height_expected );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.gridCellPosition                                 = function ( timeout, position_expected, grid_cell_index ) {
        let _to_return = 100;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "TEST.gridCellPosition" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let grid_cell = new SHINKEN.TOOLS.TEST_AUTO.Widget( grid_cell_index );
            let coords    = grid_cell.getPositionInGrid();
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( coords.x, position_expected.x, "cell X position not expected: " + coords.x + " /= " + position_expected.x );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( coords.y, position_expected.y, "cell Y position not expected: " + coords.y + " /= " + position_expected.y );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.gridCellState                                    = function ( timeout, status_expected, grid_cell_index ) {
        let _to_return = 3000;
        setTimeout( function () {
            let _dom = TI.WEATHER.GRID.CELL.DOM.cellByIndex( false, grid_cell_index );
            let _dom_shadow;
            let _dom_original_position;
            switch ( status_expected ) {
                case SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.CONST.GRID_CELL.WEATHER.STATUS.NORMAL:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom.querySelector( ".shinken-bin-container" ) );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom.querySelector( ".shinken-cog-container" ) );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasNotStyle( 0, _dom.querySelector( ".shinken-grid-cell-border" ), "border", "2px solid rgb(70, 166, 255)" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.CONST.GRID_CELL.WEATHER.STATUS.SELECTED:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom.querySelector( ".shinken-grid-cell-border" ), "border", "2px solid rgb(70, 166, 255)" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom.querySelector( ".shinken-grid-cell-border" ), "borderRadius", 5 );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.CONST.GRID_CELL.WEATHER.STATUS.WARNING:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom.querySelector( ".shinken-grid-cell-container-edit-mode" ), "border", "2px solid rgb(255, 130, 60)" );
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _dom.querySelector( ".shinken-grid-cell-container-error-primary-content" ), "" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.CONST.GRID_CELL.WEATHER.STATUS.ERROR:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom.querySelector( ".shinken-grid-cell-container-edit-mode" ), "border", "2px solid rgb(255, 0, 0)" );
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _dom.querySelector( ".shinkon-warning" ), "" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.CONST.GRID_CELL.WEATHER.STATUS.ADDING:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasNotStyle( 0, _dom, "border", "2px solid rgb(70, 166, 255)" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _dom, "background-color", "rgb(223, 240, 255)", "" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.CONST.GRID_CELL.WEATHER.STATUS.ADDING_OVERLAPPED:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _dom, "background-color", "rgb(255, 82, 82)", "" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.CONST.GRID_CELL.WEATHER.STATUS.MOVING:  // FOR THIS STATUS grid_cell_index IS MANDATORY !!!
                case SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.CONST.GRID_CELL.WEATHER.STATUS.MOVING_OVERLAPPED:
                    _dom                   = TI.WEATHER.GRID.CELL.DOM.cellByIndex( false, grid_cell_index + 2 );
                    _dom_shadow            = TI.WEATHER.GRID.CELL.DOM.cellByIndex( false, grid_cell_index + 1 );
                    _dom_original_position = TI.WEATHER.GRID.CELL.DOM.cellByIndex( false, grid_cell_index );
                    
                    
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _dom_original_position, "background-color", "rgb(229, 229, 229)", "" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.doesntExist( timeout, _dom_original_position.querySelector( ".shinken-widget" ), "" );
                    
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _dom_shadow, "background-color", "rgb(209, 233, 255)", "" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.doesntExist( timeout, _dom_shadow.querySelector( ".shinken-widget" ), "" );
                    
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _dom, "background-color", "rgba(70, 166, 255, 0.08)", "" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _dom.querySelector( ".shinken-grid-cell-content" ), "border", "2px solid rgb(70, 166, 255)", "" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _dom.querySelector( ".shinken-grid-cell-mask-container" ), "display", "none", "" );
                    
                    if ( status_expected === SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.CONST.GRID_CELL.WEATHER.STATUS.MOVING_OVERLAPPED ) {
                        SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _dom, "border", "2px solid rgb(255, 0, 0)", "" );
                    }
                    break;
            }
        }, timeout );
        return _to_return;
    };
    self.TEST.radioBtnStatus                                   = function ( timeout, radio_mode_name, status_expected ) {
        let _to_return = 3000;
        setTimeout( function () {
            let _dom = self.DOM.widgetRadioMode( false, radio_mode_name );
            switch ( status_expected ) {
                case SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING :
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom, "background-color", "rgba(200, 234, 255, 0.3)" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom.querySelector( ".shinken-label-container" ), "color", "rgb(119, 165, 255)" );
                    break;
                case SHINKEN.OBJECT.CONST.PHASE.SLEEPING :
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasNotStyle( 0, _dom, "background-color", "rgba(200, 234, 255, 0.3)" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasNotStyle( 0, _dom.querySelector( ".shinken-label-container" ), "color", "rgb(119, 165, 255)" );
                    break;
                
            }
        }, timeout );
        return _to_return;
    };
    self.TEST.countSelectedGridCells                           = function ( timeout, number_expected ) {
        let _to_return = 3000;
        setTimeout( function () {
            let _dom_list = SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.gridContainer().querySelectorAll( ".shinken-grid-cell[data-current-phase='SELECTED']" );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _dom_list.length, number_expected );
        }, timeout );
        return _to_return;
    };
    self.TEST.countGridCells                                   = function ( timeout, number_expected ) {
        let _to_return = 3000;
        setTimeout( function () {
            let _dom_list = SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.gridContainer().querySelectorAll( ".shinken-grid-cell" );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _dom_list.length, number_expected );
        }, timeout );
        return _to_return;
    };
    self.TEST.displayState                                     = function ( timeout, type_element, state ) {
        var _to_return = 50;
        setTimeout( function () {
            var _dom = self.DOM.CONFIRMATION_POPUP.buttonDelete();
            switch ( state ) {
                case self.CONST.STATE_DISPLAY.NO_CLICKABLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, type_element );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom.firstElementChild, "pointerEvents", "none" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "opacity", "0.5" );
                    break;
                default:
                    break;
            }
        }, timeout );
        return _to_return;
    };
    //********************************************  INTERNAL **************************************************//
    self.INTERNAL.moveMouseAt                                  = function ( timeout, _dom, start_x, start_y, end_x, end_y, ctrlKey, is_try ) {
        let _timeout = 0;
        setTimeout( function () {
            _timeout += SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( _timeout, _dom, SHINKEN.TOOLS.TEST_AUTO_MOUSE_EVENT.getMouseDownEvent( start_x, start_y, ctrlKey ) );
            _timeout += SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( _timeout, _dom, SHINKEN.TOOLS.TEST_AUTO_MOUSE_EVENT.getMouseMoveEvent( end_x, end_y, ctrlKey ) );
            if ( !is_try ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( _timeout, _dom, SHINKEN.TOOLS.TEST_AUTO_MOUSE_EVENT.getMouseUpEvent( end_x, end_y, ctrlKey ) );
            }
        }, timeout );
        return 900;
    };
    self.INTERNAL.tilesToPixels                                = function ( nb_tiles ) {
        let ratio = CONTROLLER.PageController.current_page.content.grids.contents[ 0 ].tile_pixel_size;
        return nb_tiles * ratio;
    };
    self.INTERNAL.pixelToTiles                                 = function ( nb_pixels ) {
        let ratio = CONTROLLER.PageController.current_page.content.grids.contents[ 0 ].tile_pixel_size;
        return nb_pixels / ratio;
    };
    self.INTERNAL.getCoordinatesFromTiles                      = function ( position_x, position_y ) { // ETAPE OBLIGEE POUR QUE LES COORDONNEES DONNEES CORRESPONDENT AU COIN EN HAUT A GAUCHE DE LA WIDGET
        return {
            "x": self.INTERNAL.tilesToPixels( position_x ) + self.INTERNAL.tilesToPixels( 15 / 2 ),
            "y": self.INTERNAL.tilesToPixels( position_y + 1 ) + self.INTERNAL.tilesToPixels( 4 / 2 ) + DOM.Service.getBoundingClientRect( SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.grid(), DOM.CONST.STYLE.TOP )
        };
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL || {} );

