"use strict";
SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT = (function ( self ) {
    var _sub_functions = [];
    
    function executeSequentially ( sub_functions, callback, index = 0 ) {
        if ( index >= sub_functions.length ) {
            console.log( index, 'All sub functions executed' );
            _sub_functions = [];
            callback();
            return;
        }
        const currentFunction = sub_functions[ index ];
        currentFunction( () => {
            executeSequentially( sub_functions, callback, index + 1 );
        } );
    }
    
    function make_sub_functions_array ( func, callback, last ) {
        _sub_functions.push( func );
        console.log( "FGAR", "_sub_functions", func );
        if ( last ) {
            executeSequentially( _sub_functions, callback );
        }
    }
    
    self.DOM                                           = {};
    self.TEST                                          = {};
    self.TEST.JS                                       = {};
    self.ACTION                                        = {};
    self.ACTION.IFRAME                                 = {};
    self.TEST.EXTERNAL_LINKS                           = {};
    self.INTERNAL                                      = {};
    self.STATUS_LINE_NUMBER                            = {
        STATE_DISPLAY: {
            OK     : 0,
            WARNING: 1,
            ERROR  : 2
        }
    };
    self.CONST                                         = {
        WINDOW_GROUP_PROBLEM: {
            STATUS: {
                VISIBLE     : "visible",
                HIDDEN      : "hidden",
                NON_EXISTING: "non_existing"
            }
        }
    };
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.editButtonsContainer                      = function ( in_iframe ) {
        var _document = in_iframe ? SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.IFRAME.getIframe() : document;
        return _document.querySelector( "#id-shinken-weather-edit-buttons-container" );
    };
    self.DOM.slidePanelFormContainer                   = function ( in_iframe ) {
        var _document = in_iframe ? SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.IFRAME.getIframe() : document;
        return _document.querySelector( ".shinken-weather-form-container" );
    };
    self.DOM.getTooltip                                = function ( in_iframe ) {
        var _document = in_iframe ? SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.IFRAME.getIframe() : document;
        return _document.getElementById( "shi-tip" );
    };
    self.DOM.tabsNavigation                            = function ( in_iframe ) {
        return self.DOM.slidePanelFormContainer( in_iframe ).querySelectorAll( ".shinken-window-element-V2" );
    };
    self.DOM.tabNavigation                             = function ( tab_name, in_iframe ) {
        var _tab_navigations = self.DOM.tabsNavigation( in_iframe );
        for ( var i = 0, _size_i = _tab_navigations.length; i < _size_i; i++ ) {
            if ( _tab_navigations[ i ].dataset.name === tab_name ) {
                return _tab_navigations[ i ];
            }
        }
    };
    self.DOM.modeEditButton                            = function ( in_iframe ) {
        return self.DOM.editButtonsContainer( in_iframe ).querySelector( '.shinken-button[data-name="enter_in_edit_mode"]' );
    };
    self.DOM.publishWeatherButton                      = function ( in_iframe ) {
        return self.DOM.slidePanelFormContainer( in_iframe ).querySelector( '.shinken-button[data-name="publish_view"]' );
    };
    self.DOM.shinkenWeatherHistoryTabButton            = function ( in_iframe ) {
        return self.DOM.slidePanelFormContainer( in_iframe ).querySelector( '.shinken-window-element-V2[data-name="edit_tab_history"]' );
    };
    self.DOM.shinkenWeatherJsonTabButton               = function ( in_iframe ) {
        return self.DOM.slidePanelFormContainer( in_iframe ).querySelector( '.shinken-window-element-V2[data-name="edit_tab_json"]' );
    };
    self.DOM.weatherHistoryLines                       = function ( in_iframe ) {
        return self.DOM.slidePanelFormContainer( in_iframe ).querySelectorAll( '.shinken-list-line .shinken-list-cell[data-name="date_history"]' );
    };
    self.DOM.saveButton                                = function ( in_iframe ) {
        return self.DOM.slidePanelFormContainer( in_iframe ).querySelector( '.shinken-button[data-name="enter_in_save_mode"]' );
    };
    self.DOM.cancelButton                              = function ( in_iframe ) {
        return self.DOM.slidePanelFormContainer( in_iframe ).querySelector( '.shinken-button[data-name="cancel_edit_mode_grid_page"]' );
    };
    self.DOM.toggleDisplayOfWidgetsIssuesButton        = function ( in_iframe ) {
        return self.DOM.slidePanelFormContainer( in_iframe ).querySelector( '.shinken-button-see-all .shinken-button' );
    };
    self.DOM.externalLinksButton                       = function ( in_iframe ) {
        return self.DOM.editButtonsContainer( in_iframe ).querySelector( '.shinken-button[data-name="external_links_weather"]' );
    };
    self.DOM.popUpExternalLinks                        = function ( in_iframe ) {
        return self.DOM.editButtonsContainer( in_iframe ).querySelector( ".shinken-weather-external-links-container" );
    };
    self.DOM.getWindowProblemsContainer                = function () {
        return document.querySelector( ".shinken-weather-main-container-error-message" );
    };
    self.DOM.getProblemsContainer                      = function () {
        return document.querySelector( ".shinken-weather-problem-window-container" );
    };
    self.DOM.getWidgetProblemsContainer                = function ( widget_uuid ) {
        return self.DOM.getProblemsContainer().querySelector( '.shinken-dom-element-problem[data-problem-cell-uuid="' + widget_uuid + '"]' );
    };
    self.DOM.getWidgetProblemsContainerFocusJSONButton = function ( widget_uuid ) {
        return self.DOM.getWidgetProblemsContainer( widget_uuid ).querySelector( '.shinken-button[data-name="focus-on-json-forced"]' );
    };
    self.DOM.previewButton                             = function ( in_iframe ) {
        return self.DOM.slidePanelFormContainer( in_iframe ).querySelector( '.shinken-button[data-name="preview_grid_page"]' );
    };
    self.DOM.backToPreviousPreview                     = function ( in_iframe ) {
        return self.DOM.slidePanelFormContainer( in_iframe ).querySelector( '.shinken-button[data-name="back_to_previous_preview"]' );
    };
    self.DOM.getAllErrorsProblems                      = function () {
        let _dom_problem_container = self.DOM.getProblemsContainer();
        if ( !_dom_problem_container ) {
            return [];
        }
        return _dom_problem_container.querySelectorAll( ".shinken-error-status" );
    };
    self.DOM.getAllWarningsProblems                    = function () {
        var _dom_problem_container = self.DOM.getProblemsContainer();
        if ( !_dom_problem_container ) {
            return [];
        }
        return _dom_problem_container.querySelectorAll( ".shinken-warning-status" );
    };
    self.DOM.formTextArea                              = function ( in_iframe ) {
        return self.DOM.slidePanelFormContainer( in_iframe ).querySelector( "#id-shinken-output-json" );
    };
    self.DOM.getLineNumber                             = function ( number, in_iframe ) {
        return self.DOM.slidePanelFormContainer( in_iframe ).querySelector( ".shinken-textarea-line-nums" ).querySelector( '.shinken-line-number[data-number="' + number + '"]' );
    };
    self.DOM.formTextAreaErrorsProblems                = function () {
        return self.DOM.formTextArea().querySelectorAll( "." + SHINKEN.OBJECT.JSON_EDITOR.CLASS_ERROR );
    };
    self.DOM.getElement                                = function ( type_element, in_iframe ) {
        switch ( type_element ) {
            case "button_mode_edit":
                return self.DOM.modeEditButton( in_iframe );
            case "publish_view":
                return self.DOM.publishWeatherButton( in_iframe );
            case "weather_history_container":
                return self.DOM.publishWeatherButton( in_iframe );
            case "button_back_to_previous_preview":
                return self.DOM.backToPreviousPreview( in_iframe );
            case "edit_tab_history":
                return self.DOM.shinkenWeatherHistoryTabButton( in_iframe );
            case "edit_tab_json":
                return self.DOM.shinkenWeatherJsonTabButton( in_iframe );
            case "edit_tab_visual":
            case SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.VISUAL:
            case SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.DEFAULT:
                return self.DOM.slidePanelFormContainer( in_iframe ).querySelector( '.shinken-window-element-V2[data-name="' + type_element + '"]' );
            case "weather_history_pagination_container":
                return self.DOM.weatherPaginationContainer( in_iframe );
            case "button_external_links":
                return self.DOM.externalLinksButton( in_iframe );
            case "button_save":
                return self.DOM.saveButton( in_iframe );
            case "preview_grid_page":
                return self.DOM.previewButton( in_iframe );
            case "popup_external_links":
                return self.DOM.popUpExternalLinks( in_iframe );
            case "cancel_edit_mode":
                return self.DOM.cancelButton( in_iframe );
            case "toggle_display_widgets_withs_issues":
                return self.DOM.toggleDisplayOfWidgetsIssuesButton( in_iframe );
        }
    };
    self.DOM.getExternalLinks                          = function ( in_iframe ) {
        return self.DOM.editButtonsContainer( in_iframe ).querySelector( ".shinken-external-links-table" );
    };
    self.DOM.getExternalLinkByUUID                     = function ( in_iframe, link_uuid ) {
        return self.DOM.getExternalLinks( in_iframe ).querySelector( '.shinken-external-link-row[data-link-uuid="' + link_uuid + '"]' );
    };
    self.DOM.JSONEditor                                = function ( in_iframe ) {
        return self.DOM.slidePanelFormContainer( in_iframe ).querySelector( ".shinken-json-div" );
    };
    self.DOM.widgetInJSONEditor                        = function ( in_iframe, widget_uuid ) {
        return self.DOM.JSONEditor( in_iframe ).querySelector( '[data-json-uuid-part="' + widget_uuid + '"]' );
    };
    //********************************************  GETTER   **************************************************//
    
    //********************************************  TEST   **************************************************//
    self.TEST.validationCase                           = function ( timeout, value_to_test, nb_errors_window, nb_warnings_window, nb_errors_json, nb_warnings_json ) {
        let _to_return     = 15000;
        nb_errors_window   = nb_errors_window || 0;
        nb_warnings_window = nb_warnings_window || 0;
        nb_errors_json     = typeof nb_errors_json === "undefined" ? nb_errors_window : nb_errors_json;
        nb_warnings_json   = typeof nb_warnings_json === "undefined" ? nb_warnings_window : nb_warnings_json;
        let _uuid          = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "validationCase", [value_to_test, nb_errors_window, nb_warnings_window, nb_errors_json, nb_warnings_json].join( " - " ) );
        setTimeout( function () {
            let _timeout_temp = 0;
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.setDoLog( false );
            _timeout_temp += self.ACTION.clickOnButton( _timeout_temp, "button_mode_edit" );
            _timeout_temp += self.ACTION.clickOnButton( _timeout_temp, "edit_tab_json" );
            _timeout_temp += self.ACTION.setJSONInForm( _timeout_temp, false, false, "TEXT XSS", value_to_test );
            _timeout_temp += self.ACTION.clickOnButton( _timeout_temp, "preview_grid_page" );
            _timeout_temp += SHINKEN.TOOLS.TEST_AUTO.ACTION.do_JS_action( _timeout_temp, "CONTROLLER.PageController.current_page.json_editor.updateHtml()", 2000 );
            _timeout_temp += self.TEST.countProblemsInWindow( _timeout_temp, nb_errors_window, nb_warnings_window );
            _timeout_temp += self.TEST.countProblemsInJson( _timeout_temp, nb_errors_json, nb_warnings_json );
            _timeout_temp += SHINKEN.TOOLS.TEST_AUTO_XSS.isFunctionExisting( _timeout_temp );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.setDoLog( true );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.validationJsonInvalid                    = function ( timeout, comma_index_removed, line_error_number ) {
        let _to_return = 2000 + 1000 + 2000 + 400;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "validationCase", comma_index_removed + " - " + line_error_number );
        setTimeout( function () {
            let _timeout_temp = 0;
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.setDoLog( false );
            _timeout_temp += self.ACTION.clickOnButton( _timeout_temp, "button_mode_edit" );
            _timeout_temp += self.ACTION.clickOnButton( _timeout_temp, "edit_tab_json" );
            _timeout_temp += self.ACTION.setJSONInvalidInForm( _timeout_temp, comma_index_removed );
            _timeout_temp += self.ACTION.clickOnButton( _timeout_temp, "preview_grid_page" );
            _timeout_temp += 2000; //NEEDED BECAUSE THE COMPUTE LINE IS TIMEOUT WITH 1000
            _timeout_temp += self.TEST.lineNumberStatus( _timeout_temp, line_error_number, self.STATUS_LINE_NUMBER.STATE_DISPLAY.ERROR );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.setDoLog( true );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.lineNumberStatus                         = function ( timeout, line_error_number, status_to_test ) {
        let _to_return = 400;
        setTimeout( function () {
            var _dom = self.DOM.getLineNumber( line_error_number );
            switch ( status_to_test ) {
                case self.STATUS_LINE_NUMBER.STATE_DISPLAY.ERROR:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "background-color", "rgb(255, 0, 0)" );
                    break;
            }
        }, timeout );
        return _to_return;
    };
    self.TEST.countProblemsInWindow                    = function ( timeout, nb_errors_expected, nb_warnings_expected, skip_visibility_test ) {
        setTimeout( function () {
            if ( skip_visibility_test ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.visibility( 0, self.DOM.getProblemsContainer(), "container de message", !!(nb_errors_expected) );
            }
            var _doms_error   = self.DOM.getAllErrorsProblems();
            var _doms_warning = self.DOM.getAllWarningsProblems();
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( _doms_error, nb_errors_expected, "number errors" );
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( _doms_warning, nb_warnings_expected, "number warnings" );
        }, timeout );
        return 200;
    };
    self.TEST.countProblemsInJson                      = function ( timeout, nb_errors_expected, nb_warnings_expected ) {
        let _to_return = 200;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "countProblemsInJson" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( self.DOM.formTextAreaErrorsProblems(), nb_errors_expected, "JSON => number errors" );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.windowProblemsState                      = function ( timeout, status_expected ) {
        let _to_return = 200;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "windowProblemsState" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let _dom = self.DOM.getWindowProblemsContainer();
            switch ( status_expected ) {
                case SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT.CONST.WINDOW_GROUP_PROBLEM.STATUS.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT.CONST.WINDOW_GROUP_PROBLEM.STATUS.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT.CONST.WINDOW_GROUP_PROBLEM.STATUS.NON_EXISTING:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.doesntExist( 0, _dom );
                    break;
                
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.EXTERNAL_LINKS.tooltipOfLinkContainsText = function ( timeout, text, in_iframe ) {
        let _to_return = 500;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "TEST.EXTERNAL_LINKS.tooltipOfLinkContainsText" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom_element = DOM.Service.createElement( "div", {}, text );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextContains( self.DOM.getTooltip( in_iframe ), _dom_element, "text dans le tooltip" );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.countHistoryLineNumber                   = function ( timeout, total_number_element_expected, in_iframe ) {
        let _to_return = 500;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "TEST.LINES.count", total_number_element_expected );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( self.DOM.weatherHistoryLines( in_iframe ), total_number_element_expected, "total number history lines" );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.isJSONInScreenForWidget                  = function ( timeout, widget_index ) {
        let _to_return = 1000;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "isJSONInScreenForWidget" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let json_editor    = self.DOM.JSONEditor();
            let widget_in_json = self.DOM.widgetInJSONEditor( false, self.INTERNAL.getWidgetUuid_ByIndex( widget_index ) );
            SHINKEN.TOOLS.TEST_AUTO_DOM.isPartiallyInScreen( 0, widget_in_json, json_editor );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.navigateInTab                          = function ( timeout, tab_name, in_iframe ) {
        let _to_return = 200;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.navigateInTab", tab_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            self.ACTION.clickOnButton( 0, tab_name );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.resetJSON                              = function ( timeout ) {
        let _to_return = 11000;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "reset", "" );
        setTimeout( function () {
            var _temp_timeout = 0;
            _temp_timeout += self.ACTION.clickOnButton( _temp_timeout + timeout, "button_mode_edit" );
            _temp_timeout += self.ACTION.clickOnButton( _temp_timeout + timeout, "edit_tab_json" );
            _temp_timeout += self.ACTION.setJSONInForm( _temp_timeout + timeout, "", true );
            _temp_timeout += self.ACTION.clickOnButton( _temp_timeout + timeout, "button_save" );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnButton                          = function ( timeout, button_name, in_iframe ) {
        let _to_return = 3000;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "clickOnButton", button_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let _dom_button = self.DOM.getElement( button_name, in_iframe );
            if ( SHINKEN.TOOLS.TEST_AUTO.hasMessage() && button_name === "button_save" ) {
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "NOK", _to_return );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _dom_button );
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
            }
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnButton_V2                       = function ( callback, button_name, in_iframe ) {
        let _dom_button = self.DOM.getElement( button_name, in_iframe );
        SHINKEN.TOOLS.TEST_AUTO_DOM.click_V2( _dom_button, callback );
    };
    self.ACTION.IFRAME.clickOnButton                   = function ( timeout, button_name ) {
        return self.ACTION.clickOnButton( timeout, button_name, true );
    };
    self.ACTION.setJSONInForm                          = function ( timeout, extra_step, is_reset, info, value_to_force, in_iframe ) {
        let _to_return = 1000;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "setJSONInForm", info );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            self.DOM.formTextArea( in_iframe ).innerText = JSON.stringify( SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_JSON.GETTER.template( extra_step, is_reset, value_to_force ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.IFRAME.setJSONInForm                   = function ( timeout, extra_step, is_reset, info, value_to_force ) {
        return self.ACTION.setJSONInForm( timeout, extra_step, is_reset, info, value_to_force, true );
    };
    self.ACTION.IFRAME.createJSONInForm                = function ( timeout, name_title, user_name ) {
        let _to_return = 1000;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "setJSONInForm2", name_title );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom_textarea       = self.DOM.formTextArea( true );
            _dom_textarea.innerText = JSON.stringify( SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_JSON.GETTER.template2( name_title, user_name ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.setJSONInvalidInForm                   = function ( timeout, index_comma_to_remove ) {
        let _to_return = 1000;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "setJSONInForm", "TEST MISSING COMMA" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _index                        = SHINKEN.TOOLS.STRING.indexesOf( self.DOM.formTextArea().innerHTML, "," )[ index_comma_to_remove ];
            var _new_html                     = self.DOM.formTextArea().innerHTML.substring( 0, _index - 1 ) + self.DOM.formTextArea().innerHTML.substring( _index + 1, self.DOM.formTextArea().innerHTML.length );
            self.DOM.formTextArea().innerHTML = _new_html;
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.mouseEnterLink                         = function ( timeout, link_uuid, in_iframe ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.dispatchMouseEvent( timeout, self.DOM.getExternalLinkByUUID( in_iframe, link_uuid ), "mouseenter" );
        }, timeout );
        return 5000;
    };
    self.ACTION.clickOnPublishWeather                  = function ( timeout, in_iframe ) {
        let _to_return = 5000;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "clickOnPublishWeather", in_iframe );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.publishWeatherButton( in_iframe ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.enterEditMode                          = function ( timeout, in_iframe ) {
        let _to_return = 5000;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "enterEditMode", in_iframe );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.modeEditButton( in_iframe ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.enterEditModeJSON                      = function ( timeout, in_iframe ) {
        const _to_return  = 6000;
        let _uuid         = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "clickOnPublishWeather", in_iframe );
        let _timeout_temp = 0;
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            _timeout_temp += self.ACTION.clickOnButton( _timeout_temp, "button_mode_edit", in_iframe );
            _timeout_temp += self.ACTION.clickOnButton( _timeout_temp, "edit_tab_json", in_iframe );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.enterEditMode_V2                       = function ( callback, in_iframe ) {
        executeSequentially( [
            function ( sub_callback ) {
                self.ACTION.clickOnButton_V2( sub_callback, "button_mode_edit", in_iframe );
            },
            function ( sub_callback ) {
                self.INTERNAL.wait( sub_callback, function () {
                    return self.INTERNAL.isGridPageInPhase( "3" );
                }, 3000 );
            }
        ], callback, 0 );
        
    };
    self.ACTION.IFRAME.mouseEnterLink                  = function ( timeout, link_uuid ) {
        return self.ACTION.mouseEnterLink( timeout, link_uuid, true );
    };
    self.ACTION.clickOnGridCellConfigurationByIndex    = function ( timeout, index ) {
        let _to_return = 200;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "clickOnGridCellConfigurationByIndex", index );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( 0, TI.WEATHER.GRID.CELL.DOM.clickOnGridCellConfigurationByIndex( false, index ), SHINKEN.TOOLS.TEST_AUTO_MOUSE_EVENT.getMouseDownEvent() );
        }, timeout );
        return _to_return;
    };
    self.ACTION.focusOnJSONForGridCell                 = function ( timeout, index ) {
        let _to_return = 200;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "focusOnJSONForGridCell", index );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let widget_uuid   = self.INTERNAL.getWidgetUuid_ByIndex( index );
            let anchor_button = self.DOM.getWidgetProblemsContainerFocusJSONButton( widget_uuid );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, anchor_button );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.focusOnJSONForGridCell_V2              = function ( callback, index ) {
        let widget_uuid   = self.INTERNAL.getWidgetUuid_ByIndex( index );
        let anchor_button = self.DOM.getWidgetProblemsContainerFocusJSONButton( widget_uuid );
        SHINKEN.TOOLS.TEST_AUTO_DOM.click_V2( anchor_button );
        callback();
    };
    //********************************************  INTERNAL **************************************************//
    self.INTERNAL.getWidgetUuid_ByIndex                = function ( index ) {
        return CONTROLLER.PageController.current_page.content.grids.contents[ 0 ].grid_elements.contents[ index ].uuid;
    };
    self.INTERNAL.isGridPageInPhase                    = function ( phase ) {
        return SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.pageContainer().dataset[ 'currentPhase' ] === phase;
    };
    self.INTERNAL.wait                                 = function ( callback, condition, interval ) {
        setTimeout( function () {
            if ( condition() ) {
                callback();
            }
            else {
                self.INTERNAL.wait( callback, condition, interval );
            }
        }, interval );
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT || {} );

