SHINKEN.TOOLS.TEST_AUTO_SOURCE_DETAIL_LAST_RUN_TAB = (function ( self ) {
    self.DOM                           = {};
    self.TEST                          = {};
    self.ACTION                        = {};
    //********************************************  DOM   **************************************************//
    self.DOM.getTab                    = function () {
        return document.querySelector( "#tab-pane-detail-last-run-target" );
    };
    self.DOM.filterInput               = function ( filter_name ) {
        return self.DOM.getTab().querySelector( 'input.form-control[data-filter-tag-js="' + filter_name + '"]' );
    };
    self.DOM.allButtonDetail           = function () {
        return self.DOM.getTab().querySelectorAll( '.shinken-source-item-action' );
    };
    self.DOM.allLinkForElementInDetail = function () {
        return self.DOM.getTab().querySelectorAll( 'a.shinken-link-element' );
    };
    self.DOM.allElementRows            = function () {
        return self.DOM.getTab().querySelectorAll( 'tr.shinken-source-state-container' );
    };
    self.DOM.cellName                  = function ( row ) {
        return row.querySelector( 'td.col-type' );
    };
    self.DOM.buttonDelete              = function ( row ) {
        return row.querySelector( '.shinken-source-item-action.delete-item-js' );
    };
    self.DOM.elementRow                = function ( element_name ) {
        let _rows = self.DOM.allElementRows();
        for ( let i = 0, _size_i = _rows.length; i < _size_i; i++ ) {
            let _row = _rows[ i ];
            if ( self.DOM.cellName( _row ).innerText === element_name ) {
                return _row;
            }
        }
    };
    //********************************************  TEST   **************************************************//
    self.TEST.showConfigurationStatus  = function ( timeout, state_expected ) {
        setTimeout( function () {
            var _table = self.DOM.configurationTable();
            switch ( state_expected ) {
                case COMPONENT.CONST.BTN_STATE.OFF:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _table, 'showConfiguration' );
                    break;
                case COMPONENT.CONST.BTN_STATE.ON:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _table, 'showConfiguration' );
                    break;
            }
        }, timeout );
        return 200;
    };
    self.TEST.linkForElementDetail     = function ( timeout, number_link_expected ) {
        var _to_return = 100;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.setFilter', number_link_expected );
        setTimeout( function () {
            var _doms = self.DOM.allLinkForElementInDetail();
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( _doms, number_link_expected, "nb link for detail" );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.setInputFilter         = function ( timeout, filter_name, filter_value ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.setFilter', filter_name + "=" + filter_value );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
                SHINKEN.TOOLS.TEST_AUTO_DOM.setValue( 0, self.DOM.filterInput( filter_name ), filter_value, true );
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "NOK" );
            }
        }, timeout );
        return _to_return;
    };
    self.ACTION.openAllDetails         = function ( timeout ) {
        var _to_return = 400;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.openAllDetails' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _buttons = self.DOM.allButtonDetail();
            for ( var i = 0, _size_i = _buttons.length; i < _size_i; i++ ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _buttons[ i ] );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    self.ACTION.deleteRowElement       = function ( timeout, element_name ) {
        let _to_return = 7000;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.deleteRowElement' );
        setTimeout( () => {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.buttonDelete( self.DOM.elementRow( element_name ) ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
        return _to_return;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_SOURCE_DETAIL_LAST_RUN_TAB || {} );
