"use strict";
TI.ANGULAR.DETAIL = (function ( self ) {
    self.DOM                                  = {};
    self.DOM.MANAGE                           = {};
    self.DOM.HISTORIC                         = {};
    self.TEST                                 = {};
    self.ACTION                               = {};
    self.CONST                                = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getIframe                        = function () {
        SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).window.onerror = function () {
            _has_script_error++;
        };
        return SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).document;
    };
    self.DOM.buttonRefresh                    = function () {
        return self.DOM.getIframe().querySelector( "#refresh-detail-btn" );
    };
    self.DOM.actionCommandButton              = function ( action_class ) {
        return self.DOM.getIframe().querySelector( "." + action_class ).querySelector( ".shinken-action-command" );
    };
    self.DOM.buttonActionParent               = function ( action ) {
        return self.DOM.getIframe().querySelector( ".shinken-action-command-container." + action );
    };
    self.DOM.buttonAction                     = function ( action ) {
        return self.DOM.buttonActionParent( action ).querySelector( ".shinken-action-command" );
    };
    self.DOM.actionCommandButtonLabel         = function ( action_class ) {
        return self.DOM.actionCommandButton( action_class ).querySelector( ".ssssss" );
    };
    self.DOM.actionCommandButtonUserLabel     = function ( action_class ) {
        return self.DOM.actionCommandButtonLabel( action_class ).querySelector( ".shinken-property-data-user" );
    };
    self.DOM.checkList                        = function () {
        return self.DOM.getIframe().querySelector( ".shinken-grid-datas-container" );
    };
    self.DOM.check                            = function ( check_uuid ) {
        return self.DOM.checkList().querySelector( ".row-data[data-uuid='" + check_uuid + "']" );
    };
    self.DOM.status                           = function ( check_uuid ) {
        return self.DOM.check( check_uuid ).querySelector( ".shinken-cell-data[data-header-field='statusName']" );
    };
    self.DOM.context                          = function ( check_uuid ) {
        return self.DOM.check( check_uuid ).querySelector( ".shinken-cell-data[data-header-field='context']" );
    };
    self.DOM.MANAGE.manageWindow              = function () {
        return self.DOM.getIframe().querySelector( ".manage" );
    };
    self.DOM.MANAGE.contextInformations       = function () {
        return self.DOM.MANAGE.manageWindow().querySelector( ".shinken-acknowledge-container" );
    };
    self.DOM.HISTORIC.historicWindow          = function () {
        return self.DOM.getIframe().querySelector( ".historics" );
    };
    self.DOM.HISTORIC.historicDayLine         = function () {
        return self.DOM.HISTORIC.historicWindow().querySelector( ".day" );
    };
    self.DOM.HISTORIC.historicDayContainer    = function () {
        return self.DOM.HISTORIC.historicDayLine().querySelector( ".historic-row.historic-container" );
    };
    self.DOM.HISTORIC.historicDaySlaContainer = function () {
        return self.DOM.HISTORIC.historicDayLine().querySelector( ".sla-row.historic-container" );
    };
    self.DOM.HISTORIC.historicDayHistoricIcon = function () {
        return self.DOM.HISTORIC.historicDaySlaContainer().querySelector( ".ranges-table-container .row-ranges .shinken-range-table .element-status-big" );
    };
    self.DOM.HISTORIC.historicDaySlaIcon      = function () {
        return self.DOM.HISTORIC.historicDaySlaContainer().querySelector( ".ranges-table-container .row-ranges .shinken-range-table .element-status-big" );
    };
    //********************************************  GETTER   **************************************************//
    //********************************************  TEST   **************************************************//
    self.TEST.labelCommandButton             = function ( timeout, action_class, label ) {
        var _to_return = 300;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.labelCommandButton', label );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.actionCommandButtonLabel( action_class ), label );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.status                         = function ( timeout, status_to_test, check_uuid, reverse ) {
        const _to_return = 500;
        const _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.status' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.hasAttribute( 0, self.DOM.status( check_uuid ), "data-filter", status_to_test.toLowerCase(), null, reverse );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.context                        = function ( timeout, context_to_test, check_uuid, reverse ) {
        const _to_return = 500;
        const _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.context' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.hasAttribute( 0, self.DOM.context( check_uuid ), "data-filter", context_to_test.toLowerCase(), null, reverse );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.displayContextInfos            = function ( timeout, status_expected ) {
        const _to_return = 500;
        const _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.displayContextInfos' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            switch ( status_expected ) {
                case TI.ANGULAR.CONST.STATE.INHERITED:
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( self.DOM.MANAGE.contextInformations() );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.containsText( 0, self.DOM.MANAGE.contextInformations().querySelector( "span" ), "Prise en compte héritée activée" );
                    break;
                case TI.ANGULAR.CONST.STATE.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( self.DOM.MANAGE.contextInformations() );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.containsText( 0, self.DOM.MANAGE.contextInformations().querySelector( "span" ), "Prise en compte activée" );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.isActionCommandState__20250303 = function ( timeout, option_name, state ) {
        setTimeout( function () {
            const _dom_element = self.DOM.buttonActionParent( option_name );
            switch ( state ) {
                case TI.ANGULAR.CONST.STATE.RUNNING:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom_element, "opacity", "1", option_name );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom_element, "cursor", "default", option_name );
                    break;
                case TI.ANGULAR.CONST.STATE.DISABLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom_element, "opacity", "0.3", option_name );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom_element, "cursor", "not-allowed", option_name );
                    break;
                case TI.ANGULAR.CONST.STATE.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom_element, "display", "none", option_name );
                    break;
            }
        }, timeout );
        return 100;
    };
    self.TEST.isIconInCell                   = function ( timeout, column_name, icon_expected ) {
        setTimeout( function () {
            let _dom = column_name === "history" ? self.DOM.HISTORIC.historicDayHistoricIcon() : self.DOM.HISTORIC.historicDaySlaIcon();
            SHINKEN.TOOLS.TEST_AUTO.__containsStyle( _dom, "backgroundImage", icon_expected );
        }, timeout );
        
        return 400;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.disableRefreshAuto           = function ( timeout ) {
        const _to_return = 500;
        const _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.disableRefreshAuto', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).EXTERNAL.COMMUNICATION.getAngularService( "App" ).isNavigatorHidden = function () {
                return true;
            };
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnRefresh               = function ( timeout ) {
        const _to_return = 2000;
        const _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnRefresh', "" );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.buttonRefresh() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        
        return _to_return;
    };
    self.ACTION.doAction__addAcknowledge     = function ( timeout ) {
        var _to_return = 2000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "doAction__addAcknowledge" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            TI.ANGULAR.ACTION.ngClick( 0, self.DOM.buttonAction( "acknowledge" ), "onClickActionButton", "acknowledge" );
            setTimeout( function () {
                SHINKEN.TOOLS.TEST_AUTO_DOM.ACTION.setInputValue( 0, TI.ANGULAR.LIST_ALL.DOM.formAddAcknowledgeInput(), "test_auto" );
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 800, TI.ANGULAR.LIST_ALL.DOM.formAddAcknowledgeSubmit() );
            }, 500 );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    self.ACTION.doAction__removeAcknowledge  = function ( timeout ) {
        var _to_return = 2000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "doAction__removeAcknowledge" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            TI.ANGULAR.ACTION.ngClick( 0, self.DOM.buttonAction( "remove_acknowledge" ), "onClickActionButton", "remove_acknowledge" );
            setTimeout( function () {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 800, TI.ANGULAR.LIST_ALL.DOM.formAddAcknowledgeSubmit() );
            }, 500 );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    //********************************************  CONSTANT **************************************************//
    
    return self;
})( TI.ANGULAR.DETAIL || {} );

